import ec2 = require('@aws-cdk/aws-ec2');
/**
 * Properties for EksOptimizedAmi
 */
export interface EksOptimizedAmiProps {
    /**
     * What instance type to retrieve the image for (normal or GPU-optimized)
     *
     * @default Normal
     */
    readonly nodeType?: NodeType;
    /**
     * The Kubernetes version to use
     *
     * @default The latest version
     */
    readonly kubernetesVersion?: string;
}
/**
 * Source for EKS optimized AMIs
 */
export declare class EksOptimizedAmi extends ec2.GenericLinuxImage implements ec2.IMachineImageSource {
    constructor(props?: EksOptimizedAmiProps);
}
/**
 * Whether the worker nodes should support GPU or just normal instances
 */
export declare enum NodeType {
    /**
     * Normal instances
     */
    Normal = "Normal",
    /**
     * GPU instances
     */
    GPU = "GPU"
}
export declare function nodeTypeForInstanceType(instanceType: ec2.InstanceType): NodeType;
