# -*- coding: utf-8 -*-

"""
swaggerpetstore

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from apimatic_core.configurations.global_configuration import GlobalConfiguration
from apimatic_core.decorators.lazy_property import LazyProperty
from swaggerpetstore.configuration import Configuration
from swaggerpetstore.controllers.base_controller import BaseController
from swaggerpetstore.configuration import Environment
from swaggerpetstore.http.auth.custom_authentication import CustomAuthentication
from swaggerpetstore.controllers.pet_controller import PetController
from swaggerpetstore.controllers.store_controller import StoreController
from swaggerpetstore.controllers.user_controller import UserController


class SwaggerpetstoreClient(object):

    @LazyProperty
    def pet(self):
        return PetController(self.global_configuration)

    @LazyProperty
    def store(self):
        return StoreController(self.global_configuration)

    @LazyProperty
    def user(self):
        return UserController(self.global_configuration)

    def __init__(self, http_client_instance=None,
                 override_http_client_configuration=False, http_call_back=None,
                 timeout=60, max_retries=0, backoff_factor=2,
                 retry_statuses=[408, 413, 429, 500, 502, 503, 504, 521, 522, 524],
                 retry_methods=['GET', 'PUT'],
                 environment=Environment.PRODUCTION, password='TODO: Replace',
                 config=None):
        if config is None:
            self.config = Configuration(
                                         http_client_instance=http_client_instance,
                                         override_http_client_configuration=override_http_client_configuration,
                                         http_call_back=http_call_back,
                                         timeout=timeout,
                                         max_retries=max_retries,
                                         backoff_factor=backoff_factor,
                                         retry_statuses=retry_statuses,
                                         retry_methods=retry_methods,
                                         environment=environment,
                                         password=password)
        else:
            self.config = config

        self.global_configuration = GlobalConfiguration(self.config)\
            .global_errors(BaseController.global_errors())\
            .base_uri_executor(self.config.get_base_uri)\
            .user_agent(BaseController.user_agent(), BaseController.user_agent_parameters())
        self.initialize_auth_managers(self.global_configuration)

        self.global_configuration = self.global_configuration.auth_managers(self.auth_managers)

    def initialize_auth_managers(self, global_config):
        http_client_config = global_config.get_http_client_configuration()
        self.auth_managers = { key: None for key in ['global']}
        self.auth_managers['global'] = CustomAuthentication(http_client_config.password, http_client_config)
        return self.auth_managers
