# -*- coding: utf-8 -*-

"""
swaggerpetstore

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from swaggerpetstore.api_helper import APIHelper
from swaggerpetstore.configuration import Server
from swaggerpetstore.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from swaggerpetstore.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from apimatic_core.authentication.multiple.and_auth_group import And
from apimatic_core.authentication.multiple.or_auth_group import Or
from swaggerpetstore.models.user import User
from swaggerpetstore.exceptions.api_exception import APIException


class UserController(BaseController):

    """A Controller to access Endpoints in the swaggerpetstore API."""
    def __init__(self, config):
        super(UserController, self).__init__(config)

    def create_users_with_array_input(self,
                                      body):
        """Does a POST request to /user/createWithArray.

        Creates list of users with given input array

        Args:
            body (list of User): List of user object

        Returns:
            void: Response from the API.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVER1)
            .path('/user/createWithArray')
            .http_method(HttpMethodEnum.POST)
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('global'))
        ).execute()

    def get_user_by_name(self,
                         username):
        """Does a GET request to /user/{username}.

        Get user by user name

        Args:
            username (string): The name that needs to be fetched. Use user1
                for testing.

        Returns:
            User: Response from the API. successful operation

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVER1)
            .path('/user/{username}')
            .http_method(HttpMethodEnum.GET)
            .template_param(Parameter()
                            .key('username')
                            .value(username)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('global'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(User.from_dictionary)
            .local_error('400', 'Invalid username supplied', APIException)
            .local_error('404', 'User not found', APIException)
        ).execute()

    def delete_user(self,
                    username):
        """Does a DELETE request to /user/{username}.

        This can only be done by the logged in user.

        Args:
            username (string): The name that needs to be deleted

        Returns:
            void: Response from the API.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVER1)
            .path('/user/{username}')
            .http_method(HttpMethodEnum.DELETE)
            .template_param(Parameter()
                            .key('username')
                            .value(username)
                            .should_encode(True))
            .auth(Single('global'))
        ).execute()

    def login_user(self,
                   username,
                   password):
        """Does a GET request to /user/login.

        Logs user into the system

        Args:
            username (string): The user name for login
            password (string): The password for login in clear text

        Returns:
            string: Response from the API. successful operation

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVER1)
            .path('/user/login')
            .http_method(HttpMethodEnum.GET)
            .query_param(Parameter()
                         .key('username')
                         .value(username))
            .query_param(Parameter()
                         .key('password')
                         .value(password))
            .auth(Single('global'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .local_error('400', 'Invalid username/password supplied', APIException)
        ).execute()

    def create_users_with_list_input(self,
                                     body):
        """Does a POST request to /user/createWithList.

        Creates list of users with given input array

        Args:
            body (list of User): List of user object

        Returns:
            void: Response from the API.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVER1)
            .path('/user/createWithList')
            .http_method(HttpMethodEnum.POST)
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('global'))
        ).execute()

    def update_user(self,
                    username,
                    body):
        """Does a PUT request to /user/{username}.

        This can only be done by the logged in user.

        Args:
            username (string): name that need to be updated
            body (User): Updated user object

        Returns:
            void: Response from the API.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVER1)
            .path('/user/{username}')
            .http_method(HttpMethodEnum.PUT)
            .template_param(Parameter()
                            .key('username')
                            .value(username)
                            .should_encode(True))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('global'))
        ).execute()

    def logout_user(self):
        """Does a GET request to /user/logout.

        Logs out current logged in user session

        Returns:
            void: Response from the API.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVER1)
            .path('/user/logout')
            .http_method(HttpMethodEnum.GET)
            .auth(Single('global'))
        ).execute()

    def create_user(self,
                    body):
        """Does a POST request to /user.

        This can only be done by the logged in user.

        Args:
            body (User): Created user object

        Returns:
            void: Response from the API.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVER1)
            .path('/user')
            .http_method(HttpMethodEnum.POST)
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('global'))
        ).execute()
