# -*- coding: utf-8 -*-

"""
swaggerpetstore

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from deprecation import deprecated
from swaggerpetstore.api_helper import APIHelper
from swaggerpetstore.configuration import Server
from swaggerpetstore.utilities.file_wrapper import FileWrapper
from swaggerpetstore.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from swaggerpetstore.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from apimatic_core.authentication.multiple.and_auth_group import And
from apimatic_core.authentication.multiple.or_auth_group import Or
from swaggerpetstore.models.api_response import ApiResponse
from swaggerpetstore.models.pet import Pet
from swaggerpetstore.exceptions.api_exception import APIException


class PetController(BaseController):

    """A Controller to access Endpoints in the swaggerpetstore API."""
    def __init__(self, config):
        super(PetController, self).__init__(config)

    def inpet(self,
              body):
        """Does a POST request to /pet.

        Add a new pet to the store

        Args:
            body (Pet): Pet object that needs to be added to the store

        Returns:
            void: Response from the API.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVER1)
            .path('/pet')
            .http_method(HttpMethodEnum.POST)
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('global'))
        ).execute()

    def upload_file(self,
                    pet_id,
                    additional_metadata=None,
                    file=None):
        """Does a POST request to /pet/{petId}/uploadImage.

        uploads an image

        Args:
            pet_id (long|int): ID of pet to update
            additional_metadata (string, optional): Additional data to pass to
                server
            file (typing.BinaryIO, optional): file to upload

        Returns:
            ApiResponse: Response from the API. successful operation

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVER1)
            .path('/pet/{petId}/uploadImage')
            .http_method(HttpMethodEnum.POST)
            .template_param(Parameter()
                            .key('petId')
                            .value(pet_id)
                            .should_encode(True))
            .form_param(Parameter()
                        .key('additionalMetadata')
                        .value(additional_metadata))
            .multipart_param(Parameter()
                             .key('file')
                             .value(file)
                             .default_content_type('application/octet-stream'))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('global'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(ApiResponse.from_dictionary)
        ).execute()

    def update_an_pet(self,
                      body):
        """Does a PUT request to /pet.

        Update an existing pet

        Args:
            body (Pet): Pet object that needs to be added to the store

        Returns:
            void: Response from the API.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVER1)
            .path('/pet')
            .http_method(HttpMethodEnum.PUT)
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('global'))
        ).execute()

    def find_pet_in_the_status(self,
                               status):
        """Does a GET request to /pet/findByStatus.

        Multiple status values can be provided with comma separated strings

        Args:
            status (list of Status2Enum): Status values that need to be
                considered for filter

        Returns:
            list of Pet: Response from the API. successful operation

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVER1)
            .path('/pet/findByStatus')
            .http_method(HttpMethodEnum.GET)
            .query_param(Parameter()
                         .key('status')
                         .value(status))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('global'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(Pet.from_dictionary)
            .local_error('400', 'Invalid status value', APIException)
        ).execute()

    @deprecated()
    def find_pets_an_tags(self,
                          tags):
        """Does a GET request to /pet/findByTags.

        Multiple tags can be provided with comma separated strings. Use tag1,
        tag2, tag3 for testing.

        Args:
            tags (list of string): Tags to filter by

        Returns:
            list of Pet: Response from the API. successful operation

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVER1)
            .path('/pet/findByTags')
            .http_method(HttpMethodEnum.GET)
            .query_param(Parameter()
                         .key('tags')
                         .value(tags))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('global'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(Pet.from_dictionary)
            .local_error('400', 'Invalid tag value', APIException)
        ).execute()

    def get_pet_by_id(self,
                      pet_id):
        """Does a GET request to /pet/{petId}.

        Returns a single pet

        Args:
            pet_id (long|int): ID of pet to return

        Returns:
            Pet: Response from the API. successful operation

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVER1)
            .path('/pet/{petId}')
            .http_method(HttpMethodEnum.GET)
            .template_param(Parameter()
                            .key('petId')
                            .value(pet_id)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('global'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(Pet.from_dictionary)
            .local_error('400', 'Invalid ID supplied', APIException)
            .local_error('404', 'Pet not found', APIException)
        ).execute()

    def delete_pet(self,
                   pet_id,
                   api_key=None):
        """Does a DELETE request to /pet/{petId}.

        Deletes a pet

        Args:
            pet_id (long|int): Pet id to delete
            api_key (string, optional): TODO: type description here.

        Returns:
            void: Response from the API.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVER1)
            .path('/pet/{petId}')
            .http_method(HttpMethodEnum.DELETE)
            .template_param(Parameter()
                            .key('petId')
                            .value(pet_id)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('api_key')
                          .value(api_key))
            .auth(Single('global'))
        ).execute()

    def update_pet_with_form(self,
                             pet_id,
                             name=None,
                             status=None):
        """Does a POST request to /pet/{petId}.

        Updates a pet in the store with form data

        Args:
            pet_id (long|int): ID of pet that needs to be updated
            name (string, optional): Updated name of the pet
            status (string, optional): Updated status of the pet

        Returns:
            void: Response from the API.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVER1)
            .path('/pet/{petId}')
            .http_method(HttpMethodEnum.POST)
            .template_param(Parameter()
                            .key('petId')
                            .value(pet_id)
                            .should_encode(True))
            .form_param(Parameter()
                        .key('name')
                        .value(name))
            .form_param(Parameter()
                        .key('status')
                        .value(status))
            .header_param(Parameter()
                          .key('content-type')
                          .value('application/x-www-form-urlencoded'))
            .auth(Single('global'))
        ).execute()
