# Streamlit App Generator

🚀 Generate complete Streamlit applications with authentication and database templates in seconds!

<div align="center">

[![PyPI version](https://badge.fury.io/py/streamlit-app-generator.svg)](https://badge.fury.io/py/streamlit-app-generator)
[![Python 3.8+](https://img.shields.io/badge/python-3.8+-blue.svg)](https://www.python.org/downloads/)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
[![Downloads](https://pepy.tech/badge/streamlit-app-generator/month)](https://pepy.tech/project/streamlit-app-generator)

**💖 Support:** [![PIX](https://img.shields.io/badge/PIX-00B0FF?style=flat&logo=paypal&logoColor=white)](lmdcorti@gmail.com) [![Crypto](https://img.shields.io/badge/Crypto-FF9900?style=flat&logo=bitcoin&logoColor=white)](#-support-the-project)

**Created by: [Leandro Meyer Dal Cortivo](https://github.com/leandrodalcortivo)**

</div>

## Features

- 📱 **6 Application Templates**: Basic, Dashboard, CRUD, E-commerce, Blog/CMS, and Custom
- 🌍 **Multilingual Support**: Full English and Portuguese (Brazil) interface with auto-detection
- 🔐 **Multiple Auth Styles**: Basic, Modern, and Minimal login templates
- 🗄️ **6 Database Options**: PostgreSQL, MySQL, SQLite, MongoDB, Redis, Oracle (or install all!)
- 📄 **Multi-page Support**: Auto-generate page structure based on template
- 🎨 **Customizable Themes**: Light, Dark, and Custom themes
- 🛡️ **Security First**: Password hashing, session management, role-based access
- 📦 **Production Ready**: Clean code, type hints, comprehensive tests
- ⚡ **Performance Optimized**: Caching, connection pooling, lazy loading
- 🧙 **Interactive Wizard**: Guided setup with language selection and detailed database info

## Installation

```bash
pip install streamlit-app-generator
```

### Development Installation

```bash
git clone https://github.com/leandrodalcortivo/streamlit-app-generator.git
cd streamlit-app-generator
pip install -e ".[dev]"
```

### Install with Database Support

```bash
# PostgreSQL
pip install streamlit-app-generator[postgresql]

# MySQL
pip install streamlit-app-generator[mysql]

# MongoDB
pip install streamlit-app-generator[mongodb]

# Redis
pip install streamlit-app-generator[redis]

# Oracle
pip install streamlit-app-generator[oracle]

# All databases
pip install streamlit-app-generator[all-databases]
```

## Quick Start

### Super Simple (3 steps)

```bash
# 1. Install
pip install streamlit-app-generator

# 2. Create your app
streamlit-app-generator create my_app

# 3. Run it
cd my_app
pip install -r requirements.txt
streamlit run app.py
```

**Login:** admin / admin123

### With Specific Options

```bash
streamlit-app-generator create my_app \
    --database postgresql \
    --auth modern \
    --theme dark \
    --pages home,dashboard,analytics,settings
```

### Interactive Mode (Recommended!)

The interactive wizard guides you through the setup with a beautiful interface:

```bash
streamlit-app-generator create my_app --interactive
```

**Features in Interactive Mode:**
- 🌍 Choose your language (English or Português)
- 📱 Select from 6 application templates
- 🗄️ Pick your database (including "All Databases" option for learning)
- 🔐 Choose authentication style with previews
- 🎨 Select theme
- 📄 Define custom pages (or use template defaults)
- 📋 Review complete summary before creation

**Choose Your Language:**
```bash
# Auto-detect system language
streamlit-app-generator create my_app -i

# Force English
streamlit-app-generator create my_app -l en -i

# Force Portuguese
streamlit-app-generator create my_app -l pt-BR -i
```

### Using Python API

```python
from streamlit_app_generator import AppGenerator

generator = AppGenerator(
    name="my_awesome_app",
    database="postgresql",
    auth_style="modern",
    pages=["home", "dashboard", "analytics", "settings"],
    theme="dark",
    enable_multipage=True
)

generator.generate()
```

### 📖 More Help

- **[Como Usar - Guia Simples](COMO_USAR.md)** - Guia completo em português
- **[Examples](examples/EXEMPLOS.md)** - 10+ exemplos práticos

## Usage Examples

### Create a Basic App

```bash
streamlit-app-generator create my_app
```

This creates a minimal Streamlit app with:
- Basic authentication
- SQLite database
- Home page
- Default theme

### Create a Full-Featured App

```bash
streamlit-app-generator create my_app \
    --database postgresql \
    --auth modern \
    --theme dark \
    --pages home,dashboard,analytics,settings
```

### Add Components to Existing Project

```bash
cd my_app
streamlit-app-generator add-database mysql
streamlit-app-generator add-page analytics
```

## Generated Project Structure

```
my_app/
├── .streamlit/
│   ├── config.toml
│   └── secrets.toml
├── pages/
│   ├── 1_🏠_Home.py
│   ├── 2_📊_Dashboard.py
│   └── 3_⚙️_Settings.py
├── auth/
│   ├── __init__.py
│   ├── login.py
│   └── session.py
├── database/
│   ├── __init__.py
│   ├── connection.py
│   └── models.py
├── utils/
│   ├── __init__.py
│   └── helpers.py
├── app.py
├── requirements.txt
├── .env.example
├── .gitignore
└── README.md
```

## Application Templates

Choose from 6 professionally designed templates tailored for different use cases:

### 📱 Basic App
**Best for:** General purpose, learning, prototypes
**Pages:** home, dashboard, settings
Simple multi-page application perfect for getting started or building MVPs.

### 📊 Dashboard/Analytics
**Best for:** Business intelligence, data analysis, reporting
**Pages:** overview, metrics, charts, data, settings
Complete analytics dashboard with data visualization and reporting capabilities.

### 📝 CRUD Application
**Best for:** Management systems, admin panels, data entry
**Pages:** list, create, edit, view, settings
Full Create, Read, Update, Delete application for managing records.

### 🛒 E-commerce
**Best for:** Online shops, product catalogs, sales
**Pages:** catalog, cart, checkout, orders, profile
Complete e-commerce solution with shopping cart and order management.

### 📰 Blog/CMS
**Best for:** Blogs, news sites, content platforms
**Pages:** posts, create_post, categories, comments, settings
Content management system for blogs and publishing platforms.

### 🎨 Custom
**Best for:** Specific requirements, unique workflows
**Pages:** You define!
Completely customizable - define your own pages and structure.

## Authentication Styles

### Basic
Simple and functional authentication with username/password.

### Modern
Beautiful UI with gradients, animations, and modern design.

### Minimal
Clean and minimalist design focused on simplicity.

## Database Support


### 🗄️ All Databases (New!)
Install support for **all** databases at once! Perfect for:
- Learning and experimentation
- Development environments
- Switching databases easily
- Maximum flexibility

### 📁 SQLite
Lightweight embedded database, perfect for prototyping.
- Zero configuration required
- No server needed
- Great for development and small apps

### 🐘 PostgreSQL
Full support with SQLAlchemy ORM, connection pooling, and migrations.
- Production-ready
- ACID compliant
- Advanced features

### 🐬 MySQL/MariaDB
Complete MySQL integration with connection management.
- Very popular and well-documented
- Great for traditional web apps
- Large community

### 🍃 MongoDB
NoSQL database support with pymongo.
- Flexible schema
- Excellent for unstructured data
- High scalability

### 🔴 Redis
In-memory data structure store for caching and sessions.
- Extremely fast
- Perfect for caching
- Pub/Sub and queues

### 🏛️ Oracle Database
Enterprise database with advanced features.
- Maximum reliability
- High availability
- Corporate support

## Documentation

- 🌍 **[Internationalization Guide](I18N_GUIDE.md)** - English and Portuguese support
- 📖 **[Setup Guide](SETUP_GUIDE.md)** - Complete configuration guide for all databases
- 🇧🇷 **[Como Usar](COMO_USAR.md)** - Guia completo em português
- 📝 **[Examples](examples/EXEMPLOS.md)** - 10+ practical examples
- [Installation Guide](docs/installation.md)
- [Quick Start](docs/quickstart.md)
- [Configuration](docs/configuration.md)
- [API Reference](docs/api_reference.md)

## For Developers

- [Publishing to PyPI](PUBLISHING.md) - Complete guide for publishing the package
- [Quick Start Publishing](QUICK_START_PUBLISH.md) - Quick reference for PyPI publication

## Development

### Setup Development Environment

```bash
git clone https://github.com/leandrodalcortivo/streamlit-app-generator.git
cd streamlit-app-generator
pip install -e ".[dev]"
pre-commit install
```

### Run Tests

```bash
pytest
pytest --cov=streamlit_app_generator
```

### Code Quality

```bash
# Format code
black .
isort .

# Lint
flake8 .
mypy .
```

### Using Makefile

```bash
make install       # Install dependencies
make test          # Run tests
make format        # Format code
make lint          # Run linters
make clean         # Clean build artifacts
```

## Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

1. Fork the repository
2. Create your feature branch (`git checkout -b feature/AmazingFeature`)
3. Commit your changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the branch (`git push origin feature/AmazingFeature`)
5. Open a Pull Request

## Roadmap

- [ ] Support for more authentication providers (OAuth, SAML)
- [ ] GraphQL API template
- [ ] Docker deployment templates
- [ ] CI/CD pipeline generator
- [ ] Admin dashboard template
- [ ] Email integration
- [ ] File upload/download components
- [ ] Data visualization templates

## 💖 Support the Project

If you find this project useful and want to support its development, consider making a donation!

Your support helps maintain and improve this project with new features, bug fixes, and documentation updates.

<div align="center">

### ☕ Buy Me a Coffee

<table>
<tr>
<td align="center" width="50%">
<h3>🇧🇷 PIX (Brazil)</h3>
<img src="https://img.shields.io/badge/PIX-00B0FF?style=for-the-badge&logo=paypal&logoColor=white" alt="PIX"/>
<br><br>
<code>lmdcorti@gmail.com</code>
<br><br>
<em>Escaneie o QR Code ou copie a chave PIX acima</em>
</td>
<td align="center" width="50%">
<h3>🌍 Crypto (International)</h3>
<img src="https://img.shields.io/badge/Bitcoin-FF9900?style=for-the-badge&logo=bitcoin&logoColor=white" alt="BTC"/>
<img src="https://img.shields.io/badge/Ethereum-3C3C3D?style=for-the-badge&logo=ethereum&logoColor=white" alt="ETH"/>
<br><br>
<details>
<summary><b>📋 View Crypto Addresses</b></summary>
<br>
<table>
<tr><td><b>BTC</b></td><td><code>bc1qqkhzmz0fmlgt8m0sn2d3hf9qpz56mpsrmkz4k9</code></td></tr>
<tr><td><b>ETH</b></td><td><code>0x4533957C8a21043ce3843bD3ACB2e09ca59541F8</code></td></tr>
<tr><td><b>BNB</b></td><td><code>0x4533957C8a21043ce3843bD3ACB2e09ca59541F8</code></td></tr>
<tr><td><b>USDT</b></td><td><code>0x4533957C8a21043ce3843bD3ACB2e09ca59541F8</code></td></tr>
</table>
</details>
</td>
</tr>
</table>

---

**Every contribution, no matter how small, is greatly appreciated!** 🙏

</div>

## License

MIT License - Copyright (c) 2024 Leandro Meyer

## Author

**Leandro Meyer**

- GitHub: [@leandrodalcortivo](https://github.com/leandrodalcortivo)
- Email: lmdcorti@gmail.com

## Acknowledgments

- Built with [Streamlit](https://streamlit.io/)
- CLI powered by [Click](https://click.palletsprojects.com/)
- Templates using [Jinja2](https://jinja.palletsprojects.com/)

---

<div align="center">

### ⭐ Star us on GitHub | 💖 [Support the Project](#-support-the-project)

Made with ❤️ by [Leandro Meyer Dal Cortivo](https://github.com/leandrodalcortivo)

**Support:** 🇧🇷 PIX `lmdcorti@gmail.com` | 💰 [Crypto](#-support-the-project)

[![GitHub stars](https://img.shields.io/github/stars/leandrodalcortivo/streamlit-app-generator?style=social)](https://github.com/leandrodalcortivo/streamlit-app-generator)
[![PyPI](https://img.shields.io/pypi/v/streamlit-app-generator)](https://pypi.org/project/streamlit-app-generator/)
[![Downloads](https://pepy.tech/badge/streamlit-app-generator)](https://pepy.tech/project/streamlit-app-generator)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

</div>
