from pyvenafi.tpp.attributes._helper import IterableMeta, Attribute
from pyvenafi.tpp.attributes.driver_base import DriverBaseAttributes
from pyvenafi.tpp.attributes.monitoring_base import MonitoringBaseAttributes


class X509CertificateBaseAttributes(DriverBaseAttributes, MonitoringBaseAttributes, metaclass=IterableMeta):
    __config_class__ = "X509 Certificate Base"
    adaptable_ca_binary_data_vault_id = Attribute('Adaptable CA:Binary Data Vault ID')
    adaptable_ca_early_password_vault_id = Attribute('Adaptable CA:Early Password Vault ID')
    adaptable_ca_early_pkcs7_vault_id = Attribute('Adaptable CA:Early Pkcs7 Vault ID')
    adaptable_ca_early_private_key_vault_id = Attribute('Adaptable CA:Early Private Key Vault ID')
    adaptable_ca_script_hash_mismatch_error = Attribute('Adaptable CA:Script Hash Mismatch Error')
    adaptable_workflow_approvers = Attribute('Adaptable Workflow Approvers')
    adaptable_workflow_reference_id = Attribute('Adaptable Workflow Reference ID')
    adaptable_workflow_stage = Attribute('Adaptable Workflow Stage')
    address = Attribute('Address')
    allow_private_key_reuse = Attribute('Allow Private Key Reuse')
    amazon_ca_first_pickup_request = Attribute('Amazon CA:First Pickup Request')
    amazon_ca_timestamp = Attribute('Amazon CA:Timestamp')
    approved_issuer = Attribute('Approved Issuer')
    approver = Attribute('Approver')
    csr_thumbprint = Attribute('CSR Thumbprint')
    csr_vault_id = Attribute('CSR Vault Id')
    certificate_authority = Attribute('Certificate Authority')
    certificate_download_pbes2_algorithm = Attribute('Certificate Download: PBES2 Algorithm')
    certificate_process_validator = Attribute('Certificate Process Validator')
    certificate_vault_id = Attribute('Certificate Vault Id')
    city = Attribute('City')
    comodo_ca_dcv_email = Attribute('Comodo CA:DCV Email')
    comodo_ca_server_type_id = Attribute('Comodo CA:Server Type Id')
    comodo_ccm_ca_pass_phrase = Attribute('Comodo CCM CA:Pass Phrase')
    comodo_ccm_ca_server_type = Attribute('Comodo CCM CA:Server Type')
    consumers = Attribute('Consumers')
    country = Attribute('Country')
    created_by = Attribute('Created By')
    digicert_ca_address = Attribute('DigiCert CA:Address')
    digicert_ca_request_id = Attribute('DigiCert CA:Request Id')
    digicert_ca_server_type = Attribute('DigiCert CA:Server Type')
    digicert_ca_specific_end_date = Attribute('DigiCert CA:Specific End Date')
    digicert_ca_zip = Attribute('DigiCert CA:Zip')
    disable_automatic_renewal = Attribute('Disable Automatic Renewal')
    disable_password_complexity = Attribute('Disable Password Complexity')
    discovered_by_dn = Attribute('Discovered By DN')
    discovered_on = Attribute('Discovered On')
    domain_suffix_whitelist = Attribute('Domain Suffix Whitelist')
    esm_ca_override_default_key_update_policy = Attribute('ESM CA:Override Default Key Update Policy')
    est_reenrollment_in_progress = Attribute('EST ReEnrollment In Progress')
    elliptic_curve = Attribute('Elliptic Curve')
    encryption_driver = Attribute('Encryption Driver')
    enforce_unique_subject = Attribute('Enforce Unique Subject')
    entrust_pki_gateway_early_private_key_vault_id = Attribute('Entrust PKI Gateway:Early Private Key Vault ID')
    entrust_pki_gateway_early_x509_vault_id = Attribute('Entrust PKI Gateway:Early X509 Vault ID')
    entrustnet_ca_additional_emails = Attribute('EntrustNET CA:Additional Emails')
    entrustnet_ca_additional_field_value = Attribute('EntrustNET CA:Additional Field Value')
    entrustnet_ca_email_address = Attribute('EntrustNET CA:Email Address')
    entrustnet_ca_first_name = Attribute('EntrustNET CA:First Name')
    entrustnet_ca_first_pickup_request = Attribute('EntrustNET CA:First Pickup Request')
    entrustnet_ca_last_name = Attribute('EntrustNET CA:Last Name')
    entrustnet_ca_specific_end_date = Attribute('EntrustNET CA:Specific End Date')
    entrustnet_ca_timestamp = Attribute('EntrustNET CA:Timestamp')
    escalation_notice_interval = Attribute('Escalation Notice Interval')
    escalation_notice_start = Attribute('Escalation Notice Start')
    expiration_notice_interval = Attribute('Expiration Notice Interval')
    expiration_notice_start = Attribute('Expiration Notice Start')
    fields = Attribute('Fields')
    generate_keypair_on_application = Attribute('Generate Keypair On Application')
    geotrust_ca_address = Attribute('GeoTrust CA:Address')
    geotrust_ca_admin_contact_address = Attribute('GeoTrust CA:Admin Contact Address')
    geotrust_ca_admin_contact_city = Attribute('GeoTrust CA:Admin Contact City')
    geotrust_ca_admin_contact_country = Attribute('GeoTrust CA:Admin Contact Country')
    geotrust_ca_admin_contact_email_address = Attribute('GeoTrust CA:Admin Contact Email Address')
    geotrust_ca_admin_contact_first_name = Attribute('GeoTrust CA:Admin Contact First Name')
    geotrust_ca_admin_contact_last_name = Attribute('GeoTrust CA:Admin Contact Last Name')
    geotrust_ca_admin_contact_organization = Attribute('GeoTrust CA:Admin Contact Organization')
    geotrust_ca_admin_contact_phone_number = Attribute('GeoTrust CA:Admin Contact Phone Number')
    geotrust_ca_admin_contact_postal_code = Attribute('GeoTrust CA:Admin Contact Postal Code')
    geotrust_ca_admin_contact_state = Attribute('GeoTrust CA:Admin Contact State')
    geotrust_ca_admin_contact_title = Attribute('GeoTrust CA:Admin Contact Title')
    geotrust_ca_authentication_comments = Attribute('GeoTrust CA:Authentication Comments')
    geotrust_ca_authentication_statuses = Attribute('GeoTrust CA:Authentication Statuses')
    geotrust_ca_enrollment_mode = Attribute('GeoTrust CA:Enrollment Mode')
    geotrust_ca_order_id = Attribute('GeoTrust CA:Order Id')
    geotrust_ca_postal_code = Attribute('GeoTrust CA:Postal Code')
    geotrust_ca_server_count = Attribute('GeoTrust CA:Server Count')
    geotrust_ca_server_type = Attribute('GeoTrust CA:Server Type')
    geotrust_ca_telephone_number = Attribute('GeoTrust CA:Telephone Number')
    geotrust_ca_timestamp = Attribute('GeoTrust CA:Timestamp')
    geotrust_enterprise_ca_address = Attribute('GeoTrust Enterprise CA:Address')
    geotrust_enterprise_ca_admin_contact_email_address = Attribute('GeoTrust Enterprise CA:Admin Contact Email Address')
    geotrust_enterprise_ca_admin_contact_first_name = Attribute('GeoTrust Enterprise CA:Admin Contact First Name')
    geotrust_enterprise_ca_admin_contact_last_name = Attribute('GeoTrust Enterprise CA:Admin Contact Last Name')
    geotrust_enterprise_ca_admin_contact_phone_number = Attribute('GeoTrust Enterprise CA:Admin Contact Phone Number')
    geotrust_enterprise_ca_admin_contact_title = Attribute('GeoTrust Enterprise CA:Admin Contact Title')
    geotrust_enterprise_ca_approver_email = Attribute('GeoTrust Enterprise CA:Approver Email')
    geotrust_enterprise_ca_enrollment_mode = Attribute('GeoTrust Enterprise CA:Enrollment Mode')
    geotrust_enterprise_ca_postal_code = Attribute('GeoTrust Enterprise CA:Postal Code')
    geotrust_enterprise_ca_server_count = Attribute('GeoTrust Enterprise CA:Server Count')
    geotrust_enterprise_ca_server_type = Attribute('GeoTrust Enterprise CA:Server Type')
    geotrust_enterprise_ca_telephone_number = Attribute('GeoTrust Enterprise CA:Telephone Number')
    geotrust_enterprise_ca_timestamp = Attribute('GeoTrust Enterprise CA:Timestamp')
    given_name = Attribute('Given Name')
    globalsign_mssl_ca_email = Attribute('GlobalSign MSSL CA:Email')
    globalsign_mssl_ca_first_name = Attribute('GlobalSign MSSL CA:First Name')
    globalsign_mssl_ca_last_name = Attribute('GlobalSign MSSL CA:Last Name')
    globalsign_mssl_ca_phone = Attribute('GlobalSign MSSL CA:Phone')
    google_cloud_ca_early_x509_chain_vault_id = Attribute('Google Cloud CA:Early X509 Chain Vault ID')
    google_cloud_ca_early_x509_vault_id = Attribute('Google Cloud CA:Early X509 Vault ID')
    grouping_id = Attribute('Grouping Id')
    in_error = Attribute('In Error')
    in_process = Attribute('In Process')
    internet_email_address = Attribute('Internet EMail Address')
    issued_to = Attribute('Issued To')
    key_algorithm = Attribute('Key Algorithm')
    key_bit_strength = Attribute('Key Bit Strength')
    key_storage_location = Attribute('Key Storage Location')
    keynectis_sequoia_ca_fields = Attribute('Keynectis Sequoia CA:Fields')
    last_evaluated_on = Attribute('Last Evaluated On')
    last_notification = Attribute('Last Notification')
    last_renewed_by = Attribute('Last Renewed By')
    last_renewed_on = Attribute('Last Renewed On')
    last_validation_state_update = Attribute('Last Validation State Update')
    license_count = Attribute('License Count')
    management_type = Attribute('Management Type')
    manual_approval = Attribute('Manual Approval')
    manual_csr = Attribute('Manual Csr')
    microsoft_ca_request_approved = Attribute('Microsoft CA:Request Approved')
    microsoft_ca_specific_end_date = Attribute('Microsoft CA:Specific End Date')
    network_validation_disabled = Attribute('Network Validation Disabled')
    opentrust_pki_ca_fields = Attribute('OpenTrust PKI CA:Fields')
    opentrust_pki_ca_first_pickup_request = Attribute('OpenTrust PKI CA:First Pickup Request')
    opentrust_pki_ca_requester_email = Attribute('OpenTrust PKI CA:Requester Email')
    options = Attribute('Options')
    organization = Attribute('Organization')
    organizational_unit = Attribute('Organizational Unit')
    origin = Attribute('Origin')
    pkcs10_hash_algorithm = Attribute('PKCS10 Hash Algorithm')
    postal_code = Attribute('Postal Code')
    private_key_vault_id = Attribute('Private Key Vault Id')
    prohibit_wildcard = Attribute('Prohibit Wildcard')
    prohibited_subject_attributes = Attribute('Prohibited Subject Attributes')
    protection_key = Attribute('Protection Key')
    public_key_vault_id = Attribute('Public Key Vault Id')
    renewal_window = Attribute('Renewal Window')
    reverse_dc_order = Attribute('Reverse DC Order')
    revocation_check_disabled = Attribute('Revocation Check Disabled')
    revocation_check_in_error = Attribute('Revocation Check In Error')
    revocation_check_last_checked = Attribute('Revocation Check Last Checked')
    revocation_check_now = Attribute('Revocation Check Now')
    revocation_check_status = Attribute('Revocation Check Status')
    revocation_original_request = Attribute('Revocation Original Request')
    revocation_request = Attribute('Revocation Request')
    scep_transaction_id = Attribute('Scep Transaction Id')
    server_type = Attribute('Server Type')
    signing_request_subject = Attribute('Signing Request Subject')
    specific_end_date = Attribute('Specific End Date')
    stage = Attribute('Stage')
    state = Attribute('State')
    status = Attribute('Status')
    surname = Attribute('Surname')
    symantec_lhk_ca_fields = Attribute('Symantec LHK CA:Fields')
    telephone = Attribute('Telephone')
    thawte_ca_emails = Attribute('Thawte CA:Emails')
    thawte_ca_enrollment_mode = Attribute('Thawte CA:Enrollment Mode')
    thawte_ca_first_pickup_request = Attribute('Thawte CA:First Pickup Request')
    thawte_ca_timestamp = Attribute('Thawte CA:Timestamp')
    transaction_id = Attribute('Transaction Id')
    trusted_status = Attribute('Trusted Status')
    trustwave_ca_enrollment_mode = Attribute('Trustwave CA:Enrollment Mode')
    trustwave_ca_first_pickup_request = Attribute('Trustwave CA:First Pickup Request')
    trustwave_ca_timestamp = Attribute('Trustwave CA:Timestamp')
    validation_state = Attribute('Validation State')
    validity_period = Attribute('Validity Period')
    verisign_ca_additional_field_value = Attribute('VeriSign CA:Additional Field Value')
    verisign_ca_challenge_credential = Attribute('VeriSign CA:Challenge Credential')
    verisign_ca_comment = Attribute('VeriSign CA:Comment')
    verisign_ca_enrollment_mode = Attribute('VeriSign CA:Enrollment Mode')
    verisign_ca_first_pickup_request = Attribute('VeriSign CA:First Pickup Request')
    verisign_ca_license_count = Attribute('VeriSign CA:License Count')
    verisign_ca_original_challenge_credential = Attribute('VeriSign CA:Original Challenge Credential')
    verisign_ca_replacement_reason = Attribute('VeriSign CA:Replacement Reason')
    verisign_ca_server_type = Attribute('VeriSign CA:Server Type')
    verisign_ca_specific_end_date = Attribute('VeriSign CA:Specific End Date')
    verisign_ca_timestamp = Attribute('VeriSign CA:Timestamp')
    verizon_ca_additional_field_value = Attribute('Verizon CA:Additional Field Value')
    verizon_ca_challenge_credential = Attribute('Verizon CA:Challenge Credential')
    verizon_ca_challenge_credential_hint = Attribute('Verizon CA:Challenge Credential Hint')
    verizon_ca_enrollment_mode = Attribute('Verizon CA:Enrollment Mode')
    verizon_ca_first_pickup_request = Attribute('Verizon CA:First Pickup Request')
    verizon_ca_license_count = Attribute('Verizon CA:License Count')
    verizon_ca_number_of_servers = Attribute('Verizon CA:Number Of Servers')
    verizon_ca_organization_summary = Attribute('Verizon CA:Organization Summary')
    verizon_ca_server_name = Attribute('Verizon CA:Server Name')
    verizon_ca_server_type = Attribute('Verizon CA:Server Type')
    verizon_ca_tech_email = Attribute('Verizon CA:Tech Email')
    verizon_ca_tech_firstname = Attribute('Verizon CA:Tech Firstname')
    verizon_ca_tech_surname = Attribute('Verizon CA:Tech Surname')
    verizon_ca_tech_telnumber = Attribute('Verizon CA:Tech Telnumber')
    verizon_ca_timestamp = Attribute('Verizon CA:Timestamp')
    want_renewal = Attribute('Want Renewal')
    x509_d = Attribute('X509 D')
    x509_dc = Attribute('X509 DC')
    x509_dnq = Attribute('X509 DNQ')
    x509_e = Attribute('X509 E')
    x509_extension_fields = Attribute('X509 Extension Fields')
    x509_gn = Attribute('X509 GN')
    x509_gq = Attribute('X509 GQ')
    x509_i = Attribute('X509 I')
    x509_p = Attribute('X509 P')
    x509_pa = Attribute('X509 PA')
    x509_pc = Attribute('X509 PC')
    x509_sa = Attribute('X509 SA')
    x509_sn = Attribute('X509 SN')
    x509_sno = Attribute('X509 SNO')
    x509_subject = Attribute('X509 Subject')
    x509_subjectaltname = Attribute('X509 SubjectAltName')
    x509_subjectaltname_dns = Attribute('X509 SubjectAltName DNS')
    x509_subjectaltname_ipaddress = Attribute('X509 SubjectAltName IPAddress')
    x509_subjectaltname_othername_upn = Attribute('X509 SubjectAltName OtherName UPN')
    x509_subjectaltname_rfc822 = Attribute('X509 SubjectAltName RFC822')
    x509_subjectaltname_uri = Attribute('X509 SubjectAltName URI')
    x509_t = Attribute('X509 T')
    x509_tn = Attribute('X509 TN')
    x509_ua = Attribute('X509 UA')
    x509_uid = Attribute('X509 UID')
    x509_un = Attribute('X509 UN')
    xolphin_ca_address = Attribute('Xolphin CA:Address')
    xolphin_ca_approver_email_address = Attribute('Xolphin CA:Approver Email Address')
    xolphin_ca_approver_first_name = Attribute('Xolphin CA:Approver First Name')
    xolphin_ca_approver_last_name = Attribute('Xolphin CA:Approver Last Name')
    xolphin_ca_approver_phone_number = Attribute('Xolphin CA:Approver Phone Number')
    xolphin_ca_approver_type = Attribute('Xolphin CA:Approver Type')
    xolphin_ca_city = Attribute('Xolphin CA:City')
    xolphin_ca_company = Attribute('Xolphin CA:Company')
    xolphin_ca_country_code = Attribute('Xolphin CA:Country Code')
    xolphin_ca_department = Attribute('Xolphin CA:Department')
    xolphin_ca_effective_polling_interval = Attribute('Xolphin CA:Effective Polling Interval')
    xolphin_ca_kvk_number = Attribute('Xolphin CA:KvK Number')
    xolphin_ca_postbox = Attribute('Xolphin CA:Postbox')
    xolphin_ca_reference_number = Attribute('Xolphin CA:Reference Number')
    xolphin_ca_zip_code = Attribute('Xolphin CA:Zip Code')
