# -*- coding: utf-8 -*-

import io
import os

from setuptools import find_packages, setup

# Package meta-data.
NAME = "cicflowmeter"
DESCRIPTION = "CICFlowMeter V3 Python Implementation"
URL = "https://gitlab.com/hieulw/cicflowmeter"
EMAIL = "hieulw99@gmail.com"
AUTHOR = "Le Hieu"
REQUIRES_PYTHON = ">=3.7.0"
VERSION = None

REQUIRED = ["numpy", "scipy", "scapy"]

# The rest you shouldn't have to touch too much :)
# ------------------------------------------------
# Except, perhaps the License and Trove Classifiers!
# If you do change the License, remember to change the Trove Classifier for that!

here = os.path.abspath(os.path.dirname(__file__))

# Import the README and use it as the long-description.
# Note: this will only work if 'README.md' is present in your MANIFEST.in file!
try:
    with io.open(os.path.join(here, "README.md"), encoding="utf-8") as f:
        long_description = "\n" + f.read()
except FileNotFoundError:
    long_description = DESCRIPTION

# Load the package's __version__.py module as a dictionary.
about = {}
if not VERSION:
    prefix = "src"
    project_slug = NAME.lower().replace("-", "_").replace(" ", "_")
    with open(os.path.join(here, prefix, project_slug, "__init__.py")) as f:
        exec(f.read(), about)
else:
    about["__version__"] = VERSION

# Where the magic happens:
setup(
    name=NAME,
    version=about["__version__"],
    description=DESCRIPTION,
    long_description=long_description,
    author=AUTHOR,
    author_email=EMAIL,
    python_requires=REQUIRES_PYTHON,
    url=URL,
    packages=find_packages("src"),
    # package_dir={"cicflowmeter": "src/cicflowmeter"},
    package_dir={"": "src"},
    entry_points={
        "console_scripts": ["cicflowmeter=cicflowmeter.sniffer:main"],
    },
    install_requires=REQUIRED,
    include_package_data=True,
    license="MIT",
    classifiers=[
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: Implementation :: CPython",
        "Programming Language :: Python :: Implementation :: PyPy",
    ],
)
