[![PyPI](https://img.shields.io/pypi/v/pybryt)](https://pypi.org/project/pybryt/)
[![GitHub license](https://img.shields.io/github/license/microsoft/pybryt.svg)](https://github.com/microsoft/pybryt/blob/main/LICENSE)
[![GitHub contributors](https://img.shields.io/github/contributors/microsoft/pybryt.svg)](https://GitHub.com/microsoft/pybryt/graphs/contributors/)
[![GitHub issues](https://img.shields.io/github/issues/microsoft/pybryt.svg)](https://GitHub.com/microsoft/pybryt/issues/)
[![GitHub pull-requests](https://img.shields.io/github/issues-pr/microsoft/pybryt.svg)](https://GitHub.com/microsoft/pybryt/pull/)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](http://makeapullrequest.com)
[![GitHub Actions](https://github.com/microsoft/pybryt/actions/workflows/run-tests.yml/badge.svg)](https://github.com/microsoft/pybryt/actions/workflows/run-tests.yml)
[![codecov](https://codecov.io/gh/microsoft/pybryt/branch/main/graph/badge.svg?token=PFVA425I3X)](https://codecov.io/gh/microsoft/pybryt)

[![GitHub watchers](https://img.shields.io/github/watchers/microsoft/pybryt.svg?style=social&label=Watch&maxAge=2592000)](https://GitHub.com/microsoft/pybryt/watchers/)
[![GitHub forks](https://img.shields.io/github/forks/microsoft/pybryt.svg?style=social&label=Fork&maxAge=2592000)](https://GitHub.com/microsoft/pybryt/network/)
[![GitHub stars](https://img.shields.io/github/stars/microsoft/pybryt.svg?style=social&label=Star&maxAge=2592000)](https://GitHub.com/microsoft/pybryt/stargazers/)

# PyBryt - Python Library

![PyBrytLogo](https://github.com/microsoft/pybryt/blob/main/images/pybryt-logo.PNG "PyBryt")

PyBryt is an auto-assessment Python library for teaching and learning.

- The PyBryt Library is a FREE Open Source Python Library that provides auto assessment of grading submissions. Our goal is to empower students and educators to learn about technology through fun, guided, hands-on content aimed at specific learning goals.
- The PyBryt Library is a Open Source Python Library - focused on the auto assessment and validation of Python coding.
- The PyBryt library has been developed under open source to support learning and training institutions to auto assess the work completed by learners.<br>![PyBrytGoals](https://github.com/microsoft/pybryt/blob/main/images/pybryt-goals.PNG "PyBryt Goals")
- The PyBryt Library will work existing auto grading solution such as [Otter Grader](https://pypi.org/project/otter-grader/), [OkPy](https://pypi.org/project/okpy/) or [Autolab](https://pypi.org/project/autolab/).

## Features

Educators and Institutions can leverage the PyBryt Library to integrate auto assessment and reference models to hands on labs and assessments.

- Educators do not have to enforce the structure of the solution;
- Learner practice the design process,code design and implemented solution;
- Meaningful & pedagogical feedback to the learners;
- Analysis of complexity within the learners solution;
- Plagiarism detection and support for reference solutions;
- Easy integration into existing organizational or institutional grading infrastructure. 

## Getting Started

See the [Getting Started](https://microsoft.github.io/pybryt/html/getting_started.html) page on the pybryt documentation for steps to install and use pybryt for the first time.

## Testing

To run the demos, all demos are located in the demo folder. 

First install PyBryt with `pip`:

```
pip install pybryt
```

Simply launch the `index.ipynb` notebook in each of the directories under `demo` from Jupyter Notebook, which demonstrates the process of using PyBryt to assess student submissions.

## Contributing

This project welcomes contributions and suggestions.  Most contributions require you to agree to a
Contributor License Agreement (CLA) declaring that you have the right to, and actually do, grant us
the rights to use your contribution. For details, visit
[https://cla.opensource.microsoft.com](https://cla.opensource.microsoft.com).

When you submit a pull request, a CLA bot will automatically determine whether you need to provide
a CLA and decorate the PR appropriately (e.g., status check, comment). Simply follow the instructions
provided by the bot. You will only need to do this once across all repos using our CLA.

This project has adopted the [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/).
For more information see the [Code of Conduct FAQ](https://opensource.microsoft.com/codeofconduct/faq/) or
contact [opencode@microsoft.com](mailto:opencode@microsoft.com) with any additional questions or comments.

## Trademarks

This project may contain trademarks or logos for projects, products, or services. Authorized use of Microsoft trademarks or logos is subject to and must follow [Microsoft's Trademark & Brand Guidelines](https://www.microsoft.com/en-us/legal/intellectualproperty/trademarks/usage/general).
Use of Microsoft trademarks or logos in modified versions of this project must not cause confusion or imply Microsoft sponsorship.
Any use of third-party trademarks or logos are subject to those third-party's policies.
