"""pyiso2mesh - Iso2Mesh for Python
"""

from .geometry import (
    meshgrid5,
    meshgrid6,
    latticegrid,
    meshabox,
    meshacylinder,
    meshcylinders,
    meshanellip,
    meshunitsphere,
    meshasphere,
    extrudecurve,
    extrudesurf,
)

from .plot import (
    plotsurf,
    plotasurf,
    plotmesh,
    plottetra,
    plotedges,
)

from .trait import (
    finddisconnsurf,
    surfedge,
    volface,
    extractloops,
    meshconn,
    nodevolume,
    elemvolume,
    neighborelem,
    layersurf,
    faceneighbors,
    edgeneighbors,
    maxsurf,
    flatsegment,
    surfplane,
    surfinterior,
    surfpart,
    surfseeds,
    meshquality,
    meshedge,
    meshface,
    surfacenorm,
    nodesurfnorm,
    uniqedges,
    uniqfaces,
    innersurf,
    advancefront,
    meshreorient,
    mesheuler,
    raytrace,
    elemfacecenter,
    barydualmesh,
    meshcentroid,
    highordertet,
)

from .utils import (
    getexeext,
    fallbackexeext,
    mwpath,
    mcpath,
    deletemeshfile,
    rotatevec3d,
    rotmat2vec,
    varargin2struct,
    jsonopt,
)

from .io import (
    saveinr,
    saveoff,
    saveasc,
    savestl,
    savebinstl,
    readmedit,
    readtetgen,
    savesurfpoly,
    readoff,
)

from .core import (
    v2m,
    v2s,
    s2m,
    s2v,
    vol2mesh,
    vol2surf,
    surf2mesh,
    surf2volz,
    surf2vol,
    binsurface,
    cgalv2m,
    cgals2m,
    getintersecttri,
    vol2restrictedtri,
    fillsurf,
    outersurf,
    surfvolume,
    insurface,
)

from .modify import (
    sms,
    smoothsurf,
    qmeshcut,
    meshcheckrepair,
    removedupelem,
    removedupnodes,
    removeisolatednode,
    removeisolatedsurf,
    surfaceclean,
    removeedgefaces,
    getintersecttri,
    delendelem,
    surfreorient,
    sortmesh,
    cart2sph,
    sortrows,
    mergemesh,
    meshrefine,
    mergesurf,
    surfboolean,
    meshresample,
    domeshsimplify,
    remeshsurf,
)

from .raster import (
    m2v,
    mesh2vol,
    mesh2mask,
    barycentricgrid,
)

__version__ = "0.3.2"
__all__ = [
    "advancefront",
    "barycentricgrid",
    "barydualmesh",
    "binsurface",
    "cart2sph",
    "cgals2m",
    "cgalv2m",
    "delendelem",
    "deletemeshfile",
    "domeshsimplify",
    "edgeneighbors",
    "elemfacecenter",
    "elemvolume",
    "extractloops",
    "extrudecurve",
    "extrudesurf",
    "faceneighbors",
    "fallbackexeext",
    "fillsurf",
    "finddisconnsurf",
    "flatsegment",
    "getexeext",
    "getintersecttri",
    "getintersecttri",
    "highordertet",
    "innersurf",
    "insurface",
    "jsonopt",
    "latticegrid",
    "layersurf",
    "m2v",
    "maxsurf",
    "mcpath",
    "mergemesh",
    "mergesurf",
    "mesh2mask",
    "mesh2vol",
    "meshabox",
    "meshacylinder",
    "meshanellip",
    "meshasphere",
    "meshcentroid",
    "meshcheckrepair",
    "meshconn",
    "meshcylinders",
    "meshedge",
    "mesheuler",
    "meshface",
    "meshgrid5",
    "meshgrid6",
    "meshquality",
    "meshrefine",
    "meshreorient",
    "meshresample",
    "meshunitsphere",
    "mwpath",
    "neighborelem",
    "nodesurfnorm",
    "nodevolume",
    "outersurf",
    "plotasurf",
    "plotedges",
    "plotmesh",
    "plotsurf",
    "plottetra",
    "qmeshcut",
    "raytrace",
    "readmedit",
    "readoff",
    "readtetgen",
    "remeshsurf",
    "removedupelem",
    "removedupnodes",
    "removeedgefaces",
    "removeisolatednode",
    "removeisolatedsurf",
    "rotatevec3d",
    "rotmat2vec",
    "s2m",
    "s2v",
    "saveasc",
    "savebinstl",
    "saveinr",
    "saveoff",
    "savestl",
    "savesurfpoly",
    "smoothsurf",
    "sms",
    "sortmesh",
    "sortrows",
    "surf2mesh",
    "surf2vol",
    "surf2volz",
    "surfaceclean",
    "surfacenorm",
    "surfboolean",
    "surfedge",
    "surfinterior",
    "surfpart",
    "surfplane",
    "surfreorient",
    "surfseeds",
    "surfvolume",
    "uniqedges",
    "uniqfaces",
    "v2m",
    "v2s",
    "varargin2struct",
    "vol2mesh",
    "vol2restrictedtri",
    "vol2surf",
    "volface",
]
__license__ = """GNU General Public License v3 and later"""
