
# storage for citations a dictionary of tuples, first element bibtex id(s), second element bibtex
CITATIONS = {
    "general": {
        "cogsworth": {
            "tags": ["cogsworth:joss", "cogsworth:apjs"],
            "bibtex": r"""@ARTICLE{cogsworth:joss,
       author = {{Wagg}, Tom and {Breivik}, Katelyn and {Renzo}, Mathieu and {Price-Whelan}, Adrian},
        title = "{cogsworth: A Gala of COSMIC proportions combining binary stellar evolution and galactic dynamics}",
      journal = {The Journal of Open Source Software},
     keywords = {astronomy, binary stellar evolution, galactic dynamics, Python},
         year = 2025,
        month = jan,
       volume = {10},
       number = {105},
          eid = {7400},
        pages = {7400},
          doi = {10.21105/joss.07400},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2025JOSS...10.7400W},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}}
      
@ARTICLE{cogsworth:apjs,
       author = {{Wagg}, Tom and {Breivik}, Katelyn and {Renzo}, Mathieu and {Price-Whelan}, Adrian M.},
        title = "{cogsworth: A Gala of COSMIC Proportions Combining Binary Stellar Evolution and Galactic Dynamics}",
      journal = {\apjs},
     keywords = {Binary stars, Stellar evolution, Galaxy dynamics, Open source software, 154, 1599, 591, 1866, Astrophysics - Astrophysics of Galaxies, Astrophysics - Instrumentation and Methods for Astrophysics, Astrophysics - Solar and Stellar Astrophysics},
         year = 2025,
        month = jan,
       volume = {276},
       number = {1},
          eid = {16},
        pages = {16},
          doi = {10.3847/1538-4365/ad8b1f},
archivePrefix = {arXiv},
       eprint = {2409.04543},
 primaryClass = {astro-ph.GA},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2025ApJS..276...16W},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}}"""
        },
        "cosmic": {
            "tags": ["cosmic:apj"],
            "bibtex": r"""@ARTICLE{Breivik+2020,
       author = {{Breivik}, Katelyn and {Coughlin}, Scott and {Zevin}, Michael and {Rodriguez}, Carl L. and {Kremer}, Kyle and et al.},
        title = "{COSMIC Variance in Binary Population Synthesis}",
      journal = {\apj},
     keywords = {Compact binary stars, Interacting binary stars, Stellar populations, Gravitational wave astronomy, 283, 801, 1622, 675, Astrophysics - High Energy Astrophysical Phenomena, Astrophysics - Solar and Stellar Astrophysics},
         year = 2020,
        month = jul,
       volume = {898},
       number = {1},
          eid = {71},
        pages = {71},
          doi = {10.3847/1538-4357/ab9d85},
archivePrefix = {arXiv},
       eprint = {1911.00903},
 primaryClass = {astro-ph.HE},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2020ApJ...898...71B},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}}"""
        },
        "gala": {
            "tags": ["gala:joss"],
            "bibtex": r"""@article{gala,
        doi = {10.21105/joss.00388},
        url = {https://doi.org/10.21105%2Fjoss.00388},
        year = 2017,
        month = {oct},
        publisher = {The Open Journal},
        volume = {2},
        number = {18},
        author = {Adrian M. Price-Whelan},
        title = {Gala: A Python package for galactic dynamics},
        journal = {The Journal of Open Source Software}}"""
        },
    },
    "sfh": {
        "Wagg+2022": {
            "tags": ["Wagg+2022"],
            "bibtex": r"""@ARTICLE{Wagg+2022,
       author = {{Wagg}, T. and {Broekgaarden}, F.~S. and {de Mink}, S.~E. and {Frankel}, N. and {van Son}, L.~A.~C. and et al.},
        title = "{Gravitational Wave Sources in Our Galactic Backyard: Predictions for BHBH, BHNS, and NSNS Binaries Detectable with LISA}",
      journal = {\apj},
     keywords = {Gravitational waves, Gravitational wave detectors, Compact objects, Neutron stars, Stellar mass black holes, Binary stars, Pulsars, Stellar evolution, 678, 676, 288, 1108, 1611, 154, 1306, 1599, Astrophysics - High Energy Astrophysical Phenomena},
         year = 2022,
        month = oct,
       volume = {937},
       number = {2},
          eid = {118},
        pages = {118},
          doi = {10.3847/1538-4357/ac8675},
archivePrefix = {arXiv},
       eprint = {2111.13704},
 primaryClass = {astro-ph.HE},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2022ApJ...937..118W},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}}"""
        },
        "Frankel+2018": {
            "tags": ["Frankel+2018"],
            "bibtex": r"""@ARTICLE{Frankel+2018,
       author = {{Frankel}, Neige and {Rix}, Hans-Walter and {Ting}, Yuan-Sen and {Ness}, Melissa and {Hogg}, David W.},
        title = "{Measuring Radial Orbit Migration in the Galactic Disk}",
      journal = {\apj},
     keywords = {Galaxy: abundances, Galaxy: disk, Galaxy: evolution, Galaxy: formation, ISM: abundances, stars: abundances, Astrophysics - Astrophysics of Galaxies},
         year = 2018,
        month = oct,
       volume = {865},
       number = {2},
          eid = {96},
        pages = {96},
          doi = {10.3847/1538-4357/aadba5},
archivePrefix = {arXiv},
       eprint = {1805.09198},
 primaryClass = {astro-ph.GA},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2018ApJ...865...96F},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}}"""
        },
        "Bovy+2016": {
            "tags": ["Bovy+2016"],
            "bibtex": r"""@ARTICLE{Bovy+2016,
       author = {{Bovy}, Jo and {Rix}, Hans-Walter and {Schlafly}, Edward F. and {Nidever}, David L. and {Holtzman}, Jon A. and et al.},
        title = "{The Stellar Population Structure of the Galactic Disk}",
      journal = {\apj},
     keywords = {Galaxy: abundances, Galaxy: disk, Galaxy: evolution, Galaxy: formation, Galaxy: fundamental parameters, Galaxy: structure, Astrophysics - Astrophysics of Galaxies},
         year = 2016,
        month = may,
       volume = {823},
       number = {1},
          eid = {30},
        pages = {30},
          doi = {10.3847/0004-637X/823/1/30},
archivePrefix = {arXiv},
       eprint = {1509.05796},
 primaryClass = {astro-ph.GA},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2016ApJ...823...30B},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}}"""
        },
        "Bovy+2019": {
            "tags": ["Bovy+2019"],
            "bibtex": r"""@ARTICLE{Bovy+2019,
       author = {{Bovy}, Jo and {Leung}, Henry W. and {Hunt}, Jason A.~S. and {Mackereth}, J. Ted and {Garc{\'\i}a-Hern{\'a}ndez}, Domingo A. and et al.},
        title = "{Life in the fast lane: a direct view of the dynamics, formation, and evolution of the Milky Way's bar}",
      journal = {\mnras},
     keywords = {Galaxy: abundances, Galaxy: bulge, Galaxy: evolution, Galaxy: fundamental parameters, Galaxy: kinematics and dynamics, Galaxy: structure, Astrophysics - Astrophysics of Galaxies, Astrophysics - Cosmology and Nongalactic Astrophysics},
         year = 2019,
        month = dec,
       volume = {490},
       number = {4},
        pages = {4740-4747},
          doi = {10.1093/mnras/stz2891},
archivePrefix = {arXiv},
       eprint = {1905.11404},
 primaryClass = {astro-ph.GA},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2019MNRAS.490.4740B},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}}"""
        },
        "McMillan+2011": {
            "tags": ["McMillan+2011"],
            "bibtex": r"""@ARTICLE{McMillan+2011,
       author = {{McMillan}, Paul J.},
        title = "{Mass models of the Milky Way}",
      journal = {\mnras},
     keywords = {methods: statistical, Galaxy: fundamental parameters, Galaxy: kinematics and dynamics, Astrophysics - Astrophysics of Galaxies},
         year = 2011,
        month = jul,
       volume = {414},
       number = {3},
        pages = {2446-2457},
          doi = {10.1111/j.1365-2966.2011.18564.x},
archivePrefix = {arXiv},
       eprint = {1102.4340},
 primaryClass = {astro-ph.GA},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2011MNRAS.414.2446M},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}}"""
        },
        "Sanders&Binney2015": {
            "tags": ["Sanders&Binney2015"],
            "bibtex": r"""@ARTICLE{Sanders&Binney2015,
       author = {{Sanders}, Jason L. and {Binney}, James},
        title = "{Extended distribution functions for our Galaxy}",
      journal = {\mnras},
     keywords = {Galaxy: abundances, Galaxy: disc, Galaxy: evolution, Galaxy: kinematics and dynamics, solar neighbourhood, Astrophysics - Astrophysics of Galaxies},
         year = 2015,
        month = jun,
       volume = {449},
       number = {4},
        pages = {3479-3502},
          doi = {10.1093/mnras/stv578},
archivePrefix = {arXiv},
       eprint = {1501.02227},
 primaryClass = {astro-ph.GA},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2015MNRAS.449.3479S},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}
}"""
        },
        "Pascale+2019": {
            "tags": ["Pascale+2019"],
            "bibtex": r"""@ARTICLE{Pascale+2019:2019MNRAS.488.2423P,
       author = {{Pascale}, Raffaele and {Binney}, James and {Nipoti}, Carlo and {Posti}, Lorenzo},
        title = "{Action-based models for dwarf spheroidal galaxies and globular clusters}",
      journal = {\mnras},
     keywords = {globular clusters: general, galaxies: dwarf, galaxies: kinematics and dynamics, galaxies: structure, dark matter, Astrophysics - Astrophysics of Galaxies},
         year = 2019,
        month = sep,
       volume = {488},
       number = {2},
        pages = {2423-2439},
          doi = {10.1093/mnras/stz1617},
archivePrefix = {arXiv},
       eprint = {1904.08447},
 primaryClass = {astro-ph.GA},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2019MNRAS.488.2423P},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}
}"""
        },
    },
    "observables": {
        "isochrones": {
            "tags": ["isochrones-python"],
            "bibtex": r"""@MISC{isochrones-python,
       author = {{Morton}, Timothy D.},
        title = "{isochrones: Stellar model grid package}",
     keywords = {Software},
 howpublished = {Astrophysics Source Code Library, record ascl:1503.010},
         year = 2015,
        month = mar,
          eid = {ascl:1503.010},
        pages = {ascl:1503.010},
archivePrefix = {ascl},
       eprint = {1503.010},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2015ascl.soft03010M},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}}"""
        },
        "MIST": {
            "tags": ["MIST0", "MIST1"],
            "bibtex": r"""@ARTICLE{Dotter+2016,
       author = {{Dotter}, Aaron},
        title = "{MESA Isochrones and Stellar Tracks (MIST) 0: Methods for the Construction of Stellar Isochrones}",
      journal = {\apjs},
     keywords = {methods: numerical, stars: evolution, Astrophysics - Solar and Stellar Astrophysics, Astrophysics - Instrumentation and Methods for Astrophysics},
         year = 2016,
        month = jan,
       volume = {222},
       number = {1},
          eid = {8},
        pages = {8},
          doi = {10.3847/0067-0049/222/1/8},
archivePrefix = {arXiv},
       eprint = {1601.05144},
 primaryClass = {astro-ph.SR},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2016ApJS..222....8D},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}}

@ARTICLE{Choi+2016,
       author = {{Choi}, Jieun and {Dotter}, Aaron and {Conroy}, Charlie and {Cantiello}, Matteo and {Paxton}, Bill and et al.},
        title = "{Mesa Isochrones and Stellar Tracks (MIST). I. Solar-scaled Models}",
      journal = {\apj},
     keywords = {stars: evolution, stars: general, stars: interiors, Astrophysics - Solar and Stellar Astrophysics},
         year = 2016,
        month = jun,
       volume = {823},
       number = {2},
          eid = {102},
        pages = {102},
          doi = {10.3847/0004-637X/823/2/102},
archivePrefix = {arXiv},
       eprint = {1604.08592},
 primaryClass = {astro-ph.SR},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2016ApJ...823..102C},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}}"""
        },
        "MESA": {
            "tags": ["Paxton+2011", "Paxton+2013", "Paxton+2015", "Paxton+2018"],
            "bibtex": r"""@ARTICLE{Paxton+2011,
       author = {{Paxton}, Bill and {Bildsten}, Lars and {Dotter}, Aaron and {Herwig}, Falk and {Lesaffre}, Pierre and et al.},
        title = "{Modules for Experiments in Stellar Astrophysics (MESA)}",
      journal = {\apjs},
     keywords = {methods: numerical, stars: evolution, stars: general, Astrophysics - Solar and Stellar Astrophysics, Astrophysics - Instrumentation and Methods for Astrophysics},
         year = 2011,
        month = jan,
       volume = {192},
       number = {1},
          eid = {3},
        pages = {3},
          doi = {10.1088/0067-0049/192/1/3},
archivePrefix = {arXiv},
       eprint = {1009.1622},
 primaryClass = {astro-ph.SR},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2011ApJS..192....3P},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}}

@ARTICLE{Paxton+2013,
       author = {{Paxton}, Bill and {Cantiello}, Matteo and {Arras}, Phil and {Bildsten}, Lars and {Brown}, Edward F. and et al.},
        title = "{Modules for Experiments in Stellar Astrophysics (MESA): Planets, Oscillations, Rotation, and Massive Stars}",
      journal = {\apjs},
     keywords = {asteroseismology, methods: numerical, planets and satellites: physical evolution, stars: evolution, stars: massive, stars: rotation, Astrophysics - Solar and Stellar Astrophysics, Astrophysics - Instrumentation and Methods for Astrophysics},
         year = 2013,
        month = sep,
       volume = {208},
       number = {1},
          eid = {4},
        pages = {4},
          doi = {10.1088/0067-0049/208/1/4},
archivePrefix = {arXiv},
       eprint = {1301.0319},
 primaryClass = {astro-ph.SR},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2013ApJS..208....4P},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}}

@ARTICLE{Paxton+2015,
       author = {{Paxton}, Bill and {Marchant}, Pablo and {Schwab}, Josiah and {Bauer}, Evan B. and {Bildsten}, Lars and et al.},
        title = "{Modules for Experiments in Stellar Astrophysics (MESA): Binaries, Pulsations, and Explosions}",
      journal = {\apjs},
     keywords = {binaries: general, methods: numerical, nuclear reactions, nucleosynthesis, abundances, shock waves, stars: evolution, stars: oscillations, Astrophysics - Solar and Stellar Astrophysics},
         year = 2015,
        month = sep,
       volume = {220},
       number = {1},
          eid = {15},
        pages = {15},
          doi = {10.1088/0067-0049/220/1/15},
archivePrefix = {arXiv},
       eprint = {1506.03146},
 primaryClass = {astro-ph.SR},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2015ApJS..220...15P},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}}

@ARTICLE{Paxton+2018,
       author = {{Paxton}, Bill and {Schwab}, Josiah and {Bauer}, Evan B. and {Bildsten}, Lars and {Blinnikov}, Sergei and et al.},
        title = "{Modules for Experiments in Stellar Astrophysics (MESA): Convective Boundaries, Element Diffusion, and Massive Star Explosions}",
      journal = {\apjs},
     keywords = {convection, diffusion, hydrodynamics, methods: numerical, stars: evolution, supernovae: general, Astrophysics - Solar and Stellar Astrophysics, Astrophysics - High Energy Astrophysical Phenomena},
         year = 2018,
        month = feb,
       volume = {234},
       number = {2},
          eid = {34},
        pages = {34},
          doi = {10.3847/1538-4365/aaa5a8},
archivePrefix = {arXiv},
       eprint = {1710.08424},
 primaryClass = {astro-ph.SR},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2018ApJS..234...34P},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}}"""
    },
        "bayestar2019": {
            "tags": ["bayestar2019"],
            "bibtex": r"""@ARTICLE{bayestar2019,
       author = {{Green}, Gregory M. and {Schlafly}, Edward and {Zucker}, Catherine and {Speagle}, Joshua S. and {Finkbeiner}, Douglas},
        title = "{A 3D Dust Map Based on Gaia, Pan-STARRS 1, and 2MASS}",
      journal = {\apj},
     keywords = {Interstellar reddening, Interstellar dust extinction, Galaxy structure, Galaxy stellar content, Interstellar dust, 853, 837, 622, 621, 836, Astrophysics - Astrophysics of Galaxies},
         year = 2019,
        month = dec,
       volume = {887},
       number = {1},
          eid = {93},
        pages = {93},
          doi = {10.3847/1538-4357/ab5362},
archivePrefix = {arXiv},
       eprint = {1905.02734},
 primaryClass = {astro-ph.GA},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2019ApJ...887...93G},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}}"""
        },
    },
    "gaia": {
        "gaia-selection-function": {
            "tags": ["gaia-selection-function"],
            "bibtex": r"""@ARTICLE{Cantat-Gaudin+2023,
       author = {{Cantat-Gaudin}, Tristan and {Fouesneau}, Morgan and {Rix}, Hans-Walter and {Brown}, Anthony G.~A. and {Castro-Ginard}, Alfred and et al.},
        title = "{An empirical model of the Gaia DR3 selection function}",
      journal = {\aap},
     keywords = {astrometry, catalogs, methods: data analysis, methods: statistical, Astrophysics - Astrophysics of Galaxies, Astrophysics - Instrumentation and Methods for Astrophysics},
         year = 2023,
        month = jan,
       volume = {669},
          eid = {A55},
        pages = {A55},
          doi = {10.1051/0004-6361/202244784},
archivePrefix = {arXiv},
       eprint = {2208.09335},
 primaryClass = {astro-ph.GA},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2023A&A...669A..55C},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}}"""
        }
    },
    "legwork": {
        "legwork": {
            "tags": ["legwork-joss", "legwork-apjs"],
            "bibtex": r"""@ARTICLE{legwork-joss,
       author = {{Wagg}, T. and {Breivik}, K. and {de Mink}, S.~E.},
        title = "{LEGWORK: A Python Package for Computing the Evolution and Detectability of Stellar-origin Gravitational-wave Sources with Space-based Detectors}",
      journal = {\apjs},
     keywords = {Open source software, Gravitational waves, Gravitational wave detectors, Compact objects, Orbital evolution, White dwarf stars, Neutron stars, Stellar mass black holes, 1866, 678, 676, 288, 1178, 1799, 1108, 1611, Astrophysics - High Energy Astrophysical Phenomena, General Relativity and Quantum Cosmology},
         year = 2022,
        month = jun,
       volume = {260},
       number = {2},
          eid = {52},
        pages = {52},
          doi = {10.3847/1538-4365/ac5c52},
archivePrefix = {arXiv},
       eprint = {2111.08717},
 primaryClass = {astro-ph.HE},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2022ApJS..260...52W},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}
}

@ARTICLE{legwork-apjs,
       author = {{Wagg}, Tom and {Breivik}, Katelyn and {de Mink}, Selma},
        title = "{LEGWORK: A python package for computing the evolution and detectability of stellar-origin gravitational-wave sources with space-based detectors}",
      journal = {The Journal of Open Source Software},
     keywords = {neutron stars, white dwarfs, TianQin, Python, stellar mass black holes, gravitational wave detectors, orbital evolution, compact objects, gravitational waves, LISA, astronomy},
         year = 2022,
        month = feb,
       volume = {7},
       number = {70},
          eid = {3998},
        pages = {3998},
          doi = {10.21105/joss.03998},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2022JOSS....7.3998W},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}}"""},
    },
    "FIRE": {
        "FIRE": {
            "tags": ["Hopkins+2014", "Hopkins+2018", "Hopkins+2023"],
            "bibtex": r"""@ARTICLE{Hopkins+2014,
       author = {{Hopkins}, Philip F. and {Kere{\v{s}}}, Du{\v{s}}an and {O{\~n}orbe}, Jos{\'e} and {Faucher-Gigu{\`e}re}, Claude-Andr{\'e} and {Quataert}, Eliot and {Murray}, Norman and {Bullock}, James S.},
        title = "{Galaxies on FIRE (Feedback In Realistic Environments): stellar feedback explains cosmologically inefficient star formation}",
      journal = {\mnras},
     keywords = {stars: formation, galaxies: active, galaxies: evolution, galaxies: formation, cosmology: theory, Astrophysics - Cosmology and Nongalactic Astrophysics, Astrophysics - Astrophysics of Galaxies},
         year = 2014,
        month = nov,
       volume = {445},
       number = {1},
        pages = {581-603},
          doi = {10.1093/mnras/stu1738},
archivePrefix = {arXiv},
       eprint = {1311.2073},
 primaryClass = {astro-ph.CO},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2014MNRAS.445..581H},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}
}

@ARTICLE{Hopkins+2018,
       author = {{Hopkins}, Philip F. and {Wetzel}, Andrew and {Kere{\v{s}}}, Du{\v{s}}an and {Faucher-Gigu{\`e}re}, Claude-Andr{\'e} and {Quataert}, Eliot and {Boylan-Kolchin}, Michael and {Murray}, Norman and {Hayward}, Christopher C. and {Garrison-Kimmel}, Shea and {Hummels}, Cameron and {Feldmann}, Robert and {Torrey}, Paul and {Ma}, Xiangcheng and {Angl{\'e}s-Alc{\'a}zar}, Daniel and {Su}, Kung-Yi and {Orr}, Matthew and {Schmitz}, Denise and {Escala}, Ivanna and {Sanderson}, Robyn and {Grudi{\'c}}, Michael Y. and {Hafen}, Zachary and {Kim}, Ji-Hoon and {Fitts}, Alex and {Bullock}, James S. and {Wheeler}, Coral and {Chan}, T.~K. and {Elbert}, Oliver D. and {Narayanan}, Desika},
        title = "{FIRE-2 simulations: physics versus numerics in galaxy formation}",
      journal = {\mnras},
     keywords = {methods: numerical, stars: formation, galaxies: active, galaxies: evolution, galaxies: formation, cosmology: theory, Astrophysics - Astrophysics of Galaxies, Astrophysics - Cosmology and Nongalactic Astrophysics, Astrophysics - Instrumentation and Methods for Astrophysics},
         year = 2018,
        month = oct,
       volume = {480},
       number = {1},
        pages = {800-863},
          doi = {10.1093/mnras/sty1690},
archivePrefix = {arXiv},
       eprint = {1702.06148},
 primaryClass = {astro-ph.GA},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2018MNRAS.480..800H},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}
}

@ARTICLE{Hopkins+2023,
       author = {{Hopkins}, Philip F. and {Wetzel}, Andrew and {Wheeler}, Coral and {Sanderson}, Robyn and {Grudi{\'c}}, Michael Y. and {Sameie}, Omid and {Boylan-Kolchin}, Michael and {Orr}, Matthew and {Ma}, Xiangcheng and {Faucher-Gigu{\`e}re}, Claude-Andr{\'e} and {Kere{\v{s}}}, Du{\v{s}}an and {Quataert}, Eliot and {Su}, Kung-Yi and {Moreno}, Jorge and {Feldmann}, Robert and {Bullock}, James S. and {Loebman}, Sarah R. and {Angl{\'e}s-Alc{\'a}zar}, Daniel and {Stern}, Jonathan and {Necib}, Lina and {Choban}, Caleb R. and {Hayward}, Christopher C.},
        title = "{FIRE-3: updated stellar evolution models, yields, and microphysics and fitting functions for applications in galaxy simulations}",
      journal = {\mnras},
     keywords = {methods: numerical, stars: formation, ISM: structure, galaxies: evolution, galaxies: formation, Astrophysics - Astrophysics of Galaxies, Astrophysics - Cosmology and Nongalactic Astrophysics, Astrophysics - High Energy Astrophysical Phenomena, Astrophysics - Instrumentation and Methods for Astrophysics, Astrophysics - Solar and Stellar Astrophysics},
         year = 2023,
        month = feb,
       volume = {519},
       number = {2},
        pages = {3154-3181},
          doi = {10.1093/mnras/stac3489},
archivePrefix = {arXiv},
       eprint = {2203.00040},
 primaryClass = {astro-ph.GA},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2023MNRAS.519.3154H},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}}"""},
    },
    "hydro": {
        "pynbody": {
            "tags": ["pynbody"],
            "bibtex": r"""@misc{pynbody,
  author = {{Pontzen}, A. and {Ro{\v s}kar}, R. and {Stinson}, G.~S. and {Woods},
     R. and {Reed}, D.~M. and {Coles}, J. and {Quinn}, T.~R.},
  title = "{pynbody: Astrophysics Simulation Analysis for Python}",
  note = {Astrophysics Source Code Library, ascl:1305.002},
  year = 2013}"""
        }
    }
}
