# Generated by Django 3.1.2 on 2020-11-25 12:31

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Cell",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("original_value", models.TextField(null=True)),
                ("latest_value", models.TextField(null=True)),
            ],
        ),
        migrations.CreateModel(
            name="Column",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                ("type", models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name="Permission",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("permission_type", models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name="Row",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("key", models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name="Spreadsheet",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255, unique=True)),
                ("object_name", models.CharField(max_length=255)),
                ("key_column", models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name="Template",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("wiki_key", models.TextField(null=True)),
                ("type", models.TextField(null=True)),
                ("name", models.TextField()),
                ("is_default", models.BooleanField(default=False)),
                ("template_file", models.FileField(upload_to="templates/")),
                (
                    "sheet",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="templates",
                        to="torque.spreadsheet",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="User",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("username", models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name="SheetConfig",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("wiki_key", models.TextField()),
                ("group", models.TextField()),
                (
                    "sheet",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="configs",
                        to="torque.spreadsheet",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="SearchCacheRow",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("wiki_key", models.TextField()),
                ("group", models.TextField()),
                ("data", models.TextField()),
                (
                    "row",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="torque.row"
                    ),
                ),
                (
                    "sheet",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="torque.spreadsheet",
                    ),
                ),
                (
                    "sheet_config",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="torque.sheetconfig",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="row",
            name="sheet",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="rows",
                to="torque.spreadsheet",
            ),
        ),
        migrations.AddField(
            model_name="row",
            name="sheet_config",
            field=models.ManyToManyField(
                related_name="valid_ids", to="torque.SheetConfig"
            ),
        ),
        migrations.CreateModel(
            name="PermissionGroup",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                ("object_name", models.CharField(max_length=255)),
                ("columns", models.ManyToManyField(to="torque.Column")),
            ],
        ),
        migrations.AddField(
            model_name="column",
            name="sheet",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="columns",
                to="torque.spreadsheet",
            ),
        ),
        migrations.AddField(
            model_name="column",
            name="sheet_config",
            field=models.ManyToManyField(
                related_name="valid_columns", to="torque.SheetConfig"
            ),
        ),
        migrations.CreateModel(
            name="CellEdit",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("value", models.CharField(max_length=255)),
                ("message", models.CharField(max_length=255, null=True)),
                ("edit_timestamp", models.DateTimeField(auto_now=True)),
                ("approval_timestamp", models.DateTimeField(null=True)),
                ("approval_code", models.CharField(max_length=255, null=True)),
                (
                    "cell",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="edits",
                        to="torque.cell",
                    ),
                ),
                (
                    "config",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="torque.sheetconfig",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="cell",
            name="column",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="cells",
                to="torque.column",
            ),
        ),
        migrations.AddField(
            model_name="cell",
            name="row",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="cells",
                to="torque.row",
            ),
        ),
        migrations.CreateModel(
            name="Attachment",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.TextField()),
                ("file", models.FileField(upload_to="attachments")),
                (
                    "permissions_column",
                    models.ForeignKey(
                        default=None,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="attachments",
                        to="torque.column",
                    ),
                ),
                (
                    "row",
                    models.ForeignKey(
                        default=None,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="attachments",
                        to="torque.row",
                    ),
                ),
                (
                    "sheet",
                    models.ForeignKey(
                        default=None,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="attachments",
                        to="torque.spreadsheet",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="TableOfContents",
            fields=[
                ("name", models.TextField()),
                ("json_file", models.TextField()),
                (
                    "template",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        serialize=False,
                        to="torque.template",
                    ),
                ),
                (
                    "sheet",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="tables_of_contents",
                        to="torque.spreadsheet",
                    ),
                ),
            ],
        ),
        migrations.AddConstraint(
            model_name="row",
            constraint=models.UniqueConstraint(
                fields=("sheet", "key"), name="unique_key"
            ),
        ),
        migrations.AddConstraint(
            model_name="tableofcontents",
            constraint=models.UniqueConstraint(
                fields=("sheet", "name"), name="unique_toc"
            ),
        ),
    ]
