"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpnPbrRouteEntry = exports.VpnPbrRouteEntryProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vpc_generated_1 = require("./vpc.generated");
Object.defineProperty(exports, "VpnPbrRouteEntryProperty", { enumerable: true, get: function () { return vpc_generated_1.RosVpnPbrRouteEntry; } });
/**
 * A ROS resource type:  `ALIYUN::VPC::VpnPbrRouteEntry`
 */
class VpnPbrRouteEntry extends ros.Resource {
    /**
     * Create a new `ALIYUN::VPC::VpnPbrRouteEntry`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosVpnPbrRouteEntry = new vpc_generated_1.RosVpnPbrRouteEntry(this, id, {
            description: props.description,
            routeDest: props.routeDest,
            overlayMode: props.overlayMode,
            vpnGatewayId: props.vpnGatewayId,
            nextHop: props.nextHop,
            routeSource: props.routeSource,
            publishVpc: props.publishVpc,
            weight: props.weight,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosVpnPbrRouteEntry;
        this.attrNextHop = rosVpnPbrRouteEntry.attrNextHop;
        this.attrRouteDest = rosVpnPbrRouteEntry.attrRouteDest;
        this.attrRouteSource = rosVpnPbrRouteEntry.attrRouteSource;
        this.attrVpnGatewayId = rosVpnPbrRouteEntry.attrVpnGatewayId;
    }
}
exports.VpnPbrRouteEntry = VpnPbrRouteEntry;
//# sourceMappingURL=data:application/json;base64,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