"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcPeerConnection = exports.VpcPeerConnectionProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vpc_generated_1 = require("./vpc.generated");
Object.defineProperty(exports, "VpcPeerConnectionProperty", { enumerable: true, get: function () { return vpc_generated_1.RosVpcPeerConnection; } });
/**
 * A ROS resource type:  `ALIYUN::VPC::VpcPeerConnection`
 */
class VpcPeerConnection extends ros.Resource {
    /**
     * Create a new `ALIYUN::VPC::VpcPeerConnection`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosVpcPeerConnection = new vpc_generated_1.RosVpcPeerConnection(this, id, {
            description: props.description,
            deletionForce: props.deletionForce,
            acceptingVpcId: props.acceptingVpcId,
            vpcId: props.vpcId,
            acceptingRegionId: props.acceptingRegionId,
            acceptingAliUid: props.acceptingAliUid,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosVpcPeerConnection;
        this.attrInstanceId = rosVpcPeerConnection.attrInstanceId;
    }
}
exports.VpcPeerConnection = VpcPeerConnection;
//# sourceMappingURL=data:application/json;base64,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