"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SslVpnServer = exports.SslVpnServerProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vpc_generated_1 = require("./vpc.generated");
Object.defineProperty(exports, "SslVpnServerProperty", { enumerable: true, get: function () { return vpc_generated_1.RosSslVpnServer; } });
/**
 * A ROS resource type:  `ALIYUN::VPC::SslVpnServer`
 */
class SslVpnServer extends ros.Resource {
    /**
     * Create a new `ALIYUN::VPC::SslVpnServer`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosSslVpnServer = new vpc_generated_1.RosSslVpnServer(this, id, {
            compress: props.compress === undefined || props.compress === null ? false : props.compress,
            localSubnet: props.localSubnet,
            clientIpPool: props.clientIpPool,
            proto: props.proto === undefined || props.proto === null ? 'UDP' : props.proto,
            vpnGatewayId: props.vpnGatewayId,
            port: props.port === undefined || props.port === null ? 1194 : props.port,
            cipher: props.cipher === undefined || props.cipher === null ? 'AES-128-CBC' : props.cipher,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosSslVpnServer;
        this.attrSslVpnServerId = rosSslVpnServer.attrSslVpnServerId;
    }
}
exports.SslVpnServer = SslVpnServer;
//# sourceMappingURL=data:application/json;base64,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