"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ipv6InternetBandwidth = exports.Ipv6InternetBandwidthProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vpc_generated_1 = require("./vpc.generated");
Object.defineProperty(exports, "Ipv6InternetBandwidthProperty", { enumerable: true, get: function () { return vpc_generated_1.RosIpv6InternetBandwidth; } });
/**
 * A ROS resource type:  `ALIYUN::VPC::Ipv6InternetBandwidth`
 */
class Ipv6InternetBandwidth extends ros.Resource {
    /**
     * Create a new `ALIYUN::VPC::Ipv6InternetBandwidth`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosIpv6InternetBandwidth = new vpc_generated_1.RosIpv6InternetBandwidth(this, id, {
            bandwidth: props.bandwidth,
            ipv6AddressId: props.ipv6AddressId,
            ipv6GatewayId: props.ipv6GatewayId,
            tags: props.tags,
            internetChargeType: props.internetChargeType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosIpv6InternetBandwidth;
        this.attrInternetBandwidthId = rosIpv6InternetBandwidth.attrInternetBandwidthId;
    }
}
exports.Ipv6InternetBandwidth = Ipv6InternetBandwidth;
//# sourceMappingURL=data:application/json;base64,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