"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IpsecServer = exports.IpsecServerProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vpc_generated_1 = require("./vpc.generated");
Object.defineProperty(exports, "IpsecServerProperty", { enumerable: true, get: function () { return vpc_generated_1.RosIpsecServer; } });
/**
 * A ROS resource type:  `ALIYUN::VPC::IpsecServer`
 */
class IpsecServer extends ros.Resource {
    /**
     * Create a new `ALIYUN::VPC::IpsecServer`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosIpsecServer = new vpc_generated_1.RosIpsecServer(this, id, {
            localSubnet: props.localSubnet,
            effectImmediately: props.effectImmediately,
            clientIpPool: props.clientIpPool,
            vpnGatewayId: props.vpnGatewayId,
            ipsecConfig: props.ipsecConfig,
            psk: props.psk,
            ikeConfig: props.ikeConfig,
            ipsecServerName: props.ipsecServerName,
            pskEnabled: props.pskEnabled,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosIpsecServer;
        this.attrIpsecServerId = rosIpsecServer.attrIpsecServerId;
        this.attrIpsecServerName = rosIpsecServer.attrIpsecServerName;
    }
}
exports.IpsecServer = IpsecServer;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaXBzZWNzZXJ2ZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpcHNlY3NlcnZlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4Q0FBOEM7QUFDOUMsbURBQWlEO0FBRXRCLG9HQUZsQiw4QkFBYyxPQUV1QjtBQXNEOUM7O0dBRUc7QUFDSCxNQUFhLFdBQVksU0FBUSxHQUFHLENBQUMsUUFBUTtJQWlCekM7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUF1QixFQUFFLG1DQUEyQyxJQUFJO1FBQ2xILEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxjQUFjLEdBQUcsSUFBSSw4QkFBYyxDQUFDLElBQUksRUFBRSxFQUFFLEVBQUc7WUFDakQsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxpQkFBaUI7WUFDMUMsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZO1lBQ2hDLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtZQUNoQyxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsR0FBRyxFQUFFLEtBQUssQ0FBQyxHQUFHO1lBQ2QsU0FBUyxFQUFFLEtBQUssQ0FBQyxTQUFTO1lBQzFCLGVBQWUsRUFBRSxLQUFLLENBQUMsZUFBZTtZQUN0QyxVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVU7U0FDL0IsRUFBRSxnQ0FBZ0MsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLGdDQUFnQyxDQUFDLENBQUM7UUFDcEYsSUFBSSxDQUFDLFFBQVEsR0FBRyxjQUFjLENBQUM7UUFDL0IsSUFBSSxDQUFDLGlCQUFpQixHQUFHLGNBQWMsQ0FBQyxpQkFBaUIsQ0FBQztRQUMxRCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsY0FBYyxDQUFDLG1CQUFtQixDQUFDO0lBQ2xFLENBQUM7Q0FDSjtBQTFDRCxrQ0EwQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyByb3MgZnJvbSAnQGFsaWNsb3VkL3Jvcy1jZGstY29yZSc7XG5pbXBvcnQgeyBSb3NJcHNlY1NlcnZlciB9IGZyb20gJy4vdnBjLmdlbmVyYXRlZCc7XG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cbmV4cG9ydCB7IFJvc0lwc2VjU2VydmVyIGFzIElwc2VjU2VydmVyUHJvcGVydHkgfTtcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBBTElZVU46OlZQQzo6SXBzZWNTZXJ2ZXJgXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSXBzZWNTZXJ2ZXJQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBjbGllbnRJcFBvb2w6IENsaWVudCBuZXR3b3JrIHNlZ21lbnQgcmVmZXJzIHRvIHRoZSBhZGRyZXNzIHNlZ21lbnQgdGhhdCBhc3NpZ25zIGFjY2VzcyBhZGRyZXNzZXMgdG8gdGhlIHZpcnR1YWwgbmV0d29yayBjYXJkIG9mIHRoZSBjbGllbnQuIE5vdGU6IFRoZSBjbGllbnQgbmV0d29yayBzZWdtZW50IGNhbm5vdCBjb25mbGljdCB3aXRoIHRoZSBWUEMgc2lkZSBuZXR3b3JrIHNlZ21lbnQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgY2xpZW50SXBQb29sOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBsb2NhbFN1Ym5ldDogVGhlIGxvY2FsIG5ldHdvcmsgc2VnbWVudCByZWZlcnMgdG8gdGhlIG5ldHdvcmsgc2VnbWVudCBvbiB0aGUgVlBDIHNpZGUgdGhhdCBuZWVkcyB0byBiZSBpbnRlcmNvbm5lY3RlZCB3aXRoIHRoZSBjbGllbnQgbmV0d29yayBzZWdtZW50LiBVc2UgaGFsZi13aWR0aCBjb21tYXMgKCwpIHRvIHNlcGFyYXRlIG11bHRpcGxlIG5ldHdvcmsgc2VnbWVudHMsIGZvciBleGFtcGxlOiAxOTIuMTY4LjEuMC8yNCwxOTIuMTY4LjIuMC8yNC5cbiAgICAgKi9cbiAgICByZWFkb25seSBsb2NhbFN1Ym5ldDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgdnBuR2F0ZXdheUlkOiBWUE4gZ2F0ZXdheSBpbnN0YW5jZSBJRC5cbiAgICAgKi9cbiAgICByZWFkb25seSB2cG5HYXRld2F5SWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGVmZmVjdEltbWVkaWF0ZWx5OiB0cnVlOiBBcHBseSB0aGUgbmV3IGNvbmZpZ3VyYXRpb24gYW5kIHRyaWdnZXIgYSByZWNvbm5lY3Rpb24gaW1tZWRpYXRlbHkuIFxuICAgICAqIGZhbHNlOiBUcmlnZ2VyIGEgcmVjb25uZWN0aW9uIG9ubHkgd2hlbiBuZXR3b3JrIHRyYWZmaWMgb2NjdXJzLiAoVGhlIHJlY29ubmVjdGlvbiBtYXkgY2F1c2UgdGhlIG5ldHdvcmsgdG8gYmUgdW5hdmFpbGFibGUgZm9yIGEgYnJpZWYgbW9tZW50KVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVmZmVjdEltbWVkaWF0ZWx5PzogYm9vbGVhbiB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGlrZUNvbmZpZzogTmVnb3RpYXRpb24gcGFyYW1ldGVyIGNvbmZpZ3VyYXRpb24gaW4gdGhlIGZpcnN0IHBoYXNlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGlrZUNvbmZpZz86IFJvc0lwc2VjU2VydmVyLklrZUNvbmZpZ1Byb3BlcnR5IHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgaXBzZWNDb25maWc6IE5lZ290aWF0aW9uIHBhcmFtZXRlciBjb25maWd1cmF0aW9uIGluIHRoZSBzZWNvbmQgcGhhc2UuXG4gICAgICovXG4gICAgcmVhZG9ubHkgaXBzZWNDb25maWc/OiBSb3NJcHNlY1NlcnZlci5JcHNlY0NvbmZpZ1Byb3BlcnR5IHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgaXBzZWNTZXJ2ZXJOYW1lOiBUaGUgdmFsdWUgbXVzdCBiZSAyIHRvIDEyOCBjaGFyYWN0ZXJzIGluIGxlbmd0aCBhbmQgc3RhcnQgd2l0aCBhIGxldHRlciBvciBDaGluZXNlIGNoYXJhY3Rlci4gSXQgY2FuIGNvbnRhaW4gZGlnaXRzLCB1bmRlcnNjb3JlcyAoXyksIGFuZCBoeXBoZW5zICgtKS5cbiAgICAgKi9cbiAgICByZWFkb25seSBpcHNlY1NlcnZlck5hbWU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBwc2s6IFByZS1TaGFyZWQga2V5LiBVc2VkIGZvciBpZGVudGl0eSBhdXRoZW50aWNhdGlvbiBiZXR3ZWVuIHRoZSBWUE4gZ2F0ZXdheSBhbmQgdGhlIGNsaWVudC4gQSAxNi1iaXQgcmFuZG9tIHN0cmluZyBpcyByYW5kb21seSBnZW5lcmF0ZWQgYnkgZGVmYXVsdCwgb3IgeW91IGNhbiBtYW51YWxseSBzcGVjaWZ5IHRoZSBrZXkuIFRoZSBsZW5ndGggaXMgbGltaXRlZCB0byAxMDAgY2hhcmFjdGVycy5cbiAgICAgKi9cbiAgICByZWFkb25seSBwc2s/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBwc2tFbmFibGVkOiBXaGV0aGVyIHRvIGVuYWJsZSB0aGUgcHJlLXNoYXJlZCBrZXkgYXV0aGVudGljYXRpb24gbWV0aG9kLiBPbmx5IHRoZSB2YWx1ZSBpcyB0cnVlLCB3aGljaCBtZWFucyB0aGF0IHRoZSBwcmUtc2hhcmVkIGtleSBhdXRoZW50aWNhdGlvbiBtb2RlIGlzIGVuYWJsZWQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcHNrRW5hYmxlZD86IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XG59XG5cbi8qKlxuICogQSBST1MgcmVzb3VyY2UgdHlwZTogIGBBTElZVU46OlZQQzo6SXBzZWNTZXJ2ZXJgXG4gKi9cbmV4cG9ydCBjbGFzcyBJcHNlY1NlcnZlciBleHRlbmRzIHJvcy5SZXNvdXJjZSB7XG5cbiAgICAvKipcbiAgICAgKiBBIGZhY3RvcnkgbWV0aG9kIHRoYXQgY3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGlzIGNsYXNzIGZyb20gYW4gb2JqZWN0XG4gICAgICogY29udGFpbmluZyB0aGUgcHJvcGVydGllcyBvZiB0aGlzIFJPUyByZXNvdXJjZSwgd2hpY2ggd2lsbCBiZSBhc3NpZ25lZCB0byBST1MgcmVzb3VyY2UuXG4gICAgICovXG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgSXBzZWNTZXJ2ZXJJZDogSVBzZWMgc2VydmVyIElELlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRySXBzZWNTZXJ2ZXJJZDogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIElwc2VjU2VydmVyTmFtZTogSVBzZWMgc2VydmVyIG5hbWUuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJJcHNlY1NlcnZlck5hbWU6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIENyZWF0ZSBhIG5ldyBgQUxJWVVOOjpWUEM6Oklwc2VjU2VydmVyYC5cbiAgICAgKlxuICAgICAqIFBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogUGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogUGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IHJvcy5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBJcHNlY1NlcnZlclByb3BzLCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDpib29sZWFuID0gdHJ1ZSkge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgICAgIGNvbnN0IHJvc0lwc2VjU2VydmVyID0gbmV3IFJvc0lwc2VjU2VydmVyKHRoaXMsIGlkLCAge1xuICAgICAgICAgICAgbG9jYWxTdWJuZXQ6IHByb3BzLmxvY2FsU3VibmV0LFxuICAgICAgICAgICAgZWZmZWN0SW1tZWRpYXRlbHk6IHByb3BzLmVmZmVjdEltbWVkaWF0ZWx5LFxuICAgICAgICAgICAgY2xpZW50SXBQb29sOiBwcm9wcy5jbGllbnRJcFBvb2wsXG4gICAgICAgICAgICB2cG5HYXRld2F5SWQ6IHByb3BzLnZwbkdhdGV3YXlJZCxcbiAgICAgICAgICAgIGlwc2VjQ29uZmlnOiBwcm9wcy5pcHNlY0NvbmZpZyxcbiAgICAgICAgICAgIHBzazogcHJvcHMucHNrLFxuICAgICAgICAgICAgaWtlQ29uZmlnOiBwcm9wcy5pa2VDb25maWcsXG4gICAgICAgICAgICBpcHNlY1NlcnZlck5hbWU6IHByb3BzLmlwc2VjU2VydmVyTmFtZSxcbiAgICAgICAgICAgIHBza0VuYWJsZWQ6IHByb3BzLnBza0VuYWJsZWQsXG4gICAgICAgIH0sIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50ICYmIHRoaXMuc3RhY2suZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQpO1xuICAgICAgICB0aGlzLnJlc291cmNlID0gcm9zSXBzZWNTZXJ2ZXI7XG4gICAgICAgIHRoaXMuYXR0cklwc2VjU2VydmVySWQgPSByb3NJcHNlY1NlcnZlci5hdHRySXBzZWNTZXJ2ZXJJZDtcbiAgICAgICAgdGhpcy5hdHRySXBzZWNTZXJ2ZXJOYW1lID0gcm9zSXBzZWNTZXJ2ZXIuYXR0cklwc2VjU2VydmVyTmFtZTtcbiAgICB9XG59XG4iXX0=