"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EIPSegment = exports.EIPSegmentProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vpc_generated_1 = require("./vpc.generated");
Object.defineProperty(exports, "EIPSegmentProperty", { enumerable: true, get: function () { return vpc_generated_1.RosEIPSegment; } });
/**
 * A ROS resource type:  `ALIYUN::VPC::EIPSegment`
 */
class EIPSegment extends ros.Resource {
    /**
     * Create a new `ALIYUN::VPC::EIPSegment`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosEIPSegment = new vpc_generated_1.RosEIPSegment(this, id, {
            eipMask: props.eipMask,
            resourceGroupId: props.resourceGroupId,
            netmode: props.netmode,
            bandwidth: props.bandwidth,
            internetChargeType: props.internetChargeType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosEIPSegment;
        this.attrEipAddresses = rosEIPSegment.attrEipAddresses;
        this.attrEipSegmentInstanceId = rosEIPSegment.attrEipSegmentInstanceId;
    }
}
exports.EIPSegment = EIPSegment;
//# sourceMappingURL=data:application/json;base64,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