"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Eip = exports.EIPProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vpc_generated_1 = require("./vpc.generated");
Object.defineProperty(exports, "EIPProperty", { enumerable: true, get: function () { return vpc_generated_1.RosEIP; } });
/**
 * A ROS resource type:  `ALIYUN::VPC::EIP`
 */
class Eip extends ros.Resource {
    /**
     * Create a new `ALIYUN::VPC::EIP`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosEIP = new vpc_generated_1.RosEIP(this, id, {
            description: props.description,
            resourceGroupId: props.resourceGroupId,
            instanceChargeType: props.instanceChargeType === undefined || props.instanceChargeType === null ? 'Postpaid' : props.instanceChargeType,
            pricingCycle: props.pricingCycle === undefined || props.pricingCycle === null ? 'Month' : props.pricingCycle,
            isp: props.isp,
            period: props.period === undefined || props.period === null ? 1 : props.period,
            deletionProtection: props.deletionProtection === undefined || props.deletionProtection === null ? false : props.deletionProtection,
            autoPay: props.autoPay === undefined || props.autoPay === null ? true : props.autoPay,
            name: props.name,
            internetChargeType: props.internetChargeType === undefined || props.internetChargeType === null ? 'PayByBandwidth' : props.internetChargeType,
            netmode: props.netmode,
            bandwidth: props.bandwidth === undefined || props.bandwidth === null ? 5 : props.bandwidth,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosEIP;
        this.attrAllocationId = rosEIP.attrAllocationId;
        this.attrEipAddress = rosEIP.attrEipAddress;
        this.attrIsp = rosEIP.attrIsp;
        this.attrOrderId = rosEIP.attrOrderId;
    }
}
exports.Eip = Eip;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZWlwLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZWlwLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDhDQUE4QztBQUM5QyxtREFBeUM7QUFFdEIsNEZBRlYsc0JBQU0sT0FFZTtBQTZFOUI7O0dBRUc7QUFDSCxNQUFhLEdBQUksU0FBUSxHQUFHLENBQUMsUUFBUTtJQTJCakM7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxRQUFrQixFQUFFLEVBQUUsbUNBQTJDLElBQUk7UUFDL0csS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLE1BQU0sR0FBRyxJQUFJLHNCQUFNLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRztZQUNqQyxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsZUFBZSxFQUFFLEtBQUssQ0FBQyxlQUFlO1lBQ3RDLGtCQUFrQixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsS0FBSyxTQUFTLElBQUksS0FBSyxDQUFDLGtCQUFrQixLQUFLLElBQUksQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsa0JBQWtCO1lBQ3ZJLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWSxLQUFLLFNBQVMsSUFBSSxLQUFLLENBQUMsWUFBWSxLQUFLLElBQUksQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsWUFBWTtZQUM1RyxHQUFHLEVBQUUsS0FBSyxDQUFDLEdBQUc7WUFDZCxNQUFNLEVBQUUsS0FBSyxDQUFDLE1BQU0sS0FBSyxTQUFTLElBQUksS0FBSyxDQUFDLE1BQU0sS0FBSyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLE1BQU07WUFDOUUsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixLQUFLLFNBQVMsSUFBSSxLQUFLLENBQUMsa0JBQWtCLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxrQkFBa0I7WUFDbEksT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPLEtBQUssU0FBUyxJQUFJLEtBQUssQ0FBQyxPQUFPLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxPQUFPO1lBQ3JGLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSTtZQUNoQixrQkFBa0IsRUFBRSxLQUFLLENBQUMsa0JBQWtCLEtBQUssU0FBUyxJQUFJLEtBQUssQ0FBQyxrQkFBa0IsS0FBSyxJQUFJLENBQUMsQ0FBQyxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsa0JBQWtCO1lBQzdJLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTztZQUN0QixTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVMsS0FBSyxTQUFTLElBQUksS0FBSyxDQUFDLFNBQVMsS0FBSyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLFNBQVM7WUFDMUYsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO1NBQ25CLEVBQUUsZ0NBQWdDLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQ3BGLElBQUksQ0FBQyxRQUFRLEdBQUcsTUFBTSxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxNQUFNLENBQUMsZ0JBQWdCLENBQUM7UUFDaEQsSUFBSSxDQUFDLGNBQWMsR0FBRyxNQUFNLENBQUMsY0FBYyxDQUFDO1FBQzVDLElBQUksQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQztRQUM5QixJQUFJLENBQUMsV0FBVyxHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQUM7SUFDMUMsQ0FBQztDQUNKO0FBMURELGtCQTBEQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHJvcyBmcm9tICdAYWxpY2xvdWQvcm9zLWNkay1jb3JlJztcbmltcG9ydCB7IFJvc0VJUCB9IGZyb20gJy4vdnBjLmdlbmVyYXRlZCc7XG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cbmV4cG9ydCB7IFJvc0VJUCBhcyBFSVBQcm9wZXJ0eSB9O1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYEFMSVlVTjo6VlBDOjpFSVBgXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRUlQUHJvcHMge1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgYXV0b1BheTogQXV0b21hdGljIFBheW1lbnQuIERlZmF1bHQgaXMgdHJ1ZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBhdXRvUGF5PzogYm9vbGVhbiB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGJhbmR3aWR0aDogQmFuZHdpZHRoIGZvciB0aGUgb3V0cHV0IG5ldHdvcmsuIERlZmF1bHQgaXMgNU1CLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGJhbmR3aWR0aD86IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGRlbGV0aW9uUHJvdGVjdGlvbjogV2hldGhlciB0byBlbmFibGUgZGVsZXRpb24gcHJvdGVjdGlvbi5cbiAgICAgKiBEZWZhdWx0IHRvIEZhbHNlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRlbGV0aW9uUHJvdGVjdGlvbj86IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkZXNjcmlwdGlvbjogT3B0aW9uYWwuIFRoZSBkZXNjcmlwdGlvbiBvZiB0aGUgRUlQLiBUaGUgZGVzY3JpcHRpb24gbXVzdCBiZSAyIHRvIDI1NiBjaGFyYWN0ZXJzIGluIGxlbmd0aC4gSXQgbXVzdCBzdGFydCB3aXRoIGEgbGV0dGVyLiBJdCBjYW5ub3Qgc3RhcnQgd2l0aCBodHRwOi8vICBvciBodHRwczovLy5cbiAgICAgKi9cbiAgICByZWFkb25seSBkZXNjcmlwdGlvbj86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGluc3RhbmNlQ2hhcmdlVHlwZTogVGhlIHJlc291cmNlIGNoYXJnZSB0eXBlLiBEZWZhdWx0IHZhbHVlIGlzIFBvc3RwYWlkXG4gICAgICovXG4gICAgcmVhZG9ubHkgaW5zdGFuY2VDaGFyZ2VUeXBlPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgaW50ZXJuZXRDaGFyZ2VUeXBlOiBUaGUgbmV0d29yayBjaGFyZ2UgdHlwZS4gU3VwcG9ydCAnUGF5QnlCYW5kd2lkdGgnIGFuZCAnUGF5QnlUcmFmZmljJyBvbmx5LiBEZWZhdWx0IGlzIFBheUJ5QmFuZHdpZHRoLiBQYXlCeVRyYWZmaWMgd2lsbCBjaGFyZ2UgYnkgaG91ciwgUGF5QnlCYW5kd2lkdGggd2lsbCBjaGFyZ2UgYnkgZGF5LlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGludGVybmV0Q2hhcmdlVHlwZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGlzcDogVGhlIGxpbmUgdHlwZS4gWW91IGNhbiBzZXQgdGhpcyBwYXJhbWV0ZXIgb25seSB3aGVuIHlvdSBjcmVhdGUgYSBwYXktYXMteW91LWdvIEVJUC4gVmFsaWQgdmFsdWVzOlxuICAgICAqIEJHUDogQkdQIChNdWx0aS1JU1ApIGxpbmVzLiBVcCB0byA4OSBoaWdoLXF1YWxpdHkgQkdQIGxpbmVzIGFyZSBhdmFpbGFibGUgd29ybGR3aWRlLiBEaXJlY3QgY29ubmVjdGlvbnMgd2l0aCBtdWx0aXBsZSBJbnRlcm5ldCBTZXJ2aWNlIFByb3ZpZGVycyAoSVNQcyksIGluY2x1ZGluZyBUZWxlY29tLCBVbmljb20sIE1vYmlsZSwgUmFpbGNvbSwgTmV0Y29tLCBDRVJORVQsIENoaW5hIEJyb2FkY2FzdCBOZXR3b3JrLCBEci4gUGVuZywgYW5kIEZvdW5kZXIsIGNhbiBiZSBlc3RhYmxpc2hlZCBpbiBhbGwgcmVnaW9ucyBpbiBtYWlubGFuZCBDaGluYS5cbiAgICAgKiBCR1BfUFJPOiBCR1AgKE11bHRpLUlTUCkgUHJvIGxpbmVzLiBCR1AgKE11bHRpLUlTUCkgUHJvIGxpbmVzIG9wdGltaXplIGRhdGEgdHJhbnNtaXNzaW9uIHRvIENoaW5hIGFuZCBpbXByb3ZlIGNvbm5lY3Rpb24gcXVhbGl0eSBmb3IgaW50ZXJuYXRpb25hbCBzZXJ2aWNlcy4gQ29tcGFyZWQgd2l0aCB0cmFkaXRpb25hbCBCR1AgKE11bHRpLUlTUCkgbGluZXMsIEJHUCAoTXVsdGktSVNQKSBQcm8gbGluZXMgY2FuIGJlIHVzZWQgdG8gZXN0YWJsaXNoIGRpcmVjdCBjb25uZWN0aW9ucyB3aXRob3V0IHVzaW5nIGludGVybmF0aW9uYWwgSVNQIHNlcnZpY2VzLiBUaGVyZWZvcmUsIEJHUCAoTXVsdGktSVNQKSBQcm8gbGluZXMgcmVkdWNlIG5ldHdvcmsgbGF0ZW5jeS5cbiAgICAgKi9cbiAgICByZWFkb25seSBpc3A/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBuYW1lOiBUaGUgbmFtZSBvZiB0aGUgRUlQLiBUaGUgbmFtZSBtdXN0IGJlIDIgdG8gMTI4IGNoYXJhY3RlcnMgaW4gbGVuZ3RoLiBJdCBtdXN0IHN0YXJ0IHdpdGggYSBsZXR0ZXIuIEl0IGNhbiBjb250YWluIG51bWJlcnMsIHBlcmlvZHMgKC4pLCB1bmRlcnNjb3JlcyAoXyksIGFuZCBoeXBoZW5zICgtKS4gSXQgY2Fubm90IHN0YXJ0IHdpdGggaHR0cDovLyAgb3IgaHR0cHM6Ly9cbiAgICAgKi9cbiAgICByZWFkb25seSBuYW1lPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgbmV0bW9kZTogVGhlIG5ldHdvcmsgdHlwZS4gVmFsaWQgdmFsdWU6IHB1YmxpYyAocHVibGljIG5ldHdvcmspLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IG5ldG1vZGU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBwZXJpb2Q6IFByZXBhaWQgdGltZSBwZXJpb2QuIFdoaWxlIGNob29zZSBieSBwYXkgYnkgbW9udGgsIGl0IGNvdWxkIGJlIGZyb20gMSB0byA5IG9yIDEyLCAyNCwgMzYuIFxuICAgICAqICAgV2hpbGUgY2hvb3NlIHBheSBieSB5ZWFyLCBpdCBjb3VsZCBiZSBmcm9tIDEgdG8gMy5cbiAgICAgKi9cbiAgICByZWFkb25seSBwZXJpb2Q/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBwcmljaW5nQ3ljbGU6IFByaWNlIGN5Y2xlIG9mIHRoZSByZXNvdXJjZS4gVGhpcyBwcm9wZXJ0eSBoYXMgbm8gZGVmYXVsdCB2YWx1ZS4gSWYgQ2hhcmdlVHlwZSBpcyBzcGVjaWZpZWQgYXMgUG9zdHBhaWQsIHRoaXMgdmFsdWUgd2lsbCBiZSBpZ25vcmUuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcHJpY2luZ0N5Y2xlPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcmVzb3VyY2VHcm91cElkOiBSZXNvdXJjZSBncm91cCBpZC5cbiAgICAgKi9cbiAgICByZWFkb25seSByZXNvdXJjZUdyb3VwSWQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB0YWdzOiBUYWdzIHRvIGF0dGFjaCB0byBlaXAuIE1heCBzdXBwb3J0IDIwIHRhZ3MgdG8gYWRkIGR1cmluZyBjcmVhdGUgZWlwLiBFYWNoIHRhZyB3aXRoIHR3byBwcm9wZXJ0aWVzIEtleSBhbmQgVmFsdWUsIGFuZCBLZXkgaXMgcmVxdWlyZWQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGFncz86IFJvc0VJUC5UYWdzUHJvcGVydHlbXTtcbn1cblxuLyoqXG4gKiBBIFJPUyByZXNvdXJjZSB0eXBlOiAgYEFMSVlVTjo6VlBDOjpFSVBgXG4gKi9cbmV4cG9ydCBjbGFzcyBFaXAgZXh0ZW5kcyByb3MuUmVzb3VyY2Uge1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIHByb3BlcnRpZXMgb2YgdGhpcyBST1MgcmVzb3VyY2UsIHdoaWNoIHdpbGwgYmUgYXNzaWduZWQgdG8gUk9TIHJlc291cmNlLlxuICAgICAqL1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIEFsbG9jYXRpb25JZDogSUQgdGhhdCBBbGl5dW4gYXNzaWducyB0byByZXByZXNlbnQgdGhlIGFsbG9jYXRpb24gb2YgdGhlIGFkZHJlc3MgZm9yIHVzZSB3aXRoIFZQQy4gUmV0dXJuZWQgb25seSBmb3IgVlBDIGVsYXN0aWMgSVAgYWRkcmVzc2VzLlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyQWxsb2NhdGlvbklkOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgRWlwQWRkcmVzczogSVAgYWRkcmVzcyBvZiBjcmVhdGVkIEVJUC5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckVpcEFkZHJlc3M6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBJc3A6IFRoZSBsaW5lIHR5cGUuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJJc3A6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBPcmRlcklkOiBPcmRlciBJRCBvZiBwcmVwYWlkIEVJUCBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ck9yZGVySWQ6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIENyZWF0ZSBhIG5ldyBgQUxJWVVOOjpWUEM6OkVJUGAuXG4gICAgICpcbiAgICAgKiBQYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIFBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIFBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiByb3MuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogRUlQUHJvcHMgPSB7fSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6Ym9vbGVhbiA9IHRydWUpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgICAgICBjb25zdCByb3NFSVAgPSBuZXcgUm9zRUlQKHRoaXMsIGlkLCAge1xuICAgICAgICAgICAgZGVzY3JpcHRpb246IHByb3BzLmRlc2NyaXB0aW9uLFxuICAgICAgICAgICAgcmVzb3VyY2VHcm91cElkOiBwcm9wcy5yZXNvdXJjZUdyb3VwSWQsXG4gICAgICAgICAgICBpbnN0YW5jZUNoYXJnZVR5cGU6IHByb3BzLmluc3RhbmNlQ2hhcmdlVHlwZSA9PT0gdW5kZWZpbmVkIHx8IHByb3BzLmluc3RhbmNlQ2hhcmdlVHlwZSA9PT0gbnVsbCA/ICdQb3N0cGFpZCcgOiBwcm9wcy5pbnN0YW5jZUNoYXJnZVR5cGUsXG4gICAgICAgICAgICBwcmljaW5nQ3ljbGU6IHByb3BzLnByaWNpbmdDeWNsZSA9PT0gdW5kZWZpbmVkIHx8IHByb3BzLnByaWNpbmdDeWNsZSA9PT0gbnVsbCA/ICdNb250aCcgOiBwcm9wcy5wcmljaW5nQ3ljbGUsXG4gICAgICAgICAgICBpc3A6IHByb3BzLmlzcCxcbiAgICAgICAgICAgIHBlcmlvZDogcHJvcHMucGVyaW9kID09PSB1bmRlZmluZWQgfHwgcHJvcHMucGVyaW9kID09PSBudWxsID8gMSA6IHByb3BzLnBlcmlvZCxcbiAgICAgICAgICAgIGRlbGV0aW9uUHJvdGVjdGlvbjogcHJvcHMuZGVsZXRpb25Qcm90ZWN0aW9uID09PSB1bmRlZmluZWQgfHwgcHJvcHMuZGVsZXRpb25Qcm90ZWN0aW9uID09PSBudWxsID8gZmFsc2UgOiBwcm9wcy5kZWxldGlvblByb3RlY3Rpb24sXG4gICAgICAgICAgICBhdXRvUGF5OiBwcm9wcy5hdXRvUGF5ID09PSB1bmRlZmluZWQgfHwgcHJvcHMuYXV0b1BheSA9PT0gbnVsbCA/IHRydWUgOiBwcm9wcy5hdXRvUGF5LFxuICAgICAgICAgICAgbmFtZTogcHJvcHMubmFtZSxcbiAgICAgICAgICAgIGludGVybmV0Q2hhcmdlVHlwZTogcHJvcHMuaW50ZXJuZXRDaGFyZ2VUeXBlID09PSB1bmRlZmluZWQgfHwgcHJvcHMuaW50ZXJuZXRDaGFyZ2VUeXBlID09PSBudWxsID8gJ1BheUJ5QmFuZHdpZHRoJyA6IHByb3BzLmludGVybmV0Q2hhcmdlVHlwZSxcbiAgICAgICAgICAgIG5ldG1vZGU6IHByb3BzLm5ldG1vZGUsXG4gICAgICAgICAgICBiYW5kd2lkdGg6IHByb3BzLmJhbmR3aWR0aCA9PT0gdW5kZWZpbmVkIHx8IHByb3BzLmJhbmR3aWR0aCA9PT0gbnVsbCA/IDUgOiBwcm9wcy5iYW5kd2lkdGgsXG4gICAgICAgICAgICB0YWdzOiBwcm9wcy50YWdzLFxuICAgICAgICB9LCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCAmJiB0aGlzLnN0YWNrLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50KTtcbiAgICAgICAgdGhpcy5yZXNvdXJjZSA9IHJvc0VJUDtcbiAgICAgICAgdGhpcy5hdHRyQWxsb2NhdGlvbklkID0gcm9zRUlQLmF0dHJBbGxvY2F0aW9uSWQ7XG4gICAgICAgIHRoaXMuYXR0ckVpcEFkZHJlc3MgPSByb3NFSVAuYXR0ckVpcEFkZHJlc3M7XG4gICAgICAgIHRoaXMuYXR0cklzcCA9IHJvc0VJUC5hdHRySXNwO1xuICAgICAgICB0aGlzLmF0dHJPcmRlcklkID0gcm9zRUlQLmF0dHJPcmRlcklkO1xuICAgIH1cbn1cbiJdfQ==