"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DhcpOptionsSet = exports.DhcpOptionsSetProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vpc_generated_1 = require("./vpc.generated");
Object.defineProperty(exports, "DhcpOptionsSetProperty", { enumerable: true, get: function () { return vpc_generated_1.RosDhcpOptionsSet; } });
/**
 * A ROS resource type:  `ALIYUN::VPC::DhcpOptionsSet`
 */
class DhcpOptionsSet extends ros.Resource {
    /**
     * Create a new `ALIYUN::VPC::DhcpOptionsSet`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDhcpOptionsSet = new vpc_generated_1.RosDhcpOptionsSet(this, id, {
            domainName: props.domainName,
            dhcpOptionsSetName: props.dhcpOptionsSetName,
            dhcpOptionsSetDescription: props.dhcpOptionsSetDescription,
            domainNameServers: props.domainNameServers,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDhcpOptionsSet;
        this.attrDhcpOptionsSetId = rosDhcpOptionsSet.attrDhcpOptionsSetId;
    }
}
exports.DhcpOptionsSet = DhcpOptionsSet;
//# sourceMappingURL=data:application/json;base64,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