"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrepayDBInstance = exports.PrepayDBInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "PrepayDBInstanceProperty", { enumerable: true, get: function () { return rds_generated_1.RosPrepayDBInstance; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::PrepayDBInstance`
 */
class PrepayDBInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::RDS::PrepayDBInstance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosPrepayDBInstance = new rds_generated_1.RosPrepayDBInstance(this, id, {
            periodType: props.periodType === undefined || props.periodType === null ? 'Month' : props.periodType,
            resourceGroupId: props.resourceGroupId,
            archiveBackupRetentionPeriod: props.archiveBackupRetentionPeriod,
            dbTimeZone: props.dbTimeZone,
            port: props.port,
            archiveBackupKeepCount: props.archiveBackupKeepCount,
            logBackupRetentionPeriod: props.logBackupRetentionPeriod,
            dbInstanceStorage: props.dbInstanceStorage,
            dbMappings: props.dbMappings,
            connectionStringPrefix: props.connectionStringPrefix,
            multiAz: props.multiAz === undefined || props.multiAz === null ? false : props.multiAz,
            engine: props.engine,
            tags: props.tags,
            dbInstanceDescription: props.dbInstanceDescription,
            targetDedicatedHostIdForMaster: props.targetDedicatedHostIdForMaster,
            engineVersion: props.engineVersion,
            dbInstanceClass: props.dbInstanceClass,
            archiveBackupKeepPolicy: props.archiveBackupKeepPolicy,
            vSwitchId: props.vSwitchId,
            backupPolicyMode: props.backupPolicyMode,
            period: props.period === undefined || props.period === null ? 1 : props.period,
            localLogRetentionHours: props.localLogRetentionHours,
            highSpaceUsageProtection: props.highSpaceUsageProtection,
            roleArn: props.roleArn,
            masterUserPassword: props.masterUserPassword,
            vpcId: props.vpcId,
            sslSetting: props.sslSetting === undefined || props.sslSetting === null ? 'Disabled' : props.sslSetting,
            masterUsername: props.masterUsername,
            connectionMode: props.connectionMode,
            localLogRetentionSpace: props.localLogRetentionSpace,
            category: props.category,
            privateIpAddress: props.privateIpAddress,
            targetDedicatedHostIdForSlave: props.targetDedicatedHostIdForSlave,
            dbInstanceNetType: props.dbInstanceNetType === undefined || props.dbInstanceNetType === null ? 'Intranet' : props.dbInstanceNetType,
            releasedKeepPolicy: props.releasedKeepPolicy,
            dedicatedHostGroupId: props.dedicatedHostGroupId,
            autoRenew: props.autoRenew === undefined || props.autoRenew === null ? false : props.autoRenew,
            encryptionKey: props.encryptionKey,
            preferredBackupPeriod: props.preferredBackupPeriod,
            logBackupLocalRetentionNumber: props.logBackupLocalRetentionNumber,
            slaveZoneIds: props.slaveZoneIds,
            dbIsIgnoreCase: props.dbIsIgnoreCase,
            commodityCode: props.commodityCode === undefined || props.commodityCode === null ? 'rds' : props.commodityCode,
            maintainTime: props.maintainTime,
            dbParamGroupId: props.dbParamGroupId,
            zoneId: props.zoneId,
            targetDedicatedHostIdForLog: props.targetDedicatedHostIdForLog,
            allocatePublicConnection: props.allocatePublicConnection,
            preferredBackupTime: props.preferredBackupTime,
            securityGroupId: props.securityGroupId,
            quantity: props.quantity === undefined || props.quantity === null ? 1 : props.quantity,
            autoPay: props.autoPay === undefined || props.autoPay === null ? false : props.autoPay,
            dbInstanceStorageType: props.dbInstanceStorageType,
            backUpCategory: props.backUpCategory,
            compressType: props.compressType,
            logBackupFrequency: props.logBackupFrequency,
            connectionStringType: props.connectionStringType === undefined || props.connectionStringType === null ? 'Inner' : props.connectionStringType,
            couponCode: props.couponCode,
            masterUserType: props.masterUserType === undefined || props.masterUserType === null ? 'Normal' : props.masterUserType,
            enableBackupLog: props.enableBackupLog,
            sqlCollectorStatus: props.sqlCollectorStatus,
            backupRetentionPeriod: props.backupRetentionPeriod === undefined || props.backupRetentionPeriod === null ? 7 : props.backupRetentionPeriod,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosPrepayDBInstance;
        this.attrDbInstanceId = rosPrepayDBInstance.attrDbInstanceId;
        this.attrInnerConnectionString = rosPrepayDBInstance.attrInnerConnectionString;
        this.attrInnerIpAddress = rosPrepayDBInstance.attrInnerIpAddress;
        this.attrInnerPort = rosPrepayDBInstance.attrInnerPort;
        this.attrOrderId = rosPrepayDBInstance.attrOrderId;
        this.attrPublicConnectionString = rosPrepayDBInstance.attrPublicConnectionString;
        this.attrPublicIpAddress = rosPrepayDBInstance.attrPublicIpAddress;
        this.attrPublicPort = rosPrepayDBInstance.attrPublicPort;
    }
}
exports.PrepayDBInstance = PrepayDBInstance;
//# sourceMappingURL=data:application/json;base64,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