"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBInstance = exports.DBInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "DBInstanceProperty", { enumerable: true, get: function () { return rds_generated_1.RosDBInstance; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::DBInstance`
 */
class DBInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::RDS::DBInstance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBInstance = new rds_generated_1.RosDBInstance(this, id, {
            periodType: props.periodType === undefined || props.periodType === null ? 'Month' : props.periodType,
            resourceGroupId: props.resourceGroupId,
            archiveBackupRetentionPeriod: props.archiveBackupRetentionPeriod,
            dbTimeZone: props.dbTimeZone,
            port: props.port,
            archiveBackupKeepCount: props.archiveBackupKeepCount,
            logBackupRetentionPeriod: props.logBackupRetentionPeriod,
            dbInstanceStorage: props.dbInstanceStorage,
            dbMappings: props.dbMappings,
            connectionStringPrefix: props.connectionStringPrefix,
            multiAz: props.multiAz === undefined || props.multiAz === null ? false : props.multiAz,
            engine: props.engine,
            tags: props.tags,
            dbInstanceDescription: props.dbInstanceDescription,
            targetDedicatedHostIdForMaster: props.targetDedicatedHostIdForMaster,
            engineVersion: props.engineVersion,
            dbInstanceClass: props.dbInstanceClass,
            archiveBackupKeepPolicy: props.archiveBackupKeepPolicy,
            vSwitchId: props.vSwitchId,
            backupPolicyMode: props.backupPolicyMode,
            period: props.period === undefined || props.period === null ? 1 : props.period,
            localLogRetentionHours: props.localLogRetentionHours,
            payType: props.payType === undefined || props.payType === null ? 'Postpaid' : props.payType,
            highSpaceUsageProtection: props.highSpaceUsageProtection,
            roleArn: props.roleArn,
            masterUserPassword: props.masterUserPassword,
            vpcId: props.vpcId,
            sslSetting: props.sslSetting === undefined || props.sslSetting === null ? 'Disabled' : props.sslSetting,
            masterUsername: props.masterUsername,
            connectionMode: props.connectionMode,
            localLogRetentionSpace: props.localLogRetentionSpace,
            category: props.category,
            privateIpAddress: props.privateIpAddress,
            targetDedicatedHostIdForSlave: props.targetDedicatedHostIdForSlave,
            dbInstanceNetType: props.dbInstanceNetType === undefined || props.dbInstanceNetType === null ? 'Intranet' : props.dbInstanceNetType,
            releasedKeepPolicy: props.releasedKeepPolicy,
            dedicatedHostGroupId: props.dedicatedHostGroupId,
            autoRenew: props.autoRenew,
            encryptionKey: props.encryptionKey,
            preferredBackupPeriod: props.preferredBackupPeriod,
            logBackupLocalRetentionNumber: props.logBackupLocalRetentionNumber,
            slaveZoneIds: props.slaveZoneIds,
            securityIpList: props.securityIpList,
            dbIsIgnoreCase: props.dbIsIgnoreCase,
            maintainTime: props.maintainTime,
            dbParamGroupId: props.dbParamGroupId,
            zoneId: props.zoneId,
            targetDedicatedHostIdForLog: props.targetDedicatedHostIdForLog,
            allocatePublicConnection: props.allocatePublicConnection,
            preferredBackupTime: props.preferredBackupTime,
            securityGroupId: props.securityGroupId,
            dbInstanceStorageType: props.dbInstanceStorageType,
            backUpCategory: props.backUpCategory,
            compressType: props.compressType,
            logBackupFrequency: props.logBackupFrequency,
            connectionStringType: props.connectionStringType === undefined || props.connectionStringType === null ? 'Inner' : props.connectionStringType,
            masterUserType: props.masterUserType === undefined || props.masterUserType === null ? 'Normal' : props.masterUserType,
            enableBackupLog: props.enableBackupLog,
            sqlCollectorStatus: props.sqlCollectorStatus,
            backupRetentionPeriod: props.backupRetentionPeriod === undefined || props.backupRetentionPeriod === null ? 7 : props.backupRetentionPeriod,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBInstance;
        this.attrDbInstanceId = rosDBInstance.attrDbInstanceId;
        this.attrInnerConnectionString = rosDBInstance.attrInnerConnectionString;
        this.attrInnerIpAddress = rosDBInstance.attrInnerIpAddress;
        this.attrInnerPort = rosDBInstance.attrInnerPort;
        this.attrPublicConnectionString = rosDBInstance.attrPublicConnectionString;
        this.attrPublicIpAddress = rosDBInstance.attrPublicIpAddress;
        this.attrPublicPort = rosDBInstance.attrPublicPort;
    }
}
exports.DBInstance = DBInstance;
//# sourceMappingURL=data:application/json;base64,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