# generated by datamodel-codegen:
#   filename:  https://api.jinko.ai/openapi.json
#   timestamp: 2025-02-17T08:56:43+00:00

from __future__ import annotations

from datetime import timedelta
from typing import Any, Dict, List, Literal, NotRequired, Optional, TypedDict, Union


class AnchorTransform(TypedDict):
    height: float
    """
    Height of the anchor
    """
    width: float
    """
    Width of the anchor
    """
    x: float
    """
    Relative X anchor offset in pixels to the page of the reference work
    """
    y: float
    """
    Relative Y anchor offset in pixels to the page of the reference work
    """


type ArmId = str


type BMQualifierType = Literal[
    "bqmodel:is",
    "bqmodel:isDescribedBy",
    "bqmodel:isDerivedFrom",
    "bqmodel:isInstanceOf",
    "bqmodel:hasInstance",
    "bqbiol:is",
    "bqbiol:hasPart",
    "bqbiol:isPartOf",
    "bqbiol:isVersionOf",
    "bqbiol:hasVersion",
    "bqbiol:isHomologTo",
    "bqbiol:isDescribedBy",
    "bqbiol:isEncodedBy",
    "bqbiol:encodes",
    "bqbiol:occursIn",
    "bqbiol:hasProperty",
    "bqbiol:isPropertyOf",
    "bqbiol:hasTaxon",
]


class BarChartBinNDouble(TypedDict):
    category: float
    count: int
    normalizedFrequency: float


class BarChartBinText(TypedDict):
    category: str
    count: int
    normalizedFrequency: float


class Bibliography(TypedDict):
    title: Optional[Dict[str, Any]]
    """
    Work titles, including translated titles
    """
    doi: Optional[Dict[str, Any]]
    """
    DOI of the work
    """
    journal: Optional[Dict[str, Any]]
    """
    Full titles of the containing work (usually a book or journal)
    """
    authors: Optional[Dict[str, Any]]
    """
    Contributors of the work
    """
    keywords: Optional[Dict[str, Any]]
    """
    Keywords of the work
    """
    issue: Optional[Dict[str, Any]]
    """
    Issue number of an article's journal
    """
    pages: Optional[Dict[str, Any]]
    """
    Pages numbers of an article within its journal
    """
    volume: Optional[Dict[str, Any]]
    """
    Volume number of an article's journal
    """
    publicationDate: Optional[Dict[str, Any]]
    """
    Earliest of date og the work was published in print or online
    """
    publicationType: Optional[
        Literal[
            "book-section",
            "monograph",
            "report-component",
            "report",
            "peer-review",
            "book-track",
            "journal-article",
            "book-part",
            "other",
            "book",
            "journal-volume",
            "book-set",
            "reference-entry",
            "proceedings-article",
            "journal",
            "component",
            "book-chapter",
            "proceedings-series",
            "report-series",
            "proceedings",
            "database",
            "standard",
            "reference-book",
            "posted-content",
            "journal-issue",
            "dissertation",
            "grant",
            "dataset",
            "book-series",
            "edited-book",
        ]
    ]
    """
    Type of the work
    """
    publisher: Optional[Dict[str, Any]]
    """
    Name of work's publisher
    """


type BiolQualifierType = Literal[
    "bqbiol:is",
    "bqbiol:hasPart",
    "bqbiol:isPartOf",
    "bqbiol:isVersionOf",
    "bqbiol:hasVersion",
    "bqbiol:isHomologTo",
    "bqbiol:isDescribedBy",
    "bqbiol:isEncodedBy",
    "bqbiol:encodes",
    "bqbiol:occursIn",
    "bqbiol:hasProperty",
    "bqbiol:isPropertyOf",
    "bqbiol:hasTaxon",
]


type BoolOp = Literal["AndCond", "OrCond", "XorCond"]


class CalibrationOptions(TypedDict):
    numberOfIterations: NotRequired[int]
    """
    When this number of iterations is reached, the calibration stops.
    """
    populationSize: NotRequired[int]
    """
    Size of the virtual population drawn at each iteration.
    """
    seed: int
    """
    An arbitrary integer between 0 and 2^32-1 to initialize the random number generation.
    """
    thresholdWeightedScore: float
    """
    The weighted score is the averaged sum of scores, for a given patient. This quantity is maximized during the optimization process. As soon as a patient exceeds this threshold weighted score, the calibration stops.
    """


class CalibrationOptionsJson(TypedDict):
    numberOfIterations: NotRequired[Optional[int]]
    populationSize: NotRequired[Optional[int]]
    seed: NotRequired[Optional[int]]
    thresholdWeightedScore: NotRequired[Optional[float]]


class CalibrationParameter(TypedDict):
    id: str
    """
    ID of parameter, compartment or species to calibrate
    """
    logTransform: NotRequired[bool]
    """
    When on, the mean and std parameters apply to log10(x)
    """
    maxBound: NotRequired[Optional[float]]
    """
    An optional maximum bound for x. The constraint is enforced using a penalty term.
    """
    mean: NotRequired[Optional[float]]
    """
    The mu parameter of the normal distribution for x (or log10(x) when log transform is on)
    """
    minBound: NotRequired[Optional[float]]
    """
    An optional minimum bound for x. The constraint is enforced using a penalty term.
    """
    std: NotRequired[Optional[float]]
    """
    The sigma parameter of the normal distribution for x (or log10(x) when log transform is on)
    """


class CancelJobForm(TypedDict):
    target_queue: str


class CategoricalBarChat(TypedDict):
    """
    See https://novak.jinko.ai/doc/doc-simworkZSmathZSnovarandom/Math-Random-BarChart.html#t:CategoricalBarChart
    """

    barChart: List[BarChartBinText]


class Classification(TypedDict):
    id: str
    """
    Identifier of the classification
    """
    name: str
    """
    Name of the classification
    """
    level: Optional[Literal["Weak", "Medium", "Strong", "Excellent"]]
    """
    Level of the classification
    """


class CmBundleBody(TypedDict):
    """
    Parameters for the bundle request
    """

    cmInJson: bool
    """
    Get computational model in JSON format
    """
    cmInSbml: bool
    """
    Get computational model in SBML format
    """
    differentialModel: NotRequired[bool]
    """
    (advanced) A model where the reactions have been converted to ODEs
    """
    name: NotRequired[Optional[str]]
    """
    Optional computational model name
    """
    sbmlVersion: NotRequired[
        Literal["L1V1", "L1V2", "L2V1", "L2V2", "L2V3", "L2V4", "L2V5", "L3V1", "L3V2"]
    ]
    """
    Which SBML version to convert to
    """
    solvingOptionsInJson: bool
    """
    Get solving options in JSON format
    """


type ColumnName = str


type ColumnType = Literal["BIGINT", "TEXT", "DOUBLE"]


type ColumnValue = str


type Comparator = Literal["Equal", "NotEqual", "GrT", "GrTE", "LsT", "LsTE"]


type ComponentKind = Literal[
    "Species",
    "Compartment",
    "Parameter",
    "CategoricalParameter",
    "Reaction",
    "Ode",
    "Event",
    "BaselineCheck",
    "Tag",
]


class Condition4(TypedDict):
    contents: bool
    tag: Literal["BoolConst"]


class ConstraintSpecifics(TypedDict):
    constraint: NotRequired[Optional[str]]
    filter: NotRequired[Optional[str]]


type ConvertSpeciesToExtentUnits = Literal[
    "ConvertAllSpecies", "OnlyReactantsAndProducts"
]


type CoreItemId = str


type CytoscapeArrowType = Literal[
    "MainFormulaArrow",
    "OtherFormulaArrow",
    "CompartmentArrow",
    "DynamicsArrow",
    "ReactantProductArrow",
]


class DataOverlayWarningDetails1(TypedDict):
    tag: Literal["NoVisualizationArmFound"]


class DataOverlayWarningDetails2(TypedDict):
    arms: List[str]
    tag: Literal["VisualizationArmsNotFound"]


class DataOverlayWarningDetails3(TypedDict):
    tag: Literal["NoVisualizationOutputFound"]


class DataTableColumnFormula1(TypedDict):
    contents: float
    tag: Literal["Const"]


class DataTableColumnFormula2(TypedDict):
    contents: ColumnName
    tag: Literal["Var"]


class DataTableColumnFormula8(TypedDict):
    tag: Literal["Nil"]


type DataTableColumnType = Literal[
    "number", "non-negative-number", "string", "iso8601-duration", "unit"
]


class DataTableOverview(TypedDict):
    """
    Information computed from the data_table content
    """

    initialColumnCount: NotRequired[Optional[int]]
    initialRowCount: NotRequired[Optional[int]]
    observableCount: NotRequired[Optional[int]]
    timePointCount: NotRequired[Optional[int]]
    validForFitnessFunction: NotRequired[Optional[bool]]
    withMappingColumnCount: NotRequired[Optional[int]]
    withMappingRowCount: NotRequired[Optional[int]]


class DataTablePredicate4(TypedDict):
    contents: bool
    tag: Literal["BoolConst"]


type DataTableValue = Any


type Date = str


class DescriptorType4(TypedDict):
    labels: List
    type: Literal["Technical"]


class Diagnostic1(TypedDict):
    tag: Literal["Success"]


type DiscontinuityCheckLevel = Literal["AddAuxiliaryEvents", "WarnOnly", "DontCheck"]


class Distrib1(TypedDict):
    highBound: float
    lowBound: float
    tag: Literal["Uniform"]


class Distrib11(TypedDict):
    randDistrib: List[float]
    tag: Literal["RandDistrib"]


class Document(TypedDict):
    version: float
    """
    The version number of the document content schema
    """
    doc: Dict[str, Any]
    """
    The content of the document
    """


type DualOp = Literal[
    "Plus", "Minus", "Times", "Div", "Pow", "LogBase", "Max", "Min", "Mod"
]


type Duration = str


type ElemHead = Literal["RF", "O", "E", "P", "V", "C"]


type ElemName = str


type EmptyOverview = List


type EvaluationMethod = Literal["Haskell", "LLVM"]


type EvaluationMode = Literal["ScoringV2"]


type ExportTable = List[Any]


class FileUrl(TypedDict):
    id: str
    """
    Unique identifier of the file
    """
    link: str
    """
    Link to retrieve the content of the file
    """


class Filter3(TypedDict):
    contents: List[str]
    tag: Literal["PatientList"]


class Folder(TypedDict):
    id: str
    """
    Unique identifier of the folder
    """
    name: str
    """
    Name of the folder
    """


class Formula1(TypedDict):
    contents: float
    tag: Literal["Const"]


class Formula8(TypedDict):
    tag: Literal["Nil"]


class FriendlyError(TypedDict):
    howToFix: NotRequired[Optional[str]]
    reassurance: NotRequired[Optional[str]]
    wayOut: NotRequired[Optional[str]]
    what: NotRequired[Optional[str]]
    why: NotRequired[Optional[str]]


class GeneratorOptions(TypedDict):
    label: NotRequired[str]
    """
    A label to customize the name of the fitness function generated from the data table
    """
    logTransformWideBounds: NotRequired[List[str]]
    """
    For the observables selected, the wide bounds are defined to be at 50% (resp. 200%) of the left (resp. right) narrow bounds. If wide bounds are already defined for those observables in the datatable, the explicitely defined wide bounds take precedence.
    """
    timeTolerance: NotRequired[str]
    """
    Parameter to allow for the calibrated timeseries to match the source data within a time window around the data table time points
    """
    weight: NotRequired[float]
    """
    The weight of the data table, if it is to be combined with other data tables
    """


type Granularity = Literal["year", "month", "week", "day", "hour", "minute", "second"]


class Group1(TypedDict):
    """
    One group per 'scalarId' per value group (here 'Span')
    """

    tag: Literal["All"]


class Group2(TypedDict):
    """
    One group per 'scalarId' per value group (here 'Span')
    """

    contents: str
    tag: Literal["ScenarioArm"]


class Parameters(TypedDict):
    boundsAdditionalInfo: NotRequired[List[float]]
    highBound: float
    lowBound: float


class GroupBy1(TypedDict):
    tag: Literal["ScenarioArm"]


class GroupBy2(TypedDict):
    tag: Literal["All"]


class HistogramBin(TypedDict):
    count: int
    interval: List[float]
    normalizedFrequency: float


class Html(TypedDict):
    pass


type Id = str


type IdComponentKind = str


class IdSelection1(TypedDict):
    Some: List[Id]


class IdSelection2(TypedDict):
    AllBut: List[Id]


type IdSelection = Union[Literal["All"], IdSelection1, IdSelection2]


type ImmutableId = str


type ImmutableIdMapping = Optional[Dict[str, IdComponentKind]]


class IndividualPatientsDescriptor(TypedDict):
    arms: NotRequired[List[str]]
    id: str


class IndividualPatientsOverlay(TypedDict):
    descriptors: List[IndividualPatientsDescriptor]
    patients: List[str]


class InputDescriptorsSelector1(TypedDict):
    tag: Literal["InputBaselineOnly"]


class InputDescriptorsSelector2(TypedDict):
    tag: Literal["AllBaseline"]


class InputDescriptorsSelector3(TypedDict):
    contents: List[Id]
    tag: Literal["CustomInputDescriptorSelection"]


type InputDescriptorsSelector = Union[
    InputDescriptorsSelector1, InputDescriptorsSelector2, InputDescriptorsSelector3
]


class IntegerRatio1(TypedDict):
    denominator: int
    numerator: int


type IntegerRatio = Union[float, IntegerRatio1]


class IterationSummary(TypedDict):
    averageScore: NotRequired[Optional[float]]
    duration: NotRequired[Union[Duration, Dict[str, Any]]]
    failedPatients: int
    iterationNumber: int
    maximumScore: NotRequired[Optional[float]]
    outOfBoundsPatients: int
    totalPopulationSize: int
    totalTasks: int


type JobStatus = Literal["completed", "running", "not_launched", "stopped", "error"]


type Label = Literal[
    "Unspecified",
    "ValueFormula",
    "ScaleFormula",
    "MolarMassFormula",
    "InitialConditionFormula",
    "IsInCompartment",
    "EventTime",
    "UpdatedByEvent",
    "EventUpdateFormula",
    "EventCondition",
    "BaselineCheckCondition",
    "OdeLhs",
    "OdeRhs",
    "OdeFilter",
    "ReactionKineticLaw",
    "ReactionRateMultiplierFormula",
    "ReactionFilter",
    "ReactionReactives",
    "ReactionProducts",
]


class LatexResult(TypedDict):
    latex: str


class Layout(TypedDict):
    pass


class Legend(TypedDict):
    pass


type Level = str


type LocVariableMap = Optional[Dict[str, str]]


class Mapping1(TypedDict):
    """
    Create a column with a constant
    """

    column: ColumnName
    operation: Literal["const"]
    """
    Operation
    """
    value: ColumnValue


class Mapping2(TypedDict):
    """
    Fill missing values of a column with a constant
    """

    column: ColumnName
    operation: Literal["fromMaybe"]
    """
    Operation
    """
    value: ColumnValue


class Mapping3(TypedDict):
    """
    Cast a column to a different type
    """

    cast: ColumnType
    column: ColumnName
    operation: Literal["cast"]
    """
    Operation
    """


class Mapping4(TypedDict):
    """
    Cast a column with time to a duration
    """

    column: ColumnName
    granularity: Granularity
    operation: Literal["castDuration"]
    """
    Operation
    """


Map = TypedDict(
    "Map",
    {
        "from": ColumnValue,
        "to": ColumnValue,
    },
)


class Mapping5(TypedDict):
    """
    Map values from a column
    """

    column: ColumnName
    maps: List[Map]
    operation: Literal["mapContent"]
    """
    Operation
    """


"""
Rename a column
"""
Mapping6 = TypedDict(
    "Mapping6",
    {
        "from": ColumnName,
        "operation": Literal["renameColumn"],
        """
    Operation
    """
        "to": ColumnName,
    },
)


class Mapping7(TypedDict):
    """
    Tabulate a table: creates columns _columnWithNames_ and _columnWithValues_ containing names and values from the columns in _columns_
    """

    columnWithNames: ColumnName
    columnWithValues: ColumnName
    columns: NotRequired[List[ColumnName]]
    operation: Literal["tabulate"]
    """
    Operation
    """


class Mapping10(TypedDict):
    """
    Apply (binary) _function_ on _originColumn1_ and _originColumn2_ (infix: _origColumn1_ _function_ _origColumn2_) and store result in new column _destinationColumn_
    """

    destinationColumn: ColumnName
    function: DualOp
    operation: Literal["duoExtend"]
    """
    Operation
    """
    originColumn1: ColumnName
    originColumn2: ColumnName


class Mapping13(TypedDict):
    """
    Delete a column
    """

    column: ColumnName
    operation: Literal["deleteColumn"]
    """
    Operation
    """


class PointAtTime(TypedDict):
    """
    The measure is taken at a specific time point
    """

    At: str
    """
    The measure is made at a time point defined as a duration in ISO8601 format, or the value of a descriptor of the model.
    """


class Function4(TypedDict):
    PointAtTime: Union[Literal["TStart", "TEnd"], PointAtTime]
    """
    The measure is taken at a specific time point
    """


class ObservationWindow(TypedDict):
    FromTimeUntilEnd: str
    """
    The observation window starts at this time and stops at the end of the simulation.
    """


class ObservationWindow1(TypedDict):
    FromStartUntilTime: str
    """
    The observation window starts at the beginning of the simulation and stops at this time.
    """


class FromTimeUntilTime(TypedDict):
    TEnd: str
    """
    The observation window stops at TEnd.
    """
    TStart: str
    """
    The observation window starts at TStart.
    """


class ObservationWindow2(TypedDict):
    FromTimeUntilTime: FromTimeUntilTime


class AcrossTime(TypedDict):
    """
    The measure is computed during a specified period of time
    """

    CrossTimeMeasure: Literal[
        "Min",
        "Max",
        "TimeOfMax",
        "TimeOfMin",
        "Avg",
        "Auc",
        "MaxSlope",
        "MinSlope",
        "Amplitude",
        "EndMinusStart",
    ]
    """
    Reduce functions to go from one time series to a single scalar value.
    """
    ObservationWindow: Union[
        Literal["FromStartUntilEnd"],
        ObservationWindow,
        ObservationWindow1,
        ObservationWindow2,
    ]


class Function5(TypedDict):
    AcrossTime: AcrossTime
    """
    The measure is computed during a specified period of time
    """


class Measure(TypedDict):
    function: NotRequired[Union[Function4, Function5]]
    name: NotRequired[str]
    """
    A user-defined name given to the measure. If not provided, an automatically generated name will be given to the measure.
    """
    origin: NotRequired[Literal["OnEachArm", "DifferenceVsControl", "RatioVsControl"]]
    """
    The measure is either computed on each scenario arm, or it's a comparison between the measure on a scenario arm and its control arm.
    """
    timeseriesId: str
    """
    On which output of the model the measure is made
    """


class MeasureDesignOverview(TypedDict):
    """
    Information computed from the measure_design content
    """

    measureCount: int
    outputCount: int


class MeasureSpecifics(TypedDict):
    formula: NotRequired[Optional[str]]
    unit: NotRequired[Optional[str]]


class MembershipCondition(TypedDict):
    membershipScrutinee: Id
    membershipSet: List[Level]


class ModelCreator(TypedDict):
    email: NotRequired[Optional[str]]
    name: str
    organization: NotRequired[Optional[str]]


class ModelHistory(TypedDict):
    createdDate: NotRequired[Union[Date, Dict[str, Any]]]
    creators: List[ModelCreator]
    modifiedDates: List[Date]


type ModelInputTag = Literal[
    "ModelIntrinsic",
    "PatientDescriptorKnown",
    "PatientDescriptorPartiallyKnown",
    "PatientDescriptorUnknown",
    "Formulaic",
    "ProtocolSpecific",
    "Technical",
    "NoTag",
]


type LocationItem = int


class Diagnostic4(TypedDict):
    field: NotRequired[Optional[str]]
    location: NotRequired[List[LocationItem]]
    message: str
    severity: Literal[
        "Debug", "Info", "Notice", "Warning", "Error", "Critical", "Alert", "Emergency"
    ]


class Specifics(TypedDict):
    condition: str


class BaselineCheck(TypedDict):
    description: NotRequired[Optional[str]]
    """
    Optional. Description of the component
    """
    diagnostics: NotRequired[List[Diagnostic4]]
    displayName: NotRequired[Optional[str]]
    """
    Optional. A more readable name that will be used in particular in the Trial visualization. In formulas, the 'ID' must be used
    """
    id: str
    """
    Unique identifier of the component, used in particular in formulas. An ID cannot start with a number, '-' or '.' and cannot contain special characters
    """
    immutableId: NotRequired[Optional[str]]
    isActive: NotRequired[bool]
    links: NotRequired[Optional[List[str]]]
    """
    Optional. Links to the source knowledge that was used to build this component. Used for traceability
    """
    specifics: Specifics
    tags: NotRequired[List[str]]
    """
    A set of immutable IDs for custom tags.
    """


class Diagnostic5(TypedDict):
    field: NotRequired[Optional[str]]
    location: NotRequired[List[LocationItem]]
    message: str
    severity: Literal[
        "Debug", "Info", "Notice", "Warning", "Error", "Critical", "Alert", "Emergency"
    ]


class Specifics1(TypedDict):
    availableLevels: List[str]
    """
    Possible levels the parameter can take
    """
    level: str
    """
    Level of the parameter in the default setting
    """


class CategoricalParameter(TypedDict):
    description: NotRequired[Optional[str]]
    """
    Optional. Description of the component
    """
    diagnostics: NotRequired[List[Diagnostic5]]
    displayName: NotRequired[Optional[str]]
    """
    Optional. A more readable name that will be used in particular in the Trial visualization. In formulas, the 'ID' must be used
    """
    id: str
    """
    Unique identifier of the component, used in particular in formulas. An ID cannot start with a number, '-' or '.' and cannot contain special characters
    """
    immutableId: NotRequired[Optional[str]]
    isActive: NotRequired[bool]
    links: NotRequired[Optional[List[str]]]
    """
    Optional. Links to the source knowledge that was used to build this component. Used for traceability
    """
    specifics: Specifics1
    tags: NotRequired[List[str]]
    """
    A set of immutable IDs for custom tags.
    """


class Diagnostic6(TypedDict):
    field: NotRequired[Optional[str]]
    location: NotRequired[List[LocationItem]]
    message: str
    severity: Literal[
        "Debug", "Info", "Notice", "Warning", "Error", "Critical", "Alert", "Emergency"
    ]


class Specifics2(TypedDict):
    constant: NotRequired[bool]
    """
    Optional, defaults to false. If set to true, the volume of the compartment remains constant over time, it will not be altered by any assignment formula, ODE or Event. See <a target="_blank" href=https://sbml.org/specifications/sbml-level-3/version-2/core/release-2/sbml-level-3-version-2-release-2-core.pdf#subsubsection.4.6.6>the SBML documentation on the constant attribute</a>
    """
    scale: NotRequired[Union[str, float]]
    """
    Optional (defaults to 1). Scale σ. If x is the variable, we introduce the change of variable x'=x/σ and the initial Ode dx/dt=f(x,t) becomes dx'/dt=σ*f(σx',t) such that the variable we actually solve for, x', has the order of magnitude of x/σ
    """
    tolerance: NotRequired[float]
    """
    Optional (defaults to 1). The tolerance of the scaled variable (in dimensionless units). This value is multiplied by the model-wide tolAbs to get the actual absolute tolerance passed to the solver
    """
    unit: NotRequired[Optional[str]]
    """
    Unit used for the compartment volume. If the volume is a formula, the unit can be inferred and is therefore optional. See help center - Units for a list of available units and prefixes
    """
    volume: Union[str, float]
    """
    Volume of the compartment. Is used in formulas if compartment ID is referenced and also for the conversion of species in that compartment
    """


class Compartment(TypedDict):
    description: NotRequired[Optional[str]]
    """
    Optional. Description of the component
    """
    diagnostics: NotRequired[List[Diagnostic6]]
    displayName: NotRequired[Optional[str]]
    """
    Optional. A more readable name that will be used in particular in the Trial visualization. In formulas, the 'ID' must be used
    """
    id: str
    """
    Unique identifier of the component, used in particular in formulas. An ID cannot start with a number, '-' or '.' and cannot contain special characters
    """
    immutableId: NotRequired[Optional[str]]
    isActive: NotRequired[bool]
    links: NotRequired[Optional[List[str]]]
    """
    Optional. Links to the source knowledge that was used to build this component. Used for traceability
    """
    specifics: Specifics2
    tags: NotRequired[List[str]]
    """
    A set of immutable IDs for custom tags.
    """


class Diagnostic7(TypedDict):
    field: NotRequired[Optional[str]]
    location: NotRequired[List[LocationItem]]
    message: str
    severity: Literal[
        "Debug", "Info", "Notice", "Warning", "Error", "Critical", "Alert", "Emergency"
    ]


class TimeTrigger(TypedDict):
    firstTime: Union[str, float]
    """
    Time at which the event is triggered
    """


class TimeTrigger1(TypedDict):
    every: Union[str, float]
    """
    Optional. Time between two occurrences for a repeated event. If unset, the event is triggered only once
    """
    firstTime: Union[str, float]
    """
    First time the event is triggered
    """


class TimeTrigger2(TypedDict):
    count: Union[str, float]
    """
    Optional. Number of times the event is triggered. If unset, the event is repeated until tmax. Incompatible with Until
    """
    every: Union[str, float]
    """
    Optional. Time between two occurrences for a repeated event. If unset, the event is triggered only once
    """
    firstTime: Union[str, float]
    """
    First time the event is triggered
    """


class TimeTrigger3(TypedDict):
    every: Union[str, float]
    """
    Optional. Time between two occurrences for a repeated event. If unset, the event is triggered only once
    """
    firstTime: Union[str, float]
    """
    First time the event is triggered
    """
    until: Union[str, float]
    """
    Timestamp of the end of the event series. If unset, the event is repeated until tmax. Incompatible with Number of occurrences
    """


class Specifics3(TypedDict):
    conditionTrigger: NotRequired[str]
    """
    Condition for the event to be triggered, evaluated at each occurrence of the event
    """
    priority: NotRequired[Union[str, float]]
    """
    Optional. When multiple events trigger simultaneously, the event with highest priority gets executed first
    """
    record: NotRequired[bool]
    """
    Optional, defaults to false. If true, the state before and after the event is recorded in the ODE solution, adding 2 timepoints to the results
    """
    solverStop: NotRequired[Literal["nostop", "stop"]]
    timeTrigger: NotRequired[
        Union[TimeTrigger, TimeTrigger1, TimeTrigger2, TimeTrigger3]
    ]
    updates: List[List]


class Event(TypedDict):
    description: NotRequired[Optional[str]]
    """
    Optional. Description of the component
    """
    diagnostics: NotRequired[List[Diagnostic7]]
    displayName: NotRequired[Optional[str]]
    """
    Optional. A more readable name that will be used in particular in the Trial visualization. In formulas, the 'ID' must be used
    """
    id: str
    """
    Unique identifier of the component, used in particular in formulas. An ID cannot start with a number, '-' or '.' and cannot contain special characters
    """
    immutableId: NotRequired[Optional[str]]
    isActive: NotRequired[bool]
    links: NotRequired[Optional[List[str]]]
    """
    Optional. Links to the source knowledge that was used to build this component. Used for traceability
    """
    specifics: Specifics3
    tags: NotRequired[List[str]]
    """
    A set of immutable IDs for custom tags.
    """


class Diagnostic8(TypedDict):
    field: NotRequired[Optional[str]]
    location: NotRequired[List[LocationItem]]
    message: str
    severity: Literal[
        "Debug", "Info", "Notice", "Warning", "Error", "Critical", "Alert", "Emergency"
    ]


class Specifics4(TypedDict):
    filter: NotRequired[str]
    """
    Optional. Condition evaluated at tmin, to assess whether the ODE should be used or not in the model
    """
    leftSide: str
    """
    ID used to define the LHS of the ODE: d(LeftSide)/dt = RightSide
    """
    rightSide: Union[str, float]
    """
    Definition of the time derivative of the left side: d(LeftSide)/dt = RightSide
    """


class Ode(TypedDict):
    description: NotRequired[Optional[str]]
    """
    Optional. Description of the component
    """
    diagnostics: NotRequired[List[Diagnostic8]]
    displayName: NotRequired[Optional[str]]
    """
    Optional. A more readable name that will be used in particular in the Trial visualization. In formulas, the 'ID' must be used
    """
    id: str
    """
    Unique identifier of the component, used in particular in formulas. An ID cannot start with a number, '-' or '.' and cannot contain special characters
    """
    immutableId: NotRequired[Optional[str]]
    isActive: NotRequired[bool]
    links: NotRequired[Optional[List[str]]]
    """
    Optional. Links to the source knowledge that was used to build this component. Used for traceability
    """
    specifics: Specifics4
    tags: NotRequired[List[str]]
    """
    A set of immutable IDs for custom tags.
    """


class Diagnostic9(TypedDict):
    field: NotRequired[Optional[str]]
    location: NotRequired[List[LocationItem]]
    message: str
    severity: Literal[
        "Debug", "Info", "Notice", "Warning", "Error", "Critical", "Alert", "Emergency"
    ]


class Specifics5(TypedDict):
    constant: NotRequired[bool]
    """
    Optional, defaults to false. If set to true, the parameter's value remains constant over time, it will not be altered by any assignment formula, ODE or Event. See <a target="_blank" href=https://sbml.org/specifications/sbml-level-3/version-2/core/release-2/sbml-level-3-version-2-release-2-core.pdf#subsubsection.4.6.6>the SBML documentation on the constant attribute</a>
    """
    formula: Union[str, float]
    """
    Value or formula of the parameter. If an ODE has this parameter as LHS, this represents the initial condition
    """
    scale: NotRequired[Union[str, float]]
    """
    Optional (defaults to 1). Scale σ. If x is the variable, we introduce the change of variable x'=x/σ and the initial Ode dx/dt=f(x,t) becomes dx'/dt=σ*f(σx',t) such that the variable we actually solve for, x', has the order of magnitude of x/σ
    """
    tolerance: NotRequired[float]
    """
    Optional (defaults to 1). The tolerance of the scaled variable (in dimensionless units). This value is multiplied by the model-wide tolAbs to get the actual absolute tolerance passed to the solver
    """
    unit: NotRequired[Optional[str]]
    """
    Unit used for the parameter. If the value is a formula, the unit can be inferred and is therefore optional. See help center - units for a list of available units and prefixes
    """


class Parameter(TypedDict):
    description: NotRequired[Optional[str]]
    """
    Optional. Description of the component
    """
    diagnostics: NotRequired[List[Diagnostic9]]
    displayName: NotRequired[Optional[str]]
    """
    Optional. A more readable name that will be used in particular in the Trial visualization. In formulas, the 'ID' must be used
    """
    id: str
    """
    Unique identifier of the component, used in particular in formulas. An ID cannot start with a number, '-' or '.' and cannot contain special characters
    """
    immutableId: NotRequired[Optional[str]]
    isActive: NotRequired[bool]
    links: NotRequired[Optional[List[str]]]
    """
    Optional. Links to the source knowledge that was used to build this component. Used for traceability
    """
    specifics: Specifics5
    tags: NotRequired[List[str]]
    """
    A set of immutable IDs for custom tags.
    """


class Diagnostic10(TypedDict):
    field: NotRequired[Optional[str]]
    location: NotRequired[List[LocationItem]]
    message: str
    severity: Literal[
        "Debug", "Info", "Notice", "Warning", "Error", "Critical", "Alert", "Emergency"
    ]


class Contents10(TypedDict):
    products: List[List]
    rate: Union[str, float]
    """
    Rate of the reaction
    """
    reactants: List[List]


class Kinetics(TypedDict):
    contents: Contents10
    tag: Literal["General"]


class Contents11(TypedDict):
    kMinus: NotRequired[Optional[str]]
    kPlus: str
    products: List[List]
    reactants: List[List]


class Kinetics1(TypedDict):
    contents: Contents11
    tag: Literal["MassAction"]


class Contents12(TypedDict):
    enzyme: str
    kCat: str
    kM: str
    product: str
    substrate: str


class Kinetics2(TypedDict):
    contents: Contents12
    tag: Literal["MichaelisMenten"]


class Contents13(TypedDict):
    enzyme: str
    kCat: str
    kInv: str
    kM: str
    kP: str
    product: str
    substrate: str


class Kinetics3(TypedDict):
    contents: Contents13
    tag: Literal["ReversibleMichaelisMenten"]


class Contents14(TypedDict):
    enzyme: str
    hillCoefficient: str
    kCat: str
    kM: str
    product: str
    substrate: str


class Kinetics4(TypedDict):
    contents: Contents14
    tag: Literal["HillEquation"]


class Contents15(TypedDict):
    activator: str
    enzyme: str
    kA: str
    kCat: str
    kM: str
    product: str
    substrate: str


class Kinetics5(TypedDict):
    contents: Contents15
    tag: Literal["EnzymaticActivation"]


class Contents16(TypedDict):
    enzyme: str
    inhibitor: str
    kCat: str
    kIEnzyme: str
    kM: str
    product: str
    substrate: str


class Kinetics6(TypedDict):
    contents: Contents16
    tag: Literal["CompetitiveInhibition"]


class Contents17(TypedDict):
    enzyme: str
    inhibitor: str
    kCat: str
    kIEnzymaticComplex: str
    kM: str
    product: str
    substrate: str


class Kinetics7(TypedDict):
    contents: Contents17
    tag: Literal["UncompetitiveInhibition"]


class Contents18(TypedDict):
    enzyme: str
    inhibitor: str
    kCat: str
    kIEnzymaticComplex: str
    kIEnzyme: str
    kM: str
    product: str
    substrate: str


class Kinetics8(TypedDict):
    contents: Contents18
    tag: Literal["MixedInhibition"]


class Specifics6(TypedDict):
    filter: NotRequired[str]
    """
    Optional. Condition evaluated at tmin, to assess whether the reaction should be used or not in the model
    """
    kinetics: Union[
        Kinetics,
        Kinetics1,
        Kinetics2,
        Kinetics3,
        Kinetics4,
        Kinetics5,
        Kinetics6,
        Kinetics7,
        Kinetics8,
    ]
    rateMultiplier: NotRequired[Union[str, float]]
    """
    Optional. Multiplier of the rate. Can be used together with different kinetic law types to add complexity
    """


class Reaction(TypedDict):
    description: NotRequired[Optional[str]]
    """
    Optional. Description of the component
    """
    diagnostics: NotRequired[List[Diagnostic10]]
    displayName: NotRequired[Optional[str]]
    """
    Optional. A more readable name that will be used in particular in the Trial visualization. In formulas, the 'ID' must be used
    """
    id: str
    """
    Unique identifier of the component, used in particular in formulas. An ID cannot start with a number, '-' or '.' and cannot contain special characters
    """
    immutableId: NotRequired[Optional[str]]
    isActive: NotRequired[bool]
    links: NotRequired[Optional[List[str]]]
    """
    Optional. Links to the source knowledge that was used to build this component. Used for traceability
    """
    specifics: Specifics6
    tags: NotRequired[List[str]]
    """
    A set of immutable IDs for custom tags.
    """


class Diagnostic11(TypedDict):
    field: NotRequired[Optional[str]]
    location: NotRequired[List[LocationItem]]
    message: str
    severity: Literal[
        "Debug", "Info", "Notice", "Warning", "Error", "Critical", "Alert", "Emergency"
    ]


class Specifics7(TypedDict):
    boundaryCondition: NotRequired[bool]
    """
    Optional, defaults to false. When true, the amount of the species is not determined by any reaction. See <a target="_blank" href=https://sbml.org/specifications/sbml-level-3/version-2/core/release-2/sbml-level-3-version-2-release-2-core.pdf#subsubsection.4.6.6>the corresponding SBML documentation</a>
    """
    compartment: str
    """
    Compartment where the species lives
    """
    constant: NotRequired[bool]
    """
    Optional, defaults to false. If set to true, the species amount remains constant over time, it will not be altered by any assignment formula, reaction, ODE or event. See <a target="_blank" href=https://sbml.org/specifications/sbml-level-3/version-2/core/release-2/sbml-level-3-version-2-release-2-core.pdf#subsubsection.4.6.6>the SBML documentation on the constant attribute</a>
    """
    conversionFactor: NotRequired[str]
    """
    Optional. Conversion factor is used to multiply all reaction rates to define the dynamics of this species. See 4.11.7 of the SBML L3V2 specifications
    """
    initialCondition: Union[str, float]
    """
    Initial condition (or formula) of the species
    """
    molarMass: NotRequired[Union[str, float]]
    """
    Optional. The molar mass is used to convert the Species to the extentUnits when needed (see Unit)
    """
    scale: NotRequired[Union[str, float]]
    """
    Optional (defaults to 1). Scale σ. If x is the variable, we introduce the change of variable x'=x/σ and the initial Ode dx/dt=f(x,t) becomes dx'/dt=σ*f(σx',t) such that the variable we actually solve for, x', has the order of magnitude of x/σ
    """
    tolerance: NotRequired[float]
    """
    Optional (defaults to 1). The tolerance of the scaled variable (in dimensionless units). This value is multiplied by the model-wide tolAbs to get the actual absolute tolerance passed to the solver
    """
    unit: NotRequired[Optional[str]]
    """
    Unit used for the species initial condition. If the initial condition is a formula, the unit can be inferred and is therefore optional. Note that species used in formulas may be converted, meaning that they will be converted in extentUnits (defaults to mol) when used in a formula. See help center - Units for a list of available units and prefixes and more details on the conversions
    """


class Species(TypedDict):
    description: NotRequired[Optional[str]]
    """
    Optional. Description of the component
    """
    diagnostics: NotRequired[List[Diagnostic11]]
    displayName: NotRequired[Optional[str]]
    """
    Optional. A more readable name that will be used in particular in the Trial visualization. In formulas, the 'ID' must be used
    """
    id: str
    """
    Unique identifier of the component, used in particular in formulas. An ID cannot start with a number, '-' or '.' and cannot contain special characters
    """
    immutableId: NotRequired[Optional[str]]
    isActive: NotRequired[bool]
    links: NotRequired[Optional[List[str]]]
    """
    Optional. Links to the source knowledge that was used to build this component. Used for traceability
    """
    specifics: Specifics7
    tags: NotRequired[List[str]]
    """
    A set of immutable IDs for custom tags.
    """


class Components(TypedDict):
    baselineChecks: NotRequired[List[BaselineCheck]]
    categoricalParameters: NotRequired[List[CategoricalParameter]]
    compartments: NotRequired[List[Compartment]]
    events: NotRequired[List[Event]]
    odes: NotRequired[List[Ode]]
    parameters: NotRequired[List[Parameter]]
    reactions: NotRequired[List[Reaction]]
    species: NotRequired[List[Species]]


class Diagnostic12(TypedDict):
    field: NotRequired[Optional[str]]
    location: NotRequired[List[LocationItem]]
    message: str
    severity: Literal[
        "Debug", "Info", "Notice", "Warning", "Error", "Critical", "Alert", "Emergency"
    ]


class Specifics8(TypedDict):
    color: NotRequired[Optional[str]]
    protected: NotRequired[Optional[bool]]
    """
    Optional, defaults to false. If true, the tag is a protected tag
    """


class Tag(TypedDict):
    description: NotRequired[Optional[str]]
    """
    Optional. Description of the component
    """
    diagnostics: NotRequired[List[Diagnostic12]]
    displayName: NotRequired[Optional[str]]
    """
    Optional. A more readable name that will be used in particular in the Trial visualization. In formulas, the 'ID' must be used
    """
    id: str
    """
    Unique identifier of the component, used in particular in formulas. An ID cannot start with a number, '-' or '.' and cannot contain special characters
    """
    immutableId: NotRequired[Optional[str]]
    isActive: NotRequired[bool]
    links: NotRequired[Optional[List[str]]]
    """
    Optional. Links to the source knowledge that was used to build this component. Used for traceability
    """
    specifics: Specifics8
    tags: NotRequired[List[str]]
    """
    A set of immutable IDs for custom tags.
    """


class ModelInterface(TypedDict):
    components: NotRequired[Components]
    description: NotRequired[Optional[str]]
    displayName: NotRequired[Optional[str]]
    tags: NotRequired[List[Tag]]


type ModelQualifierType = Literal[
    "bqmodel:is",
    "bqmodel:isDescribedBy",
    "bqmodel:isDerivedFrom",
    "bqmodel:isInstanceOf",
    "bqmodel:hasInstance",
]


type ModelUnloadedRaw = Union[str, bytes]


class ModelWithOptsOverview(TypedDict):
    """
    Information computed from the jinko_model content
    """

    baselineCheckCount: int
    categoricalParameterCount: int
    compartmentCount: int
    eventCount: int
    odeCount: int
    parameterCount: int
    reactionCount: int
    speciesCount: int


type MonoOp = Literal[
    "Neg",
    "Abs",
    "Sign",
    "Exp",
    "Log",
    "Sin",
    "Cos",
    "Tan",
    "Asin",
    "Acos",
    "Atan",
    "Tanh",
    "Sqrt",
    "Floor",
    "Ceil",
    "Round",
    "Factorial",
]


class NumericBarChart(TypedDict):
    """
    See https://novak.jinko.ai/doc/doc-simworkZSmathZSnovarandom/Math-Random-BarChart.html#t:NumericBarChart
    """

    barChart: List[BarChartBinNDouble]


class OdeEquation(TypedDict):
    latex: str


type OdeMethod = Literal[
    "ADAMS",
    "BDF",
    "SDIRK_2_1_2",
    "BILLINGTON_3_3_2",
    "TRBDF2_3_3_2",
    "KVAERNO_4_2_3",
    "ARK324L2SA_DIRK_4_2_3",
    "CASH_5_2_4",
    "CASH_5_3_4",
    "SDIRK_5_3_4",
    "KVAERNO_5_3_4",
    "ARK436L2SA_DIRK_6_3_4",
    "KVAERNO_7_4_5",
    "ARK548L2SA_DIRK_8_4_5",
    "HEUN_EULER_2_1_2",
    "BOGACKI_SHAMPINE_4_2_3",
    "ARK324L2SA_ERK_4_2_3",
    "ZONNEVELD_5_3_4",
    "ARK436L2SA_ERK_6_3_4",
    "SAYFY_ABURUB_6_3_4",
    "CASH_KARP_6_4_5",
    "FEHLBERG_6_4_5",
    "DORMAND_PRINCE_7_4_5",
    "ARK548L2SA_ERK_8_4_5",
    "VERNER_8_5_6",
    "FEHLBERG_13_7_8",
]


type Operator = Literal["Eq", "Lte", "Gte", "Neq", "Lt", "Gt"]


class OutputResult(TypedDict):
    coord: List[float]
    origin: List[float]


class OutputResultsList(TypedDict):
    keys: List[Id]
    vals: OutputResult


type OutputType = Literal["Standard", "Custom"]


type OverrideLabel = Literal[
    "VpopOverride",
    "DependsOnVpopOverride",
    "ScenarioOverride",
    "DependsOnScenarioOverride",
]


class PatientCategoricalAttribute(TypedDict):
    id: Id
    val: Level


class PhasePortraitParameter(TypedDict):
    parameterId: Id
    parameterRange: List[float]


class PhasePortraitVariable(TypedDict):
    variableId: Id
    variableRange: List[float]


class PhenomenaMuter1(TypedDict):
    Some: List[Id]


class PhenomenaMuter2(TypedDict):
    AllBut: List[Id]


type PhenomenaMuter = Union[Literal["None"], PhenomenaMuter1, PhenomenaMuter2]


type Phenomenon = str


class PhysicalUnit1(TypedDict):
    name: str


type PhysicalUnit = Union[str, PhysicalUnit1]


class PlainOde(TypedDict):
    equation: OdeEquation
    id: Id


type PositiveDouble = float


type PositiveInt = int


type Power = Union[str, IntegerRatio]


type Precision = Literal["Low", "High"]


type Probability = float


type ProjectId = Optional[str]


class ProjectItemCoreId(TypedDict):
    id: str
    snapshotId: str


class ProjectItemCreator(TypedDict):
    username: str
    displayName: Optional[Dict[str, Any]]


class ProjectItemLock(TypedDict):
    enabled: bool
    updatedAt: str
    updatedBy: ProjectItemCreator


type ProjectItemType = Literal[
    "Assertion",
    "Calibration",
    "ComputationalModel",
    "DataTable",
    "Document",
    "MeasureDesign",
    "ProtocolDesign",
    "ScoringDesign",
    "Source",
    "SubsamplingDesign",
    "Trial",
    "TrialVisualization",
    "Vpop",
    "VpopDesign",
]


class ProjectItemUrl(TypedDict):
    sid: str
    """
    Unique identifier of the project item
    """
    link: str
    """
    Link to retrieve the details of the project item
    """


class ProjectItemVersion(TypedDict):
    id: str
    """
    Internal version Id
    """
    revision: float
    """
    Revision number of the version
    """
    isLatest: bool
    label: Optional[str]
    """
    Name of the version
    """
    createdAt: str
    coreId: Optional[ProjectItemCoreId]
    """
    Project item identifier for modeling and simulation
    """


class ProtocolDesignOverview(TypedDict):
    """
    Information computed from the protocol_design content
    """

    activeArmCount: int
    armCount: PositiveInt
    armOverrideCount: int


class Quantile(TypedDict):
    name: float
    vals: List[float]


type QuantileList = List[Quantile]


class Reference(TypedDict):
    file: Optional[FileUrl]
    """
    File of the reference
    """
    bibliography: Bibliography
    """
    Bibliography of the reference
    """
    extracts: List[ProjectItemUrl]
    """
    Related extracts of the reference
    """


type RegressionType = Literal["linear", "quadratic", "cubic"]


type Resource = str


class RowPreview(TypedDict):
    formula: str
    x: List[float]
    y: List[float]


type SBMLValidationErrorCode = int


class SanityCheck(TypedDict):
    field: NotRequired[Optional[str]]
    location: NotRequired[List[LocationItem]]
    message: str
    severity: Literal[
        "Debug", "Info", "Notice", "Warning", "Error", "Critical", "Alert", "Emergency"
    ]


class SanityItem(TypedDict):
    items: List[str]
    reason: str


class SanityReason(TypedDict):
    code: Literal[
        "NoVPOP",
        "GeneralMinimalSampleSizeForStatisticalAnalysis",
        "NoTimeToEventScalarId",
        "NoPatientInSelection",
        "OnePatientInSelection",
        "NullSelect",
        "OneQuantityInSelect",
        "NoConfiguration",
    ]
    message: str


class SbmlCheck(TypedDict):
    code: NotRequired[Union[SBMLValidationErrorCode, Dict[str, Any]]]
    message: str


class ScalarWithArm(TypedDict):
    arm: NotRequired[Union[ArmId, Dict[str, Any]]]
    id: Id


class ScatterPlotXvsXArms(TypedDict):
    x: str
    y: List[str]


class ScatterPlotXvsYVariables(TypedDict):
    x: Id
    y: Id


class SchemaValidations(TypedDict):
    fitnessFunction: bool


class ScoringDesignObservable(TypedDict):
    arm: NotRequired[Optional[str]]
    id: Id


class ScoringDesignSummary(TypedDict):
    observables: NotRequired[List[ScoringDesignObservable]]


class SelectByArm(TypedDict):
    mandatorySelector: str
    optionalSelector: NotRequired[List[Id]]


class SelectByOutput(TypedDict):
    mandatorySelector: Id
    optionalSelector: NotRequired[List[str]]


class SensitivityIndex1(TypedDict):
    contents: List[Union[Id, float]]
    tag: Literal["FirstOrder"]


class SensitivityIndex2(TypedDict):
    contents: List[Union[Id, float]]
    tag: Literal["SecondOrder"]


type SensitivityIndex = Union[SensitivityIndex1, SensitivityIndex2]


type SnapshotId = str


class SnapshotMetadata(TypedDict):
    keep: NotRequired[Optional[bool]]


class SolveScoreAtomicJobError(TypedDict):
    armId: str
    error: str
    patientId: str


class MutePhenomena(TypedDict):
    """
    Mute all theses phenomena (all associated differential equations will have their right hand side set to zero resulting in piece-wise constant solutions)
    """

    Some: List[str]


class MutePhenomena1(TypedDict):
    """
    Mute all but theses phenomena (other than for these phenomena all the differential equations will have their right hand side set to zero resulting in piece-wise constant solutions)
    """

    AllBut: List[str]


class MuteVariables(TypedDict):
    """
    Mute some of theses variables (all associated differential equations will have their right hand side set to zero resulting in piece-wise constant solutions)
    """

    Some: List[str]


class MuteVariables1(TypedDict):
    """
    Mute all but theses variables (other than for these variables all the differential equations will have their right hand side set to zero resulting in piece-wise constant solutions)
    """

    AllBut: List[str]


class OutputCompartments(TypedDict):
    """
    Output these compartments in the results files
    """

    Some: List[str]


class OutputCompartments1(TypedDict):
    """
    Output all but these compartments in the results files
    """

    AllBut: List[str]


class OutputParameters(TypedDict):
    """
    Output these parameters in the results files
    """

    Some: List[str]


class OutputParameters1(TypedDict):
    """
    Output all but these parameters in the results files
    """

    AllBut: List[str]


class OutputRates(TypedDict):
    """
    Output these rates in the results files
    """

    Some: List[str]


class OutputRates1(TypedDict):
    """
    Output all but these rates in the results files
    """

    AllBut: List[str]


class OutputVariables(TypedDict):
    """
    Output these variables in the results files
    """

    Some: List[str]


class OutputVariables1(TypedDict):
    """
    Output all but these variables in the results files
    """

    AllBut: List[str]


class SolvingTimes(TypedDict):
    """
    An implicit solving time span
    """

    parentUuid: NotRequired[str]
    tMax: timedelta
    """
    Final time
    """
    tMin: timedelta
    """
    Initial time
    """
    tStep: timedelta
    """
    Step duration
    """
    uuid: NotRequired[str]


class SolvingOptions(TypedDict):
    allowVaryingStoichiometry: bool
    """
    Set to true if you need to allow for stoichiometric coefficients varying in time (not recommended but might be needed for SBML models allowing this feature)
    """
    coreVersion: NotRequired[str]
    discontinuityEvents: Literal["AddAuxiliaryEvents", "WarnOnly", "DontCheck"]
    """
    Adds auxiliary root-based events to help the ODE solver detect time-discontinuities in the right hand side (RHS). This is useful for time-adaptive solvers such as BDF to avoid missing short time-span variations in the system's RHS such as short term injections encoded via a time varying parameter
    """
    evaluator: Literal["LLVM", "Haskell"]
    """
    Whether you use the LLVM optimized or the Native Haskell solver
    """
    extentUnits: str
    """
    The unit the species are converted to. See our <a target="_blank" href=https://community.jinko.ai/t/h7h46z3>unit syntax guide</a>
    """
    inlineLimit: int
    """
    A number to control the maximum size (number of nodes) of expression trees that will be inlined before solving: 0 means there is no inlining, 1 means that we inline constants, etc...
    """
    maxEvents: int
    """
    Maximum number of root-based event occurrences
    """
    mutePhenomena: NotRequired[Union[Literal["None"], MutePhenomena, MutePhenomena1]]
    """
    Phenomena to be muted
    """
    muteVariables: NotRequired[Union[Literal["None"], MuteVariables, MuteVariables1]]
    """
    Variables to be muted
    """
    odeSolverAbsoluteTolerance: float
    """
    The solver absolute error tolerance
    """
    odeSolverInitialStep: float
    """
    The initial step of the solver
    """
    odeSolverRelativeTolerance: float
    """
    The solver relative error tolerance
    """
    outputCompartments: NotRequired[
        Union[Literal["All"], OutputCompartments, OutputCompartments1]
    ]
    """
    Compartments to output in the results files
    """
    outputParameters: NotRequired[
        Union[Literal["All"], OutputParameters, OutputParameters1]
    ]
    """
    Parameters to output in the results files
    """
    outputRates: NotRequired[Union[Literal["All"], OutputRates, OutputRates1]]
    """
    Rates to output in the results files
    """
    outputVariables: NotRequired[
        Union[Literal["All"], OutputVariables, OutputVariables1]
    ]
    """
    Variables to output in the results files
    """
    scoringMode: NotRequired[Literal["ScoringV2"]]
    """
    Use ScoringV2, other modes are now deprecated
    """
    solver: Literal[
        "ADAMS",
        "BDF",
        "SDIRK_2_1_2",
        "BILLINGTON_3_3_2",
        "TRBDF2_3_3_2",
        "KVAERNO_4_2_3",
        "ARK324L2SA_DIRK_4_2_3",
        "CASH_5_2_4",
        "CASH_5_3_4",
        "SDIRK_5_3_4",
        "KVAERNO_5_3_4",
        "ARK436L2SA_DIRK_6_3_4",
        "KVAERNO_7_4_5",
        "ARK548L2SA_DIRK_8_4_5",
        "HEUN_EULER_2_1_2",
        "BOGACKI_SHAMPINE_4_2_3",
        "ARK324L2SA_ERK_4_2_3",
        "ZONNEVELD_5_3_4",
        "ARK436L2SA_ERK_6_3_4",
        "SAYFY_ABURUB_6_3_4",
        "CASH_KARP_6_4_5",
        "FEHLBERG_6_4_5",
        "DORMAND_PRINCE_7_4_5",
        "ARK548L2SA_ERK_8_4_5",
        "VERNER_8_5_6",
        "FEHLBERG_13_7_8",
    ]
    """
    The numerical solving method used
    """
    solvingTimes: List[Union[timedelta, SolvingTimes]]
    """
    Each entry in this array will be either an explicit time or a regularly spaced time span. Those will determine the time points returned in the results. They are different from the time points used internally for solving
    """
    unitCheck: Literal[
        "NoUnitCheck",
        "UnitCheckWithNoUnitConversion",
        "UnitCheckAndConvertAllSpeciesToExtentUnits",
        "UnitCheckAndConvertOnlyReactantsAndProductsToExtentUnits",
    ]
    """
    How to perform unit checking on the model. See our <a target="_blank" href=https://community.jinko.ai/t/h7h46z3>unit syntax guide</a>
    """


class MutePhenomena2(TypedDict):
    """
    Mute all theses phenomena (all associated differential equations will have their right hand side set to zero resulting in piece-wise constant solutions)
    """

    Some: List[str]


class MutePhenomena3(TypedDict):
    """
    Mute all but theses phenomena (other than for these phenomena all the differential equations will have their right hand side set to zero resulting in piece-wise constant solutions)
    """

    AllBut: List[str]


class MuteVariables2(TypedDict):
    """
    Mute some of theses variables (all associated differential equations will have their right hand side set to zero resulting in piece-wise constant solutions)
    """

    Some: List[str]


class MuteVariables3(TypedDict):
    """
    Mute all but theses variables (other than for these variables all the differential equations will have their right hand side set to zero resulting in piece-wise constant solutions)
    """

    AllBut: List[str]


class OutputCompartments2(TypedDict):
    """
    Output these compartments in the results files
    """

    Some: List[str]


class OutputCompartments3(TypedDict):
    """
    Output all but these compartments in the results files
    """

    AllBut: List[str]


class OutputParameters2(TypedDict):
    """
    Output these parameters in the results files
    """

    Some: List[str]


class OutputParameters3(TypedDict):
    """
    Output all but these parameters in the results files
    """

    AllBut: List[str]


class OutputRates2(TypedDict):
    """
    Output these rates in the results files
    """

    Some: List[str]


class OutputRates3(TypedDict):
    """
    Output all but these rates in the results files
    """

    AllBut: List[str]


class OutputVariables2(TypedDict):
    """
    Output these variables in the results files
    """

    Some: List[str]


class OutputVariables3(TypedDict):
    """
    Output all but these variables in the results files
    """

    AllBut: List[str]


class SqlQuery(TypedDict):
    params: List[Union[float, str]]
    query: str


type SqliteDatabase = bytes


class StatisticalMoments(TypedDict):
    kurtosis: NotRequired[Optional[float]]
    mean: float
    skewness: NotRequired[Optional[float]]
    standardDeviation: float


type StreamedZipBundle = Any


class SubsamplingGeneratorOverview(TypedDict):
    categoricalCount: int
    correlationCount: int
    filterCount: int
    marginalCount: int
    summaryStatisticCount: int
    survivalCount: int


class Method(TypedDict):
    allowDuplicates: bool
    tag: Literal["InclusionProbabilities"]


class Method1(TypedDict):
    boltzmannConstant: float
    """
    The probability of taking a step from a state of energy Ea to one of energy Eb where Eb > Ea is exp((Ea - Eb) / kT), defaults to 1e-3
    """
    itersFixedTemperature: int
    """
    Number of iterations for each temperature
    """
    numIterations: int
    """
    Total number of iterations of simulated annealing, must be >= itersFixedTemperature
    """
    replacementRate: float
    """
    Proportion of samples to swap at each iteration
    """
    tag: Literal["SimulatedAnnealing"]


class SubsamplingOptions(TypedDict):
    method: Union[Method, Method1]
    numSamples: int
    """
    How many patients do we want to subsample from the initial trial?
    """
    seed: int
    """
    A seed to initialize the random number generator, ensures reproducibility of results
    """


class SummarizeOp1(TypedDict):
    """
    Summarize operation
    """

    argument: NotRequired[str]
    operation: NotRequired[Literal["Count", "Sum", "Avg", "Min", "Max", "Concat"]]
    """
    Operation
    """


type SummarizeOp = Union[
    Literal["Count", "Sum", "Avg", "Min", "Max", "Concat"], SummarizeOp1
]


class SurvivalAnalysisTimeSeries(TypedDict):
    name: str
    vals: List[float]


class SurvivalQuantile(TypedDict):
    name: Probability
    value: NotRequired[Optional[float]]
    valueLowerBound: NotRequired[Optional[float]]
    valueUpperBound: NotRequired[Optional[float]]


class TSOptsQuery(TypedDict):
    quantiles: NotRequired[List[IntegerRatio]]


class Tag1(TypedDict):
    tagCategory: Literal["All"]
    tagHeader: ElemHead


class Tag2(TypedDict):
    tagCategory: Literal["Individual"]
    tagHeader: ElemHead
    tagKey: ElemName


class Tag3(TypedDict):
    tagCategory: Literal["Group"]
    tagKey: Phenomenon


type TagModel = Union[Tag1, Tag2, Tag3]


class TagSpecifics(TypedDict):
    color: NotRequired[Optional[str]]
    protected: NotRequired[Optional[bool]]
    """
    Optional, defaults to false. If true, the tag is a protected tag
    """


class TargetRange(TypedDict):
    """
    The range of acceptable values for the target.
    """

    narrowRangeHighBound: NotRequired[Optional[float]]
    narrowRangeLowBound: NotRequired[Optional[float]]
    wideRangeHighBound: NotRequired[Optional[float]]
    wideRangeLowBound: NotRequired[Optional[float]]


class TextOverride(TypedDict):
    formula: NotRequired[Optional[str]]
    key: str


type TextOverrides = List[TextOverride]


type TimeMeasure = Union[Id, Duration]


class TimeSeriesSummary(TypedDict):
    quantiles: QuantileList


class TimeseriesMetadataItem(TypedDict):
    displayName: NotRequired[Optional[str]]
    id: Id


class TornadoSensitivityValue(TypedDict):
    medianValue: float
    mediumHighSensitivity: float
    mediumLowSensitivity: float


class TrialOverview(TypedDict):
    armCount: int
    patientCount: int


class TrialRunPerArmMetrics(TypedDict):
    allocationsMib: float
    """
    Total allocated memory for this peculiar arm of the simulation (in Mebibytes).
    """
    armId: ArmId
    cpuTimeSeconds: float
    """
    The sum of cpu solving times needed for this peculiar arm of the simulation.
    """
    missingPatients: int
    """
    The number of failed patients on this arm.
    """


class TrialVisualizationSanityInfo(TypedDict):
    items: List[str]
    reason: str


type URI = str


type UTCTime = str


type UUID = str


type UnitCheckOptions = Literal[
    "NoUnitCheck",
    "UnitCheckWithNoUnitConversion",
    "UnitCheckAndConvertAllSpeciesToExtentUnits",
    "UnitCheckAndConvertOnlyReactantsAndProductsToExtentUnits",
]


class UntabulateAggregateAction1(TypedDict):
    """
    Aggregation action for untabulate
    """

    action: Literal["fail", "failIfDifferent", "aggregate"]
    """
    Aggregation action for untabulate
    """
    operation: NotRequired[SummarizeOp]


type UntabulateAggregateAction = Union[
    Literal["fail", "failIfDifferent", "aggregate"], UntabulateAggregateAction1
]


class UntabulateMergedColumn(TypedDict):
    """
    Untabulate merge column payload
    """

    aggregation: NotRequired[UntabulateAggregateAction]
    originColumn: ColumnName
    suffix: NotRequired[Union[str, bool]]


class UpdateModelPayload(TypedDict):
    atomicDelete: NotRequired[List[ImmutableId]]
    delete: NotRequired[List[ImmutableId]]
    update: NotRequired[Union[ModelInterface, Dict[str, Any]]]


class ValidateResponse(TypedDict):
    errors: List[str]
    warnings: List[str]


type ValidationLevel = Literal["warning", "error"]


class ValidationMessageContent2(TypedDict):
    tag: Literal["ValidationNotEvaluated"]


class ValidationMessageContent3(TypedDict):
    tag: Literal["EmptyContent"]


class ValidationMessageContent4(TypedDict):
    missingColumnsNames: List[List[str]]
    tag: Literal["MissingColumns"]


class ValidationMessageContent8(TypedDict):
    givenColumnName: str
    knownColumnName: str
    tag: Literal["MisspelledColumn"]


class ValidationMessageContent9(TypedDict):
    tag: Literal["UnknownColumns"]
    unknownColumnsNames: List[str]


class ValidationToken(TypedDict):
    column: int
    friendlyError: NotRequired[Union[FriendlyError, Dict[str, Any]]]
    line: int
    message: str
    missingReferences: List[str]


type VarId = str


class VariablesMuter1(TypedDict):
    Some: List[VarId]


class VariablesMuter2(TypedDict):
    AllBut: List[VarId]


type VariablesMuter = Union[Literal["None"], VariablesMuter1, VariablesMuter2]


type Void = Any


class VpopDesignOverview(TypedDict):
    correlationCount: int
    descriptorCount: int


class VpopGenerator3(TypedDict):
    contents: str
    coreVersion: NotRequired[str]
    tag: Literal["FromVpopRaw"]


class VpopGeneratorMetadata2(TypedDict):
    """
    Technical information about the vpop generator
    """

    tag: Literal["VpopGeneratorMetadataEmpty"]


class VpopGeneratorOptions2(TypedDict):
    contents: SubsamplingOptions
    coreVersion: NotRequired[str]
    tag: Literal["VpopGeneratorOptionsForSubsampling"]


class VpopJobArmStatusSummary(TypedDict):
    countError: int
    countPending: int
    countSuccess: int


class VpopJobStatusSummary(TypedDict):
    completionTimestamp: NotRequired[Union[UTCTime, Dict[str, Any]]]
    isNew: bool
    isRunning: bool
    jobError: NotRequired[Optional[str]]
    perArmSummary: Dict[str, VpopJobArmStatusSummary]
    status: JobStatus
    timeToCompletion: NotRequired[Optional[float]]


class VpopOptions(TypedDict):
    coreVersion: NotRequired[str]
    maximumIterations: NotRequired[int]
    """
    Maximum iterations when optimizing the correlation matrix
    """
    optimizeCorrelation: NotRequired[bool]
    """
    Toggle optimization of the correlation matrix
    """
    seed: int
    """
    An arbitrary integer between 0 and 2^32-1 to initialize the random number generation
    """
    size: int
    """
    Size of the virtual population, i.e. number of patients
    """
    varianceReduction: bool
    """
    Apply the variance reduction trick (using the antithetic variates method)
    """


class VpopOverview(TypedDict):
    """
    Information computed from the vpop content
    """

    descriptorCount: NotRequired[Optional[int]]
    patientCount: NotRequired[Optional[int]]


class WorkloadMetrics(TypedDict):
    total_jobs: int


class Anchor(TypedDict):
    page: float
    """
    Page number of the work from which the extract is taken
    """
    pdfPoint: bool
    transform: List[AnchorTransform]
    """
    Defines the position and size of the rectangle that makes up the anchor
    """


class AnovaExtra(TypedDict):
    explainedVariance: float
    handleInteractions: bool
    inputDescriptors: InputDescriptorsSelector


class AnovaSensitivity(TypedDict):
    """
    See https://novak.jinko.ai/doc/simworkZSmathZSanova/Math-Anova.html#t:Sensitivity
    """

    indices: List[SensitivityIndex]
    inertia: float
    quantityOfInterest: Id


class Arm(TypedDict):
    armControl: NotRequired[Union[ArmId, Dict[str, Any]]]
    armIsActive: NotRequired[Optional[bool]]
    armName: ArmId
    armOverrides: TextOverrides
    armWeight: NotRequired[Union[PositiveDouble, Dict[str, Any]]]


class BMQualifier(TypedDict):
    nestedQualifiers: NotRequired[List[BMQualifier]]
    qualifierType: BMQualifierType
    resources: List[Resource]


class CalibrationMetadata(TypedDict):
    """
    Technical information about the calibration
    """

    contentHash: str
    status: JobStatus
    uuid: NotRequired[Union[UUID, Dict[str, Any]]]


class Metadata(TypedDict):
    internal: NotRequired[CalibrationMetadata]
    public: NotRequired[EmptyOverview]


class CatDistribLevel(TypedDict):
    catMapping: Dict[str, Probability]
    tag: NotRequired[Optional[str]]


class CategoricalBaselineDescriptor(TypedDict):
    allLevels: NotRequired[List[Level]]
    desc: NotRequired[Optional[str]]
    distrib: CatDistribLevel
    id: Id
    inputTag: ModelInputTag
    ref: NotRequired[Union[URI, Dict[str, Any]]]
    val: Level


class CategoricalDescriptorCondition(TypedDict):
    arm: NotRequired[Optional[str]]
    descriptorId: Id
    levels: List[Level]


class CategoricalDescriptorStatistics(TypedDict):
    barChart: CategoricalBarChat
    id: Id


class CategoricalParamDoc(TypedDict):
    categoricalParamAllLevels: List[str]
    categoricalParamCurrentLevel: str
    categoricalParamDesc: str
    categoricalParamDistrib: NotRequired[Optional[str]]
    categoricalParamRefs: List[URI]


class Condition5(TypedDict):
    contents: MembershipCondition
    tag: Literal["Membership"]


class Constituent1(TypedDict):
    contents: Id
    tag: Literal["Constituent"]


class Constituent2(TypedDict):
    contents: PhysicalUnit
    tag: Literal["Unit"]


type Constituent = Union[Constituent1, Constituent2]


class ConstructDependencies(TypedDict):
    dependsOn: List[ImmutableId]
    isUsedBy: List[ImmutableId]


class ContributionAnalysisPayload(TypedDict):
    baseline: NotRequired[Union[InputDescriptorsSelector, Dict[str, Any]]]
    layout: NotRequired[Union[Layout, Dict[str, Any]]]
    quantile: NotRequired[Union[Probability, Dict[str, Any]]]
    selectors: NotRequired[List[Id]]


class ContributionAnalysisPayloadPatch(TypedDict):
    baseline: NotRequired[Union[InputDescriptorsSelector, Dict[str, Any]]]
    layout: NotRequired[Union[Layout, Dict[str, Any]]]
    quantile: NotRequired[Union[Probability, Dict[str, Any]]]
    selectors: NotRequired[List[Id]]


class Correlate1(TypedDict):
    id: Id
    level: NotRequired[Union[Level, Dict[str, Any]]]


type Correlate = Union[str, Correlate1]


class CorrelateWithArm(TypedDict):
    arm: NotRequired[Union[ArmId, Dict[str, Any]]]
    id: Id
    level: NotRequired[Union[Level, Dict[str, Any]]]


class CytoscapeEdgeData(TypedDict):
    arrow: CytoscapeArrowType
    label: Label
    source: ImmutableId
    target: ImmutableId


class CytoscapeNodeData(TypedDict):
    id: ImmutableId


class DataOverlayWarningDetails4(TypedDict):
    outputs: List[Id]
    tag: Literal["VisualizationOutputsNotFound"]


type DataOverlayWarningDetails = Union[
    DataOverlayWarningDetails1,
    DataOverlayWarningDetails2,
    DataOverlayWarningDetails3,
    DataOverlayWarningDetails4,
]


class DataTableColumn(TypedDict):
    dname: str
    dtype: DataTableColumnType
    mandatory: bool


class DataTableObservable(TypedDict):
    arm: NotRequired[Optional[str]]
    id: Id


class DataTablePredicate5(TypedDict):
    contents: MembershipCondition
    tag: Literal["Membership"]


class DataTableSummary(TypedDict):
    observables: NotRequired[List[DataTableObservable]]


class DescriptorCondition(TypedDict):
    arm: NotRequired[Optional[str]]
    descriptorId: Id
    operator: Operator
    value: float


class DescriptorType1(TypedDict):
    labels: List[OverrideLabel]
    type: Literal["BaselineInput"]


class DescriptorType2(TypedDict):
    labels: List[OverrideLabel]
    type: Literal["BaselineFormulaic"]


class DescriptorType3(TypedDict):
    labels: List[OutputType]
    type: Literal["Output"]


type DescriptorType = Union[
    DescriptorType1, DescriptorType2, DescriptorType3, DescriptorType4
]


class Diagnostic2(TypedDict):
    contents: List[SanityReason]
    tag: Literal["Warning"]


class Diagnostic3(TypedDict):
    contents: SanityReason
    tag: Literal["Error"]


type Diagnostic = Union[Diagnostic1, Diagnostic2, Diagnostic3]


type Dimensionality = Optional[Dict[str, Power]]


class Distrib2(TypedDict):
    base: PositiveDouble
    highBound: float
    lowBound: float
    tag: Literal["LogUniform"]


class Distrib3(TypedDict):
    mean: float
    stdev: PositiveDouble
    tag: Literal["Normal"]


class Distrib4(TypedDict):
    highBound: float
    lowBound: float
    mean: float
    stdev: PositiveDouble
    tag: Literal["NormalTruncated"]


class Distrib5(TypedDict):
    base: PositiveDouble
    mean: float
    stdev: PositiveDouble
    tag: Literal["LogNormal"]


class Distrib6(TypedDict):
    base: PositiveDouble
    mean: float
    posHighBound: PositiveDouble
    posLowBound: PositiveDouble
    stdev: PositiveDouble
    tag: Literal["LogNormalTruncated"]


class Distrib7(TypedDict):
    biNum: int
    biProb: Probability
    tag: Literal["Binomial"]


class Distrib8(TypedDict):
    bernProb: Probability
    tag: Literal["Bernoulli"]


class Distrib9(TypedDict):
    catMapping: Dict[str, Probability]
    tag: Literal["Categorical"]


class Distrib10(TypedDict):
    poiLambda: PositiveDouble
    tag: Literal["Poisson"]


class Distrib13(TypedDict):
    location: float
    scale: PositiveDouble
    shape: float
    tag: Literal["SkewNormal"]


Distrib14 = TypedDict(
    "Distrib14",
    {
        "k": PositiveDouble,
        "lambda": PositiveDouble,
        "tag": Literal["Weibull"],
    },
)


class EstimatedCorrelation(TypedDict):
    correlateX: CorrelateWithArm
    correlateY: CorrelateWithArm
    correlationCoefficient: float


class Filter1(TypedDict):
    contents: List[DescriptorCondition]
    tag: Literal["DescriptorFilter"]


class Filter2(TypedDict):
    contents: List[CategoricalDescriptorCondition]
    tag: Literal["CategoricalDescriptorFilter"]


type Filter = Union[Filter1, Filter2, Filter3]


class Formula2(TypedDict):
    contents: Constituent
    tag: Literal["Var"]


class FormulaEvaluation(TypedDict):
    booleanValue: NotRequired[Optional[bool]]
    numericValue: NotRequired[Optional[float]]
    unit: NotRequired[Union[PhysicalUnit, Dict[str, Any]]]
    validationTokens: List[ValidationToken]


class GenericMetadata(TypedDict):
    """
    Technical information about the content
    """

    contentHash: str
    projectId: NotRequired[Optional[ProjectId]]


class GenericVisPayload(TypedDict):
    layout: NotRequired[Union[Layout, Dict[str, Any]]]
    selectors: NotRequired[List[Id]]


class GenericVisPayloadPatch(TypedDict):
    layout: NotRequired[Union[Layout, Dict[str, Any]]]
    selectors: NotRequired[List[Id]]


class GlobalSensitivity(TypedDict):
    """
    See https://novak.jinko.ai/doc/simworkZSvpopZSanalysis/Sensitivity-Global.html#t:Sensitivity
    """

    inputDescriptor: Id
    quantityOfInterest: Id
    sensitivity: float


class Contents(TypedDict):
    arm: str
    descriptorId: Id
    mode: Literal["Distinct"]
    parameters: float


class Contents1(TypedDict):
    arm: str
    descriptorId: Id
    mode: Literal["Span"]
    parameters: Parameters


class Contents2(TypedDict):
    arm: str
    descriptorId: Id
    mode: Literal["Quantiles"]
    parameters: Parameters


class Group3(TypedDict):
    """
    One group per 'scalarId' per value group (here 'Span')
    """

    contents: Union[Contents, Contents1, Contents2]
    tag: Literal["Scalar"]


class Contents3(TypedDict):
    arm: str
    descriptorId: Id
    level: Level


class Group4(TypedDict):
    """
    One group per 'scalarId' per value group (here 'Span')
    """

    contents: Contents3
    tag: Literal["Categorical"]


type Group = Union[Group1, Group2, Group3, Group4]


class Contents4(TypedDict):
    arm: str
    descriptorId: Id
    mode: Literal["Distinct"]


class Parameters2(TypedDict):
    offset: float
    width: PositiveDouble


class Contents5(TypedDict):
    arm: str
    descriptorId: Id
    mode: Literal["Span"]
    parameters: Parameters2


class Contents6(TypedDict):
    arm: str
    descriptorId: Id
    mode: Literal["Buckets"]
    parameters: int


class Contents7(TypedDict):
    arm: str
    descriptorId: Id
    mode: Literal["Quantiles"]
    parameters: PositiveInt


class Contents8(TypedDict):
    arm: str
    breaks: List[float]
    descriptorId: Id
    mode: Literal["Explicit"]


class GroupBy3(TypedDict):
    contents: Union[Contents4, Contents5, Contents6, Contents7, Contents8]
    tag: Literal["Scalar"]


class Contents9(TypedDict):
    arm: str
    descriptorId: Id


class GroupBy4(TypedDict):
    contents: Contents9
    tag: Literal["Categorical"]


type GroupBy = Union[GroupBy1, GroupBy2, GroupBy3, GroupBy4]


class Highlight(TypedDict):
    id: str
    """
    Identifier of the highlight
    """
    type: Literal["Textual", "Rectangular", "Latex", "DataTable"]
    """
    Type of the highlight
    """
    text: NotRequired[str]
    """
    Text of the highlight (only displayed if highlight type is a Textual type)
    """
    file: NotRequired[FileUrl]
    """
    Image represented the highlight (only displayed if highlight type is not a Textual type)
    """
    latex: NotRequired[str]
    """
    Latex of the highlight (only displayed if highlight type is a Latex type)
    """
    dataTable: NotRequired[ProjectItemUrl]
    """
    Related data table of the highlight (only displayed if highlight type is a DataTable type)
    """
    anchors: List[Anchor]
    """
    Positions of the highlight on the reference work
    """
    color: Literal["Green", "Cyan", "Purple", "Pink", "Orange", "Red", "Grey"]
    """
    Color of the highlight
    """
    createdAt: str
    updatedAt: str


class Histogram(TypedDict):
    """
    See https://novak.jinko.ai/doc/doc-simworkZSmathZSnovarandom/Math-Random-Histogram.html#t:Histogram
    """

    histogram: List[HistogramBin]


class InRange(TypedDict):
    range: TargetRange
    target: NotRequired[Optional[str]]


class InputReport(TypedDict):
    errors: List[SanityItem]
    warnings: List[SanityItem]


class JobStatusForResponse(TypedDict):
    jobCompletionTimestamp: NotRequired[Union[UTCTime, Dict[str, Any]]]
    jobStillRunning: bool


class KSSensitivityGroup(TypedDict):
    count: int
    group: List[Group]
    sensitivities: List[GlobalSensitivity]


class KSSensitivitySummary(TypedDict):
    outputs: List[KSSensitivityGroup]


class KSTornadoExtra(TypedDict):
    inputDescriptors: InputDescriptorsSelector
    quantile: Probability


class LawEstimationOptions(TypedDict):
    precision: Precision


class LogRankTest(TypedDict):
    chiSquare: float
    correctedPValue: float
    group1: List[Group]
    group2: List[Group]
    groupSize1: int
    groupSize2: int
    maxComboChiSquare: float
    maxComboCorrectedPValue: float
    pValue: float
    timeToEventScalarId: Id


class Mapping8(TypedDict):
    """
    Untabulate a table: creates new columns with names (headers) from _pivot_ and values from _mergedColumns_, grouped by _groupedByColumns_
    """

    groupedByColumns: List[ColumnName]
    mergedColumns: List[UntabulateMergedColumn]
    operation: Literal["untabulate"]
    """
    Operation
    """
    pivot: ColumnName


class Mapping9(TypedDict):
    """
    Apply (unary) _function_ on _originColumn_ and store result in new column _destinationColumn_
    """

    destinationColumn: ColumnName
    function: MonoOp
    operation: Literal["monoExtend"]
    """
    Operation
    """
    originColumn: ColumnName


class MarginalCategorical(TypedDict):
    distribution: CatDistribLevel
    id: Id
    reference: NotRequired[Union[URI, Dict[str, Any]]]


class Metadata2(TypedDict):
    internal: NotRequired[GenericMetadata]
    public: NotRequired[MeasureDesignOverview]


class ModelConstructJsonConstraintSpecifics(TypedDict):
    description: NotRequired[Optional[str]]
    diagnostics: NotRequired[List[SanityCheck]]
    displayName: NotRequired[Optional[str]]
    id: Id
    immutableId: NotRequired[Union[ImmutableId, Dict[str, Any]]]
    isActive: NotRequired[Optional[bool]]
    links: NotRequired[List[str]]
    specifics: ConstraintSpecifics
    tags: NotRequired[List[ImmutableId]]


class ModelConstructJsonMeasureSpecifics(TypedDict):
    description: NotRequired[Optional[str]]
    diagnostics: NotRequired[List[SanityCheck]]
    displayName: NotRequired[Optional[str]]
    id: Id
    immutableId: NotRequired[Union[ImmutableId, Dict[str, Any]]]
    isActive: NotRequired[Optional[bool]]
    links: NotRequired[List[str]]
    specifics: MeasureSpecifics
    tags: NotRequired[List[ImmutableId]]


class ModelConstructJsonTagSpecifics(TypedDict):
    description: NotRequired[Optional[str]]
    diagnostics: NotRequired[List[SanityCheck]]
    displayName: NotRequired[Optional[str]]
    id: Id
    immutableId: NotRequired[Union[ImmutableId, Dict[str, Any]]]
    isActive: NotRequired[Optional[bool]]
    links: NotRequired[List[str]]
    specifics: TagSpecifics
    tags: NotRequired[List[ImmutableId]]


class ModelErrorType(TypedDict):
    errors: List[SbmlCheck]
    warnings: List[SbmlCheck]


class Metadata3(TypedDict):
    internal: NotRequired[GenericMetadata]
    public: NotRequired[ModelWithOptsOverview]


class ObjectiveSpecifics(TypedDict):
    filter: NotRequired[Optional[str]]
    formula: InRange
    weight: PositiveDouble


type ObjectivesWeights = Optional[Dict[str, PositiveDouble]]


class OneCategorical(TypedDict):
    error: NotRequired[Optional[str]]
    id: Id
    type: DescriptorType
    value: NotRequired[Union[Level, Dict[str, Any]]]


class OneCategoricalForAPopulation(TypedDict):
    type_: DescriptorType
    unit: NotRequired[Union[PhysicalUnit, Dict[str, Any]]]
    values: List[Level]


class OneCategoricalGroup(TypedDict):
    barChart: CategoricalBarChat
    categoricalId: Id
    count: int
    group: List[Group]


class OneCategoricalParamDoc(TypedDict):
    content: CategoricalParamDoc
    id: Id


class OneRes1(TypedDict):
    id: Id
    size: int
    unit: PhysicalUnit
    vals: float


class OneRes2(TypedDict):
    id: Id
    size: int
    unit: PhysicalUnit
    vals: List[float]


type OneRes = Union[OneRes1, OneRes2]


class OneScalGroup(TypedDict):
    barChart: NotRequired[Union[NumericBarChart, Dict[str, Any]]]
    count: int
    group: List[Group]
    histogram: NotRequired[Union[Histogram, Dict[str, Any]]]
    maximumQuantity: NotRequired[Optional[float]]
    minimumQuantity: NotRequired[Optional[float]]
    scalarId: Id
    unit: NotRequired[Union[PhysicalUnit, Dict[str, Any]]]


class OneScalar(TypedDict):
    error: NotRequired[Optional[str]]
    id: Id
    type: DescriptorType
    unit: NotRequired[Union[PhysicalUnit, Dict[str, Any]]]
    value: NotRequired[Optional[float]]


class OneScalarForAPopulation(TypedDict):
    type_: DescriptorType
    unit: NotRequired[Union[PhysicalUnit, Dict[str, Any]]]
    values: List[float]


class OutputSummary(TypedDict):
    count: int
    group: List[Group]
    outputId: Id
    summary: TimeSeriesSummary
    timeUnit: PhysicalUnit
    timeVals: List[float]
    unit: PhysicalUnit


class PIMetadataCalibration(TypedDict):
    internal: NotRequired[CalibrationMetadata]
    public: NotRequired[EmptyOverview]


class PIMetadataDataTable(TypedDict):
    internal: NotRequired[GenericMetadata]
    public: NotRequired[DataTableOverview]


class PIMetadataMeasureDesign(TypedDict):
    internal: NotRequired[GenericMetadata]
    public: NotRequired[MeasureDesignOverview]


class PIMetadataModelWithOpts(TypedDict):
    internal: NotRequired[GenericMetadata]
    public: NotRequired[ModelWithOptsOverview]


class PIMetadataProtocolDesign(TypedDict):
    internal: NotRequired[GenericMetadata]
    public: NotRequired[ProtocolDesignOverview]


class PIMetadataScoringDesign(TypedDict):
    internal: NotRequired[GenericMetadata]
    public: NotRequired[EmptyOverview]


class PIMetadataSolvingOptions(TypedDict):
    internal: NotRequired[GenericMetadata]
    public: NotRequired[EmptyOverview]


class PIMetadataTrialVisualization(TypedDict):
    internal: NotRequired[GenericMetadata]
    public: NotRequired[EmptyOverview]


class PIMetadataVpop(TypedDict):
    internal: NotRequired[GenericMetadata]
    public: NotRequired[VpopOverview]


class PatientAttribute(TypedDict):
    id: Id
    unit: NotRequired[Union[PhysicalUnit, Dict[str, Any]]]
    val: float


class PatientWithId(TypedDict):
    parent: NotRequired[Optional[str]]
    patientAttributes: List[PatientAttribute]
    patientCategoricalAttributes: NotRequired[List[PatientCategoricalAttribute]]
    patientIndex: str


class PhasePortraitPayload(TypedDict):
    freezeModel: bool
    lhsVar: PhasePortraitVariable
    numberOfPoints: int
    rhsInputDescriptors: List[PhasePortraitParameter]
    rhsVar: PhasePortraitVariable


class PhysicalUnitWithMetadata1(TypedDict):
    dimensionality: NotRequired[Union[Dimensionality, Dict[str, Any]]]
    name: str


type PhysicalUnitWithMetadata = Union[PhysicalUnitWithMetadata1, str]


class ProjectItem(TypedDict):
    sid: str
    """
    Short identifier of the project item
    """
    coreId: Optional[ProjectItemCoreId]
    """
    Project item identifier for modeling and simulation
    """
    type: Literal[
        "Assertion",
        "Calibration",
        "ComputationalModel",
        "DataTable",
        "Document",
        "MeasureDesign",
        "ProtocolDesign",
        "ScoringDesign",
        "Source",
        "SubsamplingDesign",
        "Trial",
        "TrialVisualization",
        "Vpop",
        "VpopDesign",
    ]
    """
    Type of the project item
    """
    name: str
    description: Optional[str]
    createdAt: str
    updatedAt: str
    deletedAt: Optional[str]
    lock: ProjectItemLock
    version: Optional[ProjectItemVersion]
    folders: List[Folder]
    """
    List of folders that the project item belongs to
    """
    createdBy: ProjectItemCreator


class ProjectItemId(TypedDict):
    coreItemId: CoreItemId
    snapshotId: NotRequired[Union[SnapshotId, Dict[str, Any]]]


class ProjectItemMapping(TypedDict):
    pimContentId: str
    pimCoreItemId: UUID
    pimCreated: UTCTime
    pimKeep: bool
    pimProjectId: NotRequired[Union[UUID, Dict[str, Any]]]
    pimSnapshotId: UUID
    pimType: str


class ProjectItemResponseCalibration(TypedDict):
    coreItemId: CoreItemId
    metadata: PIMetadataCalibration
    snapshotId: SnapshotId
    warnings: List[str]


class ProjectItemResponseDataTable(TypedDict):
    coreItemId: CoreItemId
    metadata: PIMetadataDataTable
    snapshotId: SnapshotId
    warnings: List[str]


class ProjectItemResponseMeasureDesign(TypedDict):
    coreItemId: CoreItemId
    metadata: PIMetadataMeasureDesign
    snapshotId: SnapshotId
    warnings: List[str]


class ProjectItemResponseModelWithOpts(TypedDict):
    coreItemId: CoreItemId
    metadata: PIMetadataModelWithOpts
    snapshotId: SnapshotId
    warnings: List[str]


class ProjectItemResponseProtocolDesign(TypedDict):
    coreItemId: CoreItemId
    metadata: PIMetadataProtocolDesign
    snapshotId: SnapshotId
    warnings: List[str]


class ProjectItemResponseScoringDesign(TypedDict):
    coreItemId: CoreItemId
    metadata: PIMetadataScoringDesign
    snapshotId: SnapshotId
    warnings: List[str]


class ProjectItemResponseSolvingOptions(TypedDict):
    coreItemId: CoreItemId
    metadata: PIMetadataSolvingOptions
    snapshotId: SnapshotId
    warnings: List[str]


class ProjectItemResponseTrialVisualization(TypedDict):
    coreItemId: CoreItemId
    metadata: PIMetadataTrialVisualization
    snapshotId: SnapshotId
    warnings: List[str]


class ProjectItemResponseVpop(TypedDict):
    coreItemId: CoreItemId
    metadata: PIMetadataVpop
    snapshotId: SnapshotId
    warnings: List[str]


class ProjectItemStored(TypedDict):
    coreItemId: CoreItemId
    snapshotId: SnapshotId


class ProtocolDesign(TypedDict):
    computationalModelId: NotRequired[Union[ProjectItemStored, Dict[str, Any]]]
    coreVersion: NotRequired[str]
    scenarioArms: List[Arm]


class Metadata4(TypedDict):
    internal: NotRequired[GenericMetadata]
    public: NotRequired[ProtocolDesignOverview]


class ProtocolDesignWithMetadata(TypedDict):
    computationalModelId: NotRequired[Union[ProjectItemStored, Dict[str, Any]]]
    coreVersion: NotRequired[str]
    metadata: NotRequired[Metadata4]
    scenarioArms: List[Arm]


class RMDiagnostic(TypedDict):
    model_result: Diagnostic
    scalar_result: Diagnostic
    scatter_plot: Diagnostic
    survival_analysis: Diagnostic
    tornado_sensitivity: Diagnostic


class RegressionOptions(TypedDict):
    lineEquationLegend: Legend
    regressionType: NotRequired[Union[RegressionType, Dict[str, Any]]]
    showLineEquation: bool


class RelativeTags(TypedDict):
    compTags: List[TagModel]
    paramTags: List[TagModel]
    varTags: List[TagModel]


class SanityDetail(TypedDict):
    coreItemId: NotRequired[Union[CoreItemId, Dict[str, Any]]]
    sanity: InputReport


type SanityMap = List[SanityDetail]


class SanityOutput(TypedDict):
    dataTables: SanityMap
    model: SanityMap
    outputSet: SanityMap
    protocol: SanityMap
    scorings: SanityMap
    solvingTimes: SanityMap
    vpop: SanityMap


class ScalResSummary(TypedDict):
    outputs: List[OneScalGroup]
    outputsCategorical: List[OneCategoricalGroup]


class ScalarData(TypedDict):
    arms: List[str]
    description: NotRequired[Optional[str]]
    displayName: NotRequired[Optional[str]]
    id: Id
    type: DescriptorType
    unit: NotRequired[Union[PhysicalUnit, Dict[str, Any]]]


class ScalarDataCrossArm(TypedDict):
    description: NotRequired[Optional[str]]
    displayName: NotRequired[Optional[str]]
    id: Id
    type: DescriptorType
    unit: NotRequired[Union[PhysicalUnit, Dict[str, Any]]]


class ScalarResultPopulation(TypedDict):
    categoricals: List[
        List[Union[List[Group], Dict[str, Dict[str, OneCategoricalForAPopulation]]]]
    ]
    scalars: List[
        List[Union[List[Group], Dict[str, Dict[str, OneScalarForAPopulation]]]]
    ]


class ScalarSummaryQueryProjectItem(TypedDict):
    select: List[Id]
    trialId: ProjectItemStored


class ScalarSummaryQueryUUID(TypedDict):
    select: List[Id]
    trialId: UUID


class ScatterPlotConfig1(TypedDict):
    arms: ScatterPlotXvsXArms
    groupedByArm: NotRequired[bool]
    id: str
    mode: Literal["XvsX"]
    variable: Id


class ScatterPlotConfig2(TypedDict):
    arms: List[str]
    groupedByArm: NotRequired[bool]
    id: str
    mode: Literal["XvsY"]
    variables: ScatterPlotXvsYVariables


type ScatterPlotConfig = Union[ScatterPlotConfig1, ScatterPlotConfig2]


class ScatterPlotPayload(TypedDict):
    layout: NotRequired[Union[Layout, Dict[str, Any]]]
    regression: NotRequired[Union[RegressionOptions, Dict[str, Any]]]
    scatterPlotConfig: NotRequired[List[ScatterPlotConfig]]


class ScatterPlotPayloadPatch(TypedDict):
    layout: NotRequired[Union[Layout, Dict[str, Any]]]
    regression: NotRequired[Union[RegressionOptions, Dict[str, Any]]]
    scatterPlotConfig: NotRequired[List[ScatterPlotConfig]]


class Metadata5(TypedDict):
    internal: NotRequired[GenericMetadata]
    public: NotRequired[EmptyOverview]


class Select1(TypedDict):
    contents: List[SelectByOutput]
    tag: Literal["ByOutput"]


class Select2(TypedDict):
    contents: List[SelectByArm]
    tag: Literal["ByArm"]


type Select = Union[Select1, Select2]


class SelectAllTabs(TypedDict):
    selectedImpactAnalysisScalars: NotRequired[Union[Select, Dict[str, Any]]]
    selectedScalars: NotRequired[Union[Select, Dict[str, Any]]]
    selectedScatterPlots: NotRequired[Union[Select, Dict[str, Any]]]
    selectedSurvivalAnalysisScalars: NotRequired[Union[Select, Dict[str, Any]]]
    selectedTimeSeries: NotRequired[Union[Select, Dict[str, Any]]]


class SolTimes(TypedDict):
    parentUuid: NotRequired[Union[UUID, Dict[str, Any]]]
    tMax: Duration
    tMin: Duration
    tStep: Duration
    uuid: NotRequired[Union[UUID, Dict[str, Any]]]


class SolvingOptionsJson(TypedDict):
    allowVaryingStoichiometry: NotRequired[bool]
    convertSpeciesToExtentUnits: NotRequired[ConvertSpeciesToExtentUnits]
    discontinuityEvents: NotRequired[DiscontinuityCheckLevel]
    evaluator: NotRequired[EvaluationMethod]
    extentUnits: NotRequired[PhysicalUnit]
    ignoreUnits: NotRequired[bool]
    initialOdeSolverStep: NotRequired[float]
    inlineLimit: NotRequired[int]
    maxEvents: NotRequired[int]
    minimumOdeSolverStep: NotRequired[float]
    mutePhenomena: NotRequired[PhenomenaMuter]
    muteVariables: NotRequired[VariablesMuter]
    odeSolverAbsoluteTolerance: NotRequired[float]
    odeSolverInitialStep: NotRequired[float]
    odeSolverMinimumStep: NotRequired[float]
    odeSolverRelativeTolerance: NotRequired[float]
    outputCompartments: NotRequired[IdSelection]
    outputParameters: NotRequired[IdSelection]
    outputRates: NotRequired[IdSelection]
    outputVariables: NotRequired[IdSelection]
    scoringMode: NotRequired[EvaluationMode]
    solver: NotRequired[OdeMethod]
    solvingTimes: NotRequired[List[SolTimes]]
    unitCheck: NotRequired[UnitCheckOptions]


class SolvingOptionsWithMetadata(TypedDict):
    allowVaryingStoichiometry: bool
    """
    Set to true if you need to allow for stoichiometric coefficients varying in time (not recommended but might be needed for SBML models allowing this feature)
    """
    coreVersion: NotRequired[str]
    discontinuityEvents: Literal["AddAuxiliaryEvents", "WarnOnly", "DontCheck"]
    """
    Adds auxiliary root-based events to help the ODE solver detect time-discontinuities in the right hand side (RHS). This is useful for time-adaptive solvers such as BDF to avoid missing short time-span variations in the system's RHS such as short term injections encoded via a time varying parameter
    """
    evaluator: Literal["LLVM", "Haskell"]
    """
    Whether you use the LLVM optimized or the Native Haskell solver
    """
    extentUnits: str
    """
    The unit the species are converted to. See our <a target="_blank" href=https://community.jinko.ai/t/h7h46z3>unit syntax guide</a>
    """
    inlineLimit: int
    """
    A number to control the maximum size (number of nodes) of expression trees that will be inlined before solving: 0 means there is no inlining, 1 means that we inline constants, etc...
    """
    maxEvents: int
    """
    Maximum number of root-based event occurrences
    """
    metadata: NotRequired[Metadata5]
    mutePhenomena: NotRequired[Union[Literal["None"], MutePhenomena2, MutePhenomena3]]
    """
    Phenomena to be muted
    """
    muteVariables: NotRequired[Union[Literal["None"], MuteVariables2, MuteVariables3]]
    """
    Variables to be muted
    """
    odeSolverAbsoluteTolerance: float
    """
    The solver absolute error tolerance
    """
    odeSolverInitialStep: float
    """
    The initial step of the solver
    """
    odeSolverRelativeTolerance: float
    """
    The solver relative error tolerance
    """
    outputCompartments: NotRequired[
        Union[Literal["All"], OutputCompartments2, OutputCompartments3]
    ]
    """
    Compartments to output in the results files
    """
    outputParameters: NotRequired[
        Union[Literal["All"], OutputParameters2, OutputParameters3]
    ]
    """
    Parameters to output in the results files
    """
    outputRates: NotRequired[Union[Literal["All"], OutputRates2, OutputRates3]]
    """
    Rates to output in the results files
    """
    outputVariables: NotRequired[
        Union[Literal["All"], OutputVariables2, OutputVariables3]
    ]
    """
    Variables to output in the results files
    """
    scoringMode: NotRequired[Literal["ScoringV2"]]
    """
    Use ScoringV2, other modes are now deprecated
    """
    solver: Literal[
        "ADAMS",
        "BDF",
        "SDIRK_2_1_2",
        "BILLINGTON_3_3_2",
        "TRBDF2_3_3_2",
        "KVAERNO_4_2_3",
        "ARK324L2SA_DIRK_4_2_3",
        "CASH_5_2_4",
        "CASH_5_3_4",
        "SDIRK_5_3_4",
        "KVAERNO_5_3_4",
        "ARK436L2SA_DIRK_6_3_4",
        "KVAERNO_7_4_5",
        "ARK548L2SA_DIRK_8_4_5",
        "HEUN_EULER_2_1_2",
        "BOGACKI_SHAMPINE_4_2_3",
        "ARK324L2SA_ERK_4_2_3",
        "ZONNEVELD_5_3_4",
        "ARK436L2SA_ERK_6_3_4",
        "SAYFY_ABURUB_6_3_4",
        "CASH_KARP_6_4_5",
        "FEHLBERG_6_4_5",
        "DORMAND_PRINCE_7_4_5",
        "ARK548L2SA_ERK_8_4_5",
        "VERNER_8_5_6",
        "FEHLBERG_13_7_8",
    ]
    """
    The numerical solving method used
    """
    solvingTimes: List[Union[timedelta, SolvingTimes]]
    """
    Each entry in this array will be either an explicit time or a regularly spaced time span. Those will determine the time points returned in the results. They are different from the time points used internally for solving
    """
    unitCheck: Literal[
        "NoUnitCheck",
        "UnitCheckWithNoUnitConversion",
        "UnitCheckAndConvertAllSpeciesToExtentUnits",
        "UnitCheckAndConvertOnlyReactantsAndProductsToExtentUnits",
    ]
    """
    How to perform unit checking on the model. See our <a target="_blank" href=https://community.jinko.ai/t/h7h46z3>unit syntax guide</a>
    """


class SortPatientsPayload(TypedDict):
    calibId: ProjectItemStored
    sortBy: Id


class StaticUnitInfo(TypedDict):
    dimensions: List[str]
    prefixes: Dict[str, float]
    units: Dict[str, Dimensionality]


class SummarizeColumns(TypedDict):
    destinationColumn: ColumnName
    operation: SummarizeOp
    originColumn: ColumnName


class SummaryOpts(TypedDict):
    groupBy: NotRequired[List[GroupBy]]
    tsOpts: NotRequired[Union[TSOptsQuery, Dict[str, Any]]]


class SurvivalAnalysis(TypedDict):
    censoredTimeVals: List[float]
    censoredValues: List[float]
    group: List[Group]
    survivalRateQuantiles: List[SurvivalQuantile]
    timeToEventScalarId: Id
    timeUnit: NotRequired[Union[PhysicalUnit, Dict[str, Any]]]
    timeVals: List[float]
    yAxisVectors: List[SurvivalAnalysisTimeSeries]


class SurvivalAnalysisObservationWindow1(TypedDict):
    FromStartUntilTime: TimeMeasure


type SurvivalAnalysisObservationWindow = Union[
    Literal["FromStartUntilEnd"], SurvivalAnalysisObservationWindow1
]


class SurvivalAnalysisPayload(TypedDict):
    layout: NotRequired[Union[Layout, Dict[str, Any]]]
    observationWindow: NotRequired[
        Union[SurvivalAnalysisObservationWindow, Dict[str, Any]]
    ]
    selectors: NotRequired[List[Id]]


class SurvivalAnalysisPayloadPatch(TypedDict):
    layout: NotRequired[Union[Layout, Dict[str, Any]]]
    observationWindow: NotRequired[
        Union[SurvivalAnalysisObservationWindow, Dict[str, Any]]
    ]
    selectors: NotRequired[List[Id]]


class SurvivalAnalysisResponse(TypedDict):
    logRankTests: List[LogRankTest]
    outputs: List[SurvivalAnalysis]


class SurvivalExtra(TypedDict):
    observationWindow: SurvivalAnalysisObservationWindow
    survivalRateQuantiles: List[Probability]


class TargetCorrelation(TypedDict):
    correlateX: CorrelateWithArm
    correlateY: CorrelateWithArm
    correlationCoefficient: float
    reference: NotRequired[Union[URI, Dict[str, Any]]]
    weight: PositiveDouble


class TargetMarginalCategorical(TypedDict):
    arm: NotRequired[Union[ArmId, Dict[str, Any]]]
    distribution: CatDistribLevel
    id: Id
    reference: NotRequired[Union[URI, Dict[str, Any]]]
    weight: PositiveDouble


class TargetSummaryStatistic(TypedDict):
    arm: NotRequired[Union[ArmId, Dict[str, Any]]]
    id: Id
    mean: float
    reference: NotRequired[Union[URI, Dict[str, Any]]]
    standardDeviation: NotRequired[Optional[float]]
    weight: PositiveDouble


class TargetSurvival(TypedDict):
    arm: NotRequired[Union[ArmId, Dict[str, Any]]]
    cumulativeSurvivalRates: List[float]
    reference: NotRequired[Union[URI, Dict[str, Any]]]
    timeToEventScalarId: Id
    timeUnit: NotRequired[Union[PhysicalUnit, Dict[str, Any]]]
    timeVals: List[float]
    weight: PositiveDouble


class TimeSeriesSummaryQueryProjectItem(TypedDict):
    select: List[Id]
    trialId: ProjectItemStored


type TimeseriesMetadata = List[TimeseriesMetadataItem]


class TornadoSensitivity(TypedDict):
    """
    See https://novak.jinko.ai/doc/simworkZSvpopZSanalysis/Sensitivity-Tornado.html#t:Sensitivity
    """

    inputDescriptor: Id
    quantityOfInterest: Id
    sensitivity: TornadoSensitivityValue


class TornadoSensitivityGroup(TypedDict):
    count: int
    group: List[Group]
    sensitivities: List[TornadoSensitivity]


class TornadoSensitivitySummary(TypedDict):
    outputs: List[TornadoSensitivityGroup]


class TrialMetadata(TypedDict):
    """
    Technical information about the trial
    """

    contentHash: str
    solveScoreVpopUuid: NotRequired[Union[UUID, Dict[str, Any]]]
    status: JobStatus


class TrialRunMetrics(TypedDict):
    arms: List[TrialRunPerArmMetrics]
    clockTimeSeconds: float
    """
    Elapsed time (in seconds) between the creation and the completion of the trial. It does not account for pause/resume events.
    """
    endTime: str
    """
    Date when the trial was completed.
    """
    sizeProxy: NotRequired[Optional[int]]
    """
    An opaque number used as an approximate proxy for the size/cost of the trial.
    """
    startTime: str
    """
    Date when the trial was first started.
    """
    totalAllocationMiB: float
    """
    Total allocated memory for the whole simulation (in Mebibytes).
    """
    totalCpuTimeSeconds: float
    """
    This sums up the cpu solving times across all nodes needed to produce the simulation.By comparing it with 'clockTimeSeconds', you can have an idea how much jinko accelerated your simulation.
    """
    totalPatientCount: int
    """
    The number of patients computed across all arms, including unsolved patients.
    """


class TrialVisualizationSanityField(TypedDict):
    errors: List[TrialVisualizationSanityInfo]
    warnings: List[TrialVisualizationSanityInfo]


class Metadata8(TypedDict):
    internal: NotRequired[TrialMetadata]
    public: NotRequired[TrialOverview]


class UpdateModelResponse(TypedDict):
    deleted: List[ImmutableId]
    response: ProjectItemResponseModelWithOpts
    updated: ModelInterface


class ValidateExpressionResponse(TypedDict):
    latex: NotRequired[Optional[str]]
    validation: List[ValidationToken]


class ValidationMessageContent1(TypedDict):
    missingValuesColumns: List[List[DataTableColumn]]
    tag: Literal["MissingValues"]


class ValidationMessageContent5(TypedDict):
    column: DataTableColumn
    tag: Literal["IncorrectValue"]
    value: DataTableValue


class ValidationMessageContent6(TypedDict):
    column: DataTableColumn
    tag: Literal["IncorrectType"]
    value: DataTableValue


class ValidationMessageContent7(TypedDict):
    actualHigherValue: DataTableValue
    actualLowerValue: DataTableValue
    expectedHigherColumn: DataTableColumn
    expectedLowerColumn: DataTableColumn
    range: NotRequired[Optional[str]]
    strict: bool
    tag: Literal["Misordered"]


type ValidationMessageContent = Union[
    ValidationMessageContent1,
    ValidationMessageContent2,
    ValidationMessageContent3,
    ValidationMessageContent4,
    ValidationMessageContent5,
    ValidationMessageContent6,
    ValidationMessageContent7,
    ValidationMessageContent8,
    ValidationMessageContent9,
]


class Vpop(TypedDict):
    coreVersion: NotRequired[str]
    patients: List[PatientWithId]


class VpopGenerator2(TypedDict):
    contents: ProjectItemStored
    coreVersion: NotRequired[str]
    tag: Literal["FromModelToVpopDesign"]


class VpopGeneratorMetadata1(TypedDict):
    """
    Technical information about the vpop generator
    """

    tag: Literal["VpopGeneratorMetadataForRawModel"]
    vpopMetadata: GenericMetadata
    vpopProjectItemId: ProjectItemStored


type VpopGeneratorMetadata = Union[VpopGeneratorMetadata1, VpopGeneratorMetadata2]


class VpopGeneratorOptions1(TypedDict):
    contents: VpopOptions
    coreVersion: NotRequired[str]
    tag: Literal["VpopGeneratorOptionsForVpopDesign"]


type VpopGeneratorOptions = Union[VpopGeneratorOptions1, VpopGeneratorOptions2]


type VpopGeneratorOverview = Union[
    VpopDesignOverview, SubsamplingGeneratorOverview, VpopOverview
]


class Metadata9(TypedDict):
    internal: NotRequired[VpopGeneratorMetadata]
    public: NotRequired[VpopGeneratorOverview]


class VpopGeneratorWithMetadata2(TypedDict):
    contents: ProjectItemStored
    coreVersion: NotRequired[str]
    metadata: NotRequired[Metadata9]
    tag: Literal["FromModelToVpopDesign"]


class VpopGeneratorWithMetadata3(TypedDict):
    contents: str
    coreVersion: NotRequired[str]
    metadata: NotRequired[Metadata9]
    tag: Literal["FromVpopRaw"]


class VpopLink(TypedDict):
    vpopGeneratorId: ProjectItemId
    vpopGeneratorType: Literal[
        "raw_vpop", "vpop_design", "vpop_design_from_model", "subsampling_design"
    ]
    vpopId: ProjectItemId
    vpopOptions: VpopGeneratorOptions


class VpopListingEntry(TypedDict):
    vpopId: ProjectItemResponseVpop
    vpopOptions: VpopGeneratorOptions


class VpopSummary(TypedDict):
    outputs: List[OutputSummary]


class Metadata13(TypedDict):
    internal: NotRequired[GenericMetadata]
    public: NotRequired[VpopOverview]


class VpopWithMetadata(TypedDict):
    coreVersion: NotRequired[str]
    metadata: NotRequired[Metadata13]
    patients: List[PatientWithId]


class AggregateMRQueryProjectItem(TypedDict):
    equateBaselines: bool
    extra: NotRequired[Union[Void, Dict[str, Any]]]
    filter: List[Filter]
    group: NotRequired[Union[SummaryOpts, Dict[str, Any]]]
    select: NotRequired[Union[Select, Dict[str, Any]]]
    trialId: ProjectItemStored


class AggregateMRQueryUUID(TypedDict):
    equateBaselines: bool
    extra: NotRequired[Union[Void, Dict[str, Any]]]
    filter: List[Filter]
    group: NotRequired[Union[SummaryOpts, Dict[str, Any]]]
    select: NotRequired[Union[Select, Dict[str, Any]]]
    trialId: UUID


class Annotation(TypedDict):
    bmQualifiers: NotRequired[List[BMQualifier]]
    history: NotRequired[Union[ModelHistory, Dict[str, Any]]]


class AnovaSensitivityRequestProjectItem(TypedDict):
    """
    See https://novak.jinko.ai/doc/simworkZSresult-managerZSlib/ResultManager-Sensitivity-AnovaRequest.html#t:AnovaSensitivityRequest
    """

    equateBaselines: bool
    extra: AnovaExtra
    filter: List[Filter]
    group: NotRequired[List[GroupBy]]
    select: NotRequired[Union[Select, Dict[str, Any]]]
    trialId: ProjectItemStored


class AnovaSensitivityRequestUUID(TypedDict):
    """
    See https://novak.jinko.ai/doc/simworkZSresult-managerZSlib/ResultManager-Sensitivity-AnovaRequest.html#t:AnovaSensitivityRequest
    """

    equateBaselines: bool
    extra: AnovaExtra
    filter: List[Filter]
    group: NotRequired[List[GroupBy]]
    select: NotRequired[Union[Select, Dict[str, Any]]]
    trialId: UUID


type AnovaSensitivityResponse = List[List[Union[List[Group], List[AnovaSensitivity]]]]


class BatchJobStatusCalibration(TypedDict):
    creationDate: UTCTime
    simulationId: ProjectItemStored
    status: JobStatus


class BatchJobStatusTrial(TypedDict):
    creationDate: UTCTime
    simulationId: ProjectItemStored
    status: JobStatus


class CalibIterationSummaryPayload(TypedDict):
    calibId: ProjectItemStored
    select: Id


class CalibModelResultPayload(TypedDict):
    calibId: ProjectItemStored
    patientId: str
    select: List[Id]


class CalibSanityReport(TypedDict):
    dataTables: SanityMap
    model: SanityMap
    options: SanityMap
    outputSet: SanityMap
    parameters: SanityMap
    protocol: SanityMap
    scorings: SanityMap
    solvingTimes: SanityMap


class CalibScalarResultPayload(TypedDict):
    calibId: ProjectItemStored
    patientId: NotRequired[Optional[str]]
    select: NotRequired[List[Id]]


class CalibrationPerf(TypedDict):
    arms: List[TrialRunPerArmMetrics]
    clockTimeSeconds: float
    endTime: UTCTime
    iterations: List[TrialRunMetrics]
    sizeProxy: NotRequired[Optional[int]]
    startTime: UTCTime
    totalAllocationMiB: float
    totalCpuTimeSeconds: float
    totalPatientCount: int


class CalibrationResultsSummary(TypedDict):
    arms: List[str]
    scalars: List[ScalarData]
    scalarsCrossArm: List[ScalarDataCrossArm]
    timeseries: TimeseriesMetadata


class CategoricalData(TypedDict):
    arms: List[str]
    description: NotRequired[Optional[str]]
    displayName: NotRequired[Optional[str]]
    id: Id
    type: DescriptorType


class CategoricalDataCrossArm(TypedDict):
    description: NotRequired[Optional[str]]
    displayName: NotRequired[Optional[str]]
    id: Id
    type: DescriptorType


class CompareVpopPayload(TypedDict):
    vpopToCompareTo: ProjectItemId


class ContentWithDepsByIds(TypedDict):
    dependsOn: RelativeTags
    documentation: List[Id]


class ContentWithDepsId(TypedDict):
    dependsOn: RelativeTags
    documentation: Id


class CorrelEntry(TypedDict):
    correlationCoefficient: float
    reference: NotRequired[Union[URI, Dict[str, Any]]]
    x: Correlate
    y: Correlate


class CytoscapeEdge(TypedDict):
    data: CytoscapeEdgeData


class CytoscapeNode(TypedDict):
    data: CytoscapeNodeData


class DataOverlayDiagnostic(TypedDict):
    tables: List[CoreItemId]
    warning: DataOverlayWarningDetails


class DataTableDesign(TypedDict):
    dataTableId: ProjectItemStored
    include: bool
    options: GeneratorOptions


class Metadata1(TypedDict):
    internal: NotRequired[GenericMetadata]
    public: NotRequired[DataTableOverview]


class Extract(TypedDict):
    source: ProjectItemUrl
    """
    Related reference of the extract
    """
    formulation: Optional[Dict[str, Any]]
    """
    Formulation of the extract
    """
    classification: Optional[Classification]
    """
    Classification of the extract
    """
    highlights: List[Highlight]
    """
    Related highlights of the extract
    """


class FailableCatResWithLocVarMap(TypedDict):
    error: NotRequired[Optional[str]]
    group: List[Group]
    indexes: LocVariableMap
    res: NotRequired[List[OneCategorical]]


class FailableMdlResWithLocVarMap(TypedDict):
    error: NotRequired[Optional[str]]
    group: List[Group]
    indexes: LocVariableMap
    res: NotRequired[List[OneRes]]


class FailableScalResWithLocVarMap(TypedDict):
    error: NotRequired[Optional[str]]
    group: List[Group]
    indexes: LocVariableMap
    res: NotRequired[List[OneScalar]]


class IndivResQueryTrial(TypedDict):
    equateBaselines: bool
    extra: NotRequired[Union[Void, Dict[str, Any]]]
    filter: List[Filter]
    group: NotRequired[List[GroupBy]]
    select: NotRequired[Union[Select, Dict[str, Any]]]
    trialId: ProjectItemStored


class IndivResQueryUUID(TypedDict):
    equateBaselines: bool
    extra: NotRequired[Union[Void, Dict[str, Any]]]
    filter: List[Filter]
    group: NotRequired[List[GroupBy]]
    select: NotRequired[Union[Select, Dict[str, Any]]]
    trialId: UUID


class IndividualRes(TypedDict):
    outputs: List[FailableScalResWithLocVarMap]
    outputsCategorical: List[FailableCatResWithLocVarMap]


class KSTornadoSensitivityRequestProjectItem(TypedDict):
    """
    See https://novak.jinko.ai/doc/simworkZSresult-managerZSlib/ResultManager-Sensitivity-KSTornadoRequest.html#t:KSTornadoSensitivityRequest
    """

    equateBaselines: bool
    extra: KSTornadoExtra
    filter: List[Filter]
    group: NotRequired[List[GroupBy]]
    select: NotRequired[Union[Select, Dict[str, Any]]]
    trialId: ProjectItemStored


class KSTornadoSensitivityRequestUUID(TypedDict):
    """
    See https://novak.jinko.ai/doc/simworkZSresult-managerZSlib/ResultManager-Sensitivity-KSTornadoRequest.html#t:KSTornadoSensitivityRequest
    """

    equateBaselines: bool
    extra: KSTornadoExtra
    filter: List[Filter]
    group: NotRequired[List[GroupBy]]
    select: NotRequired[Union[Select, Dict[str, Any]]]
    trialId: UUID


class LatexUpdatesWithDeps(TypedDict):
    dependsOn: RelativeTags
    documentation: List[List[str]]


class LatexWithDeps(TypedDict):
    dependsOn: RelativeTags
    documentation: str


class LawEstimationRequestProjectItem(TypedDict):
    equateBaselines: bool
    extra: LawEstimationOptions
    filter: List[Filter]
    group: NotRequired[List[GroupBy]]
    select: NotRequired[Union[Select, Dict[str, Any]]]
    trialId: ProjectItemStored


class LawEstimationRequestUUID(TypedDict):
    equateBaselines: bool
    extra: LawEstimationOptions
    filter: List[Filter]
    group: NotRequired[List[GroupBy]]
    select: NotRequired[Union[Select, Dict[str, Any]]]
    trialId: UUID


class Mapping12(TypedDict):
    """
    Apply (binary) _function_ on _originColumn1_ and _originColumn2_ (infix: _originColumn1_ _function_ _originColumn2_) and store result in new column _destinationColumn_
    """

    groupedBy: List[ColumnName]
    operation: Literal["groupAndSummarize"]
    """
    Operation
    """
    summarized: List[SummarizeColumns]


class MeasureDesign(TypedDict):
    computationalModelId: NotRequired[Union[ProjectItemStored, Dict[str, Any]]]
    coreVersion: NotRequired[str]
    measures: List[Measure]


class MeasureDesignWithMetadata(TypedDict):
    computationalModelId: NotRequired[Union[ProjectItemStored, Dict[str, Any]]]
    coreVersion: NotRequired[str]
    measures: List[Measure]
    metadata: NotRequired[Metadata2]


class ModelConstructJsonObjectiveSpecifics(TypedDict):
    description: NotRequired[Optional[str]]
    diagnostics: NotRequired[List[SanityCheck]]
    displayName: NotRequired[Optional[str]]
    id: Id
    immutableId: NotRequired[Union[ImmutableId, Dict[str, Any]]]
    isActive: NotRequired[Optional[bool]]
    links: NotRequired[List[str]]
    specifics: ObjectiveSpecifics
    tags: NotRequired[List[ImmutableId]]


class ModelResult(TypedDict):
    coreVersion: NotRequired[str]
    res: List[OneRes]


class ModelWithOpts(TypedDict):
    model: bytes
    solvingOptions: SolvingOptions
    solvingOptionsOverride: NotRequired[Union[SolvingOptionsJson, Dict[str, Any]]]


class ModelWithOptsPatch(TypedDict):
    mbModel: NotRequired[Optional[bytes]]
    solvingOptions: SolvingOptionsJson


class ModelWithOptsWithMetadata(TypedDict):
    metadata: NotRequired[Metadata3]
    model: bytes
    solvingOptions: SolvingOptions
    solvingOptionsOverride: NotRequired[Union[SolvingOptionsJson, Dict[str, Any]]]


class NumericDescriptorStatistics(TypedDict):
    barChart: NotRequired[Union[NumericBarChart, Dict[str, Any]]]
    basicStatistics: StatisticalMoments
    histogram: NotRequired[Union[Histogram, Dict[str, Any]]]
    id: Id
    unit: NotRequired[Union[PhysicalUnitWithMetadata, Dict[str, Any]]]


class OdeDoc(TypedDict):
    odeAnnotation: NotRequired[Union[Annotation, Dict[str, Any]]]
    odeDesc: NotRequired[Optional[str]]
    odeFilter: NotRequired[Union[LatexWithDeps, Dict[str, Any]]]
    odeLhs: LatexWithDeps
    odeNumber: str
    odeRefs: List[URI]
    odeRhs: LatexWithDeps


class OneOdeDoc(TypedDict):
    content: OdeDoc
    id: Id


class PIMetadataTrial(TypedDict):
    internal: NotRequired[TrialMetadata]
    public: NotRequired[TrialOverview]


class PIMetadataVpopGenerator(TypedDict):
    internal: NotRequired[VpopGeneratorMetadata]
    public: NotRequired[VpopGeneratorOverview]


class ParamDoc(TypedDict):
    paramAnnotation: NotRequired[Union[Annotation, Dict[str, Any]]]
    paramDesc: str
    paramDistrib: NotRequired[Optional[str]]
    paramRefs: List[URI]
    paramUnit: str
    paramValue: LatexWithDeps


class PhenomenonDoc(TypedDict):
    phenomenonBioReactions: ContentWithDepsByIds
    phenomenonDesc: str
    phenomenonOdes: ContentWithDepsByIds


class ProjectItemResponseTrial(TypedDict):
    coreItemId: CoreItemId
    metadata: PIMetadataTrial
    snapshotId: SnapshotId
    warnings: List[str]


class ProjectItemResponseVpopGenerator(TypedDict):
    coreItemId: CoreItemId
    metadata: PIMetadataVpopGenerator
    snapshotId: SnapshotId
    warnings: List[str]


class RMSanityRequestProjectItem(TypedDict):
    equateBaselines: bool
    filter: List[Filter]
    select: SelectAllTabs
    trialId: ProjectItemStored


class RMSanityRequestUUID(TypedDict):
    equateBaselines: bool
    filter: List[Filter]
    select: SelectAllTabs
    trialId: UUID


class SanityResponse(TypedDict):
    activeArmCount: int
    actualNumberOfIterations: int
    actualPopSize: int
    sanityChecks: CalibSanityReport


class ScoringDesignComponents(TypedDict):
    constraints: List[ModelConstructJsonConstraintSpecifics]
    measures: List[ModelConstructJsonMeasureSpecifics]
    objectives: List[ModelConstructJsonObjectiveSpecifics]


class ScoringDesignWithMetadata(TypedDict):
    components: ScoringDesignComponents
    immutableIds: ImmutableIdMapping
    metadata: NotRequired[Metadata5]
    tags: List[ModelConstructJsonTagSpecifics]


class SerializedModelGraph1(TypedDict):
    edges: List[CytoscapeEdge]
    nodes: List[CytoscapeNode]


type SerializedModelGraph = Union[
    Dict[str, Dict[str, List[Label]]], SerializedModelGraph1
]


class SurvivalAnalysisRequestProjectItem(TypedDict):
    equateBaselines: bool
    extra: SurvivalExtra
    filter: List[Filter]
    group: NotRequired[List[GroupBy]]
    select: NotRequired[Union[Select, Dict[str, Any]]]
    trialId: ProjectItemStored


class SurvivalAnalysisRequestUUID(TypedDict):
    equateBaselines: bool
    extra: SurvivalExtra
    filter: List[Filter]
    group: NotRequired[List[GroupBy]]
    select: NotRequired[Union[Select, Dict[str, Any]]]
    trialId: UUID


class TrajectoriesAndVectorFields(TypedDict):
    trajectories: List[ModelResult]
    vectorFields: List[OutputResultsList]


class Trial(TypedDict):
    computationalModelId: NotRequired[ProjectItemId]
    coreVersion: NotRequired[str]
    dataTableDesigns: NotRequired[List[DataTableDesign]]
    measureDesignId: NotRequired[ProjectItemId]
    protocolDesignId: NotRequired[ProjectItemId]
    scoringDesignId: NotRequired[ProjectItemId]
    solvingOptions: NotRequired[SolvingOptions]
    solvingOptionsOverride: NotRequired[SolvingOptions]
    vpopId: NotRequired[ProjectItemId]


class TrialPatch(TypedDict):
    computationalModelId: NotRequired[ProjectItemId]
    dataTableDesigns: NotRequired[List[DataTableDesign]]
    measureDesignId: NotRequired[ProjectItemId]
    protocolDesignId: NotRequired[ProjectItemId]
    scoringDesignId: NotRequired[ProjectItemId]
    solvingOptions: NotRequired[SolvingOptions]
    vpopId: NotRequired[ProjectItemId]


class TrialResultsSummary(TypedDict):
    arms: List[str]
    categoricals: List[CategoricalData]
    categoricalsCrossArm: List[CategoricalDataCrossArm]
    coreVersion: NotRequired[str]
    patients: List[str]
    scalars: List[ScalarData]
    scalarsCrossArm: List[ScalarDataCrossArm]


class TrialVisualizationSanity(TypedDict):
    contributionAnalysis: NotRequired[
        Union[TrialVisualizationSanityField, Dict[str, Any]]
    ]
    dataOverlay: NotRequired[List[DataOverlayDiagnostic]]
    filters: NotRequired[Union[TrialVisualizationSanityField, Dict[str, Any]]]
    groups: NotRequired[Union[TrialVisualizationSanityField, Dict[str, Any]]]
    overlay: NotRequired[Union[TrialVisualizationSanityField, Dict[str, Any]]]
    plotOptions: NotRequired[Union[TrialVisualizationSanityField, Dict[str, Any]]]
    scalars: NotRequired[Union[TrialVisualizationSanityField, Dict[str, Any]]]
    scatterPlots: NotRequired[Union[TrialVisualizationSanityField, Dict[str, Any]]]
    selectedArms: NotRequired[Union[TrialVisualizationSanityField, Dict[str, Any]]]
    survivalAnalysis: NotRequired[Union[TrialVisualizationSanityField, Dict[str, Any]]]
    timeseries: NotRequired[Union[TrialVisualizationSanityField, Dict[str, Any]]]


class TrialWithMetadata(TypedDict):
    computationalModelId: NotRequired[ProjectItemId]
    coreVersion: NotRequired[str]
    dataTableDesigns: NotRequired[List[DataTableDesign]]
    measureDesignId: NotRequired[ProjectItemId]
    metadata: NotRequired[Metadata8]
    protocolDesignId: NotRequired[ProjectItemId]
    scoringDesignId: NotRequired[ProjectItemId]
    solvingOptions: NotRequired[SolvingOptions]
    solvingOptionsOverride: NotRequired[SolvingOptions]
    vpopId: NotRequired[ProjectItemId]


class ValidationMessage(TypedDict):
    details: ValidationMessageContent
    level: ValidationLevel
    message: str
    rowId: NotRequired[Optional[str]]
    rowIndex: NotRequired[Optional[int]]


class ValidationMessagesWithRows(TypedDict):
    errors: List[ValidationMessage]
    rowCount: int
    warnings: List[ValidationMessage]


class VarDoc(TypedDict):
    varAnnotation: NotRequired[Union[Annotation, Dict[str, Any]]]
    varConversionFactor: NotRequired[Union[ContentWithDepsId, Dict[str, Any]]]
    varDesc: str
    varDisplay: str
    varDisplayUnit: str
    varDistrib: NotRequired[Optional[str]]
    varInitCondDisplayUnit: LatexWithDeps
    varInitCondInternalUnit: LatexWithDeps
    varInternalUnit: str
    varRefs: List[URI]
    varUpdatedBy: List[Id]


class VpopDescribe(TypedDict):
    associatedComputationalModelId: NotRequired[
        Union[ProjectItemStored, Dict[str, Any]]
    ]
    descriptorCount: NotRequired[Optional[int]]
    generatorId: NotRequired[Union[ProjectItemStored, Dict[str, Any]]]
    generatorOptions: NotRequired[Union[VpopGeneratorOptions, Dict[str, Any]]]
    patientCount: NotRequired[Optional[int]]


class VpopStatistics(TypedDict):
    categoricalDescriptorStatistics: List[CategoricalDescriptorStatistics]
    numPatients: int
    numericDescriptorStatistics: List[NumericDescriptorStatistics]
    pearsonCorrelation: List[CorrelEntry]
    spearmanCorrelation: List[CorrelEntry]


class BaselineCheckDoc(TypedDict):
    baselineCheckCondition: LatexWithDeps
    baselineCheckDesc: str
    baselineCheckRefs: List[URI]


class BioReactionDoc(TypedDict):
    reacAnnotation: NotRequired[Union[Annotation, Dict[str, Any]]]
    reacDesc: NotRequired[Optional[str]]
    reacEquation: LatexWithDeps
    reacFilter: NotRequired[Union[LatexWithDeps, Dict[str, Any]]]
    reacNumber: str
    reacRate: LatexWithDeps
    reacRefs: List[URI]


class Calibration(TypedDict):
    calibrationOptions: NotRequired[CalibrationOptions]
    calibrationOptionsOverride: NotRequired[CalibrationOptionsJson]
    computationalModelId: NotRequired[ProjectItemId]
    coreVersion: NotRequired[str]
    dataTableDesigns: List[DataTableDesign]
    measureDesignId: NotRequired[ProjectItemId]
    parameters: List[CalibrationParameter]
    protocolDesignId: NotRequired[ProjectItemId]
    scoringDesignId: NotRequired[ProjectItemId]
    solvingOptions: NotRequired[SolvingOptions]
    solvingOptionsOverride: NotRequired[SolvingOptions]


class CalibrationPatch(TypedDict):
    calibrationOptions: NotRequired[CalibrationOptionsJson]
    computationalModelId: NotRequired[ProjectItemId]
    dataTableDesigns: NotRequired[List[DataTableDesign]]
    measureDesignId: NotRequired[ProjectItemId]
    parameters: NotRequired[List[CalibrationParameter]]
    protocolDesignId: NotRequired[ProjectItemId]
    scoringDesignId: NotRequired[ProjectItemId]
    solvingOptions: NotRequired[SolvingOptionsJson]


class CalibrationWithMetadata(TypedDict):
    calibrationOptions: NotRequired[CalibrationOptions]
    calibrationOptionsOverride: NotRequired[CalibrationOptionsJson]
    computationalModelId: NotRequired[ProjectItemId]
    coreVersion: NotRequired[str]
    dataTableDesigns: List[DataTableDesign]
    measureDesignId: NotRequired[ProjectItemId]
    metadata: NotRequired[Metadata]
    parameters: List[CalibrationParameter]
    protocolDesignId: NotRequired[ProjectItemId]
    scoringDesignId: NotRequired[ProjectItemId]
    solvingOptions: NotRequired[SolvingOptions]
    solvingOptionsOverride: NotRequired[SolvingOptions]


class CompDoc(TypedDict):
    compAnnotation: NotRequired[Union[Annotation, Dict[str, Any]]]
    compDesc: str
    compDistrib: NotRequired[Optional[str]]
    compRefs: List[URI]
    compUnit: str
    compVol: LatexWithDeps


class CompareVpopsSummary(TypedDict):
    compVpopStatistics: VpopStatistics
    ksTest: List[List[Union[Id, float]]]
    refVpopStatistics: VpopStatistics


class DataOverlay(TypedDict):
    ranges: bool
    tables: List[DataTableDesign]


class EventDoc(TypedDict):
    eventAnnotation: NotRequired[Union[Annotation, Dict[str, Any]]]
    eventCond: NotRequired[Union[LatexWithDeps, Dict[str, Any]]]
    eventDesc: str
    eventDisplay: bool
    eventRefs: List[URI]
    eventTime: LatexWithDeps
    eventUpdate: LatexUpdatesWithDeps


type ModelUnloaded = Union[str, ModelWithOpts]


type ModelUnloadedPatch = Union[str, ModelWithOptsPatch]


class OneBaselineCheckDoc(TypedDict):
    content: BaselineCheckDoc
    id: Id


class OneBioReactionDoc(TypedDict):
    content: BioReactionDoc
    id: Id


class OneCompDoc(TypedDict):
    content: CompDoc
    id: Id


class OneEventDoc(TypedDict):
    content: EventDoc
    id: Id


class OneParamDoc(TypedDict):
    content: ParamDoc
    id: Id


class OnePhenomenonDoc(TypedDict):
    content: PhenomenonDoc
    id: Id


class OneVarDoc(TypedDict):
    content: VarDoc
    id: Id


class SchemaValidationsDetails(TypedDict):
    fitnessFunction: ValidationMessagesWithRows


class ScoringDesign(TypedDict):
    components: ScoringDesignComponents
    immutableIds: ImmutableIdMapping
    tags: List[ModelConstructJsonTagSpecifics]


class ScoringDesignEditPayload(TypedDict):
    delete: NotRequired[List[ImmutableId]]
    update: NotRequired[Union[ScoringDesign, Dict[str, Any]]]


class ScoringDesignEditResponse(TypedDict):
    response: ProjectItemResponseScoringDesign
    updated: ScoringDesign


class TrialVisualization(TypedDict):
    contributionAnalysis: NotRequired[
        Union[ContributionAnalysisPayload, Dict[str, Any]]
    ]
    coreVersion: NotRequired[str]
    dataOverlay: NotRequired[Union[DataOverlay, Dict[str, Any]]]
    equateBaseline: NotRequired[bool]
    filters: NotRequired[List[Filter]]
    groups: NotRequired[List[GroupBy]]
    overlay: NotRequired[Union[IndividualPatientsOverlay, Dict[str, Any]]]
    plotOptions: NotRequired[Dict[str, Layout]]
    scalars: NotRequired[Union[GenericVisPayload, Dict[str, Any]]]
    scatterPlots: NotRequired[Union[ScatterPlotPayload, Dict[str, Any]]]
    selectedArms: NotRequired[List[str]]
    survivalAnalysis: NotRequired[Union[SurvivalAnalysisPayload, Dict[str, Any]]]
    timeseries: NotRequired[Union[GenericVisPayload, Dict[str, Any]]]
    trialId: ProjectItemId


class TrialVisualizationPatch(TypedDict):
    contributionAnalysis: NotRequired[ContributionAnalysisPayload]
    dataOverlay: NotRequired[DataOverlay]
    equateBaseline: NotRequired[bool]
    filters: NotRequired[List[Filter]]
    groups: NotRequired[List[GroupBy]]
    overlay: NotRequired[IndividualPatientsOverlay]
    plotOptions: NotRequired[Dict[str, Layout]]
    scalars: NotRequired[GenericVisPayload]
    scatterPlots: NotRequired[ScatterPlotPayload]
    selectedArms: NotRequired[List[str]]
    survivalAnalysis: NotRequired[SurvivalAnalysisPayload]
    timeseries: NotRequired[GenericVisPayload]
    trialId: NotRequired[ProjectItemId]


class TrialVisualizationWithMetadata(TypedDict):
    contributionAnalysis: NotRequired[
        Union[ContributionAnalysisPayload, Dict[str, Any]]
    ]
    coreVersion: NotRequired[str]
    dataOverlay: NotRequired[Union[DataOverlay, Dict[str, Any]]]
    equateBaseline: NotRequired[bool]
    filters: NotRequired[List[Filter]]
    groups: NotRequired[List[GroupBy]]
    metadata: NotRequired[Metadata5]
    overlay: NotRequired[Union[IndividualPatientsOverlay, Dict[str, Any]]]
    plotOptions: NotRequired[Dict[str, Layout]]
    scalars: NotRequired[Union[GenericVisPayload, Dict[str, Any]]]
    scatterPlots: NotRequired[Union[ScatterPlotPayload, Dict[str, Any]]]
    selectedArms: NotRequired[List[str]]
    survivalAnalysis: NotRequired[Union[SurvivalAnalysisPayload, Dict[str, Any]]]
    timeseries: NotRequired[Union[GenericVisPayload, Dict[str, Any]]]
    trialId: ProjectItemId


class MdlDoc(TypedDict):
    docAnnotation: NotRequired[Union[Annotation, Dict[str, Any]]]
    docBaselineChecks: List[OneBaselineCheckDoc]
    docBioReactions: List[OneBioReactionDoc]
    docCategoricalParams: List[OneCategoricalParamDoc]
    docCompartments: List[OneCompDoc]
    docEvents: List[OneEventDoc]
    docOdes: List[OneOdeDoc]
    docParameters: List[OneParamDoc]
    docPhenomena: List[OnePhenomenonDoc]
    docVariables: List[OneVarDoc]


class AggregateSRQueryProjectItem(TypedDict):
    equateBaselines: bool
    extra: NotRequired[Union[Void, Dict[str, Any]]]
    filter: List[Filter]
    group: NotRequired[Union[ScalSummaryOpts, Dict[str, Any]]]
    select: NotRequired[Union[Select, Dict[str, Any]]]
    trialId: ProjectItemStored


class AggregateSRQueryUUID(TypedDict):
    equateBaselines: bool
    extra: NotRequired[Union[Void, Dict[str, Any]]]
    filter: List[Filter]
    group: NotRequired[Union[ScalSummaryOpts, Dict[str, Any]]]
    select: NotRequired[Union[Select, Dict[str, Any]]]
    trialId: UUID


class BaselineDescriptors(TypedDict):
    categoricalDescriptors: List[CategoricalBaselineDescriptor]
    numericDescriptors: List[NumericBaselineDescriptor]


type CaseBranch = List[Union[Union[Level, Dict[str, Any]], Formula]]


class CaseExpression(TypedDict):
    caseBranches: List[CaseBranch]
    caseScrutinee: Id


class Condition1(TypedDict):
    contents: List[Union[Comparator, Formula]]
    tag: Literal["Comp"]


class Condition2(TypedDict):
    contents: List[Union[BoolOp, Condition]]
    tag: Literal["BoolOp"]


class Condition3(TypedDict):
    contents: Condition
    tag: Literal["Not"]


type Condition = Union[Condition1, Condition2, Condition3, Condition4, Condition5]


class DataTable(TypedDict):
    mappings: Dict[str, List[Mapping]]
    rawData: str
    validations: NotRequired[SchemaValidations]


class DataTableColumnCaseExpression(TypedDict):
    caseBranches: List[List[Union[Level, DataTableColumnFormula]]]
    caseScrutinee: Id


class DataTableColumnFormula3(TypedDict):
    contents: List[Union[MonoOp, DataTableColumnFormula]]
    tag: Literal["UnaryNode"]


class DataTableColumnFormula4(TypedDict):
    contents: List[Union[DualOp, DataTableColumnFormula]]
    tag: Literal["BinaryNode"]


class DataTableColumnFormula5(TypedDict):
    contents: List[Union[DataTablePredicate, DataTableColumnFormula]]
    tag: Literal["CondNode"]


class DataTableColumnFormula6(TypedDict):
    contents: DataTableColumnFunction
    tag: Literal["FunctionCall"]


class DataTableColumnFormula7(TypedDict):
    contents: DataTableColumnCaseExpression
    tag: Literal["Case"]


class DataTableColumnFormula9(TypedDict):
    contents: List[DataTableColumnFormula]
    tag: Literal["Delay"]


type DataTableColumnFormula = Union[
    DataTableColumnFormula1,
    DataTableColumnFormula2,
    DataTableColumnFormula3,
    DataTableColumnFormula4,
    DataTableColumnFormula5,
    DataTableColumnFormula6,
    DataTableColumnFormula7,
    DataTableColumnFormula8,
    DataTableColumnFormula9,
]


class DataTableColumnFunction1(TypedDict):
    contents: DataTableColumnFormula
    tag: Literal["NextSeed"]


class DataTableColumnFunction2(TypedDict):
    contents: List[DataTableColumnFormula]
    tag: Literal["Normal"]


class DataTableColumnFunction3(TypedDict):
    contents: List[DataTableColumnFormula]
    tag: Literal["Uniform"]


type DataTableColumnFunction = Union[
    DataTableColumnFunction1, DataTableColumnFunction2, DataTableColumnFunction3
]


class DataTablePredicate1(TypedDict):
    contents: List[Union[Comparator, DataTableColumnFormula]]
    tag: Literal["Comp"]


class DataTablePredicate2(TypedDict):
    contents: List[Union[BoolOp, DataTablePredicate]]
    tag: Literal["BoolOp"]


class DataTablePredicate3(TypedDict):
    contents: DataTablePredicate
    tag: Literal["Not"]


type DataTablePredicate = Union[
    DataTablePredicate1,
    DataTablePredicate2,
    DataTablePredicate3,
    DataTablePredicate4,
    DataTablePredicate5,
]


class DataTableWithMetadata(TypedDict):
    mappings: Dict[str, List[Mapping]]
    metadata: NotRequired[Metadata1]
    rawData: str
    validations: NotRequired[SchemaValidations]


class Distrib12(TypedDict):
    mixture: List[List[Union[Probability, Distrib]]]
    tag: Literal["Mixture"]


type Distrib = Union[
    Distrib1,
    Distrib2,
    Distrib3,
    Distrib4,
    Distrib5,
    Distrib6,
    Distrib7,
    Distrib8,
    Distrib9,
    Distrib10,
    Distrib11,
    Distrib12,
    Distrib13,
    Distrib14,
]


class EstimatedDistribution(TypedDict):
    bic: float
    law: Distrib


class EstimatedMarginalDistribution(TypedDict):
    arm: NotRequired[Union[ArmId, Dict[str, Any]]]
    estimatedDistributions: List[EstimatedDistribution]
    outputId: Id


class Formula3(TypedDict):
    contents: List[Union[MonoOp, Formula]]
    tag: Literal["UnaryNode"]


class Formula4(TypedDict):
    contents: List[Union[DualOp, Formula]]
    tag: Literal["BinaryNode"]


class Formula5(TypedDict):
    contents: List[Union[Condition, Formula]]
    tag: Literal["CondNode"]


class Formula6(TypedDict):
    contents: Function
    tag: Literal["FunctionCall"]


class Formula7(TypedDict):
    contents: CaseExpression
    tag: Literal["Case"]


class Formula9(TypedDict):
    contents: List[Formula]
    tag: Literal["Delay"]


type Formula = Union[
    Formula1,
    Formula2,
    Formula3,
    Formula4,
    Formula5,
    Formula6,
    Formula7,
    Formula8,
    Formula9,
]


class Function1(TypedDict):
    contents: Formula
    tag: Literal["NextSeed"]


class Function2(TypedDict):
    contents: List[Formula]
    tag: Literal["Normal"]


class Function3(TypedDict):
    contents: List[Formula]
    tag: Literal["Uniform"]


type Function = Union[Function1, Function2, Function3]


class LawEstimationResponse(TypedDict):
    correlations: List[EstimatedCorrelation]
    estimatedMarginalDistributions: List[EstimatedMarginalDistribution]


class Mapping11(TypedDict):
    """
    Apply _function_, using columns names as variables, and store result in _destinationColumn_
    """

    destinationColumn: ColumnName
    function: DataTableColumnFormula
    operation: Literal["extend"]
    """
    Operation
    """


class Mapping14(TypedDict):
    """
    Filter table, using columns names as variables
    """

    operation: Literal["filter"]
    """
    Operation
    """
    predicate: DataTablePredicate


type Mapping = Union[
    Mapping1,
    Mapping2,
    Mapping3,
    Mapping4,
    Mapping5,
    Mapping6,
    Mapping7,
    Mapping8,
    Mapping9,
    Mapping10,
    Mapping11,
    Mapping12,
    Mapping13,
    Mapping14,
]


class MarginalDistribution(TypedDict):
    distribution: Union[str, float, Distrib]
    id: Id
    reference: NotRequired[Union[URI, Dict[str, Any]]]


class NumericBaselineDescriptor(TypedDict):
    desc: NotRequired[Optional[str]]
    distribution: Distrib
    formula: NotRequired[Union[str, float, Formula]]
    formulaLatex: NotRequired[Optional[str]]
    id: Id
    inputTag: ModelInputTag
    origin: ComponentKind
    ref: NotRequired[URI]
    unit: NotRequired[PhysicalUnitWithMetadata]
    val: float


class PhasePortraitStaticInfo(TypedDict):
    lhsVar: NumericBaselineDescriptor
    rhsInputDescriptors: BaselineDescriptors
    rhsVars: List[NumericBaselineDescriptor]


class ScalSummaryOpts(TypedDict):
    distrib: NotRequired[Union[Optional[str], Optional[float], Distrib]]
    groupBy: NotRequired[List[GroupBy]]
    maxBins: NotRequired[Optional[int]]


class SubsamplingGenerator(TypedDict):
    additionalScalars: List[ScalarWithArm]
    filters: List[Filter]
    targetCategoricals: List[TargetMarginalCategorical]
    targetCorrelations: List[TargetCorrelation]
    targetMarginals: List[TargetMarginalNumeric]
    targetSummaryStatistics: List[TargetSummaryStatistic]
    targetSurvivals: List[TargetSurvival]
    trialId: ProjectItemStored


class TargetMarginalNumeric(TypedDict):
    arm: NotRequired[Union[ArmId, Dict[str, Any]]]
    distribution: Union[str, float, Distrib]
    id: Id
    reference: NotRequired[Union[URI, Dict[str, Any]]]
    weight: PositiveDouble


class VpopDesignWithModel(TypedDict):
    computationalModelId: NotRequired[Union[ProjectItemStored, Dict[str, Any]]]
    coreVersion: NotRequired[str]
    correlations: NotRequired[List[CorrelEntry]]
    marginalCategoricals: NotRequired[List[MarginalCategorical]]
    marginalDistributions: NotRequired[List[MarginalDistribution]]


class VpopGenerator1(TypedDict):
    contents: VpopDesignWithModel
    coreVersion: NotRequired[str]
    tag: Literal["VpopGeneratorFromDesign"]


class VpopGenerator4(TypedDict):
    contents: SubsamplingGenerator
    coreVersion: NotRequired[str]
    tag: Literal["FromSubsamplingGenerator"]


type VpopGenerator = Union[
    VpopGenerator1, VpopGenerator2, VpopGenerator3, VpopGenerator4
]


class VpopGeneratorWithMetadata1(TypedDict):
    contents: VpopDesignWithModel
    coreVersion: NotRequired[str]
    metadata: NotRequired[Metadata9]
    tag: Literal["VpopGeneratorFromDesign"]


class VpopGeneratorWithMetadata4(TypedDict):
    contents: SubsamplingGenerator
    coreVersion: NotRequired[str]
    metadata: NotRequired[Metadata9]
    tag: Literal["FromSubsamplingGenerator"]


type VpopGeneratorWithMetadata = Union[
    VpopGeneratorWithMetadata1,
    VpopGeneratorWithMetadata2,
    VpopGeneratorWithMetadata3,
    VpopGeneratorWithMetadata4,
]
