#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['pyprocessors_afp_keywords']

package_data = \
{'': ['*']}

package_dir = \
{'': 'src'}

install_requires = \
['pymultirole-plugins>=0.5.158,<0.6.0',
 'spacy==2.3.7',
 'textacy==0.10.1',
 'cytoolz',
 'fasttext']

extras_require = \
{'dev': ['flit', 'pre-commit', 'bump2version'],
 'docs': ['sphinx',
          'sphinx-rtd-theme',
          'm2r2',
          'sphinxcontrib.apidoc',
          'jupyter_sphinx'],
 'test': ['pytest',
          'pytest-cov',
          'pytest-flake8',
          'pytest-black',
          'flake8==3.9.2',
          'tox']}

entry_points = \
{'pyprocessors.plugins': ['afp_keywords = '
                          'pyprocessors_afp_keywords.afp_keywords:AFPKeywordsProcessor']}

setup(name='pyprocessors-afp_keywords',
      version='0.5.28',
      description='Processor based on Huggingface transformers zero-shot classification pipeline',
      author='Olivier Terrier',
      author_email='olivier.terrier@kairntech.com',
      url='https://github.com/oterrier/pyprocessors_afp_keywords/',
      packages=packages,
      package_data=package_data,
      package_dir=package_dir,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.8',
     )
