# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# Ensure we get the local copy of tornado instead of what's on the standard path
import os
import sys

sys.path.insert(0, os.path.abspath(".."))
sys.path.append(os.path.abspath("./_ext"))
import pywebio

version = release = pywebio.__version__

# -- Project information -----------------------------------------------------

project = 'PyWebIO'
copyright = 'WangWeimin'
author = 'WangWeimin'

# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    # "sphinx.ext.intersphinx",
    "sphinx.ext.viewcode",
    'sphinx_tabs.tabs',
    'sphinx.ext.extlinks',
    'codeblock'
]

primary_domain = "py"
default_role = "py:obj"
# intersphinx_mapping = {"python": ("https://docs.python.org/3.6/", None)}

master_doc = 'index'

autodoc_member_order = 'bysource'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = 'zh_CN'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "sphinx_rtd_theme"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['static']


def setup(app):
    """Configure Sphinx"""
    app.add_stylesheet('pywebio.css')


# -- Extension configuration -------------------------------------------------
from demos import config

extlinks = {
    'demo_host': (config.demo_host + '%s', 'demo_host'),
    'charts_demo_host': (config.charts_demo_host + '%s', 'charts_demo_host')
}

from sphinx.builders.html import StandaloneHTMLBuilder

StandaloneHTMLBuilder.supported_image_types = [
    'image/svg+xml',
    'image/gif',
    'image/png',
    'image/jpeg'
]
