# codat-banking

<!-- Start SDK Installation -->
## SDK Installation

```bash
pip install codat-banking
```
<!-- End SDK Installation -->

## SDK Example Usage
<!-- Start SDK Example Usage -->
```python
import codat
from codat.models import operations, shared

s = codat.Codat(
    security=shared.Security(
        auth_header="YOUR_API_KEY_HERE",
    ),
)


req = operations.ListBankingAccountBalancesRequest(
    company_id="unde",
    connection_id="deserunt",
    order_by="porro",
    page=844266,
    page_size=602763,
    query="vero",
)
    
res = s.account_balances.list_banking_account_balances(req)

if res.links is not None:
    # handle response
```
<!-- End SDK Example Usage -->

<!-- Start SDK Available Operations -->
## SDK Available Operations


### account_balances

* `list_banking_account_balances` - List account balances

### accounts

* `get_banking_account` - Get account
* `list_banking_accounts` - List accounts

### transaction_categories

* `get_bank_transaction_category` - Get transaction category
* `list_bank_transaction_categories` - List all transaction categories

### transactions

* `get_banking_transaction` - Get bank transaction
* `list_all_banking_transactions` - List banking transactions
* `list_banking_transactions` - List bank account transactions
<!-- End SDK Available Operations -->

### SDK Generated by [Speakeasy](https://docs.speakeasyapi.dev/docs/using-speakeasy/client-sdks)
