raw_presets = [
    {
        "title": "Likes",
        "icon": "<i class=\"fas fa-thumbs-up\"></i>",
        "html": "<table style=\"width:90%;min-width:240px;\">\r\n    <tr>\r\n        <td style=\"width:32px;\">\r\n            <img id=\"id_djeym_hand_like\" src=\"/static/djeym/img/like.svg\" alt=\"Like\" data-obj_type=\"djeymObjectType\" data-obj_pk=\"djeymObjectID\" style=\"cursor:pointer;\">\r\n        </td>\r\n        <td style=\"width:32px;\">\r\n            <img id=\"id_djeym_hand_dislike\" src=\"/static/djeym/img/dislike.svg\" alt=\"\" data-obj_type=\"djeymObjectType\" data-obj_pk=\"djeymObjectID\" style=\"cursor:pointer;\">\r\n        </td>\r\n        <td>\r\n            <div style=\"position:relative;height:16px;font-size:14px;\">\r\n                <span id=\"id_djeym_count_like\" style=\"position:absolute;top:0;left:0;color:#000;\">0</span>\r\n                <span id=\"id_djeym_count_dislike\" style=\"position:absolute;top:0;right:0;color:#000;\">0</span>\r\n            </div>\r\n            <div style=\"height:8px;background:#000;\">\r\n                <div id=\"id_djeym_progress_likes\" style=\"width:50%;height:8px;background:#ffc107;\"></div>\r\n            </div>\r\n        </td>\r\n    </tr>\r\n</table>\r\n<div class=\"djeymUpdateInfoPreset\" onclick=\"window.djeymUpdateLikes( 'djeymObjectType', djeymObjectID );\"></div>",
        "js": "var djeymUpdateLikes = function( djeymObjectType, djeymObjectID ) {\r\n  $.get( \"/djeym/ajax-update-likes/\", {\r\n    djeymObjectType: djeymObjectType,\r\n    djeymObjectID: djeymObjectID\r\n  } )\r\n    .done( function( data ) {\r\n      let like = +data.like;\r\n      let dislike = +data.dislike;\r\n      let progress = Math.round( ( like / ( like + dislike ) ) * 100 );\r\n      if ( progress > 100 ) { progress = 100; }\r\n      $( \"#id_djeym_count_like\" ).text( like );\r\n      $( \"#id_djeym_count_dislike\" ).text( dislike );\r\n      $( \"#id_djeym_progress_likes\" ).css( \"width\", progress.toString() + \"%\" );\r\n    } )\r\n    .fail( function( jqxhr, textStatus, error ) {\r\n      let err = textStatus + \", \" + error;\r\n      console.log( \"Request Failed: \" + err );\r\n    } );\r\n};\r\n$( document ).on( \"click\", \"#id_djeym_hand_like, #id_djeym_hand_dislike\", function() {\r\n  let $this = $( this );\r\n  $.post( \"/djeym/ajax-update-likes/\", {\r\n    djeymObjectType: $this.data( \"obj_type\" ),\r\n    djeymObjectID: $this.data( \"obj_pk\" ),\r\n    targetAction: $this.attr( \"id\" ),\r\n    csrfmiddlewaretoken: Cookies.get( \"csrftoken\" )\r\n  } )\r\n    .done( function( data ) {\r\n      let like = +data.like;\r\n      let dislike = +data.dislike;\r\n      let progress = Math.round( ( like / ( like + dislike ) ) * 100 );\r\n      if ( progress > 100 ) { progress = 100; }\r\n      $( \"#id_djeym_count_like\" ).text( like );\r\n      $( \"#id_djeym_count_dislike\" ).text( dislike );\r\n      $( \"#id_djeym_progress_likes\" ).css( \"width\", progress.toString() + \"%\" );\r\n    } )\r\n    .fail( function( jqxhr, textStatus, error ) {\r\n      let err = textStatus + \", \" + error;\r\n      console.log( \"Request Failed: \" + err );\r\n    } );\r\n} );",
        "description": "<div>\u041f\u0440\u0438\u043d\u0438\u043c\u0430\u0435\u0442 \u043b\u0430\u0439\u043a\u0438 \u043d\u0430 \u0433\u0435\u043e-\u043e\u0431\u044a\u0435\u043a\u0442\u0430\u0445.\r\n\u0420\u0430\u0431\u043e\u0442\u0430\u0435\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u0432 \u043e\u0434\u043d\u043e\u043c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u043c \u043c\u0435\u0441\u0442\u0435 - \u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a, \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0438\u043b\u0438 \u041f\u043e\u0434\u0432\u0430\u043b.</div>\r\n<div style=\"color:#607D8B;\">( Accepts likes on geo-objects.  It works only in one selected place - Header, Description or Footer.)</div>",
        "slug": "likes"
    },
    {
        "title": "Text",
        "icon": "<i class=\"fas fa-file-export\"></i>",
        "html": "<p>\r\n<div style=\"color:#e91e63;\">\u0414\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u0441\u0432\u043e\u0439 \u0442\u0435\u043a\u0441\u0442 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443 - \u042f\u041d\u0414\u0415\u041a\u0421 \u041a\u0410\u0420\u0422\u042b / \u041a\u0430\u0440\u0442\u044b / \u041a\u0430\u0440\u0442\u0430 /\u041f\u0440\u0435\u0441\u0435\u0442\u044b / Text</div>\r\n<div style=\"color:#3f51b5;\">( Add your text to the address - YANDEX MAPS / Maps / Map / Presets > Text )</div>\r\n</p>",
        "js": "",
        "description": "<div>\u0412\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u0443\u044e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e - \u0421\u0441\u044b\u043b\u043a\u0430, \u043a\u043e\u043f\u0438\u0440\u0430\u0439\u0442, \u0440\u0435\u043a\u043b\u0430\u043c\u0430 \u0438 \u0442.\u0434.</div>\r\n<div style=\"color:#607D8B;\">( Inserts text information - Link, copyright, advertising, etc. )</div>",
        "slug": "text"
    }
]
