# Generated by Django 2.1.7 on 2019-03-01 06:37

from decimal import Decimal
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import djeym.utils
import smart_selects.db_fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='CategoryPlacemark',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(help_text='Name of any geographic area - Country Name or City Name or District Name or The name of the resort coast, etc.', max_length=60, verbose_name='Title')),
                ('category_icon', models.CharField(blank=True, default='', help_text='https://fontawesome.com/icons?d=gallery&m=free - Example: &lt;i class="fab fa-android"&gt;&lt;/i&gt;', max_length=255, verbose_name='Category Icon (html tag)')),
                ('category_color', models.CharField(default='#00bfff', help_text='Applies to Checkboxes and Radio Buttons.', max_length=255, validators=[djeym.utils.validate_hex_color], verbose_name='Category color')),
                ('active', models.BooleanField(default=True, verbose_name='Active category')),
            ],
            options={
                'verbose_name': 'Category of placemarks',
                'verbose_name_plural': 'Category of placemarks',
                'ordering': ('title',),
            },
        ),
        migrations.CreateModel(
            name='CategoryPolygon',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(help_text='The name of the aggregate of any geographic area. Examples: Honduran cities or Hawaiian beaches or Residential complexes in Antarctica.', max_length=60, verbose_name='Title')),
                ('category_icon', models.CharField(blank=True, default='', help_text='https://fontawesome.com/icons?d=gallery&m=free - Example: &lt;i class="fab fa-android"&gt;&lt;/i&gt;', max_length=255, verbose_name='Category Icon (html tag)')),
                ('category_color', models.CharField(default='#00bfff', help_text='Applies to Checkboxes and Radio Buttons.', max_length=255, validators=[djeym.utils.validate_hex_color], verbose_name='Category color')),
                ('active', models.BooleanField(default=True, verbose_name='Active category')),
            ],
            options={
                'verbose_name': 'Category of territories',
                'verbose_name_plural': 'Category of territories',
                'ordering': ('title',),
            },
        ),
        migrations.CreateModel(
            name='CategoryPolyline',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(help_text='Examples: Tourist routes or Marathon routes etc.', max_length=60, verbose_name='Title')),
                ('category_icon', models.CharField(blank=True, default='', help_text='https://fontawesome.com/icons?d=gallery&m=free - Example: &lt;i class="fab fa-android"&gt;&lt;/i&gt;', max_length=255, verbose_name='Category Icon (html tag)')),
                ('category_color', models.CharField(default='#00bfff', help_text='Applies to Checkboxes and Radio Buttons.', max_length=255, validators=[djeym.utils.validate_hex_color], verbose_name='Category color')),
                ('active', models.BooleanField(default=True, verbose_name='Active category')),
            ],
            options={
                'verbose_name': 'Category of routes',
                'verbose_name_plural': 'Category of routes',
                'ordering': ('title',),
            },
        ),
        migrations.CreateModel(
            name='CounterID',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('num_id', models.PositiveIntegerField(default=1, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='CustomClusterIcon',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('svg', models.FileField(help_text='Only SVG files.', null=True, upload_to=djeym.utils.make_upload_path, validators=[djeym.utils.validate_svg], verbose_name='Icon')),
                ('title', models.CharField(default='', help_text='Example: Green Garden', max_length=60, unique=True, verbose_name='Cluster name')),
                ('size_width', models.PositiveSmallIntegerField(default=0, verbose_name='Icon width')),
                ('size_height', models.PositiveSmallIntegerField(default=0, verbose_name='Icon height')),
                ('offset_x', models.DecimalField(decimal_places=1, default=Decimal('0.0'), max_digits=3, verbose_name='Offset by axis - X')),
                ('offset_y', models.DecimalField(decimal_places=1, default=Decimal('0.0'), max_digits=3, verbose_name='Offset by axis - Y')),
            ],
            options={
                'verbose_name': 'Icons for clusters',
                'verbose_name_plural': 'Icons for clusters',
                'ordering': ('title', 'id'),
            },
        ),
        migrations.CreateModel(
            name='CustomMarkerIcon',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(default='', help_text='Example: Airport', max_length=60, verbose_name='Icon name')),
                ('svg', models.FileField(help_text='Only SVG files.', null=True, upload_to=djeym.utils.make_upload_path, validators=[djeym.utils.validate_svg], verbose_name='Icon')),
                ('size_width', models.PositiveSmallIntegerField(default=0, verbose_name='Icon width')),
                ('size_height', models.PositiveSmallIntegerField(default=0, verbose_name='Icon height')),
                ('offset_x', models.DecimalField(decimal_places=1, default=Decimal('0.0'), help_text='Left, right - First time is automatically calculated.', max_digits=3, verbose_name='Offset by axis - X')),
                ('offset_y', models.DecimalField(decimal_places=1, default=Decimal('0.0'), help_text='Up, down - First time is automatically calculated.', max_digits=3, verbose_name='Offset by axis - Y')),
                ('active', models.BooleanField(default=True, help_text='If the project uses 2-3 icons, it makes sense to disable the rest to optimize the download.', verbose_name='Active icon')),
                ('slug', models.SlugField(blank=True, max_length=255, null=True)),
            ],
            options={
                'verbose_name': 'Icons for markers',
                'verbose_name_plural': 'Icons for markers',
                'ordering': ('title', 'id'),
            },
        ),
        migrations.CreateModel(
            name='ExternalModules',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('roundtheme', models.BooleanField(default=False, verbose_name='Round map controls theme')),
                ('heatmap', models.BooleanField(default=False, verbose_name='Heatmap')),
                ('areacalculation', models.BooleanField(default=True, verbose_name='Area Calculation')),
            ],
            options={
                'verbose_name': 'External modules',
                'verbose_name_plural': 'External modules',
            },
        ),
        migrations.CreateModel(
            name='GeneralSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('clustering_edit', models.BooleanField(default=True, verbose_name='Сlustering in editor')),
                ('clustering_site', models.BooleanField(default=True, verbose_name='Сlustering on site')),
                ('cluster_layout', models.CharField(choices=[('cluster#balloonTwoColumns', 'Two Columns'), ('cluster#balloonCarousel', 'Carousel')], default='cluster#balloonTwoColumns', max_length=255, verbose_name='Layout for the cluster information window')),
                ('cluster_icon_content', models.BooleanField(default=True, verbose_name='Display the number of objects in the cluster icon')),
                ('cluster_icon_content_bg_color', models.CharField(default='#ffffff', max_length=255, validators=[djeym.utils.validate_hex_color], verbose_name='Background color')),
                ('cluster_icon_content_txt_color', models.CharField(default='#333333', max_length=255, validators=[djeym.utils.validate_hex_color], verbose_name='Text color')),
                ('disable_site_panel', models.BooleanField(default=False, verbose_name='Disable the panel on the site (button with the image of the gear and the eye in the center)')),
            ],
            options={
                'verbose_name': 'General settings',
                'verbose_name_plural': 'General settings',
            },
        ),
        migrations.CreateModel(
            name='HeatmapSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('radius', models.PositiveIntegerField(default=10, verbose_name='Point radius of influence (px)')),
                ('dissipating', models.BooleanField(default=False, help_text="Enable - Disperse points on higher zoom levels according to radius. Disable - Don't disperse.", verbose_name='Disperse points')),
                ('opacity', models.CharField(choices=[('0', '0'), ('0.1', '0.1'), ('0.2', '0.2'), ('0.3', '0.3'), ('0.4', '0.4'), ('0.5', '0.5'), ('0.6', '0.6'), ('0.7', '0.7'), ('0.8', '0.8'), ('0.9', '0.9'), ('1', '1')], default='0.8', max_length=255, validators=[djeym.utils.validate_transparency], verbose_name='Transparency of heat layer')),
                ('intensity', models.CharField(choices=[('0', '0'), ('0.1', '0.1'), ('0.2', '0.2'), ('0.3', '0.3'), ('0.4', '0.4'), ('0.5', '0.5'), ('0.6', '0.6'), ('0.7', '0.7'), ('0.8', '0.8'), ('0.9', '0.9'), ('1', '1')], default='0.2', max_length=255, validators=[djeym.utils.validate_transparency], verbose_name='Intensity of median point')),
                ('gradient_color1', models.CharField(default='#56db40b3', max_length=255, verbose_name='gradient color 1')),
                ('gradient_color2', models.CharField(default='#ffd21ecc', max_length=255, verbose_name='gradient color 2')),
                ('gradient_color3', models.CharField(default='#ed4543e6', max_length=255, verbose_name='gradient color 3')),
                ('gradient_color4', models.CharField(default='#b22222', max_length=255, verbose_name='gradient color 4')),
            ],
            options={
                'verbose_name': 'Heatmap',
                'verbose_name_plural': 'Heatmap',
            },
        ),
        migrations.CreateModel(
            name='HeatPoint',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(blank=True, default='', max_length=60, verbose_name='Place name')),
                ('weight', models.PositiveIntegerField(blank=True, default=0, help_text='Examples: Average property value on a district site or Number of cameras installed on a building, etc.', verbose_name='Weight')),
                ('coordinates', models.CharField(default='[0,0]', max_length=255, verbose_name='Coordinates')),
                ('active', models.BooleanField(default=True, verbose_name='Active heat point')),
                ('slug', models.SlugField(blank=True, max_length=255, null=True, unique=True)),
                ('json_code', models.TextField(blank=True, default='{"type": "Feature", "id": 0, "geometry": {"type": "Point", "coordinates": []}, "properties": {"weight": 0}}', verbose_name='JSON')),
            ],
            options={
                'verbose_name': 'Thermal points',
                'verbose_name_plural': 'Thermal points',
            },
        ),
        migrations.CreateModel(
            name='IconCollection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(default='', help_text='Example: Light golden Avocado', max_length=60, unique=True, verbose_name='Collection name')),
                ('slug', models.SlugField(blank=True, max_length=255, null=True, unique=True)),
            ],
            options={
                'verbose_name': 'Icon collections for markers',
                'verbose_name_plural': 'Icon collections for markers',
                'ordering': ('title', 'id'),
            },
        ),
        migrations.CreateModel(
            name='Map',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(help_text='Examples: Supermarkets of the city of Kharkov or Hawaii - Oahu Island or Luxury hotels in Honolulu or Parking of primitive people, etc.', max_length=60, unique=True, verbose_name='Title')),
                ('active', models.BooleanField(default=True, verbose_name='Active map')),
                ('zoom', models.PositiveSmallIntegerField(choices=[(0, 0), (1, 1), (2, 2), (3, 3), (4, 4), (5, 5), (6, 6), (7, 7), (8, 8), (9, 9), (10, 10), (11, 11), (12, 12), (13, 13), (14, 14), (15, 15), (16, 16), (17, 17), (18, 18), (19, 19), (20, 20), (21, 21), (22, 22), (23, 23)], default=3, verbose_name='Zoom')),
                ('latitude', models.CharField(default='0', help_text='Latitude center of the map.', max_length=255, validators=[djeym.utils.validate_coordinates], verbose_name='Latitude')),
                ('longitude', models.CharField(default='0', help_text='Longitude center of the map.', max_length=255, validators=[djeym.utils.validate_coordinates], verbose_name='Longitude')),
                ('slug', models.SlugField(blank=True, max_length=255, null=True, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('icon_cluster', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='placemark_custom_cluster', to='djeym.CustomClusterIcon', verbose_name='Icon for cluster')),
                ('icon_collection', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='map_icon_collection', to='djeym.IconCollection', verbose_name='Icon collection for markers')),
            ],
            options={
                'verbose_name': 'Map',
                'verbose_name_plural': 'Map',
                'ordering': ('title',),
            },
        ),
        migrations.CreateModel(
            name='MapControls',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('geolocation', models.BooleanField(default=True, verbose_name='Geolocation')),
                ('search', models.BooleanField(default=True, verbose_name='Search by map')),
                ('provider', models.BooleanField(default=True, verbose_name='Search by organization name')),
                ('route', models.BooleanField(default=True, verbose_name='Routing panel')),
                ('traffic', models.BooleanField(default=True, verbose_name='Traffic jams')),
                ('typeselector', models.BooleanField(default=True, verbose_name='Map Layer Switch')),
                ('fullscreen', models.BooleanField(default=True, verbose_name='Full screen mode')),
                ('zoom', models.BooleanField(default=True, verbose_name='Zoom')),
                ('ruler', models.BooleanField(default=True, verbose_name='Ruler')),
                ('maptype', models.CharField(choices=[('yandex#map', 'Scheme'), ('yandex#satellite', 'Satellite'), ('yandex#hybrid', 'Hybrid')], default='yandex#map', max_length=255, verbose_name='Map type')),
                ('ymap', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='controls', to='djeym.Map', verbose_name='Map')),
            ],
            options={
                'verbose_name_plural': 'Map Controls',
            },
        ),
        migrations.CreateModel(
            name='Placemark',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('header', models.TextField(default='', verbose_name='Place name')),
                ('body', models.TextField(blank=True, default='', verbose_name='Content')),
                ('footer', models.TextField(blank=True, default='', verbose_name='Footer')),
                ('icon_name', models.CharField(default='', max_length=255, verbose_name='Icon name')),
                ('coordinates', models.CharField(default='[0,0]', max_length=255, verbose_name='Coordinates')),
                ('like', models.PositiveIntegerField(blank=True, default=0, verbose_name='Like')),
                ('dislike', models.PositiveIntegerField(blank=True, default=0, verbose_name='Dislike')),
                ('active', models.BooleanField(default=True, verbose_name='Active placemark')),
                ('json_code', models.TextField(blank=True, default='{"type": "Feature", "id": 0, "geometry": {"type": "Point", "coordinates": []}, "properties": {"balloonContentHeader": "", "balloonContentBody": "", "balloonContentFooter": "", "id": 0, "categoryID": 0, "subCategoryIDs": [], "iconName": ""}, "options": {"iconLayout": "default#image", "iconImageHref": "", "iconImageSize": [], "iconImageOffset": []}}', verbose_name='JSON')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('category', smart_selects.db_fields.ChainedForeignKey(auto_choose=True, chained_field='ymap', chained_model_field='ymap', on_delete=django.db.models.deletion.CASCADE, related_name='placemark_category', to='djeym.CategoryPlacemark', verbose_name='Category')),
            ],
            options={
                'verbose_name': 'Placemark',
                'verbose_name_plural': 'Placemarks',
                'ordering': ('-id',),
            },
        ),
        migrations.CreateModel(
            name='Polygon',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('header', models.TextField(default='', verbose_name='Territory name')),
                ('body', models.TextField(blank=True, default='', verbose_name='Content')),
                ('footer', models.TextField(blank=True, default='', verbose_name='Footer')),
                ('stroke_width', models.PositiveIntegerField(default=2, verbose_name='Stroke width')),
                ('stroke_color', models.CharField(default='#1e98ff', max_length=255, validators=[djeym.utils.validate_hex_color], verbose_name='Line color')),
                ('stroke_opacity', models.CharField(choices=[('0', '0'), ('0.1', '0.1'), ('0.2', '0.2'), ('0.3', '0.3'), ('0.4', '0.4'), ('0.5', '0.5'), ('0.6', '0.6'), ('0.7', '0.7'), ('0.8', '0.8'), ('0.9', '0.9'), ('1', '1')], default='0.9', max_length=255, validators=[djeym.utils.validate_transparency], verbose_name='Opacity line')),
                ('fill_color', models.CharField(default='#1e98ff', max_length=255, validators=[djeym.utils.validate_hex_color], verbose_name='Fill color')),
                ('fill_opacity', models.CharField(choices=[('0', '0'), ('0.1', '0.1'), ('0.2', '0.2'), ('0.3', '0.3'), ('0.4', '0.4'), ('0.5', '0.5'), ('0.6', '0.6'), ('0.7', '0.7'), ('0.8', '0.8'), ('0.9', '0.9'), ('1', '1')], default='0.9', max_length=255, validators=[djeym.utils.validate_transparency], verbose_name='Fill opacity')),
                ('coordinates', models.TextField(default='', verbose_name='Coordinates')),
                ('like', models.PositiveIntegerField(blank=True, default=0, verbose_name='Like')),
                ('dislike', models.PositiveIntegerField(blank=True, default=0, verbose_name='Dislike')),
                ('active', models.BooleanField(default=True, verbose_name='Active territory')),
                ('json_code', models.TextField(blank=True, default='{"type": "Feature", "id": 0, "geometry": {"type": "Polygon", "coordinates": []}, "properties": {"balloonContentHeader": "", "balloonContentBody": "", "balloonContentFooter": "", "id": 0, "categoryID": 0}, "options": {"strokeWidth": 2, "strokeColor": "#1e98ff", "strokeOpacity": 0.9, "fillColor": "#1e98ff", "fillOpacity": 0.9}}', verbose_name='JSON')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('category', smart_selects.db_fields.ChainedForeignKey(auto_choose=True, chained_field='ymap', chained_model_field='ymap', on_delete=django.db.models.deletion.CASCADE, related_name='polygon_category', to='djeym.CategoryPolygon', verbose_name='Category')),
                ('ymap', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='polygon_map', to='djeym.Map', verbose_name='Map')),
            ],
            options={
                'verbose_name': 'Territorys',
                'verbose_name_plural': 'Territorys',
                'ordering': ('-id',),
            },
        ),
        migrations.CreateModel(
            name='Polyline',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('header', models.TextField(default='', verbose_name='Route name')),
                ('body', models.TextField(blank=True, default='', verbose_name='Content')),
                ('footer', models.TextField(blank=True, default='', verbose_name='Footer')),
                ('stroke_width', models.PositiveIntegerField(default=5, verbose_name='Stroke width')),
                ('stroke_color', models.CharField(default='#1e98ff', max_length=255, validators=[djeym.utils.validate_hex_color], verbose_name='Line color')),
                ('stroke_opacity', models.CharField(choices=[('0', '0'), ('0.1', '0.1'), ('0.2', '0.2'), ('0.3', '0.3'), ('0.4', '0.4'), ('0.5', '0.5'), ('0.6', '0.6'), ('0.7', '0.7'), ('0.8', '0.8'), ('0.9', '0.9'), ('1', '1')], default='0.9', max_length=255, validators=[djeym.utils.validate_transparency], verbose_name='Opacity line')),
                ('coordinates', models.TextField(default='', verbose_name='Coordinates')),
                ('like', models.PositiveIntegerField(blank=True, default=0, verbose_name='Like')),
                ('dislike', models.PositiveIntegerField(blank=True, default=0, verbose_name='Dislike')),
                ('active', models.BooleanField(default=True, verbose_name='Active route')),
                ('json_code', models.TextField(blank=True, default='{"type": "Feature", "id": 0, "geometry": {"type": "LineString", "coordinates": []}, "properties": {"balloonContentHeader": "", "balloonContentBody": "", "balloonContentFooter": "", "id": 0, "categoryID": 0}, "options": {"strokeWidth": 5, "strokeColor": "#1e98ff", "strokeOpacity": 0.9}}', verbose_name='JSON')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('category', smart_selects.db_fields.ChainedForeignKey(auto_choose=True, chained_field='ymap', chained_model_field='ymap', on_delete=django.db.models.deletion.CASCADE, related_name='polyline_category', to='djeym.CategoryPolyline', verbose_name='Category')),
                ('ymap', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='polyline_map', to='djeym.Map', verbose_name='Map')),
            ],
            options={
                'verbose_name': 'Route',
                'verbose_name_plural': 'Routes',
                'ordering': ('-id',),
            },
        ),
        migrations.CreateModel(
            name='Preset',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(default='', max_length=60, verbose_name='Title')),
                ('icon', models.CharField(blank=True, default='<i class="far fa-smile"></i>', help_text='https://fontawesome.com/icons?d=gallery&m=free - Example: &lt;i class="fab fa-android"&gt;&lt;/i&gt;', max_length=255, verbose_name='Icon (html tag)')),
                ('html', models.TextField(default='<p style="color:#e91e63;">iPreset</p>', verbose_name='HTML')),
                ('js', models.TextField(blank=True, default='', help_text='JavaScript and jQuery', verbose_name='JS')),
                ('description', models.TextField(default='<div>Описание</div>\n<div style="color:#607D8B;">Description</div>', help_text='Brief description of the preset.', verbose_name='Description')),
                ('autoheader', models.BooleanField(default=False, verbose_name='Automatically add to end of header')),
                ('autobody', models.BooleanField(default=False, verbose_name='Automatically add to end of description')),
                ('autofooter', models.BooleanField(default=False, verbose_name='Automatically add to end of footer')),
                ('placemark', models.BooleanField(default=True, verbose_name='Markers')),
                ('polyline', models.BooleanField(default=True, verbose_name='Routes')),
                ('polygon', models.BooleanField(default=True, verbose_name='Territorys')),
                ('position', models.PositiveSmallIntegerField(blank=True, default=0, verbose_name='Position')),
                ('slug', models.SlugField(blank=True, max_length=255, null=True)),
                ('ymap', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='presets', to='djeym.Map', verbose_name='Map')),
            ],
            options={
                'verbose_name': 'Preset',
                'verbose_name_plural': 'Presets',
                'ordering': ('position',),
            },
        ),
        migrations.CreateModel(
            name='Statistics',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('obj_type', models.CharField(default='', max_length=255, verbose_name='Object type')),
                ('obj_id', models.PositiveIntegerField(default=0, verbose_name='Object ID')),
                ('ip', models.GenericIPAddressField(null=True, verbose_name='IP-address')),
                ('likes', models.BooleanField(default=False, verbose_name='Likes')),
                ('timestamp', models.DateTimeField(default=django.utils.timezone.now, verbose_name='Date and Time')),
            ],
            options={
                'verbose_name': 'Record',
                'verbose_name_plural': 'Statistics',
            },
        ),
        migrations.CreateModel(
            name='SubCategoryPlacemark',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(help_text='Subcategory - This is what complements the categories of markers. Examples: Parking or Bicycle Parking or ATM or Cafe or Wi-Fi or Playground, etc.', max_length=60, verbose_name='Title')),
                ('category_icon', models.CharField(blank=True, default='', help_text='https://fontawesome.com/icons?d=gallery&m=free - Example: &lt;i class="fab fa-android"&gt;&lt;/i&gt;', max_length=255, verbose_name='Category Icon (html tag)')),
                ('category_color', models.CharField(default='#ffcc00', help_text='Applies to Checkboxes and Radio Buttons.', max_length=255, validators=[djeym.utils.validate_hex_color], verbose_name='Category color')),
                ('active', models.BooleanField(default=True, verbose_name='Active category')),
                ('ymap', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='subcategory_placemark', to='djeym.Map', verbose_name='Map')),
            ],
            options={
                'verbose_name': 'Subcategory of placemarks',
                'verbose_name_plural': 'Subcategory of placemarks',
                'ordering': ('title',),
            },
        ),
        migrations.CreateModel(
            name='TileSource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(default='', max_length=255, unique=True, verbose_name='Title')),
                ('maxzoom', models.PositiveSmallIntegerField(choices=[(0, 0), (1, 1), (2, 2), (3, 3), (4, 4), (5, 5), (6, 6), (7, 7), (8, 8), (9, 9), (10, 10), (11, 11), (12, 12), (13, 13), (14, 14), (15, 15), (16, 16), (17, 17), (18, 18), (19, 19), (20, 20), (21, 21), (22, 22), (23, 23)], default=12, verbose_name='Maximum zoom')),
                ('minzoom', models.PositiveSmallIntegerField(choices=[(0, 0), (1, 1), (2, 2), (3, 3), (4, 4), (5, 5), (6, 6), (7, 7), (8, 8), (9, 9), (10, 10), (11, 11), (12, 12), (13, 13), (14, 14), (15, 15), (16, 16), (17, 17), (18, 18), (19, 19), (20, 20), (21, 21), (22, 22), (23, 23)], default=0, verbose_name='Minimum zoom')),
                ('source', models.TextField(default='', verbose_name='Source')),
                ('screenshot', models.ImageField(help_text='Recommended size - Width=360 x Height=180', null=True, upload_to=djeym.utils.make_upload_path, validators=[djeym.utils.validate_image], verbose_name='Screenshot')),
                ('copyrights', models.TextField(blank=True, default='', verbose_name='Copyrights')),
                ('site', models.URLField(blank=True, default='', verbose_name='Site')),
                ('apikey', models.CharField(blank=True, default='', help_text='API key or access_token', max_length=255, verbose_name='API Key')),
                ('note', models.TextField(blank=True, default='', verbose_name='Note')),
                ('slug', models.SlugField(blank=True, max_length=255, null=True, unique=True)),
            ],
            options={
                'verbose_name': 'Tile Source',
                'verbose_name_plural': 'Tile Sources',
                'ordering': ('title',),
            },
        ),
        migrations.AddField(
            model_name='placemark',
            name='subcategories',
            field=smart_selects.db_fields.ChainedManyToManyField(blank=True, chained_field='ymap', chained_model_field='ymap', related_name='placemark_subcategories', to='djeym.SubCategoryPlacemark'),
        ),
        migrations.AddField(
            model_name='placemark',
            name='ymap',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='placemark_map', to='djeym.Map', verbose_name='Map'),
        ),
        migrations.AddField(
            model_name='map',
            name='tile',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='maptile', to='djeym.TileSource', verbose_name='Tile Source'),
        ),
        migrations.AddField(
            model_name='heatpoint',
            name='ymap',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='heat_point', to='djeym.Map', verbose_name='Map'),
        ),
        migrations.AddField(
            model_name='heatmapsettings',
            name='ymap',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='heatmap_settings', to='djeym.Map', verbose_name='Map'),
        ),
        migrations.AddField(
            model_name='generalsettings',
            name='ymap',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='general_settings', to='djeym.Map', verbose_name='Map'),
        ),
        migrations.AddField(
            model_name='externalmodules',
            name='ymap',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='external_modules', to='djeym.Map', verbose_name='Map'),
        ),
        migrations.AddField(
            model_name='custommarkericon',
            name='icon_collection',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='icons', to='djeym.IconCollection', verbose_name='Icon Collection'),
        ),
        migrations.AddField(
            model_name='categorypolyline',
            name='ymap',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='category_polyline', to='djeym.Map', verbose_name='Map'),
        ),
        migrations.AddField(
            model_name='categorypolygon',
            name='ymap',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='category_polygon', to='djeym.Map', verbose_name='Map'),
        ),
        migrations.AddField(
            model_name='categoryplacemark',
            name='ymap',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='category_placemark', to='djeym.Map', verbose_name='Map'),
        ),
    ]
