# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field
from fit_tool.profile.profile_type import *


class SegmentFileMessage(DataMessage):
    ID = 151
    NAME = 'segment_file'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=SegmentFileMessage.NAME,
                         global_id=SegmentFileMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             MessageIndexField(
                                 size=self.__get_field_size(definition_message, MessageIndexField.ID),
                                 growable=definition_message is None),
                             SegmentFileFileUuidField(
                                 size=self.__get_field_size(definition_message, SegmentFileFileUuidField.ID),
                                 growable=definition_message is None),
                             SegmentFileEnabledField(
                                 size=self.__get_field_size(definition_message, SegmentFileEnabledField.ID),
                                 growable=definition_message is None),
                             SegmentFileUserProfilePrimaryKeyField(
                                 size=self.__get_field_size(definition_message,
                                                            SegmentFileUserProfilePrimaryKeyField.ID),
                                 growable=definition_message is None),
                             SegmentFileLeaderTypeField(
                                 size=self.__get_field_size(definition_message, SegmentFileLeaderTypeField.ID),
                                 growable=definition_message is None),
                             SegmentFileLeaderGroupPrimaryKeyField(
                                 size=self.__get_field_size(definition_message,
                                                            SegmentFileLeaderGroupPrimaryKeyField.ID),
                                 growable=definition_message is None),
                             SegmentFileLeaderActivityIdField(
                                 size=self.__get_field_size(definition_message, SegmentFileLeaderActivityIdField.ID),
                                 growable=definition_message is None),
                             SegmentFileLeaderActivityIdStringField(
                                 size=self.__get_field_size(definition_message,
                                                            SegmentFileLeaderActivityIdStringField.ID),
                                 growable=definition_message is None),
                             SegmentFileDefaultRaceLeaderField(
                                 size=self.__get_field_size(definition_message, SegmentFileDefaultRaceLeaderField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    @property
    def message_index(self) -> Optional[int]:
        field = self.get_field(MessageIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @message_index.setter
    def message_index(self, value: int):
        field = self.get_field(MessageIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def file_uuid(self) -> Optional[str]:
        field = self.get_field(SegmentFileFileUuidField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @file_uuid.setter
    def file_uuid(self, value: str):
        field = self.get_field(SegmentFileFileUuidField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def enabled(self) -> Optional[bool]:
        field = self.get_field(SegmentFileEnabledField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @enabled.setter
    def enabled(self, value: bool):
        field = self.get_field(SegmentFileEnabledField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def user_profile_primary_key(self) -> Optional[int]:
        field = self.get_field(SegmentFileUserProfilePrimaryKeyField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @user_profile_primary_key.setter
    def user_profile_primary_key(self, value: int):
        field = self.get_field(SegmentFileUserProfilePrimaryKeyField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def leader_type(self) -> Optional[SegmentLeaderboardType]:
        field = self.get_field(SegmentFileLeaderTypeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @leader_type.setter
    def leader_type(self, value: SegmentLeaderboardType):
        field = self.get_field(SegmentFileLeaderTypeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def leader_group_primary_key(self) -> Optional[int]:
        field = self.get_field(SegmentFileLeaderGroupPrimaryKeyField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @leader_group_primary_key.setter
    def leader_group_primary_key(self, value: int):
        field = self.get_field(SegmentFileLeaderGroupPrimaryKeyField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def leader_activity_id(self) -> Optional[int]:
        field = self.get_field(SegmentFileLeaderActivityIdField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @leader_activity_id.setter
    def leader_activity_id(self, value: int):
        field = self.get_field(SegmentFileLeaderActivityIdField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def leader_activity_id_string(self) -> Optional[str]:
        field = self.get_field(SegmentFileLeaderActivityIdStringField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @leader_activity_id_string.setter
    def leader_activity_id_string(self, value: str):
        field = self.get_field(SegmentFileLeaderActivityIdStringField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def default_race_leader(self) -> Optional[int]:
        field = self.get_field(SegmentFileDefaultRaceLeaderField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @default_race_leader.setter
    def default_race_leader(self, value: int):
        field = self.get_field(SegmentFileDefaultRaceLeaderField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class MessageIndexField(Field):
    ID = 254

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='message_index',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentFileFileUuidField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='file_uuid',
            field_id=self.ID,
            base_type=BaseType.STRING,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentFileEnabledField(Field):
    ID = 3

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='enabled',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentFileUserProfilePrimaryKeyField(Field):
    ID = 4

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='user_profile_primary_key',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentFileLeaderTypeField(Field):
    ID = 7

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='leader_type',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentFileLeaderGroupPrimaryKeyField(Field):
    ID = 8

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='leader_group_primary_key',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentFileLeaderActivityIdField(Field):
    ID = 9

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='leader_activity_id',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentFileLeaderActivityIdStringField(Field):
    ID = 10

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='leader_activity_id_string',
            field_id=self.ID,
            base_type=BaseType.STRING,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SegmentFileDefaultRaceLeaderField(Field):
    ID = 11

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='default_race_leader',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )
