# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field
from fit_tool.profile.profile_type import *


class DeviceSettingsMessage(DataMessage):
    ID = 2
    NAME = 'device_settings'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=DeviceSettingsMessage.NAME,
                         global_id=DeviceSettingsMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             DeviceSettingsActiveTimeZoneField(
                                 size=self.__get_field_size(definition_message, DeviceSettingsActiveTimeZoneField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsUtcOffsetField(
                                 size=self.__get_field_size(definition_message, DeviceSettingsUtcOffsetField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsTimeOffsetField(
                                 size=self.__get_field_size(definition_message, DeviceSettingsTimeOffsetField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsTimeModeField(
                                 size=self.__get_field_size(definition_message, DeviceSettingsTimeModeField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsTimeZoneOffsetField(
                                 size=self.__get_field_size(definition_message, DeviceSettingsTimeZoneOffsetField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsBacklightModeField(
                                 size=self.__get_field_size(definition_message, DeviceSettingsBacklightModeField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsActivityTrackerEnabledField(
                                 size=self.__get_field_size(definition_message,
                                                            DeviceSettingsActivityTrackerEnabledField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsClockTimeField(
                                 size=self.__get_field_size(definition_message, DeviceSettingsClockTimeField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsPagesEnabledField(
                                 size=self.__get_field_size(definition_message, DeviceSettingsPagesEnabledField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsMoveAlertEnabledField(
                                 size=self.__get_field_size(definition_message, DeviceSettingsMoveAlertEnabledField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsDateModeField(
                                 size=self.__get_field_size(definition_message, DeviceSettingsDateModeField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsDisplayOrientationField(
                                 size=self.__get_field_size(definition_message,
                                                            DeviceSettingsDisplayOrientationField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsMountingSideField(
                                 size=self.__get_field_size(definition_message, DeviceSettingsMountingSideField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsDefaultPageField(
                                 size=self.__get_field_size(definition_message, DeviceSettingsDefaultPageField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsAutosyncMinStepsField(
                                 size=self.__get_field_size(definition_message, DeviceSettingsAutosyncMinStepsField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsAutosyncMinTimeField(
                                 size=self.__get_field_size(definition_message, DeviceSettingsAutosyncMinTimeField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsLactateThresholdAutodetectEnabledField(
                                 size=self.__get_field_size(definition_message,
                                                            DeviceSettingsLactateThresholdAutodetectEnabledField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsBleAutoUploadEnabledField(
                                 size=self.__get_field_size(definition_message,
                                                            DeviceSettingsBleAutoUploadEnabledField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsAutoSyncFrequencyField(
                                 size=self.__get_field_size(definition_message,
                                                            DeviceSettingsAutoSyncFrequencyField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsAutoActivityDetectField(
                                 size=self.__get_field_size(definition_message,
                                                            DeviceSettingsAutoActivityDetectField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsNumberOfScreensField(
                                 size=self.__get_field_size(definition_message, DeviceSettingsNumberOfScreensField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsSmartNotificationDisplayOrientationField(
                                 size=self.__get_field_size(definition_message,
                                                            DeviceSettingsSmartNotificationDisplayOrientationField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsTapInterfaceField(
                                 size=self.__get_field_size(definition_message, DeviceSettingsTapInterfaceField.ID),
                                 growable=definition_message is None),
                             DeviceSettingsTapSensitivityField(
                                 size=self.__get_field_size(definition_message, DeviceSettingsTapSensitivityField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    @property
    def active_time_zone(self) -> Optional[int]:
        field = self.get_field(DeviceSettingsActiveTimeZoneField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @active_time_zone.setter
    def active_time_zone(self, value: int):
        field = self.get_field(DeviceSettingsActiveTimeZoneField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def utc_offset(self) -> Optional[int]:
        field = self.get_field(DeviceSettingsUtcOffsetField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @utc_offset.setter
    def utc_offset(self, value: int):
        field = self.get_field(DeviceSettingsUtcOffsetField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def time_offset(self) -> Optional[int]:
        field = self.get_field(DeviceSettingsTimeOffsetField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @time_offset.setter
    def time_offset(self, value: int):
        field = self.get_field(DeviceSettingsTimeOffsetField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def time_mode(self) -> Optional[TimeMode]:
        field = self.get_field(DeviceSettingsTimeModeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @time_mode.setter
    def time_mode(self, value: TimeMode):
        field = self.get_field(DeviceSettingsTimeModeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def time_zone_offset(self) -> Optional[float]:
        field = self.get_field(DeviceSettingsTimeZoneOffsetField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @time_zone_offset.setter
    def time_zone_offset(self, value: float):
        field = self.get_field(DeviceSettingsTimeZoneOffsetField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def backlight_mode(self) -> Optional[BacklightMode]:
        field = self.get_field(DeviceSettingsBacklightModeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @backlight_mode.setter
    def backlight_mode(self, value: BacklightMode):
        field = self.get_field(DeviceSettingsBacklightModeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def activity_tracker_enabled(self) -> Optional[bool]:
        field = self.get_field(DeviceSettingsActivityTrackerEnabledField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @activity_tracker_enabled.setter
    def activity_tracker_enabled(self, value: bool):
        field = self.get_field(DeviceSettingsActivityTrackerEnabledField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @property
    def clock_time(self) -> Optional[int]:
        field = self.get_field(DeviceSettingsClockTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @clock_time.setter
    def clock_time(self, value: int):
        field = self.get_field(DeviceSettingsClockTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def pages_enabled(self) -> Optional[int]:
        field = self.get_field(DeviceSettingsPagesEnabledField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @pages_enabled.setter
    def pages_enabled(self, value: int):
        field = self.get_field(DeviceSettingsPagesEnabledField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def move_alert_enabled(self) -> Optional[bool]:
        field = self.get_field(DeviceSettingsMoveAlertEnabledField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @move_alert_enabled.setter
    def move_alert_enabled(self, value: bool):
        field = self.get_field(DeviceSettingsMoveAlertEnabledField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def date_mode(self) -> Optional[DateMode]:
        field = self.get_field(DeviceSettingsDateModeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @date_mode.setter
    def date_mode(self, value: DateMode):
        field = self.get_field(DeviceSettingsDateModeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def display_orientation(self) -> Optional[DisplayOrientation]:
        field = self.get_field(DeviceSettingsDisplayOrientationField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @display_orientation.setter
    def display_orientation(self, value: DisplayOrientation):
        field = self.get_field(DeviceSettingsDisplayOrientationField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def mounting_side(self) -> Optional[Side]:
        field = self.get_field(DeviceSettingsMountingSideField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @mounting_side.setter
    def mounting_side(self, value: Side):
        field = self.get_field(DeviceSettingsMountingSideField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def default_page(self) -> Optional[int]:
        field = self.get_field(DeviceSettingsDefaultPageField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @default_page.setter
    def default_page(self, value: int):
        field = self.get_field(DeviceSettingsDefaultPageField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def autosync_min_steps(self) -> Optional[int]:
        field = self.get_field(DeviceSettingsAutosyncMinStepsField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @autosync_min_steps.setter
    def autosync_min_steps(self, value: int):
        field = self.get_field(DeviceSettingsAutosyncMinStepsField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def autosync_min_time(self) -> Optional[int]:
        field = self.get_field(DeviceSettingsAutosyncMinTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @autosync_min_time.setter
    def autosync_min_time(self, value: int):
        field = self.get_field(DeviceSettingsAutosyncMinTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def lactate_threshold_autodetect_enabled(self) -> Optional[bool]:
        field = self.get_field(DeviceSettingsLactateThresholdAutodetectEnabledField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @lactate_threshold_autodetect_enabled.setter
    def lactate_threshold_autodetect_enabled(self, value: bool):
        field = self.get_field(DeviceSettingsLactateThresholdAutodetectEnabledField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def ble_auto_upload_enabled(self) -> Optional[bool]:
        field = self.get_field(DeviceSettingsBleAutoUploadEnabledField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @ble_auto_upload_enabled.setter
    def ble_auto_upload_enabled(self, value: bool):
        field = self.get_field(DeviceSettingsBleAutoUploadEnabledField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def auto_sync_frequency(self) -> Optional[AutoSyncFrequency]:
        field = self.get_field(DeviceSettingsAutoSyncFrequencyField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @auto_sync_frequency.setter
    def auto_sync_frequency(self, value: AutoSyncFrequency):
        field = self.get_field(DeviceSettingsAutoSyncFrequencyField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def auto_activity_detect(self) -> Optional[int]:
        field = self.get_field(DeviceSettingsAutoActivityDetectField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @auto_activity_detect.setter
    def auto_activity_detect(self, value: int):
        field = self.get_field(DeviceSettingsAutoActivityDetectField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def number_of_screens(self) -> Optional[int]:
        field = self.get_field(DeviceSettingsNumberOfScreensField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @number_of_screens.setter
    def number_of_screens(self, value: int):
        field = self.get_field(DeviceSettingsNumberOfScreensField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def smart_notification_display_orientation(self) -> Optional[DisplayOrientation]:
        field = self.get_field(DeviceSettingsSmartNotificationDisplayOrientationField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @smart_notification_display_orientation.setter
    def smart_notification_display_orientation(self, value: DisplayOrientation):
        field = self.get_field(DeviceSettingsSmartNotificationDisplayOrientationField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def tap_interface(self) -> Optional[SwitchType]:
        field = self.get_field(DeviceSettingsTapInterfaceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @tap_interface.setter
    def tap_interface(self, value: SwitchType):
        field = self.get_field(DeviceSettingsTapInterfaceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def tap_sensitivity(self) -> Optional[TapSensitivity]:
        field = self.get_field(DeviceSettingsTapSensitivityField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @tap_sensitivity.setter
    def tap_sensitivity(self, value: TapSensitivity):
        field = self.get_field(DeviceSettingsTapSensitivityField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class DeviceSettingsActiveTimeZoneField(Field):
    ID = 0

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='active_time_zone',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsUtcOffsetField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='utc_offset',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsTimeOffsetField(Field):
    ID = 2

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='time_offset',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsTimeModeField(Field):
    ID = 4

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='time_mode',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsTimeZoneOffsetField(Field):
    ID = 5

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='time_zone_offset',
            field_id=self.ID,
            base_type=BaseType.SINT8,
            offset=0,
            scale=4,
            size=size,
            units='hr',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsBacklightModeField(Field):
    ID = 12

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='backlight_mode',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsActivityTrackerEnabledField(Field):
    ID = 36

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='activity_tracker_enabled',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsClockTimeField(Field):
    ID = 39

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='clock_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=-631065600000,
            scale=0.001,
            size=size,
            units='ms',
            type_name='date_time',
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsPagesEnabledField(Field):
    ID = 40

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='pages_enabled',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsMoveAlertEnabledField(Field):
    ID = 46

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='move_alert_enabled',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsDateModeField(Field):
    ID = 47

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='date_mode',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsDisplayOrientationField(Field):
    ID = 55

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='display_orientation',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsMountingSideField(Field):
    ID = 56

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='mounting_side',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsDefaultPageField(Field):
    ID = 57

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='default_page',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsAutosyncMinStepsField(Field):
    ID = 58

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='autosync_min_steps',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='steps',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsAutosyncMinTimeField(Field):
    ID = 59

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='autosync_min_time',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='minutes',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsLactateThresholdAutodetectEnabledField(Field):
    ID = 80

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='lactate_threshold_autodetect_enabled',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsBleAutoUploadEnabledField(Field):
    ID = 86

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='ble_auto_upload_enabled',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsAutoSyncFrequencyField(Field):
    ID = 89

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='auto_sync_frequency',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsAutoActivityDetectField(Field):
    ID = 90

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='auto_activity_detect',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsNumberOfScreensField(Field):
    ID = 94

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='number_of_screens',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsSmartNotificationDisplayOrientationField(Field):
    ID = 95

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='smart_notification_display_orientation',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsTapInterfaceField(Field):
    ID = 134

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='tap_interface',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class DeviceSettingsTapSensitivityField(Field):
    ID = 174

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='tap_sensitivity',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=1,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )
