# Generated by ../generate_metasyntax.py
"""
# Grammar definition:
```
import ast
import textwrap
```

ignored Space = @/[ \\t]+/
ignored Comment = @/#[^\\r\\n]*/

Newline = @/[\\r\\n][\\s]*/
Sep = Some(Newline | ";")
Name = @/[_a-zA-Z][_a-zA-Z0-9]*/
Comma = wrap(",")

wrap(x) => Skip(Newline) >> x << Skip(Newline)

# Parse a full word, then see if it matches our keyword. The point is to make
# sure that we don't simply match the first part of a word. (For example, if
# the input string is "classify", we wouldn't want to match the keyword "class".)
kw(word) => Name where `lambda x: x == word`

Params = wrap("(") >> (wrap(Name) / Comma) << ")"

class StringLiteral {
    value: (
        @/(?s)(\"\"\"([^\\\\]|\\\\.)*?\"\"\")/
        | @/(?s)('''([^\\\\]|\\\\.)*?''')/
        | @/("([^"\\\\]|\\\\.)*")/
        | @/('([^'\\\\]|\\\\.)*')/
    ) |> `ast.literal_eval`
}

class RegexLiteral {
    # Remove the leading "@/" and the trailing "/".
    value: @/\\@\\/([^\\/\\\\]|\\\\.)*\\// |> `lambda x: x[2:-1]`
}

class PythonSection {
    # Strip the backticks and remove any common indentation.
    value: @/(?s)```.*?```/ |> `lambda x: textwrap.dedent(x[3:-3])`
}

class PythonExpression {
    # Strip the backticks.
    value: @/`.*?`/ |> `lambda x: x[1:-1]`
}

class RuleDef {
    is_ignored: Opt(kw("ignored") | kw("ignore")) |> `bool`
    name: Name
    params: Opt(Params) << wrap("=>" | "=" | ":")
    expr: Expr
}

class ClassDef {
    name: kw("class") >> Name
    params: Opt(Params)
    fields: wrap("{") >> (RuleDef / Sep) << "}"
}

Stmt = ClassDef
    | RuleDef
    | PythonSection
    | PythonExpression

class LetExpression {
    name: kw("let") >> Name << wrap("=")
    expr: Expr << wrap(kw("in"))
    body: Expr
}

class Ref {
    value: Name
}

class ListLiteral {
    elements: "[" >> (wrap(Expr) / Comma) << "]"
}

Atom = ("(" >> wrap(Expr) << ")")
    | LetExpression
    | Ref
    | StringLiteral
    | RegexLiteral
    | ListLiteral
    | PythonExpression

class KeywordArg {
    name: Name << ("=" | ":")
    expr: Expr
}

class ArgList {
    args: "(" >> (wrap(KeywordArg | Expr) / Comma) << ")"
}

Expr = OperatorPrecedence(
    Atom,
    Postfix(ArgList),
    Postfix("?" | "*" | "+"),
    LeftAssoc(wrap("//" | "/")),
    LeftAssoc(wrap("<<" | ">>")),
    LeftAssoc(wrap("<|" | "|>" | "where")),
    LeftAssoc(wrap("|")),
)

start = Skip(Newline) >> (Stmt / Sep)

"""

from collections import namedtuple as _nt
from re import compile as _compile_re



class Node:
    _fields = ()

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for field in self._fields:
            if getattr(self, field) != getattr(other, field):
                return False
        return True

    def _asdict(self):
        return {k: getattr(self, k) for k in self._fields}

    def _replace(self, **kw):
        for field in self._fields:
            if field not in kw:
                kw[field] = getattr(self, field)
        return self.__class__(**kw)


class Rule:
    def __init__(self, name, parse, definition):
        self.name = name
        self.parse = parse
        self.definition = definition

    def __repr__(self):
        return (f'Rule(name={self.name!r}, parse={self.parse.__name__},'
            f' definition={self.definition!r})')



import ast
import textwrap



class ParseError(Exception):
    def __init__(self, message, index, line, column):
        super().__init__(message)
        self.position = _Position(index, line, column)


class PartialParseError(Exception):
    def __init__(self, partial_result, last_position, excerpt):
        super().__init__('Incomplete parse. Unexpected input on line'
            f' {last_position.line}, column {last_position.column}:\n{excerpt}')
        self.partial_result = partial_result
        self.last_position = last_position


class Infix(Node):
    _fields = ('left', 'operator', 'right')

    def __init__(self, left, operator, right):
        self.left = left
        self.operator = operator
        self.right = right

    def __repr__(self):
        return f'Infix({self.left!r}, {self.operator!r}, {self.right!r})'


class Postfix(Node):
    _fields = ('left', 'operator')

    def __init__(self, left, operator):
        self.left = left
        self.operator = operator

    def __repr__(self):
        return f'Postfix({self.left!r}, {self.operator!r})'


class Prefix(Node):
    _fields = ('operator', 'right')

    def __init__(self, operator, right):
        self.operator = operator
        self.right = right

    def __repr__(self):
        return f'Prefix({self.operator!r}, {self.right!r})'


def parse(text, pos=0, fullparse=True):
    return _run(text, pos, _cont_start, fullparse)


_PositionInfo = _nt('_PositionInfo', 'start, end')

_Position = _nt('_Position', 'index, line, column')


class _ParseFunction(_nt('_ParseFunction', 'func, args, kwargs')):
    def __call__(self, _text, _pos):
        return self.func(_text, _pos, *self.args, **dict(self.kwargs))


class _StringLiteral(str):
    def __call__(self, _text, _pos):
        return self._parse_function(_text, _pos)


def _wrap_string_literal(string_value, parse_function):
    result = _StringLiteral(string_value)
    result._parse_function = parse_function
    return result


def _run(text, pos, start, fullparse):
    memo = {}
    result = None

    key = (3, start, pos)
    gtor = start(text, pos)
    stack = [(key, gtor)]

    while stack:
        key, gtor = stack[-1]
        result = gtor.send(result)

        if result[0] != 3:
            stack.pop()
            memo[key] = result
        elif result in memo:
            result = memo[result]
        else:
            gtor = result[1](text, result[2])
            stack.append((result, gtor))
            result = None

    if result[0]:
        return _finalize_parse_info(text, result[1], result[2], fullparse)
    else:
        pos = result[2]
        message = result[1](text, pos)
        raise ParseError(message, pos)


def visit(node):
    if isinstance(node, list):
        yield from node

    elif isinstance(node, Node):
        yield node

        if hasattr(node, '_fields'):
            for field in node._fields:
                yield from visit(getattr(node, field))


def transform(node, *callbacks):
    if not callbacks:
        return node

    if len(callbacks) == 1:
        callback = callbacks[0]
    else:
        def callback(node):
            for f in callbacks:
                node = f(node)
            return node

    return _transform(node, callback)


def _transform(node, callback):
    if isinstance(node, list):
        return [_transform(x, callback) for x in node]

    if not isinstance(node, Node):
        return node

    updates = {}
    for field in node._fields:
        was = getattr(node, field)
        now = _transform(was, callback)
        if was is not now:
            updates[field] = now

    if updates:
        node = node._replace(**updates)

    return callback(node)


def _finalize_parse_info(text, nodes, pos, fullparse):
    line_numbers, column_numbers = _map_index_to_line_and_column(text)

    for node in visit(nodes):
        parse_info = getattr(node, '_position_info', None)
        if parse_info:
            start, end = parse_info
            end -= 1
            node._position_info = _PositionInfo(
                start=_Position(start, line_numbers[start], column_numbers[start]),
                end=_Position(end, line_numbers[end], column_numbers[end]),
            )

    if fullparse and pos < len(text):
        line, col = line_numbers[pos], column_numbers[pos]
        position = _Position(pos, line, col)
        excerpt = _extract_excerpt(text, pos, col)
        raise PartialParseError(nodes, position, excerpt)

    return nodes


def _extract_excerpt(text, pos, col):
    start = pos - (col - 1)
    match = _compile_re('\n').search(text, pos + 1)
    end = len(text) if match is None else match.start()

    if end - start < 96:
        return text[start : end] + _caret_at(col - 1)

    if col < 60:
        # Chop the line off at the end.
        return text[start : start + 90] + ' ...' + _caret_at(col - 1)

    elif end - pos < 40:
        # Chop the line off at the start.
        return '... ' + text[end - 90 : end] + _caret_at(pos - (end - 90) + 4)

    else:
        # Chop the line off at both ends.
        return '... ' + text[pos - 42 : pos + 42] + ' ...' + _caret_at(42 + 4)


def _caret_at(index):
    return '\n' + (' ' * index) + '^'


def _get_line_and_column(text, pos):
    line_numbers, column_numbers = _map_index_to_line_and_column(text)
    return line_numbers[pos], column_numbers[pos]


def _map_index_to_line_and_column(text):
    line_numbers = []
    column_numbers = []

    current_line = 1
    current_column = 0

    for c in text:
        if c == '\n':
            current_line += 1
            current_column = 0
        else:
            current_column += 1
        line_numbers.append(current_line)
        column_numbers.append(current_column)

    return line_numbers, column_numbers



matcher1 = _compile_re('[ \\t]+').match
matcher2 = _compile_re('#[^\\r\\n]*').match
matcher3 = _compile_re('[\\r\\n][\\s]*').match
matcher4 = _compile_re('[_a-zA-Z][_a-zA-Z0-9]*').match
matcher5 = _compile_re('(?s)("""([^\\\\]|\\\\.)*?""")').match
matcher6 = _compile_re("(?s)('''([^\\\\]|\\\\.)*?''')").match
matcher7 = _compile_re('("([^"\\\\]|\\\\.)*")').match
matcher8 = _compile_re("('([^'\\\\]|\\\\.)*')").match
matcher9 = _compile_re('\\@\\/([^\\/\\\\]|\\\\.)*\\/').match
matcher10 = _compile_re('(?s)```.*?```').match
matcher11 = _compile_re('`.*?`').match


def _cont_Space(_text, _pos):
    # Rule 'Space'
    # <Regex pattern='[ \\t]+'>
    match1 = matcher1(_text, _pos)
    if match1:
        _pos = match1.end()
        _status = True
        _result = match1.group(0)
    else:
        _status = False
        _result = _raise_error2
    # </Regex>
    (yield (_status, _result, _pos,))


def _parse_Space(text, pos=0, fullparse=True):
    return _run(text, pos, _cont_Space, fullparse)


Space = Rule('Space', _parse_Space, """
    Space = @/[ \\t]+/
""")

def _raise_error2(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Space' rule, at the expression:\n"
    '    @/[ \\\\t]+/\n\n'
    'Expected to match the regular expression /[ \\t]+/'
    )
    raise ParseError((title + details), _pos, line, col)


def _cont_Comment(_text, _pos):
    # Rule 'Comment'
    # <Regex pattern='#[^\\r\\n]*'>
    match2 = matcher2(_text, _pos)
    if match2:
        _pos = match2.end()
        _status = True
        _result = match2.group(0)
    else:
        _status = False
        _result = _raise_error4
    # </Regex>
    (yield (_status, _result, _pos,))


def _parse_Comment(text, pos=0, fullparse=True):
    return _run(text, pos, _cont_Comment, fullparse)


Comment = Rule('Comment', _parse_Comment, """
    Comment = @/#[^\\r\\n]*/
""")

def _raise_error4(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Comment' rule, at the expression:\n"
    '    @/#[^\\\\r\\\\n]*/\n\n'
    'Expected to match the regular expression /#[^\\r\\n]*/'
    )
    raise ParseError((title + details), _pos, line, col)


def _cont_Newline(_text, _pos):
    # Rule 'Newline'
    # <Regex pattern='[\\r\\n][\\s]*'>
    match3 = matcher3(_text, _pos)
    if match3:
        _pos = (yield (3, _cont__ignored, match3.end(),))[2]
        _status = True
        _result = match3.group(0)
    else:
        _status = False
        _result = _raise_error6
    # </Regex>
    (yield (_status, _result, _pos,))


def _parse_Newline(text, pos=0, fullparse=True):
    return _run(text, pos, _cont_Newline, fullparse)


Newline = Rule('Newline', _parse_Newline, """
    Newline = @/[\\r\\n][\\s]*/
""")

def _raise_error6(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Newline' rule, at the expression:\n"
    '    @/[\\\\r\\\\n][\\\\s]*/\n\n'
    'Expected to match the regular expression /[\\r\\n][\\s]*/'
    )
    raise ParseError((title + details), _pos, line, col)


def _cont_Sep(_text, _pos):
    # Rule 'Sep'
    # <List>
    # (Newline | ';')+
    staging1 = []
    while True:
        checkpoint1 = _pos
        # <Choice>
        backtrack1 = farthest_pos1 = _pos
        farthest_err1 = 9
        farthest_err2 = _raise_error9
        while True:
            # Option 1:
            # <Ref name='Newline'>
            (_status, _result, _pos,) = (yield (3, _cont_Newline, _pos,))
            # </Ref>
            if _status:
                break
            if (farthest_pos1 < _pos):
                farthest_pos1 = _pos
                farthest_err2 = _result
            _pos = backtrack1
            # Option 2:
            # <String value=';'>
            value1 = ';'
            end1 = (_pos + 1)
            if (_text[_pos : end1] == value1):
                _pos = (yield (3, _cont__ignored, end1,))[2]
                _status = True
                _result = value1
            else:
                _status = False
                _result = _raise_error11
            # </String>
            if _status:
                break
            if (farthest_pos1 < _pos):
                farthest_pos1 = _pos
                farthest_err2 = _result
            _pos = farthest_pos1
            _result = farthest_err2
            break
        # </Choice>
        if (not _status):
            _pos = checkpoint1
            break
        staging1.append(_result)
    if staging1:
        _result = staging1
        _status = True
    # </List>
    (yield (_status, _result, _pos,))


def _parse_Sep(text, pos=0, fullparse=True):
    return _run(text, pos, _cont_Sep, fullparse)


Sep = Rule('Sep', _parse_Sep, """
    Sep = (Newline | ';')+
""")

def _raise_error9(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Sep' rule, at the expression:\n"
    "    Newline | ';'\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error11(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Sep' rule, at the expression:\n"
    "    ';'\n\n"
    "Expected to match the string ';'"
    )
    raise ParseError((title + details), _pos, line, col)


def _cont_Name(_text, _pos):
    # Rule 'Name'
    # <Regex pattern='[_a-zA-Z][_a-zA-Z0-9]*'>
    match4 = matcher4(_text, _pos)
    if match4:
        _pos = (yield (3, _cont__ignored, match4.end(),))[2]
        _status = True
        _result = match4.group(0)
    else:
        _status = False
        _result = _raise_error13
    # </Regex>
    (yield (_status, _result, _pos,))


def _parse_Name(text, pos=0, fullparse=True):
    return _run(text, pos, _cont_Name, fullparse)


Name = Rule('Name', _parse_Name, """
    Name = @/[_a-zA-Z][_a-zA-Z0-9]*/
""")

def _raise_error13(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Name' rule, at the expression:\n"
    '    @/[_a-zA-Z][_a-zA-Z0-9]*/\n\n'
    'Expected to match the regular expression /[_a-zA-Z][_a-zA-Z0-9]*/'
    )
    raise ParseError((title + details), _pos, line, col)


def _parse_function_17(_text, _pos):
    # <String value=','>
    value2 = ','
    end2 = (_pos + 1)
    if (_text[_pos : end2] == value2):
        _pos = (yield (3, _cont__ignored, end2,))[2]
        _status = True
        _result = value2
    else:
        _status = False
        _result = _raise_error17
    # </String>
    (yield (_status, _result, _pos,))


def _cont_Comma(_text, _pos):
    # Rule 'Comma'
    # <Call>
    # wrap(',')
    arg1 = _wrap_string_literal(',', _parse_function_17)
    func1 = _ParseFunction(_cont_wrap, (arg1,), ())
    (_status, _result, _pos,) = (yield (3, func1, _pos,))
    # </Call>
    (yield (_status, _result, _pos,))


def _parse_Comma(text, pos=0, fullparse=True):
    return _run(text, pos, _cont_Comma, fullparse)


Comma = Rule('Comma', _parse_Comma, """
    Comma = wrap(',')
""")

def _raise_error17(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Comma' rule, at the expression:\n"
    "    ','\n\n"
    "Expected to match the string ','"
    )
    raise ParseError((title + details), _pos, line, col)


def _cont_wrap(_text, _pos, x):
    # Rule 'wrap'
    # <Discard>
    # (Skip(Newline) >> x) << Skip(Newline)
    while True:
        # <Discard>
        # Skip(Newline) >> x
        while True:
            # <Skip>
            # Skip(Newline)
            while True:
                checkpoint2 = _pos
                # <Ref name='Newline'>
                (_status, _result, _pos,) = (yield (3, _cont_Newline, _pos,))
                # </Ref>
                if _status:
                    continue
                else:
                    _pos = checkpoint2
                break
            _status = True
            _result = None
            # </Skip>
            # <Ref name='x'>
            (_status, _result, _pos,) = (yield (3, x, _pos,))
            # </Ref>
            break
        # </Discard>
        if (not _status):
            break
        staging2 = _result
        # <Skip>
        # Skip(Newline)
        while True:
            checkpoint3 = _pos
            # <Ref name='Newline'>
            (_status, _result, _pos,) = (yield (3, _cont_Newline, _pos,))
            # </Ref>
            if _status:
                continue
            else:
                _pos = checkpoint3
            break
        _status = True
        _result = None
        # </Skip>
        _result = staging2
        break
    # </Discard>
    (yield (_status, _result, _pos,))


def _parse_wrap(text, pos=0, fullparse=True):
    return _run(text, pos, _cont_wrap, fullparse)


wrap = Rule('wrap', _parse_wrap, """
    wrap(x) = (Skip(Newline) >> x) << Skip(Newline)
""")

def _cont_kw(_text, _pos, word):
    # Rule 'kw'
    # <Where>
    # Name where `lambda x: x == word`
    # <Ref name='Name'>
    (_status, _result, _pos,) = (yield (3, _cont_Name, _pos,))
    # </Ref>
    if _status:
        arg2 = _result
        _result = lambda x: x == word
        _status = True
        if _result(arg2):
            _result = arg2
        else:
            _status = False
            _result = _raise_error27
    # </Where>
    (yield (_status, _result, _pos,))


def _parse_kw(text, pos=0, fullparse=True):
    return _run(text, pos, _cont_kw, fullparse)


kw = Rule('kw', _parse_kw, """
    kw(word) = Name where `lambda x: x == word`
""")

def _raise_error27(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'kw' rule, at the expression:\n"
    '    Name where `lambda x: x == word`\n\n'
    'Expected to satisfy the predicate: `lambda x: x == word`'
    )
    raise ParseError((title + details), _pos, line, col)


def _parse_function_35(_text, _pos):
    # <String value='('>
    value3 = '('
    end3 = (_pos + 1)
    if (_text[_pos : end3] == value3):
        _pos = (yield (3, _cont__ignored, end3,))[2]
        _status = True
        _result = value3
    else:
        _status = False
        _result = _raise_error35
    # </String>
    (yield (_status, _result, _pos,))


def _cont_Params(_text, _pos):
    # Rule 'Params'
    # <Discard>
    # (wrap('(') >> (wrap(Name) / Comma)) << ')'
    while True:
        # <Discard>
        # wrap('(') >> (wrap(Name) / Comma)
        while True:
            # <Call>
            # wrap('(')
            arg3 = _wrap_string_literal('(', _parse_function_35)
            func2 = _ParseFunction(_cont_wrap, (arg3,), ())
            (_status, _result, _pos,) = (yield (3, func2, _pos,))
            # </Call>
            if (not _status):
                break
            # <Alt>
            # wrap(Name) / Comma
            staging3 = []
            checkpoint4 = _pos
            while True:
                # <Call>
                # wrap(Name)
                func3 = _ParseFunction(_cont_wrap, (_cont_Name,), ())
                (_status, _result, _pos,) = (yield (3, func3, _pos,))
                # </Call>
                if (not _status):
                    break
                staging3.append(_result)
                checkpoint4 = _pos
                # <Ref name='Comma'>
                (_status, _result, _pos,) = (yield (3, _cont_Comma, _pos,))
                # </Ref>
                if (not _status):
                    break
                checkpoint4 = _pos
            _result = staging3
            _status = True
            _pos = checkpoint4
            # </Alt>
            break
        # </Discard>
        if (not _status):
            break
        staging4 = _result
        # <String value=')'>
        value4 = ')'
        end4 = (_pos + 1)
        if (_text[_pos : end4] == value4):
            _pos = (yield (3, _cont__ignored, end4,))[2]
            _status = True
            _result = value4
        else:
            _status = False
            _result = _raise_error41
        # </String>
        if _status:
            _result = staging4
        break
    # </Discard>
    (yield (_status, _result, _pos,))


def _parse_Params(text, pos=0, fullparse=True):
    return _run(text, pos, _cont_Params, fullparse)


Params = Rule('Params', _parse_Params, """
    Params = (wrap('(') >> (wrap(Name) / Comma)) << ')'
""")

def _raise_error35(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Params' rule, at the expression:\n"
    "    '('\n\n"
    "Expected to match the string '('"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error41(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Params' rule, at the expression:\n"
    "    ')'\n\n"
    "Expected to match the string ')'"
    )
    raise ParseError((title + details), _pos, line, col)


class StringLiteral(Node):
    """
    class StringLiteral {
        value: (@/(?s)(\"\"\"([^\\\\]|\\\\.)*?\"\"\")/ | @/(?s)('''([^\\\\]|\\\\.)*?''')/ | @/("([^"\\\\]|\\\\.)*")/ | @/('([^'\\\\]|\\\\.)*')/) |> `ast.literal_eval`
    }
    """
    _fields = ('value',)

    def __init__(self, value):
        self.value = value
        self._position_info = None

    def __repr__(self):
        return f'StringLiteral(value={self.value!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _cont_StringLiteral, fullparse)



def _cont_StringLiteral(_text, _pos):
    # <Seq>
    start_pos1 = _pos
    while True:
        # <Apply>
        # (@/(?s)("""([^\\\\]|\\\\.)*?""")/ | @/(?s)('''([^\\\\]|\\\\.)*?''')/ | @/("([^"\\\\]|\\\\.)*")/ | @/('([^'\\\\]|\\\\.)*')/) |> `ast.literal_eval`
        # <Choice>
        backtrack2 = farthest_pos2 = _pos
        farthest_err3 = 46
        farthest_err4 = _raise_error46
        while True:
            # Option 1:
            # <Regex pattern='(?s)("""([^\\\\]|\\\\.)*?""")'>
            match5 = matcher5(_text, _pos)
            if match5:
                _pos = (yield (3, _cont__ignored, match5.end(),))[2]
                _status = True
                _result = match5.group(0)
            else:
                _status = False
                _result = _raise_error47
            # </Regex>
            if _status:
                break
            if (farthest_pos2 < _pos):
                farthest_pos2 = _pos
                farthest_err4 = _result
            _pos = backtrack2
            # Option 2:
            # <Regex pattern="(?s)('''([^\\\\]|\\\\.)*?''')">
            match6 = matcher6(_text, _pos)
            if match6:
                _pos = (yield (3, _cont__ignored, match6.end(),))[2]
                _status = True
                _result = match6.group(0)
            else:
                _status = False
                _result = _raise_error48
            # </Regex>
            if _status:
                break
            if (farthest_pos2 < _pos):
                farthest_pos2 = _pos
                farthest_err4 = _result
            _pos = backtrack2
            # Option 3:
            # <Regex pattern='("([^"\\\\]|\\\\.)*")'>
            match7 = matcher7(_text, _pos)
            if match7:
                _pos = (yield (3, _cont__ignored, match7.end(),))[2]
                _status = True
                _result = match7.group(0)
            else:
                _status = False
                _result = _raise_error49
            # </Regex>
            if _status:
                break
            if (farthest_pos2 < _pos):
                farthest_pos2 = _pos
                farthest_err4 = _result
            _pos = backtrack2
            # Option 4:
            # <Regex pattern="('([^'\\\\]|\\\\.)*')">
            match8 = matcher8(_text, _pos)
            if match8:
                _pos = (yield (3, _cont__ignored, match8.end(),))[2]
                _status = True
                _result = match8.group(0)
            else:
                _status = False
                _result = _raise_error50
            # </Regex>
            if _status:
                break
            if (farthest_pos2 < _pos):
                farthest_pos2 = _pos
                farthest_err4 = _result
            _pos = farthest_pos2
            _result = farthest_err4
            break
        # </Choice>
        if _status:
            arg4 = _result
            _result = ast.literal_eval
            _status = True
            _result = _result(arg4)
        # </Apply>
        if (not _status):
            break
        value = _result
        _result = StringLiteral(value)
        _result._position_info = (start_pos1, _pos,)
        break
    # </Seq>
    (yield (_status, _result, _pos,))


def _raise_error46(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'StringLiteral' rule, at the expression:\n"
    '    @/(?s)("""([^\\\\\\\\]|\\\\\\\\.)*?""")/ | @/(?s)(\'\'\'([^\\\\\\\\]|\\\\\\\\.)*?\'\'\')/ | @/("([^"\\\\\\\\]|\\\\\\\\.)*")/ | @/(\'([^\'\\\\\\\\]|\\\\\\\\.)*\')/\n\n'
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error47(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'StringLiteral' rule, at the expression:\n"
    '    @/(?s)("""([^\\\\\\\\]|\\\\\\\\.)*?""")/\n\n'
    'Expected to match the regular expression /(?s)("""([^\\\\]|\\\\.)*?""")/'
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error48(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'StringLiteral' rule, at the expression:\n"
    "    @/(?s)('''([^\\\\\\\\]|\\\\\\\\.)*?''')/\n\n"
    "Expected to match the regular expression /(?s)('''([^\\\\]|\\\\.)*?''')/"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error49(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'StringLiteral' rule, at the expression:\n"
    '    @/("([^"\\\\\\\\]|\\\\\\\\.)*")/\n\n'
    'Expected to match the regular expression /("([^"\\\\]|\\\\.)*")/'
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error50(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'StringLiteral' rule, at the expression:\n"
    "    @/('([^'\\\\\\\\]|\\\\\\\\.)*')/\n\n"
    "Expected to match the regular expression /('([^'\\\\]|\\\\.)*')/"
    )
    raise ParseError((title + details), _pos, line, col)


class RegexLiteral(Node):
    """
    class RegexLiteral {
        value: @/\\@\\/([^\\/\\\\]|\\\\.)*\\// |> `lambda x: x[2:-1]`
    }
    """
    _fields = ('value',)

    def __init__(self, value):
        self.value = value
        self._position_info = None

    def __repr__(self):
        return f'RegexLiteral(value={self.value!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _cont_RegexLiteral, fullparse)



def _cont_RegexLiteral(_text, _pos):
    # <Seq>
    start_pos2 = _pos
    while True:
        # <Apply>
        # @/\\@\\/([^\\/\\\\]|\\\\.)*\\// |> `lambda x: x[2:-1]`
        # <Regex pattern='\\@\\/([^\\/\\\\]|\\\\.)*\\/'>
        match9 = matcher9(_text, _pos)
        if match9:
            _pos = (yield (3, _cont__ignored, match9.end(),))[2]
            _status = True
            _result = match9.group(0)
        else:
            _status = False
            _result = _raise_error56
        # </Regex>
        if _status:
            arg5 = _result
            _result = lambda x: x[2:-1]
            _status = True
            _result = _result(arg5)
        # </Apply>
        if (not _status):
            break
        value = _result
        _result = RegexLiteral(value)
        _result._position_info = (start_pos2, _pos,)
        break
    # </Seq>
    (yield (_status, _result, _pos,))


def _raise_error56(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'RegexLiteral' rule, at the expression:\n"
    '    @/\\\\@\\\\/([^\\\\/\\\\\\\\]|\\\\\\\\.)*\\\\//\n\n'
    'Expected to match the regular expression /\\@\\/([^\\/\\\\]|\\\\.)*\\//'
    )
    raise ParseError((title + details), _pos, line, col)


class PythonSection(Node):
    """
    class PythonSection {
        value: @/(?s)```.*?```/ |> `lambda x: textwrap.dedent(x[3:-3])`
    }
    """
    _fields = ('value',)

    def __init__(self, value):
        self.value = value
        self._position_info = None

    def __repr__(self):
        return f'PythonSection(value={self.value!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _cont_PythonSection, fullparse)



def _cont_PythonSection(_text, _pos):
    # <Seq>
    start_pos3 = _pos
    while True:
        # <Apply>
        # @/(?s)```.*?```/ |> `lambda x: textwrap.dedent(x[3:-3])`
        # <Regex pattern='(?s)```.*?```'>
        match10 = matcher10(_text, _pos)
        if match10:
            _pos = (yield (3, _cont__ignored, match10.end(),))[2]
            _status = True
            _result = match10.group(0)
        else:
            _status = False
            _result = _raise_error62
        # </Regex>
        if _status:
            arg6 = _result
            _result = lambda x: textwrap.dedent(x[3:-3])
            _status = True
            _result = _result(arg6)
        # </Apply>
        if (not _status):
            break
        value = _result
        _result = PythonSection(value)
        _result._position_info = (start_pos3, _pos,)
        break
    # </Seq>
    (yield (_status, _result, _pos,))


def _raise_error62(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'PythonSection' rule, at the expression:\n"
    '    @/(?s)```.*?```/\n\n'
    'Expected to match the regular expression /(?s)```.*?```/'
    )
    raise ParseError((title + details), _pos, line, col)


class PythonExpression(Node):
    """
    class PythonExpression {
        value: @/`.*?`/ |> `lambda x: x[1:-1]`
    }
    """
    _fields = ('value',)

    def __init__(self, value):
        self.value = value
        self._position_info = None

    def __repr__(self):
        return f'PythonExpression(value={self.value!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _cont_PythonExpression, fullparse)



def _cont_PythonExpression(_text, _pos):
    # <Seq>
    start_pos4 = _pos
    while True:
        # <Apply>
        # @/`.*?`/ |> `lambda x: x[1:-1]`
        # <Regex pattern='`.*?`'>
        match11 = matcher11(_text, _pos)
        if match11:
            _pos = (yield (3, _cont__ignored, match11.end(),))[2]
            _status = True
            _result = match11.group(0)
        else:
            _status = False
            _result = _raise_error68
        # </Regex>
        if _status:
            arg7 = _result
            _result = lambda x: x[1:-1]
            _status = True
            _result = _result(arg7)
        # </Apply>
        if (not _status):
            break
        value = _result
        _result = PythonExpression(value)
        _result._position_info = (start_pos4, _pos,)
        break
    # </Seq>
    (yield (_status, _result, _pos,))


def _raise_error68(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'PythonExpression' rule, at the expression:\n"
    '    @/`.*?`/\n\n'
    'Expected to match the regular expression /`.*?`/'
    )
    raise ParseError((title + details), _pos, line, col)


class RuleDef(Node):
    """
    class RuleDef {
        is_ignored: Opt(kw('ignored') | kw('ignore')) |> `bool`
        name: Name
        params: Opt(Params) << wrap('=>' | '=' | ':')
        expr: Expr
    }
    """
    _fields = ('is_ignored', 'name', 'params', 'expr',)

    def __init__(self, is_ignored, name, params, expr):
        self.is_ignored = is_ignored
        self.name = name
        self.params = params
        self.expr = expr
        self._position_info = None

    def __repr__(self):
        return f'RuleDef(is_ignored={self.is_ignored!r}, name={self.name!r}, params={self.params!r}, expr={self.expr!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _cont_RuleDef, fullparse)



def _parse_function_78(_text, _pos):
    # <String value='ignored'>
    value5 = 'ignored'
    end5 = (_pos + 7)
    if (_text[_pos : end5] == value5):
        _pos = (yield (3, _cont__ignored, end5,))[2]
        _status = True
        _result = value5
    else:
        _status = False
        _result = _raise_error78
    # </String>
    (yield (_status, _result, _pos,))


def _parse_function_81(_text, _pos):
    # <String value='ignore'>
    value6 = 'ignore'
    end6 = (_pos + 6)
    if (_text[_pos : end6] == value6):
        _pos = (yield (3, _cont__ignored, end6,))[2]
        _status = True
        _result = value6
    else:
        _status = False
        _result = _raise_error81
    # </String>
    (yield (_status, _result, _pos,))


def _parse_function_91(_text, _pos):
    # <Choice>
    backtrack3 = farthest_pos3 = _pos
    farthest_err5 = 91
    farthest_err6 = _raise_error91
    while True:
        # Option 1:
        # <String value='=>'>
        value7 = '=>'
        end7 = (_pos + 2)
        if (_text[_pos : end7] == value7):
            _pos = (yield (3, _cont__ignored, end7,))[2]
            _status = True
            _result = value7
        else:
            _status = False
            _result = _raise_error92
        # </String>
        if _status:
            break
        if (farthest_pos3 < _pos):
            farthest_pos3 = _pos
            farthest_err6 = _result
        _pos = backtrack3
        # Option 2:
        # <String value='='>
        value8 = '='
        end8 = (_pos + 1)
        if (_text[_pos : end8] == value8):
            _pos = (yield (3, _cont__ignored, end8,))[2]
            _status = True
            _result = value8
        else:
            _status = False
            _result = _raise_error93
        # </String>
        if _status:
            break
        if (farthest_pos3 < _pos):
            farthest_pos3 = _pos
            farthest_err6 = _result
        _pos = backtrack3
        # Option 3:
        # <String value=':'>
        value9 = ':'
        end9 = (_pos + 1)
        if (_text[_pos : end9] == value9):
            _pos = (yield (3, _cont__ignored, end9,))[2]
            _status = True
            _result = value9
        else:
            _status = False
            _result = _raise_error94
        # </String>
        if _status:
            break
        if (farthest_pos3 < _pos):
            farthest_pos3 = _pos
            farthest_err6 = _result
        _pos = farthest_pos3
        _result = farthest_err6
        break
    # </Choice>
    (yield (_status, _result, _pos,))


def _cont_RuleDef(_text, _pos):
    # <Seq>
    start_pos5 = _pos
    while True:
        # <Apply>
        # Opt(kw('ignored') | kw('ignore')) |> `bool`
        # <Opt>
        # Opt(kw('ignored') | kw('ignore'))
        backtrack4 = _pos
        # <Choice>
        backtrack5 = farthest_pos4 = _pos
        farthest_err7 = 75
        farthest_err8 = _raise_error75
        while True:
            # Option 1:
            # <Call>
            # kw('ignored')
            arg8 = _wrap_string_literal('ignored', _parse_function_78)
            func4 = _ParseFunction(_cont_kw, (arg8,), ())
            (_status, _result, _pos,) = (yield (3, func4, _pos,))
            # </Call>
            if _status:
                break
            if (farthest_pos4 < _pos):
                farthest_pos4 = _pos
                farthest_err8 = _result
            _pos = backtrack5
            # Option 2:
            # <Call>
            # kw('ignore')
            arg9 = _wrap_string_literal('ignore', _parse_function_81)
            func5 = _ParseFunction(_cont_kw, (arg9,), ())
            (_status, _result, _pos,) = (yield (3, func5, _pos,))
            # </Call>
            if _status:
                break
            if (farthest_pos4 < _pos):
                farthest_pos4 = _pos
                farthest_err8 = _result
            _pos = farthest_pos4
            _result = farthest_err8
            break
        # </Choice>
        if (not _status):
            _status = True
            _pos = backtrack4
            _result = None
        # </Opt>
        arg10 = _result
        _result = bool
        _status = True
        _result = _result(arg10)
        # </Apply>
        is_ignored = _result
        # <Ref name='Name'>
        (_status, _result, _pos,) = (yield (3, _cont_Name, _pos,))
        # </Ref>
        if (not _status):
            break
        name = _result
        # <Discard>
        # Opt(Params) << wrap('=>' | '=' | ':')
        while True:
            # <Opt>
            # Opt(Params)
            backtrack6 = _pos
            # <Ref name='Params'>
            (_status, _result, _pos,) = (yield (3, _cont_Params, _pos,))
            # </Ref>
            if (not _status):
                _status = True
                _pos = backtrack6
                _result = None
            # </Opt>
            staging5 = _result
            # <Call>
            # wrap('=>' | '=' | ':')
            func6 = _ParseFunction(_cont_wrap, (_parse_function_91,), ())
            (_status, _result, _pos,) = (yield (3, func6, _pos,))
            # </Call>
            if _status:
                _result = staging5
            break
        # </Discard>
        if (not _status):
            break
        params = _result
        # <Ref name='Expr'>
        (_status, _result, _pos,) = (yield (3, _cont_Expr, _pos,))
        # </Ref>
        if (not _status):
            break
        expr = _result
        _result = RuleDef(is_ignored, name, params, expr)
        _result._position_info = (start_pos5, _pos,)
        break
    # </Seq>
    (yield (_status, _result, _pos,))


def _raise_error75(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'RuleDef' rule, at the expression:\n"
    "    kw('ignored') | kw('ignore')\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error78(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'RuleDef' rule, at the expression:\n"
    "    'ignored'\n\n"
    "Expected to match the string 'ignored'"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error81(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'RuleDef' rule, at the expression:\n"
    "    'ignore'\n\n"
    "Expected to match the string 'ignore'"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error91(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'RuleDef' rule, at the expression:\n"
    "    '=>' | '=' | ':'\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error92(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'RuleDef' rule, at the expression:\n"
    "    '=>'\n\n"
    "Expected to match the string '=>'"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error93(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'RuleDef' rule, at the expression:\n"
    "    '='\n\n"
    "Expected to match the string '='"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error94(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'RuleDef' rule, at the expression:\n"
    "    ':'\n\n"
    "Expected to match the string ':'"
    )
    raise ParseError((title + details), _pos, line, col)


class ClassDef(Node):
    """
    class ClassDef {
        name: kw('class') >> Name
        params: Opt(Params)
        fields: (wrap('{') >> (RuleDef / Sep)) << '}'
    }
    """
    _fields = ('name', 'params', 'fields',)

    def __init__(self, name, params, fields):
        self.name = name
        self.params = params
        self.fields = fields
        self._position_info = None

    def __repr__(self):
        return f'ClassDef(name={self.name!r}, params={self.params!r}, fields={self.fields!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _cont_ClassDef, fullparse)



def _parse_function_103(_text, _pos):
    # <String value='class'>
    value10 = 'class'
    end10 = (_pos + 5)
    if (_text[_pos : end10] == value10):
        _pos = (yield (3, _cont__ignored, end10,))[2]
        _status = True
        _result = value10
    else:
        _status = False
        _result = _raise_error103
    # </String>
    (yield (_status, _result, _pos,))


def _parse_function_113(_text, _pos):
    # <String value='{'>
    value11 = '{'
    end11 = (_pos + 1)
    if (_text[_pos : end11] == value11):
        _pos = (yield (3, _cont__ignored, end11,))[2]
        _status = True
        _result = value11
    else:
        _status = False
        _result = _raise_error113
    # </String>
    (yield (_status, _result, _pos,))


def _cont_ClassDef(_text, _pos):
    # <Seq>
    start_pos6 = _pos
    while True:
        # <Discard>
        # kw('class') >> Name
        while True:
            # <Call>
            # kw('class')
            arg11 = _wrap_string_literal('class', _parse_function_103)
            func7 = _ParseFunction(_cont_kw, (arg11,), ())
            (_status, _result, _pos,) = (yield (3, func7, _pos,))
            # </Call>
            if (not _status):
                break
            # <Ref name='Name'>
            (_status, _result, _pos,) = (yield (3, _cont_Name, _pos,))
            # </Ref>
            break
        # </Discard>
        if (not _status):
            break
        name = _result
        # <Opt>
        # Opt(Params)
        backtrack7 = _pos
        # <Ref name='Params'>
        (_status, _result, _pos,) = (yield (3, _cont_Params, _pos,))
        # </Ref>
        if (not _status):
            _status = True
            _pos = backtrack7
            _result = None
        # </Opt>
        params = _result
        # <Discard>
        # (wrap('{') >> (RuleDef / Sep)) << '}'
        while True:
            # <Discard>
            # wrap('{') >> (RuleDef / Sep)
            while True:
                # <Call>
                # wrap('{')
                arg12 = _wrap_string_literal('{', _parse_function_113)
                func8 = _ParseFunction(_cont_wrap, (arg12,), ())
                (_status, _result, _pos,) = (yield (3, func8, _pos,))
                # </Call>
                if (not _status):
                    break
                # <Alt>
                # RuleDef / Sep
                staging6 = []
                checkpoint5 = _pos
                while True:
                    # <Ref name='RuleDef'>
                    (_status, _result, _pos,) = (yield (3, _cont_RuleDef, _pos,))
                    # </Ref>
                    if (not _status):
                        break
                    staging6.append(_result)
                    checkpoint5 = _pos
                    # <Ref name='Sep'>
                    (_status, _result, _pos,) = (yield (3, _cont_Sep, _pos,))
                    # </Ref>
                    if (not _status):
                        break
                    checkpoint5 = _pos
                _result = staging6
                _status = True
                _pos = checkpoint5
                # </Alt>
                break
            # </Discard>
            if (not _status):
                break
            staging7 = _result
            # <String value='}'>
            value12 = '}'
            end12 = (_pos + 1)
            if (_text[_pos : end12] == value12):
                _pos = (yield (3, _cont__ignored, end12,))[2]
                _status = True
                _result = value12
            else:
                _status = False
                _result = _raise_error117
            # </String>
            if _status:
                _result = staging7
            break
        # </Discard>
        if (not _status):
            break
        fields = _result
        _result = ClassDef(name, params, fields)
        _result._position_info = (start_pos6, _pos,)
        break
    # </Seq>
    (yield (_status, _result, _pos,))


def _raise_error103(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ClassDef' rule, at the expression:\n"
    "    'class'\n\n"
    "Expected to match the string 'class'"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error113(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ClassDef' rule, at the expression:\n"
    "    '{'\n\n"
    "Expected to match the string '{'"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error117(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ClassDef' rule, at the expression:\n"
    "    '}'\n\n"
    "Expected to match the string '}'"
    )
    raise ParseError((title + details), _pos, line, col)


def _cont_Stmt(_text, _pos):
    # Rule 'Stmt'
    # <Choice>
    backtrack8 = farthest_pos5 = _pos
    farthest_err9 = 119
    farthest_err10 = _raise_error119
    while True:
        # Option 1:
        # <Ref name='ClassDef'>
        (_status, _result, _pos,) = (yield (3, _cont_ClassDef, _pos,))
        # </Ref>
        if _status:
            break
        if (farthest_pos5 < _pos):
            farthest_pos5 = _pos
            farthest_err10 = _result
        _pos = backtrack8
        # Option 2:
        # <Ref name='RuleDef'>
        (_status, _result, _pos,) = (yield (3, _cont_RuleDef, _pos,))
        # </Ref>
        if _status:
            break
        if (farthest_pos5 < _pos):
            farthest_pos5 = _pos
            farthest_err10 = _result
        _pos = backtrack8
        # Option 3:
        # <Ref name='PythonSection'>
        (_status, _result, _pos,) = (yield (3, _cont_PythonSection, _pos,))
        # </Ref>
        if _status:
            break
        if (farthest_pos5 < _pos):
            farthest_pos5 = _pos
            farthest_err10 = _result
        _pos = backtrack8
        # Option 4:
        # <Ref name='PythonExpression'>
        (_status, _result, _pos,) = (yield (3, _cont_PythonExpression, _pos,))
        # </Ref>
        if _status:
            break
        if (farthest_pos5 < _pos):
            farthest_pos5 = _pos
            farthest_err10 = _result
        _pos = farthest_pos5
        _result = farthest_err10
        break
    # </Choice>
    (yield (_status, _result, _pos,))


def _parse_Stmt(text, pos=0, fullparse=True):
    return _run(text, pos, _cont_Stmt, fullparse)


Stmt = Rule('Stmt', _parse_Stmt, """
    Stmt = ClassDef | RuleDef | PythonSection | PythonExpression
""")

def _raise_error119(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Stmt' rule, at the expression:\n"
    '    ClassDef | RuleDef | PythonSection | PythonExpression\n\n'
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)


class LetExpression(Node):
    """
    class LetExpression {
        name: (kw('let') >> Name) << wrap('=')
        expr: Expr << wrap(kw('in'))
        body: Expr
    }
    """
    _fields = ('name', 'expr', 'body',)

    def __init__(self, name, expr, body):
        self.name = name
        self.expr = expr
        self.body = body
        self._position_info = None

    def __repr__(self):
        return f'LetExpression(name={self.name!r}, expr={self.expr!r}, body={self.body!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _cont_LetExpression, fullparse)



def _parse_function_131(_text, _pos):
    # <String value='let'>
    value13 = 'let'
    end13 = (_pos + 3)
    if (_text[_pos : end13] == value13):
        _pos = (yield (3, _cont__ignored, end13,))[2]
        _status = True
        _result = value13
    else:
        _status = False
        _result = _raise_error131
    # </String>
    (yield (_status, _result, _pos,))


def _parse_function_135(_text, _pos):
    # <String value='='>
    value14 = '='
    end14 = (_pos + 1)
    if (_text[_pos : end14] == value14):
        _pos = (yield (3, _cont__ignored, end14,))[2]
        _status = True
        _result = value14
    else:
        _status = False
        _result = _raise_error135
    # </String>
    (yield (_status, _result, _pos,))


def _parse_function_143(_text, _pos):
    # <String value='in'>
    value15 = 'in'
    end15 = (_pos + 2)
    if (_text[_pos : end15] == value15):
        _pos = (yield (3, _cont__ignored, end15,))[2]
        _status = True
        _result = value15
    else:
        _status = False
        _result = _raise_error143
    # </String>
    (yield (_status, _result, _pos,))


def _parse_function_141(_text, _pos):
    # <Call>
    # kw('in')
    arg13 = _wrap_string_literal('in', _parse_function_143)
    func9 = _ParseFunction(_cont_kw, (arg13,), ())
    (_status, _result, _pos,) = (yield (3, func9, _pos,))
    # </Call>
    (yield (_status, _result, _pos,))


def _cont_LetExpression(_text, _pos):
    # <Seq>
    start_pos7 = _pos
    while True:
        # <Discard>
        # (kw('let') >> Name) << wrap('=')
        while True:
            # <Discard>
            # kw('let') >> Name
            while True:
                # <Call>
                # kw('let')
                arg14 = _wrap_string_literal('let', _parse_function_131)
                func10 = _ParseFunction(_cont_kw, (arg14,), ())
                (_status, _result, _pos,) = (yield (3, func10, _pos,))
                # </Call>
                if (not _status):
                    break
                # <Ref name='Name'>
                (_status, _result, _pos,) = (yield (3, _cont_Name, _pos,))
                # </Ref>
                break
            # </Discard>
            if (not _status):
                break
            staging8 = _result
            # <Call>
            # wrap('=')
            arg15 = _wrap_string_literal('=', _parse_function_135)
            func11 = _ParseFunction(_cont_wrap, (arg15,), ())
            (_status, _result, _pos,) = (yield (3, func11, _pos,))
            # </Call>
            if _status:
                _result = staging8
            break
        # </Discard>
        if (not _status):
            break
        name = _result
        # <Discard>
        # Expr << wrap(kw('in'))
        while True:
            # <Ref name='Expr'>
            (_status, _result, _pos,) = (yield (3, _cont_Expr, _pos,))
            # </Ref>
            if (not _status):
                break
            staging9 = _result
            # <Call>
            # wrap(kw('in'))
            func12 = _ParseFunction(_cont_wrap, (_parse_function_141,), ())
            (_status, _result, _pos,) = (yield (3, func12, _pos,))
            # </Call>
            if _status:
                _result = staging9
            break
        # </Discard>
        if (not _status):
            break
        expr = _result
        # <Ref name='Expr'>
        (_status, _result, _pos,) = (yield (3, _cont_Expr, _pos,))
        # </Ref>
        if (not _status):
            break
        body = _result
        _result = LetExpression(name, expr, body)
        _result._position_info = (start_pos7, _pos,)
        break
    # </Seq>
    (yield (_status, _result, _pos,))


def _raise_error131(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'LetExpression' rule, at the expression:\n"
    "    'let'\n\n"
    "Expected to match the string 'let'"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error135(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'LetExpression' rule, at the expression:\n"
    "    '='\n\n"
    "Expected to match the string '='"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error143(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'LetExpression' rule, at the expression:\n"
    "    'in'\n\n"
    "Expected to match the string 'in'"
    )
    raise ParseError((title + details), _pos, line, col)


class Ref(Node):
    """
    class Ref {
        value: Name
    }
    """
    _fields = ('value',)

    def __init__(self, value):
        self.value = value
        self._position_info = None

    def __repr__(self):
        return f'Ref(value={self.value!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _cont_Ref, fullparse)



def _cont_Ref(_text, _pos):
    # <Seq>
    start_pos8 = _pos
    while True:
        # <Ref name='Name'>
        (_status, _result, _pos,) = (yield (3, _cont_Name, _pos,))
        # </Ref>
        if (not _status):
            break
        value = _result
        _result = Ref(value)
        _result._position_info = (start_pos8, _pos,)
        break
    # </Seq>
    (yield (_status, _result, _pos,))


class ListLiteral(Node):
    """
    class ListLiteral {
        elements: ('[' >> (wrap(Expr) / Comma)) << ']'
    }
    """
    _fields = ('elements',)

    def __init__(self, elements):
        self.elements = elements
        self._position_info = None

    def __repr__(self):
        return f'ListLiteral(elements={self.elements!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _cont_ListLiteral, fullparse)



def _cont_ListLiteral(_text, _pos):
    # <Seq>
    start_pos9 = _pos
    while True:
        # <Discard>
        # ('[' >> (wrap(Expr) / Comma)) << ']'
        while True:
            # <Discard>
            # '[' >> (wrap(Expr) / Comma)
            while True:
                # <String value='['>
                value16 = '['
                end16 = (_pos + 1)
                if (_text[_pos : end16] == value16):
                    _pos = (yield (3, _cont__ignored, end16,))[2]
                    _status = True
                    _result = value16
                else:
                    _status = False
                    _result = _raise_error155
                # </String>
                if (not _status):
                    break
                # <Alt>
                # wrap(Expr) / Comma
                staging10 = []
                checkpoint6 = _pos
                while True:
                    # <Call>
                    # wrap(Expr)
                    func13 = _ParseFunction(_cont_wrap, (_cont_Expr,), ())
                    (_status, _result, _pos,) = (yield (3, func13, _pos,))
                    # </Call>
                    if (not _status):
                        break
                    staging10.append(_result)
                    checkpoint6 = _pos
                    # <Ref name='Comma'>
                    (_status, _result, _pos,) = (yield (3, _cont_Comma, _pos,))
                    # </Ref>
                    if (not _status):
                        break
                    checkpoint6 = _pos
                _result = staging10
                _status = True
                _pos = checkpoint6
                # </Alt>
                break
            # </Discard>
            if (not _status):
                break
            staging11 = _result
            # <String value=']'>
            value17 = ']'
            end17 = (_pos + 1)
            if (_text[_pos : end17] == value17):
                _pos = (yield (3, _cont__ignored, end17,))[2]
                _status = True
                _result = value17
            else:
                _status = False
                _result = _raise_error161
            # </String>
            if _status:
                _result = staging11
            break
        # </Discard>
        if (not _status):
            break
        elements = _result
        _result = ListLiteral(elements)
        _result._position_info = (start_pos9, _pos,)
        break
    # </Seq>
    (yield (_status, _result, _pos,))


def _raise_error155(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ListLiteral' rule, at the expression:\n"
    "    '['\n\n"
    "Expected to match the string '['"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error161(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ListLiteral' rule, at the expression:\n"
    "    ']'\n\n"
    "Expected to match the string ']'"
    )
    raise ParseError((title + details), _pos, line, col)


def _cont_Atom(_text, _pos):
    # Rule 'Atom'
    # <Choice>
    backtrack9 = farthest_pos6 = _pos
    farthest_err11 = 163
    farthest_err12 = _raise_error163
    while True:
        # Option 1:
        # <Discard>
        # ('(' >> wrap(Expr)) << ')'
        while True:
            # <Discard>
            # '(' >> wrap(Expr)
            while True:
                # <String value='('>
                value18 = '('
                end18 = (_pos + 1)
                if (_text[_pos : end18] == value18):
                    _pos = (yield (3, _cont__ignored, end18,))[2]
                    _status = True
                    _result = value18
                else:
                    _status = False
                    _result = _raise_error166
                # </String>
                if (not _status):
                    break
                # <Call>
                # wrap(Expr)
                func14 = _ParseFunction(_cont_wrap, (_cont_Expr,), ())
                (_status, _result, _pos,) = (yield (3, func14, _pos,))
                # </Call>
                break
            # </Discard>
            if (not _status):
                break
            staging12 = _result
            # <String value=')'>
            value19 = ')'
            end19 = (_pos + 1)
            if (_text[_pos : end19] == value19):
                _pos = (yield (3, _cont__ignored, end19,))[2]
                _status = True
                _result = value19
            else:
                _status = False
                _result = _raise_error170
            # </String>
            if _status:
                _result = staging12
            break
        # </Discard>
        if _status:
            break
        if (farthest_pos6 < _pos):
            farthest_pos6 = _pos
            farthest_err12 = _result
        _pos = backtrack9
        # Option 2:
        # <Ref name='LetExpression'>
        (_status, _result, _pos,) = (yield (3, _cont_LetExpression, _pos,))
        # </Ref>
        if _status:
            break
        if (farthest_pos6 < _pos):
            farthest_pos6 = _pos
            farthest_err12 = _result
        _pos = backtrack9
        # Option 3:
        # <Ref name='Ref'>
        (_status, _result, _pos,) = (yield (3, _cont_Ref, _pos,))
        # </Ref>
        if _status:
            break
        if (farthest_pos6 < _pos):
            farthest_pos6 = _pos
            farthest_err12 = _result
        _pos = backtrack9
        # Option 4:
        # <Ref name='StringLiteral'>
        (_status, _result, _pos,) = (yield (3, _cont_StringLiteral, _pos,))
        # </Ref>
        if _status:
            break
        if (farthest_pos6 < _pos):
            farthest_pos6 = _pos
            farthest_err12 = _result
        _pos = backtrack9
        # Option 5:
        # <Ref name='RegexLiteral'>
        (_status, _result, _pos,) = (yield (3, _cont_RegexLiteral, _pos,))
        # </Ref>
        if _status:
            break
        if (farthest_pos6 < _pos):
            farthest_pos6 = _pos
            farthest_err12 = _result
        _pos = backtrack9
        # Option 6:
        # <Ref name='ListLiteral'>
        (_status, _result, _pos,) = (yield (3, _cont_ListLiteral, _pos,))
        # </Ref>
        if _status:
            break
        if (farthest_pos6 < _pos):
            farthest_pos6 = _pos
            farthest_err12 = _result
        _pos = backtrack9
        # Option 7:
        # <Ref name='PythonExpression'>
        (_status, _result, _pos,) = (yield (3, _cont_PythonExpression, _pos,))
        # </Ref>
        if _status:
            break
        if (farthest_pos6 < _pos):
            farthest_pos6 = _pos
            farthest_err12 = _result
        _pos = farthest_pos6
        _result = farthest_err12
        break
    # </Choice>
    (yield (_status, _result, _pos,))


def _parse_Atom(text, pos=0, fullparse=True):
    return _run(text, pos, _cont_Atom, fullparse)


Atom = Rule('Atom', _parse_Atom, """
    Atom = ('(' >> wrap(Expr)) << ')' | LetExpression | Ref | StringLiteral | RegexLiteral | ListLiteral | PythonExpression
""")

def _raise_error163(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Atom' rule, at the expression:\n"
    "    ('(' >> wrap(Expr)) << ')' | LetExpression | Ref | StringLiteral | RegexLiteral | ListLiteral | PythonExpression\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error166(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Atom' rule, at the expression:\n"
    "    '('\n\n"
    "Expected to match the string '('"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error170(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Atom' rule, at the expression:\n"
    "    ')'\n\n"
    "Expected to match the string ')'"
    )
    raise ParseError((title + details), _pos, line, col)


class KeywordArg(Node):
    """
    class KeywordArg {
        name: Name << ('=' | ':')
        expr: Expr
    }
    """
    _fields = ('name', 'expr',)

    def __init__(self, name, expr):
        self.name = name
        self.expr = expr
        self._position_info = None

    def __repr__(self):
        return f'KeywordArg(name={self.name!r}, expr={self.expr!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _cont_KeywordArg, fullparse)



def _cont_KeywordArg(_text, _pos):
    # <Seq>
    start_pos10 = _pos
    while True:
        # <Discard>
        # Name << ('=' | ':')
        while True:
            # <Ref name='Name'>
            (_status, _result, _pos,) = (yield (3, _cont_Name, _pos,))
            # </Ref>
            if (not _status):
                break
            staging13 = _result
            # <Choice>
            backtrack10 = farthest_pos7 = _pos
            farthest_err13 = 182
            farthest_err14 = _raise_error182
            while True:
                # Option 1:
                # <String value='='>
                value20 = '='
                end20 = (_pos + 1)
                if (_text[_pos : end20] == value20):
                    _pos = (yield (3, _cont__ignored, end20,))[2]
                    _status = True
                    _result = value20
                else:
                    _status = False
                    _result = _raise_error183
                # </String>
                if _status:
                    break
                if (farthest_pos7 < _pos):
                    farthest_pos7 = _pos
                    farthest_err14 = _result
                _pos = backtrack10
                # Option 2:
                # <String value=':'>
                value21 = ':'
                end21 = (_pos + 1)
                if (_text[_pos : end21] == value21):
                    _pos = (yield (3, _cont__ignored, end21,))[2]
                    _status = True
                    _result = value21
                else:
                    _status = False
                    _result = _raise_error184
                # </String>
                if _status:
                    break
                if (farthest_pos7 < _pos):
                    farthest_pos7 = _pos
                    farthest_err14 = _result
                _pos = farthest_pos7
                _result = farthest_err14
                break
            # </Choice>
            if _status:
                _result = staging13
            break
        # </Discard>
        if (not _status):
            break
        name = _result
        # <Ref name='Expr'>
        (_status, _result, _pos,) = (yield (3, _cont_Expr, _pos,))
        # </Ref>
        if (not _status):
            break
        expr = _result
        _result = KeywordArg(name, expr)
        _result._position_info = (start_pos10, _pos,)
        break
    # </Seq>
    (yield (_status, _result, _pos,))


def _raise_error182(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'KeywordArg' rule, at the expression:\n"
    "    '=' | ':'\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error183(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'KeywordArg' rule, at the expression:\n"
    "    '='\n\n"
    "Expected to match the string '='"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error184(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'KeywordArg' rule, at the expression:\n"
    "    ':'\n\n"
    "Expected to match the string ':'"
    )
    raise ParseError((title + details), _pos, line, col)


class ArgList(Node):
    """
    class ArgList {
        args: ('(' >> (wrap(KeywordArg | Expr) / Comma)) << ')'
    }
    """
    _fields = ('args',)

    def __init__(self, args):
        self.args = args
        self._position_info = None

    def __repr__(self):
        return f'ArgList(args={self.args!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _cont_ArgList, fullparse)



def _parse_function_196(_text, _pos):
    # <Choice>
    backtrack11 = farthest_pos8 = _pos
    farthest_err15 = 196
    farthest_err16 = _raise_error196
    while True:
        # Option 1:
        # <Ref name='KeywordArg'>
        (_status, _result, _pos,) = (yield (3, _cont_KeywordArg, _pos,))
        # </Ref>
        if _status:
            break
        if (farthest_pos8 < _pos):
            farthest_pos8 = _pos
            farthest_err16 = _result
        _pos = backtrack11
        # Option 2:
        # <Ref name='Expr'>
        (_status, _result, _pos,) = (yield (3, _cont_Expr, _pos,))
        # </Ref>
        if _status:
            break
        if (farthest_pos8 < _pos):
            farthest_pos8 = _pos
            farthest_err16 = _result
        _pos = farthest_pos8
        _result = farthest_err16
        break
    # </Choice>
    (yield (_status, _result, _pos,))


def _cont_ArgList(_text, _pos):
    # <Seq>
    start_pos11 = _pos
    while True:
        # <Discard>
        # ('(' >> (wrap(KeywordArg | Expr) / Comma)) << ')'
        while True:
            # <Discard>
            # '(' >> (wrap(KeywordArg | Expr) / Comma)
            while True:
                # <String value='('>
                value22 = '('
                end22 = (_pos + 1)
                if (_text[_pos : end22] == value22):
                    _pos = (yield (3, _cont__ignored, end22,))[2]
                    _status = True
                    _result = value22
                else:
                    _status = False
                    _result = _raise_error192
                # </String>
                if (not _status):
                    break
                # <Alt>
                # wrap(KeywordArg | Expr) / Comma
                staging14 = []
                checkpoint7 = _pos
                while True:
                    # <Call>
                    # wrap(KeywordArg | Expr)
                    func15 = _ParseFunction(_cont_wrap, (_parse_function_196,), ())
                    (_status, _result, _pos,) = (yield (3, func15, _pos,))
                    # </Call>
                    if (not _status):
                        break
                    staging14.append(_result)
                    checkpoint7 = _pos
                    # <Ref name='Comma'>
                    (_status, _result, _pos,) = (yield (3, _cont_Comma, _pos,))
                    # </Ref>
                    if (not _status):
                        break
                    checkpoint7 = _pos
                _result = staging14
                _status = True
                _pos = checkpoint7
                # </Alt>
                break
            # </Discard>
            if (not _status):
                break
            staging15 = _result
            # <String value=')'>
            value23 = ')'
            end23 = (_pos + 1)
            if (_text[_pos : end23] == value23):
                _pos = (yield (3, _cont__ignored, end23,))[2]
                _status = True
                _result = value23
            else:
                _status = False
                _result = _raise_error200
            # </String>
            if _status:
                _result = staging15
            break
        # </Discard>
        if (not _status):
            break
        args = _result
        _result = ArgList(args)
        _result._position_info = (start_pos11, _pos,)
        break
    # </Seq>
    (yield (_status, _result, _pos,))


def _raise_error192(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ArgList' rule, at the expression:\n"
    "    '('\n\n"
    "Expected to match the string '('"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error196(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ArgList' rule, at the expression:\n"
    '    KeywordArg | Expr\n\n'
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error200(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ArgList' rule, at the expression:\n"
    "    ')'\n\n"
    "Expected to match the string ')'"
    )
    raise ParseError((title + details), _pos, line, col)


def _parse_function_214(_text, _pos):
    # <Choice>
    backtrack12 = farthest_pos9 = _pos
    farthest_err17 = 214
    farthest_err18 = _raise_error214
    while True:
        # Option 1:
        # <String value='//'>
        value24 = '//'
        end24 = (_pos + 2)
        if (_text[_pos : end24] == value24):
            _pos = (yield (3, _cont__ignored, end24,))[2]
            _status = True
            _result = value24
        else:
            _status = False
            _result = _raise_error215
        # </String>
        if _status:
            break
        if (farthest_pos9 < _pos):
            farthest_pos9 = _pos
            farthest_err18 = _result
        _pos = backtrack12
        # Option 2:
        # <String value='/'>
        value25 = '/'
        end25 = (_pos + 1)
        if (_text[_pos : end25] == value25):
            _pos = (yield (3, _cont__ignored, end25,))[2]
            _status = True
            _result = value25
        else:
            _status = False
            _result = _raise_error216
        # </String>
        if _status:
            break
        if (farthest_pos9 < _pos):
            farthest_pos9 = _pos
            farthest_err18 = _result
        _pos = farthest_pos9
        _result = farthest_err18
        break
    # </Choice>
    (yield (_status, _result, _pos,))


def _parse_function_220(_text, _pos):
    # <Choice>
    backtrack13 = farthest_pos10 = _pos
    farthest_err19 = 220
    farthest_err20 = _raise_error220
    while True:
        # Option 1:
        # <String value='<<'>
        value26 = '<<'
        end26 = (_pos + 2)
        if (_text[_pos : end26] == value26):
            _pos = (yield (3, _cont__ignored, end26,))[2]
            _status = True
            _result = value26
        else:
            _status = False
            _result = _raise_error221
        # </String>
        if _status:
            break
        if (farthest_pos10 < _pos):
            farthest_pos10 = _pos
            farthest_err20 = _result
        _pos = backtrack13
        # Option 2:
        # <String value='>>'>
        value27 = '>>'
        end27 = (_pos + 2)
        if (_text[_pos : end27] == value27):
            _pos = (yield (3, _cont__ignored, end27,))[2]
            _status = True
            _result = value27
        else:
            _status = False
            _result = _raise_error222
        # </String>
        if _status:
            break
        if (farthest_pos10 < _pos):
            farthest_pos10 = _pos
            farthest_err20 = _result
        _pos = farthest_pos10
        _result = farthest_err20
        break
    # </Choice>
    (yield (_status, _result, _pos,))


def _parse_function_226(_text, _pos):
    # <Choice>
    backtrack14 = farthest_pos11 = _pos
    farthest_err21 = 226
    farthest_err22 = _raise_error226
    while True:
        # Option 1:
        # <String value='<|'>
        value28 = '<|'
        end28 = (_pos + 2)
        if (_text[_pos : end28] == value28):
            _pos = (yield (3, _cont__ignored, end28,))[2]
            _status = True
            _result = value28
        else:
            _status = False
            _result = _raise_error227
        # </String>
        if _status:
            break
        if (farthest_pos11 < _pos):
            farthest_pos11 = _pos
            farthest_err22 = _result
        _pos = backtrack14
        # Option 2:
        # <String value='|>'>
        value29 = '|>'
        end29 = (_pos + 2)
        if (_text[_pos : end29] == value29):
            _pos = (yield (3, _cont__ignored, end29,))[2]
            _status = True
            _result = value29
        else:
            _status = False
            _result = _raise_error228
        # </String>
        if _status:
            break
        if (farthest_pos11 < _pos):
            farthest_pos11 = _pos
            farthest_err22 = _result
        _pos = backtrack14
        # Option 3:
        # <String value='where'>
        value30 = 'where'
        end30 = (_pos + 5)
        if (_text[_pos : end30] == value30):
            _pos = (yield (3, _cont__ignored, end30,))[2]
            _status = True
            _result = value30
        else:
            _status = False
            _result = _raise_error229
        # </String>
        if _status:
            break
        if (farthest_pos11 < _pos):
            farthest_pos11 = _pos
            farthest_err22 = _result
        _pos = farthest_pos11
        _result = farthest_err22
        break
    # </Choice>
    (yield (_status, _result, _pos,))


def _parse_function_233(_text, _pos):
    # <String value='|'>
    value31 = '|'
    end31 = (_pos + 1)
    if (_text[_pos : end31] == value31):
        _pos = (yield (3, _cont__ignored, end31,))[2]
        _status = True
        _result = value31
    else:
        _status = False
        _result = _raise_error233
    # </String>
    (yield (_status, _result, _pos,))


def _cont_Expr(_text, _pos):
    # Rule 'Expr'
    # <OperatorPrecedence>
    """
    OperatorPrecedence(
        Atom,
        Postfix(ArgList),
        Postfix('?' | '*' | '+'),
        LeftAssoc(wrap('//' | '/')),
        LeftAssoc(wrap('<<' | '>>')),
        LeftAssoc(wrap('<|' | '|>' | 'where')),
        LeftAssoc(wrap('|'))
    )
    """
    # <LeftAssoc>
    # LeftAssoc(wrap('|'))
    is_first1 = True
    staging16 = None
    while True:
        # <LeftAssoc>
        # LeftAssoc(wrap('<|' | '|>' | 'where'))
        is_first2 = True
        staging17 = None
        while True:
            # <LeftAssoc>
            # LeftAssoc(wrap('<<' | '>>'))
            is_first3 = True
            staging18 = None
            while True:
                # <LeftAssoc>
                # LeftAssoc(wrap('//' | '/'))
                is_first4 = True
                staging19 = None
                while True:
                    # <Postfix>
                    # Postfix('?' | '*' | '+')
                    # <Postfix>
                    # Postfix(ArgList)
                    # <Ref name='Atom'>
                    (_status, _result, _pos,) = (yield (3, _cont_Atom, _pos,))
                    # </Ref>
                    if _status:
                        staging20 = _result
                        checkpoint8 = _pos
                        while True:
                            # <Ref name='ArgList'>
                            (_status, _result, _pos,) = (yield (3, _cont_ArgList, _pos,))
                            # </Ref>
                            if _status:
                                staging20 = Postfix(staging20, _result)
                                checkpoint8 = _pos
                            else:
                                _status = True
                                _result = staging20
                                _pos = checkpoint8
                                break
                    # </Postfix>
                    if _status:
                        staging21 = _result
                        checkpoint9 = _pos
                        while True:
                            # <Choice>
                            backtrack15 = farthest_pos12 = _pos
                            farthest_err23 = 207
                            farthest_err24 = _raise_error207
                            while True:
                                # Option 1:
                                # <String value='?'>
                                value32 = '?'
                                end32 = (_pos + 1)
                                if (_text[_pos : end32] == value32):
                                    _pos = (yield (3, _cont__ignored, end32,))[2]
                                    _status = True
                                    _result = value32
                                else:
                                    _status = False
                                    _result = _raise_error208
                                # </String>
                                if _status:
                                    break
                                if (farthest_pos12 < _pos):
                                    farthest_pos12 = _pos
                                    farthest_err24 = _result
                                _pos = backtrack15
                                # Option 2:
                                # <String value='*'>
                                value33 = '*'
                                end33 = (_pos + 1)
                                if (_text[_pos : end33] == value33):
                                    _pos = (yield (3, _cont__ignored, end33,))[2]
                                    _status = True
                                    _result = value33
                                else:
                                    _status = False
                                    _result = _raise_error209
                                # </String>
                                if _status:
                                    break
                                if (farthest_pos12 < _pos):
                                    farthest_pos12 = _pos
                                    farthest_err24 = _result
                                _pos = backtrack15
                                # Option 3:
                                # <String value='+'>
                                value34 = '+'
                                end34 = (_pos + 1)
                                if (_text[_pos : end34] == value34):
                                    _pos = (yield (3, _cont__ignored, end34,))[2]
                                    _status = True
                                    _result = value34
                                else:
                                    _status = False
                                    _result = _raise_error210
                                # </String>
                                if _status:
                                    break
                                if (farthest_pos12 < _pos):
                                    farthest_pos12 = _pos
                                    farthest_err24 = _result
                                _pos = farthest_pos12
                                _result = farthest_err24
                                break
                            # </Choice>
                            if _status:
                                staging21 = Postfix(staging21, _result)
                                checkpoint9 = _pos
                            else:
                                _status = True
                                _result = staging21
                                _pos = checkpoint9
                                break
                    # </Postfix>
                    if (not _status):
                        break
                    checkpoint10 = _pos
                    if is_first4:
                        is_first4 = False
                        staging19 = _result
                    else:
                        staging19 = Infix(staging19, operator1, _result)
                    # <Call>
                    # wrap('//' | '/')
                    func16 = _ParseFunction(_cont_wrap, (_parse_function_214,), ())
                    (_status, _result, _pos,) = (yield (3, func16, _pos,))
                    # </Call>
                    if (not _status):
                        break
                    operator1 = _result
                if (not is_first4):
                    _status = True
                    _result = staging19
                    _pos = checkpoint10
                # </LeftAssoc>
                if (not _status):
                    break
                checkpoint11 = _pos
                if is_first3:
                    is_first3 = False
                    staging18 = _result
                else:
                    staging18 = Infix(staging18, operator2, _result)
                # <Call>
                # wrap('<<' | '>>')
                func17 = _ParseFunction(_cont_wrap, (_parse_function_220,), ())
                (_status, _result, _pos,) = (yield (3, func17, _pos,))
                # </Call>
                if (not _status):
                    break
                operator2 = _result
            if (not is_first3):
                _status = True
                _result = staging18
                _pos = checkpoint11
            # </LeftAssoc>
            if (not _status):
                break
            checkpoint12 = _pos
            if is_first2:
                is_first2 = False
                staging17 = _result
            else:
                staging17 = Infix(staging17, operator3, _result)
            # <Call>
            # wrap('<|' | '|>' | 'where')
            func18 = _ParseFunction(_cont_wrap, (_parse_function_226,), ())
            (_status, _result, _pos,) = (yield (3, func18, _pos,))
            # </Call>
            if (not _status):
                break
            operator3 = _result
        if (not is_first2):
            _status = True
            _result = staging17
            _pos = checkpoint12
        # </LeftAssoc>
        if (not _status):
            break
        checkpoint13 = _pos
        if is_first1:
            is_first1 = False
            staging16 = _result
        else:
            staging16 = Infix(staging16, operator4, _result)
        # <Call>
        # wrap('|')
        arg16 = _wrap_string_literal('|', _parse_function_233)
        func19 = _ParseFunction(_cont_wrap, (arg16,), ())
        (_status, _result, _pos,) = (yield (3, func19, _pos,))
        # </Call>
        if (not _status):
            break
        operator4 = _result
    if (not is_first1):
        _status = True
        _result = staging16
        _pos = checkpoint13
    # </LeftAssoc>
    # </OperatorPrecedence>
    (yield (_status, _result, _pos,))


def _parse_Expr(text, pos=0, fullparse=True):
    return _run(text, pos, _cont_Expr, fullparse)


Expr = Rule('Expr', _parse_Expr, """
    Expr = OperatorPrecedence(
        Atom,
        Postfix(ArgList),
        Postfix('?' | '*' | '+'),
        LeftAssoc(wrap('//' | '/')),
        LeftAssoc(wrap('<<' | '>>')),
        LeftAssoc(wrap('<|' | '|>' | 'where')),
        LeftAssoc(wrap('|'))
    )
""")

def _raise_error207(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '?' | '*' | '+'\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error208(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '?'\n\n"
    "Expected to match the string '?'"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error209(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '*'\n\n"
    "Expected to match the string '*'"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error210(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '+'\n\n"
    "Expected to match the string '+'"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error214(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '//' | '/'\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error215(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '//'\n\n"
    "Expected to match the string '//'"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error216(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '/'\n\n"
    "Expected to match the string '/'"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error220(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '<<' | '>>'\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error221(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '<<'\n\n"
    "Expected to match the string '<<'"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error222(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '>>'\n\n"
    "Expected to match the string '>>'"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error226(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '<|' | '|>' | 'where'\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error227(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '<|'\n\n"
    "Expected to match the string '<|'"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error228(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '|>'\n\n"
    "Expected to match the string '|>'"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error229(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    'where'\n\n"
    "Expected to match the string 'where'"
    )
    raise ParseError((title + details), _pos, line, col)


def _raise_error233(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col,) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '|'\n\n"
    "Expected to match the string '|'"
    )
    raise ParseError((title + details), _pos, line, col)


def _cont_start(_text, _pos):
    # Rule 'start'
    # <Discard>
    # _cont__ignored >> (Skip(Newline) >> (Stmt / Sep))
    while True:
        # <Ref name='_cont__ignored'>
        (_status, _result, _pos,) = (yield (3, _cont__ignored, _pos,))
        # </Ref>
        if (not _status):
            break
        # <Discard>
        # Skip(Newline) >> (Stmt / Sep)
        while True:
            # <Skip>
            # Skip(Newline)
            while True:
                checkpoint14 = _pos
                # <Ref name='Newline'>
                (_status, _result, _pos,) = (yield (3, _cont_Newline, _pos,))
                # </Ref>
                if _status:
                    continue
                else:
                    _pos = checkpoint14
                break
            _status = True
            _result = None
            # </Skip>
            # <Alt>
            # Stmt / Sep
            staging22 = []
            checkpoint15 = _pos
            while True:
                # <Ref name='Stmt'>
                (_status, _result, _pos,) = (yield (3, _cont_Stmt, _pos,))
                # </Ref>
                if (not _status):
                    break
                staging22.append(_result)
                checkpoint15 = _pos
                # <Ref name='Sep'>
                (_status, _result, _pos,) = (yield (3, _cont_Sep, _pos,))
                # </Ref>
                if (not _status):
                    break
                checkpoint15 = _pos
            _result = staging22
            _status = True
            _pos = checkpoint15
            # </Alt>
            break
        # </Discard>
        break
    # </Discard>
    (yield (_status, _result, _pos,))


def _parse_start(text, pos=0, fullparse=True):
    return _run(text, pos, _cont_start, fullparse)


start = Rule('start', _parse_start, """
    start = _cont__ignored >> (Skip(Newline) >> (Stmt / Sep))
""")

def _cont__ignored(_text, _pos):
    # Rule '_ignored'
    # <Skip>
    # Skip(Space, Comment)
    while True:
        checkpoint16 = _pos
        # <Ref name='Space'>
        (_status, _result, _pos,) = (yield (3, _cont_Space, _pos,))
        # </Ref>
        if _status:
            continue
        else:
            _pos = checkpoint16
        # <Ref name='Comment'>
        (_status, _result, _pos,) = (yield (3, _cont_Comment, _pos,))
        # </Ref>
        if _status:
            continue
        else:
            _pos = checkpoint16
        break
    _status = True
    _result = None
    # </Skip>
    (yield (_status, _result, _pos,))


def _parse__ignored(text, pos=0, fullparse=True):
    return _run(text, pos, _cont__ignored, fullparse)


_ignored = Rule('_ignored', _parse__ignored, """
    _ignored = Skip(Space, Comment)
""")

