# ПРИМЕР КАЛИБРОВКИ МОДУЛЯ:
                                                  #
from pyiArduinoI2Ctds import *                    #   Подключаем библиотеку для работы с TDS/EC-метром I2C-flash.
tds = pyiArduinoI2Ctds(0x09)                      #   Объявляем объект tds  для работы с функциями и методами библиотеки pyiArduinoI2Ctds, указывая адрес модуля на шине I2C.
                                                  #   Если объявить объект без указания адреса (pyiArduinoI2Ctds tds ), то адрес будет найден автоматически.
val_t = 23.0                                      #   Температура калибровочных жидкостей.
                                                  #
tds.set_t(val_t)                                  #   Указываем температуру жидкости в °С.
print("ОПУСТИТЕ ДАТЧИК В 1 РАСТВОР", end='')      #
print(" (500 ppm). ")                             #
sleep(60)                                         #   Ждём 1 минуту.
print("КАЛИБРОВКА...")                            #
tds.setCalibration(1, 500)                        #   Выполняем 1 стадию калибровки указав известную концентрацию 1 раствора (в примере 1234ppm ).
sleep(10)                                         #   Ждём 10 секунд.
print("СПОЛОСНИТЕ ДАТЧИК.")                       #
sleep(30)                                         #   Ждём 30 секунд.
print("ОПУСТИТЕ ДАТЧИК В 2 РАСТВОР", end='')      #
print(" (1500 ppm). ")                            #
sleep(60)                                         #   Ждём 1 минуту.
print("КАЛИБРОВКА...")                            #
tds.setCalibration(2, 1500 )                      #   Выполняем 2 стадию калибровки указав известную концентрацию 2 раствора (в примере 4321ppm ).
sleep(10)                                         #   Ждём 10 секунд.
print("КАЛИБРОВКА ВЫПОЛНЕНА!")                    #
                                                  #
while True:                                       #
     print("TDS=", end='')                        #
     print(tds.getTDS() )                         #   Выводим количество растворённых твёрдых веществ в жидкости.
     print("мг/л.\r\n")                           #
     sleep(1)                                     #
