// ПРИМЕР КАЛИБРОВКИ МОДУЛЯ:                      // * Строки со звёздочкой являются необязательными.
                                                  //
#include "Serial.h"
#include "../iarduino_I2C_TDS.h"                  //   Подключаем библиотеку для работы с TDS/EC-метром I2C-flash.
iarduino_I2C_TDS tds(0x09);                       //   Объявляем объект tds  для работы с функциями и методами библиотеки iarduino_I2C_TDS, указывая адрес модуля на шине I2C.
                                                  //   Если объявить объект без указания адреса (iarduino_I2C_TDS tds;), то адрес будет найден автоматически.
float val_t = 23.0;                               //   Температура калибровочных жидкостей.
                                                  //
void setup(){                                     //
     delay(500);                                  // * Ждём завершение переходных процессов связанных с подачей питания.
     Serial.begin(9600);                          //   Инициируем работу с шиной UART для передачи данных в монитор последовательного порта на скорости 9600 бит/сек.
     tds.begin();                                 //   Инициируем работу с TDS/EC-метром I2C-flash.
     tds.set_t(val_t);                            //   Указываем температуру жидкости в °С.
     Serial.print("ОПУСТИТЕ ДАТЧИК В 1 РАСТВОР"); //
     Serial.print(" (500 ppm). \r\n");            //
     delay(60000);                                //   Ждём 1 минуту.
     Serial.print("КАЛИБРОВКА...\r\n");           //
     tds.setCalibration(1, 500 );                 //   Выполняем 1 стадию калибровки указав известную концентрацию 1 раствора (в примере 1234ppm ).
     delay(10000);                                //   Ждём 10 секунд.
     Serial.print("СПОЛОСНИТЕ ДАТЧИК.\r\n");      //
     delay(30000);                                //   Ждём 30 секунд.
     Serial.print("ОПУСТИТЕ ДАТЧИК В 2 РАСТВОР"); //
     Serial.print(" (1500 ppm). \r\n");           //
     delay(60000);                                //   Ждём 1 минуту.
     Serial.print("КАЛИБРОВКА...\r\n");           //
     tds.setCalibration(2, 1500 );                //   Выполняем 2 стадию калибровки указав известную концентрацию 2 раствора (в примере 4321ppm ).
     delay(10000);                                //   Ждём 10 секунд.
     Serial.print("КАЛИБРОВКА ВЫПОЛНЕНА!\r\n");   //
}                                                 //
                                                  //
void loop(){                                      //
     Serial.print("TDS=");                        //
     Serial.print(tds.getTDS() );                 //   Выводим количество растворённых твёрдых веществ в жидкости.
     Serial.print("мг/л.\r\n");                   //
     delay(1000);                                 //
}                                                 //
