import os
from parser_libraries import functions as f
from bs4 import BeautifulSoup

URL = 'http://audit.gov.ru/structure/'
HOST = 'http://audit.gov.ru'


def get_person(link):
    try:
        html = f.get_html(link['link'])
        soup = BeautifulSoup(html.text, 'html.parser')
        image_link = soup.find('div', class_='photo').find('img').get('src')
        cont = soup.find('div', class_='info').get_text().split(maxsplit=3)
        name = []
        for i in range(0, 3):
            name.append(cont[i].lower())
        bday = soup.find('div', class_='expand-field').get_text().lower()
        ind = bday.find('родил')
        bday = f.get_dig_date(bday[ind:bday.find('год')].split(maxsplit=1)[1])
        return {'position_id': link['work'], 'first_name': name[1], 'middle_name': name[0], 'last_name': name[2],
                'bday': bday['day'], 'bmonth': bday['month'], 'byear': bday['year'], 'image_link': image_link, 'link': link['link']}
    except:
        return 1

def parser():
    links = []
    people = []
    html = f.get_html(URL)
    if html.status_code == 200:
        soup = BeautifulSoup(html.text, 'html.parser')
        items = soup.find_all('div', class_='structure-row flex')
        for item in items:
            arr = item.find_all('a', class_='person flex flex-center-v col-4')
            for ar in arr:
                work = ar.get_text()
                work = work.split(maxsplit=3)
                work = f.get_work(work[-1].lower(), 34)
                if work != -1:
                    links.append({'link': HOST + ar.get('href'), 'work': work})
        for link in links:
            box = get_person(link)
            if box == 1:
                return [{'code': 1, 'script': os.path.basename(__file__)}]
            people.append(box)
        return people
    else:
        return [{'code': 2, 'script': os.path.basename(__file__)}]