# p_terraformer

p_terraformer is a CLI that extends terraformer.

## support

### support platform

The following environments are supported

* Darwin
* Linux

### support python version

* python version 3.9.x ~ 3.10.1

## install

terraformer must be installed to use p_terraformer.
To install terraformer from official sources, please check the following documentation.
An installation program is provided in this repository.

### install terraformer

```:terminal
python terraformer_install.py
```

Please refer to the following document for official installation.
ref: https://github.com/GoogleCloudPlatform/terraformer

### install p_terraformer

To install p_terraformer yourself, you will need to execute the following code

```:terminal
python setup.py install
```

## quick

### How to register for secret

You can configure the profile by executing the following command and entering each item The entered information is recorded in `.p_terraformer/config.yaml`.

```:terminal
$ p_terraformer profile

---output---
Please enter a profile name >hogehoge
secret manager api_key >hogehoge
secret manager app_key >hogehoge
```

```:output
---example---
profile:
- name: hogehoge
  api_key: hogehoge
  app_key: hogehoge
```

### Datadog

#### When using aws secret manager

* Generate dashboard

```:terminal
p_terraformer datadog aws_secret -p hogehoge --resource dashboard --resource_id hogehoge
```

Resource can be generated by entering the name of the resource you wish to generate in --resource and entering the corresponding resource id.

※ you must register a secret in the profile

#### When using secret default

```:terminal
p_terraformer datadog default_secret --api_key hogehoge --app_key hogehoge--resource dashboard --resource_id hogehoge
```

## AWS

* Generate sqs

```:terminal
p_terraformer aws --resource sqs --resource_id aws_sqs_queue=hogehoge --aws_profile=hogehoge
```

You can output the resource you want to retrieve by entering the name of the resource you want to retrieve in `--resource`, the filter in `--resource_id`, and the profile name of the environment you want to retrieve in `--aws_profile`.

※The default value for `--aws_profile` is default.

Check the terraformer documentation for details on how to obtain this information.

ref: https://github.com/GoogleCloudPlatform/terraformer/blob/master/docs/aws.md