"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EvaluateExpression = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const sfn = require("@aws-cdk/aws-stepfunctions");
/**
 * A Step Functions Task to evaluate an expression
 *
 * OUTPUT: the output of this task is the evaluated expression.
 *
 */
class EvaluateExpression extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_EvaluateExpressionProps(props);
        this.evalFn = createEvalFn((_b = this.props.runtime) !== null && _b !== void 0 ? _b : lambda.Runtime.NODEJS_14_X, this);
        this.taskPolicies = [
            new iam.PolicyStatement({
                resources: this.evalFn.resourceArnsForGrantInvoke,
                actions: ['lambda:InvokeFunction'],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        const matches = this.props.expression.match(/\$[.\[][.a-zA-Z[\]0-9-_]+/g);
        let expressionAttributeValues = {};
        if (matches) {
            expressionAttributeValues = matches.reduce((acc, m) => ({
                ...acc,
                [m]: sfn.JsonPath.stringAt(m),
            }), {});
        }
        const parameters = {
            expression: this.props.expression,
            expressionAttributeValues,
        };
        return {
            Resource: this.evalFn.functionArn,
            Parameters: sfn.FieldUtils.renderObject(parameters),
        };
    }
}
exports.EvaluateExpression = EvaluateExpression;
_a = JSII_RTTI_SYMBOL_1;
EvaluateExpression[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.EvaluateExpression", version: "1.151.0" };
function createEvalFn(runtime, scope) {
    const lambdaPurpose = 'Eval';
    const nodeJsGuids = {
        [lambda.Runtime.NODEJS_14_X.name]: 'da2d1181-604e-4a45-8694-1a6abd7fe42d',
        [lambda.Runtime.NODEJS_12_X.name]: '2b81e383-aad2-44db-8aaf-b4809ae0e3b4',
        [lambda.Runtime.NODEJS_10_X.name]: 'a0d2ce44-871b-4e74-87a1-f5e63d7c3bdc',
    };
    switch (runtime) {
        case lambda.Runtime.NODEJS_14_X:
        case lambda.Runtime.NODEJS_12_X:
        case lambda.Runtime.NODEJS_10_X:
            const uuid = nodeJsGuids[runtime.name];
            if (uuid) {
                return new lambda.SingletonFunction(scope, 'EvalFunction', {
                    runtime,
                    uuid,
                    handler: 'index.handler',
                    lambdaPurpose,
                    code: lambda.Code.fromAsset(path.join(__dirname, 'eval-nodejs-handler')),
                });
            }
            break;
    }
    throw new Error(`The runtime ${runtime.name} is currently not supported.`);
}
//# sourceMappingURL=data:application/json;base64,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