"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceGroupModifyConfigPropertyToJson = exports.BootstrapActionConfigToJson = exports.PlacementTypePropertyToJson = exports.InstanceGroupConfigPropertyToJson = exports.AutoScalingPolicyPropertyToJson = exports.ScalingRulePropertyToJson = exports.ScalingActionPropertyToJson = exports.ScalingTriggerPropertyToJson = exports.MetricDimensionPropertyToJson = exports.InstanceFleetConfigPropertyToJson = exports.InstanceFleetProvisioningSpecificationsPropertyToJson = exports.InstanceTypeConfigPropertyToJson = exports.EbsConfigurationPropertyToJson = exports.EbsBlockDeviceConfigPropertyToJson = exports.ConfigurationPropertyToJson = exports.ApplicationConfigPropertyToJson = exports.InstancesConfigPropertyToJson = exports.KerberosAttributesPropertyToJson = void 0;
const cdk = require("@aws-cdk/core");
/**
 * Render the KerberosAttributesProperty as JSON
 *
 * @param property
 */
function KerberosAttributesPropertyToJson(property) {
    return {
        ADDomainJoinPassword: cdk.stringToCloudFormation(property.adDomainJoinPassword),
        ADDomainJoinUser: cdk.stringToCloudFormation(property.adDomainJoinUser),
        CrossRealmTrustPrincipalPassword: cdk.stringToCloudFormation(property.crossRealmTrustPrincipalPassword),
        KdcAdminPassword: cdk.stringToCloudFormation(property.kdcAdminPassword),
        Realm: cdk.stringToCloudFormation(property.realm),
    };
}
exports.KerberosAttributesPropertyToJson = KerberosAttributesPropertyToJson;
/**
 * Render the InstancesConfigProperty to JSON
 *
 * @param property
 */
function InstancesConfigPropertyToJson(property) {
    return {
        AdditionalMasterSecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(property.additionalMasterSecurityGroups),
        AdditionalSlaveSecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(property.additionalSlaveSecurityGroups),
        Ec2KeyName: cdk.stringToCloudFormation(property.ec2KeyName),
        Ec2SubnetId: cdk.stringToCloudFormation(property.ec2SubnetId),
        Ec2SubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(property.ec2SubnetIds),
        EmrManagedMasterSecurityGroup: cdk.stringToCloudFormation(property.emrManagedMasterSecurityGroup),
        EmrManagedSlaveSecurityGroup: cdk.stringToCloudFormation(property.emrManagedSlaveSecurityGroup),
        HadoopVersion: cdk.stringToCloudFormation(property.hadoopVersion),
        InstanceCount: cdk.numberToCloudFormation(property.instanceCount),
        InstanceFleets: cdk.listMapper(InstanceFleetConfigPropertyToJson)(property.instanceFleets),
        InstanceGroups: cdk.listMapper(InstanceGroupConfigPropertyToJson)(property.instanceGroups),
        KeepJobFlowAliveWhenNoSteps: true,
        MasterInstanceType: cdk.stringToCloudFormation(property.masterInstanceType),
        Placement: property.placement === undefined ? property.placement : PlacementTypePropertyToJson(property.placement),
        ServiceAccessSecurityGroup: cdk.stringToCloudFormation(property.serviceAccessSecurityGroup),
        SlaveInstanceType: cdk.stringToCloudFormation(property.slaveInstanceType),
        TerminationProtected: cdk.booleanToCloudFormation(property.terminationProtected),
    };
}
exports.InstancesConfigPropertyToJson = InstancesConfigPropertyToJson;
/**
 * Render the ApplicationConfigProperty as JSON
 *
 * @param property
 */
function ApplicationConfigPropertyToJson(property) {
    return {
        Name: cdk.stringToCloudFormation(property.name),
        Args: cdk.listMapper(cdk.stringToCloudFormation)(property.args),
        Version: cdk.stringToCloudFormation(property.version),
        AdditionalInfo: cdk.objectToCloudFormation(property.additionalInfo),
    };
}
exports.ApplicationConfigPropertyToJson = ApplicationConfigPropertyToJson;
/**
 * Render the ConfigurationProperty as JSON
 *
 * @param property
 */
function ConfigurationPropertyToJson(property) {
    return {
        Classification: cdk.stringToCloudFormation(property.classification),
        Properties: cdk.objectToCloudFormation(property.properties),
        Configurations: cdk.listMapper(ConfigurationPropertyToJson)(property.configurations),
    };
}
exports.ConfigurationPropertyToJson = ConfigurationPropertyToJson;
/**
 * Render the EbsBlockDeviceConfigProperty as JSON
 *
 * @param property
 */
function EbsBlockDeviceConfigPropertyToJson(property) {
    var _a, _b;
    return {
        VolumeSpecification: {
            Iops: cdk.numberToCloudFormation(property.volumeSpecification.iops),
            SizeInGB: (_a = property.volumeSpecification.volumeSize) === null || _a === void 0 ? void 0 : _a.toGibibytes(),
            VolumeType: cdk.stringToCloudFormation((_b = property.volumeSpecification.volumeType) === null || _b === void 0 ? void 0 : _b.valueOf()),
        },
        VolumesPerInstance: cdk.numberToCloudFormation(property.volumesPerInstance),
    };
}
exports.EbsBlockDeviceConfigPropertyToJson = EbsBlockDeviceConfigPropertyToJson;
/**
 * Render the EbsConfigurationProperty to JSON
 *
 * @param property
 */
function EbsConfigurationPropertyToJson(property) {
    return {
        EbsBlockDeviceConfigs: cdk.listMapper(EbsBlockDeviceConfigPropertyToJson)(property.ebsBlockDeviceConfigs),
        EbsOptimized: cdk.booleanToCloudFormation(property.ebsOptimized),
    };
}
exports.EbsConfigurationPropertyToJson = EbsConfigurationPropertyToJson;
/**
 * Render the InstanceTypeConfigProperty to JSON]
 *
 * @param property
 */
function InstanceTypeConfigPropertyToJson(property) {
    var _a;
    return {
        BidPrice: cdk.stringToCloudFormation(property.bidPrice),
        BidPriceAsPercentageOfOnDemandPrice: cdk.numberToCloudFormation(property.bidPriceAsPercentageOfOnDemandPrice),
        Configurations: cdk.listMapper(ConfigurationPropertyToJson)(property.configurations),
        EbsConfiguration: property.ebsConfiguration === undefined ? property.ebsConfiguration : EbsConfigurationPropertyToJson(property.ebsConfiguration),
        InstanceType: cdk.stringToCloudFormation((_a = property.instanceType) === null || _a === void 0 ? void 0 : _a.valueOf()),
        WeightedCapacity: cdk.numberToCloudFormation(property.weightedCapacity),
    };
}
exports.InstanceTypeConfigPropertyToJson = InstanceTypeConfigPropertyToJson;
/**
 * Render the InstanceFleetProvisioningSpecificationsProperty to JSON
 *
 * @param property
 */
function InstanceFleetProvisioningSpecificationsPropertyToJson(property) {
    var _a;
    return {
        SpotSpecification: {
            AllocationStrategy: cdk.stringToCloudFormation(property.spotSpecification.allocationStrategy),
            BlockDurationMinutes: cdk.numberToCloudFormation(property.spotSpecification.blockDurationMinutes),
            TimeoutAction: cdk.stringToCloudFormation((_a = property.spotSpecification.timeoutAction) === null || _a === void 0 ? void 0 : _a.valueOf()),
            TimeoutDurationMinutes: cdk.numberToCloudFormation(property.spotSpecification.timeoutDurationMinutes),
        },
    };
}
exports.InstanceFleetProvisioningSpecificationsPropertyToJson = InstanceFleetProvisioningSpecificationsPropertyToJson;
/**
 * Render the InstanceFleetConfigProperty as JSON
 *
 * @param property
 */
function InstanceFleetConfigPropertyToJson(property) {
    var _a;
    return {
        InstanceFleetType: cdk.stringToCloudFormation((_a = property.instanceFleetType) === null || _a === void 0 ? void 0 : _a.valueOf()),
        InstanceTypeConfigs: cdk.listMapper(InstanceTypeConfigPropertyToJson)(property.instanceTypeConfigs),
        LaunchSpecifications: property.launchSpecifications === undefined
            ? property.launchSpecifications
            : InstanceFleetProvisioningSpecificationsPropertyToJson(property.launchSpecifications),
        Name: cdk.stringToCloudFormation(property.name),
        TargetOnDemandCapacity: cdk.numberToCloudFormation(property.targetOnDemandCapacity),
        TargetSpotCapacity: cdk.numberToCloudFormation(property.targetSpotCapacity),
    };
}
exports.InstanceFleetConfigPropertyToJson = InstanceFleetConfigPropertyToJson;
/**
 * Render the MetricDimensionProperty as JSON
 *
 * @param property
 */
function MetricDimensionPropertyToJson(property) {
    return {
        Key: cdk.stringToCloudFormation(property.key),
        Value: cdk.stringToCloudFormation(property.value),
    };
}
exports.MetricDimensionPropertyToJson = MetricDimensionPropertyToJson;
/**
 * Render the ScalingTriggerProperty to JSON
 *
 * @param property
 */
function ScalingTriggerPropertyToJson(property) {
    var _a, _b, _c;
    return {
        CloudWatchAlarmDefinition: {
            ComparisonOperator: cdk.stringToCloudFormation((_a = property.cloudWatchAlarmDefinition.comparisonOperator) === null || _a === void 0 ? void 0 : _a.valueOf()),
            Dimensions: cdk.listMapper(MetricDimensionPropertyToJson)(property.cloudWatchAlarmDefinition.dimensions),
            EvaluationPeriods: cdk.numberToCloudFormation(property.cloudWatchAlarmDefinition.evaluationPeriods),
            MetricName: cdk.stringToCloudFormation(property.cloudWatchAlarmDefinition.metricName),
            Namespace: cdk.stringToCloudFormation(property.cloudWatchAlarmDefinition.namespace),
            Period: cdk.numberToCloudFormation(property.cloudWatchAlarmDefinition.period.toSeconds()),
            Statistic: cdk.stringToCloudFormation((_b = property.cloudWatchAlarmDefinition.statistic) === null || _b === void 0 ? void 0 : _b.valueOf()),
            Threshold: cdk.numberToCloudFormation(property.cloudWatchAlarmDefinition.threshold),
            Unit: cdk.stringToCloudFormation((_c = property.cloudWatchAlarmDefinition.unit) === null || _c === void 0 ? void 0 : _c.valueOf()),
        },
    };
}
exports.ScalingTriggerPropertyToJson = ScalingTriggerPropertyToJson;
/**
 * Render the ScalingActionProperty to JSON
 *
 * @param property
 */
function ScalingActionPropertyToJson(property) {
    var _a;
    return {
        Market: cdk.stringToCloudFormation((_a = property.market) === null || _a === void 0 ? void 0 : _a.valueOf()),
        SimpleScalingPolicyConfiguration: {
            AdjustmentType: cdk.stringToCloudFormation(property.simpleScalingPolicyConfiguration.adjustmentType),
            CoolDown: cdk.numberToCloudFormation(property.simpleScalingPolicyConfiguration.coolDown),
            ScalingAdjustment: cdk.numberToCloudFormation(property.simpleScalingPolicyConfiguration.scalingAdjustment),
        },
    };
}
exports.ScalingActionPropertyToJson = ScalingActionPropertyToJson;
/**
 * Render the ScalingRuleProperty to JSON
 *
 * @param property
 */
function ScalingRulePropertyToJson(property) {
    return {
        Action: ScalingActionPropertyToJson(property.action),
        Description: cdk.stringToCloudFormation(property.description),
        Name: cdk.stringToCloudFormation(property.name),
        Trigger: ScalingTriggerPropertyToJson(property.trigger),
    };
}
exports.ScalingRulePropertyToJson = ScalingRulePropertyToJson;
/**
 * Render the AutoScalingPolicyProperty to JSON
 *
 * @param property
 */
function AutoScalingPolicyPropertyToJson(property) {
    return {
        Constraints: {
            MaxCapacity: cdk.numberToCloudFormation(property.constraints.maxCapacity),
            MinCapacity: cdk.numberToCloudFormation(property.constraints.minCapacity),
        },
        Rules: cdk.listMapper(ScalingRulePropertyToJson)(property.rules),
    };
}
exports.AutoScalingPolicyPropertyToJson = AutoScalingPolicyPropertyToJson;
/**
 * Render the InstanceGroupConfigProperty to JSON
 *
 * @param property
 */
function InstanceGroupConfigPropertyToJson(property) {
    var _a, _b;
    return {
        AutoScalingPolicy: property.autoScalingPolicy === undefined ? property.autoScalingPolicy : AutoScalingPolicyPropertyToJson(property.autoScalingPolicy),
        BidPrice: cdk.numberToCloudFormation(property.bidPrice),
        Configurations: cdk.listMapper(ConfigurationPropertyToJson)(property.configurations),
        EbsConfiguration: property.ebsConfiguration === undefined ? property.ebsConfiguration : EbsConfigurationPropertyToJson(property.ebsConfiguration),
        InstanceCount: cdk.numberToCloudFormation(property.instanceCount),
        InstanceRole: cdk.stringToCloudFormation((_a = property.instanceRole) === null || _a === void 0 ? void 0 : _a.valueOf()),
        InstanceType: cdk.stringToCloudFormation(property.instanceType),
        Market: cdk.stringToCloudFormation((_b = property.market) === null || _b === void 0 ? void 0 : _b.valueOf()),
        Name: cdk.stringToCloudFormation(property.name),
    };
}
exports.InstanceGroupConfigPropertyToJson = InstanceGroupConfigPropertyToJson;
/**
 * Render the PlacementTypeProperty to JSON
 *
 * @param property
 */
function PlacementTypePropertyToJson(property) {
    return {
        AvailabilityZone: cdk.stringToCloudFormation(property.availabilityZone),
        AvailabilityZones: cdk.listMapper(cdk.stringToCloudFormation)(property.availabilityZones),
    };
}
exports.PlacementTypePropertyToJson = PlacementTypePropertyToJson;
/**
 * Render the BootstrapActionProperty as JSON
 *
 * @param property
 */
function BootstrapActionConfigToJson(property) {
    return {
        Name: cdk.stringToCloudFormation(property.name),
        ScriptBootstrapAction: {
            Path: cdk.stringToCloudFormation(property.scriptBootstrapAction.path),
            Args: cdk.listMapper(cdk.stringToCloudFormation)(property.scriptBootstrapAction.args),
        },
    };
}
exports.BootstrapActionConfigToJson = BootstrapActionConfigToJson;
/**
 * Render the InstanceGroupModifyConfigProperty to JSON
 *
 * @param property
 */
function InstanceGroupModifyConfigPropertyToJson(property) {
    return {
        Configurations: cdk.listMapper(ConfigurationPropertyToJson)(property.configurations),
        EC2InstanceIdsToTerminate: cdk.listMapper(cdk.stringToCloudFormation)(property.eC2InstanceIdsToTerminate),
        InstanceCount: cdk.numberToCloudFormation(property.instanceCount),
        ShrinkPolicy: property.shrinkPolicy === undefined ? property.shrinkPolicy : ShrinkPolicyPropertyToJson(property.shrinkPolicy),
    };
}
exports.InstanceGroupModifyConfigPropertyToJson = InstanceGroupModifyConfigPropertyToJson;
/**
 * Render the ShrinkPolicyProperty to JSON
 *
 * @param property
 */
function ShrinkPolicyPropertyToJson(property) {
    var _a;
    return {
        DecommissionTimeout: cdk.numberToCloudFormation((_a = property.decommissionTimeout) === null || _a === void 0 ? void 0 : _a.toSeconds()),
        InstanceResizePolicy: property.instanceResizePolicy ? InstanceResizePolicyPropertyToJson(property.instanceResizePolicy) : undefined,
    };
}
/**
 * Render the InstanceResizePolicyProperty to JSON
 *
 * @param property
 */
function InstanceResizePolicyPropertyToJson(property) {
    var _a;
    return {
        InstancesToProtect: cdk.listMapper(cdk.stringToCloudFormation)(property.instancesToProtect),
        InstancesToTerminate: cdk.listMapper(cdk.stringToCloudFormation)(property.instancesToTerminate),
        InstanceTerminationTimeout: cdk.numberToCloudFormation((_a = property.instanceTerminationTimeout) === null || _a === void 0 ? void 0 : _a.toSeconds()),
    };
}
//# sourceMappingURL=data:application/json;base64,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