"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Table = exports.TableProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ots_generated_1 = require("./ots.generated");
Object.defineProperty(exports, "TableProperty", { enumerable: true, get: function () { return ots_generated_1.RosTable; } });
/**
 * A ROS resource type:  `ALIYUN::OTS::Table`
 */
class Table extends ros.Resource {
    /**
     * Create a new `ALIYUN::OTS::Table`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosTable = new ots_generated_1.RosTable(this, id, {
            instanceName: props.instanceName,
            tableName: props.tableName,
            timeToLive: props.timeToLive === undefined || props.timeToLive === null ? -1 : props.timeToLive,
            maxVersions: props.maxVersions === undefined || props.maxVersions === null ? 1 : props.maxVersions,
            secondaryIndices: props.secondaryIndices,
            deviationCellVersionInSec: props.deviationCellVersionInSec === undefined || props.deviationCellVersionInSec === null ? 86400 : props.deviationCellVersionInSec,
            primaryKey: props.primaryKey,
            columns: props.columns,
            reservedThroughput: props.reservedThroughput,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTable;
        this.attrTableName = rosTable.attrTableName;
    }
}
exports.Table = Table;
//# sourceMappingURL=data:application/json;base64,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