import { Stack, StackProps } from 'aws-cdk-lib';
import * as resourcegroups from 'aws-cdk-lib/aws-resourcegroups';
import { Construct } from 'constructs';
import * as utils from '../common/utils';
export interface BaseStackProps extends StackProps {
    readonly stage: string;
}
export declare class BaseStack extends Stack {
    stage: string;
    constructor(scope: Construct, id: string, props: BaseStackProps);
    addBaseTags(model: any, props?: utils.BaseTagProps): void;
    createResourcesGroup(): resourcegroups.CfnGroup;
}
