# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class VoicemailSearchCriteria(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        VoicemailSearchCriteria - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'end_value': 'str',
            'values': 'list[str]',
            'start_value': 'str',
            'fields': 'list[str]',
            'value': 'str',
            'operator': 'str',
            'group': 'list[VoicemailSearchCriteria]',
            'date_format': 'str',
            'type': 'str'
        }

        self.attribute_map = {
            'end_value': 'endValue',
            'values': 'values',
            'start_value': 'startValue',
            'fields': 'fields',
            'value': 'value',
            'operator': 'operator',
            'group': 'group',
            'date_format': 'dateFormat',
            'type': 'type'
        }

        self._end_value = None
        self._values = None
        self._start_value = None
        self._fields = None
        self._value = None
        self._operator = None
        self._group = None
        self._date_format = None
        self._type = None

    @property
    def end_value(self):
        """
        Gets the end_value of this VoicemailSearchCriteria.
        The end value of the range. This field is used for range search types.

        :return: The end_value of this VoicemailSearchCriteria.
        :rtype: str
        """
        return self._end_value

    @end_value.setter
    def end_value(self, end_value):
        """
        Sets the end_value of this VoicemailSearchCriteria.
        The end value of the range. This field is used for range search types.

        :param end_value: The end_value of this VoicemailSearchCriteria.
        :type: str
        """
        
        self._end_value = end_value

    @property
    def values(self):
        """
        Gets the values of this VoicemailSearchCriteria.
        A list of values for the search to match against

        :return: The values of this VoicemailSearchCriteria.
        :rtype: list[str]
        """
        return self._values

    @values.setter
    def values(self, values):
        """
        Sets the values of this VoicemailSearchCriteria.
        A list of values for the search to match against

        :param values: The values of this VoicemailSearchCriteria.
        :type: list[str]
        """
        
        self._values = values

    @property
    def start_value(self):
        """
        Gets the start_value of this VoicemailSearchCriteria.
        The start value of the range. This field is used for range search types.

        :return: The start_value of this VoicemailSearchCriteria.
        :rtype: str
        """
        return self._start_value

    @start_value.setter
    def start_value(self, start_value):
        """
        Sets the start_value of this VoicemailSearchCriteria.
        The start value of the range. This field is used for range search types.

        :param start_value: The start_value of this VoicemailSearchCriteria.
        :type: str
        """
        
        self._start_value = start_value

    @property
    def fields(self):
        """
        Gets the fields of this VoicemailSearchCriteria.
        Field names to search against

        :return: The fields of this VoicemailSearchCriteria.
        :rtype: list[str]
        """
        return self._fields

    @fields.setter
    def fields(self, fields):
        """
        Sets the fields of this VoicemailSearchCriteria.
        Field names to search against

        :param fields: The fields of this VoicemailSearchCriteria.
        :type: list[str]
        """
        
        self._fields = fields

    @property
    def value(self):
        """
        Gets the value of this VoicemailSearchCriteria.
        A value for the search to match against

        :return: The value of this VoicemailSearchCriteria.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this VoicemailSearchCriteria.
        A value for the search to match against

        :param value: The value of this VoicemailSearchCriteria.
        :type: str
        """
        
        self._value = value

    @property
    def operator(self):
        """
        Gets the operator of this VoicemailSearchCriteria.
        How to apply this search criteria against other criteria

        :return: The operator of this VoicemailSearchCriteria.
        :rtype: str
        """
        return self._operator

    @operator.setter
    def operator(self, operator):
        """
        Sets the operator of this VoicemailSearchCriteria.
        How to apply this search criteria against other criteria

        :param operator: The operator of this VoicemailSearchCriteria.
        :type: str
        """
        allowed_values = ["AND", "OR", "NOT"]
        if operator.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for operator -> " + operator
            self._operator = "outdated_sdk_version"
        else:
            self._operator = operator

    @property
    def group(self):
        """
        Gets the group of this VoicemailSearchCriteria.
        Groups multiple conditions

        :return: The group of this VoicemailSearchCriteria.
        :rtype: list[VoicemailSearchCriteria]
        """
        return self._group

    @group.setter
    def group(self, group):
        """
        Sets the group of this VoicemailSearchCriteria.
        Groups multiple conditions

        :param group: The group of this VoicemailSearchCriteria.
        :type: list[VoicemailSearchCriteria]
        """
        
        self._group = group

    @property
    def date_format(self):
        """
        Gets the date_format of this VoicemailSearchCriteria.
        Set date format for criteria values when using date range search type.  Supports Java date format syntax, example yyyy-MM-dd'T'HH:mm:ss.SSSX.

        :return: The date_format of this VoicemailSearchCriteria.
        :rtype: str
        """
        return self._date_format

    @date_format.setter
    def date_format(self, date_format):
        """
        Sets the date_format of this VoicemailSearchCriteria.
        Set date format for criteria values when using date range search type.  Supports Java date format syntax, example yyyy-MM-dd'T'HH:mm:ss.SSSX.

        :param date_format: The date_format of this VoicemailSearchCriteria.
        :type: str
        """
        
        self._date_format = date_format

    @property
    def type(self):
        """
        Gets the type of this VoicemailSearchCriteria.
        Search Type

        :return: The type of this VoicemailSearchCriteria.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this VoicemailSearchCriteria.
        Search Type

        :param type: The type of this VoicemailSearchCriteria.
        :type: str
        """
        allowed_values = ["EXACT", "STARTS_WITH", "CONTAINS", "REGEX", "TERM", "TERMS", "REQUIRED_FIELDS", "MATCH_ALL"]
        if type.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for type -> " + type
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

