# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ShiftTradeResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ShiftTradeResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'week_date': 'date',
            'schedule': 'BuScheduleReferenceForMuRoute',
            'state': 'str',
            'initiating_user': 'UserReference',
            'initiating_shift_id': 'str',
            'initiating_shift_start': 'datetime',
            'initiating_shift_end': 'datetime',
            'receiving_user': 'UserReference',
            'receiving_shift_id': 'str',
            'receiving_shift_start': 'datetime',
            'receiving_shift_end': 'datetime',
            'expiration': 'datetime',
            'one_sided': 'bool',
            'acceptable_intervals': 'list[str]',
            'reviewed_by': 'UserReference',
            'reviewed_date': 'datetime',
            'metadata': 'WfmVersionedEntityMetadata'
        }

        self.attribute_map = {
            'id': 'id',
            'week_date': 'weekDate',
            'schedule': 'schedule',
            'state': 'state',
            'initiating_user': 'initiatingUser',
            'initiating_shift_id': 'initiatingShiftId',
            'initiating_shift_start': 'initiatingShiftStart',
            'initiating_shift_end': 'initiatingShiftEnd',
            'receiving_user': 'receivingUser',
            'receiving_shift_id': 'receivingShiftId',
            'receiving_shift_start': 'receivingShiftStart',
            'receiving_shift_end': 'receivingShiftEnd',
            'expiration': 'expiration',
            'one_sided': 'oneSided',
            'acceptable_intervals': 'acceptableIntervals',
            'reviewed_by': 'reviewedBy',
            'reviewed_date': 'reviewedDate',
            'metadata': 'metadata'
        }

        self._id = None
        self._week_date = None
        self._schedule = None
        self._state = None
        self._initiating_user = None
        self._initiating_shift_id = None
        self._initiating_shift_start = None
        self._initiating_shift_end = None
        self._receiving_user = None
        self._receiving_shift_id = None
        self._receiving_shift_start = None
        self._receiving_shift_end = None
        self._expiration = None
        self._one_sided = None
        self._acceptable_intervals = None
        self._reviewed_by = None
        self._reviewed_date = None
        self._metadata = None

    @property
    def id(self):
        """
        Gets the id of this ShiftTradeResponse.
        The ID of this shift trade

        :return: The id of this ShiftTradeResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ShiftTradeResponse.
        The ID of this shift trade

        :param id: The id of this ShiftTradeResponse.
        :type: str
        """
        
        self._id = id

    @property
    def week_date(self):
        """
        Gets the week_date of this ShiftTradeResponse.
        The start week date of the associated schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The week_date of this ShiftTradeResponse.
        :rtype: date
        """
        return self._week_date

    @week_date.setter
    def week_date(self, week_date):
        """
        Sets the week_date of this ShiftTradeResponse.
        The start week date of the associated schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param week_date: The week_date of this ShiftTradeResponse.
        :type: date
        """
        
        self._week_date = week_date

    @property
    def schedule(self):
        """
        Gets the schedule of this ShiftTradeResponse.
        A reference to the associated schedule

        :return: The schedule of this ShiftTradeResponse.
        :rtype: BuScheduleReferenceForMuRoute
        """
        return self._schedule

    @schedule.setter
    def schedule(self, schedule):
        """
        Sets the schedule of this ShiftTradeResponse.
        A reference to the associated schedule

        :param schedule: The schedule of this ShiftTradeResponse.
        :type: BuScheduleReferenceForMuRoute
        """
        
        self._schedule = schedule

    @property
    def state(self):
        """
        Gets the state of this ShiftTradeResponse.
        The state of this shift trade

        :return: The state of this ShiftTradeResponse.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this ShiftTradeResponse.
        The state of this shift trade

        :param state: The state of this ShiftTradeResponse.
        :type: str
        """
        allowed_values = ["Unmatched", "Matched", "Approved", "Denied", "Expired", "Canceled"]
        if state.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for state -> " + state
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def initiating_user(self):
        """
        Gets the initiating_user of this ShiftTradeResponse.
        The user who initiated this trade

        :return: The initiating_user of this ShiftTradeResponse.
        :rtype: UserReference
        """
        return self._initiating_user

    @initiating_user.setter
    def initiating_user(self, initiating_user):
        """
        Sets the initiating_user of this ShiftTradeResponse.
        The user who initiated this trade

        :param initiating_user: The initiating_user of this ShiftTradeResponse.
        :type: UserReference
        """
        
        self._initiating_user = initiating_user

    @property
    def initiating_shift_id(self):
        """
        Gets the initiating_shift_id of this ShiftTradeResponse.
        The ID of the shift offered for trade by the initiating user

        :return: The initiating_shift_id of this ShiftTradeResponse.
        :rtype: str
        """
        return self._initiating_shift_id

    @initiating_shift_id.setter
    def initiating_shift_id(self, initiating_shift_id):
        """
        Sets the initiating_shift_id of this ShiftTradeResponse.
        The ID of the shift offered for trade by the initiating user

        :param initiating_shift_id: The initiating_shift_id of this ShiftTradeResponse.
        :type: str
        """
        
        self._initiating_shift_id = initiating_shift_id

    @property
    def initiating_shift_start(self):
        """
        Gets the initiating_shift_start of this ShiftTradeResponse.
        The start date/time of the shift being offered for trade. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The initiating_shift_start of this ShiftTradeResponse.
        :rtype: datetime
        """
        return self._initiating_shift_start

    @initiating_shift_start.setter
    def initiating_shift_start(self, initiating_shift_start):
        """
        Sets the initiating_shift_start of this ShiftTradeResponse.
        The start date/time of the shift being offered for trade. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param initiating_shift_start: The initiating_shift_start of this ShiftTradeResponse.
        :type: datetime
        """
        
        self._initiating_shift_start = initiating_shift_start

    @property
    def initiating_shift_end(self):
        """
        Gets the initiating_shift_end of this ShiftTradeResponse.
        The end date/time of the shift being offered for trade. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The initiating_shift_end of this ShiftTradeResponse.
        :rtype: datetime
        """
        return self._initiating_shift_end

    @initiating_shift_end.setter
    def initiating_shift_end(self, initiating_shift_end):
        """
        Sets the initiating_shift_end of this ShiftTradeResponse.
        The end date/time of the shift being offered for trade. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param initiating_shift_end: The initiating_shift_end of this ShiftTradeResponse.
        :type: datetime
        """
        
        self._initiating_shift_end = initiating_shift_end

    @property
    def receiving_user(self):
        """
        Gets the receiving_user of this ShiftTradeResponse.
        The user matching the trade, or if the state is not Matched, the user to whom the trade request was sent

        :return: The receiving_user of this ShiftTradeResponse.
        :rtype: UserReference
        """
        return self._receiving_user

    @receiving_user.setter
    def receiving_user(self, receiving_user):
        """
        Sets the receiving_user of this ShiftTradeResponse.
        The user matching the trade, or if the state is not Matched, the user to whom the trade request was sent

        :param receiving_user: The receiving_user of this ShiftTradeResponse.
        :type: UserReference
        """
        
        self._receiving_user = receiving_user

    @property
    def receiving_shift_id(self):
        """
        Gets the receiving_shift_id of this ShiftTradeResponse.
        The ID of the shift being exchanged for the initiating shift, null if the receiving user is picking up a shift

        :return: The receiving_shift_id of this ShiftTradeResponse.
        :rtype: str
        """
        return self._receiving_shift_id

    @receiving_shift_id.setter
    def receiving_shift_id(self, receiving_shift_id):
        """
        Sets the receiving_shift_id of this ShiftTradeResponse.
        The ID of the shift being exchanged for the initiating shift, null if the receiving user is picking up a shift

        :param receiving_shift_id: The receiving_shift_id of this ShiftTradeResponse.
        :type: str
        """
        
        self._receiving_shift_id = receiving_shift_id

    @property
    def receiving_shift_start(self):
        """
        Gets the receiving_shift_start of this ShiftTradeResponse.
        The start date/time of the receiving shift. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The receiving_shift_start of this ShiftTradeResponse.
        :rtype: datetime
        """
        return self._receiving_shift_start

    @receiving_shift_start.setter
    def receiving_shift_start(self, receiving_shift_start):
        """
        Sets the receiving_shift_start of this ShiftTradeResponse.
        The start date/time of the receiving shift. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param receiving_shift_start: The receiving_shift_start of this ShiftTradeResponse.
        :type: datetime
        """
        
        self._receiving_shift_start = receiving_shift_start

    @property
    def receiving_shift_end(self):
        """
        Gets the receiving_shift_end of this ShiftTradeResponse.
        The end date/time of the receiving shift. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The receiving_shift_end of this ShiftTradeResponse.
        :rtype: datetime
        """
        return self._receiving_shift_end

    @receiving_shift_end.setter
    def receiving_shift_end(self, receiving_shift_end):
        """
        Sets the receiving_shift_end of this ShiftTradeResponse.
        The end date/time of the receiving shift. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param receiving_shift_end: The receiving_shift_end of this ShiftTradeResponse.
        :type: datetime
        """
        
        self._receiving_shift_end = receiving_shift_end

    @property
    def expiration(self):
        """
        Gets the expiration of this ShiftTradeResponse.
        When this shift trade offer will expire if not matched or approved. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The expiration of this ShiftTradeResponse.
        :rtype: datetime
        """
        return self._expiration

    @expiration.setter
    def expiration(self, expiration):
        """
        Sets the expiration of this ShiftTradeResponse.
        When this shift trade offer will expire if not matched or approved. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param expiration: The expiration of this ShiftTradeResponse.
        :type: datetime
        """
        
        self._expiration = expiration

    @property
    def one_sided(self):
        """
        Gets the one_sided of this ShiftTradeResponse.
        Whether this is a one-sided shift trade (e.g. the initiating user is not asking for a shift in return)

        :return: The one_sided of this ShiftTradeResponse.
        :rtype: bool
        """
        return self._one_sided

    @one_sided.setter
    def one_sided(self, one_sided):
        """
        Sets the one_sided of this ShiftTradeResponse.
        Whether this is a one-sided shift trade (e.g. the initiating user is not asking for a shift in return)

        :param one_sided: The one_sided of this ShiftTradeResponse.
        :type: bool
        """
        
        self._one_sided = one_sided

    @property
    def acceptable_intervals(self):
        """
        Gets the acceptable_intervals of this ShiftTradeResponse.


        :return: The acceptable_intervals of this ShiftTradeResponse.
        :rtype: list[str]
        """
        return self._acceptable_intervals

    @acceptable_intervals.setter
    def acceptable_intervals(self, acceptable_intervals):
        """
        Sets the acceptable_intervals of this ShiftTradeResponse.


        :param acceptable_intervals: The acceptable_intervals of this ShiftTradeResponse.
        :type: list[str]
        """
        
        self._acceptable_intervals = acceptable_intervals

    @property
    def reviewed_by(self):
        """
        Gets the reviewed_by of this ShiftTradeResponse.
        The user who reviewed this shift trade

        :return: The reviewed_by of this ShiftTradeResponse.
        :rtype: UserReference
        """
        return self._reviewed_by

    @reviewed_by.setter
    def reviewed_by(self, reviewed_by):
        """
        Sets the reviewed_by of this ShiftTradeResponse.
        The user who reviewed this shift trade

        :param reviewed_by: The reviewed_by of this ShiftTradeResponse.
        :type: UserReference
        """
        
        self._reviewed_by = reviewed_by

    @property
    def reviewed_date(self):
        """
        Gets the reviewed_date of this ShiftTradeResponse.
        The timestamp when this shift trade was reviewed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The reviewed_date of this ShiftTradeResponse.
        :rtype: datetime
        """
        return self._reviewed_date

    @reviewed_date.setter
    def reviewed_date(self, reviewed_date):
        """
        Sets the reviewed_date of this ShiftTradeResponse.
        The timestamp when this shift trade was reviewed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param reviewed_date: The reviewed_date of this ShiftTradeResponse.
        :type: datetime
        """
        
        self._reviewed_date = reviewed_date

    @property
    def metadata(self):
        """
        Gets the metadata of this ShiftTradeResponse.
        Version data for this trade

        :return: The metadata of this ShiftTradeResponse.
        :rtype: WfmVersionedEntityMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this ShiftTradeResponse.
        Version data for this trade

        :param metadata: The metadata of this ShiftTradeResponse.
        :type: WfmVersionedEntityMetadata
        """
        
        self._metadata = metadata

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

