# coding: utf-8

"""
    SparkWorks Core API

    Management Service for the SparkWorks Processing Engine  # noqa: E501

    OpenAPI spec version: v2.0
    Contact: info@sparkworks.net
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from sparkworks_client.api_client import ApiClient


class UnitApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_unit(self, unit_create_dto, **kwargs):  # noqa: E501
        """Create a Unit  # noqa: E501

        A Spark Works Accounts authenticated user is able to create a Unit.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_unit(unit_create_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UnitCreateDTO unit_create_dto: Unit Creation API Model (required)
        :return: UnitDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_unit_with_http_info(unit_create_dto, **kwargs)  # noqa: E501
        else:
            (data) = self.create_unit_with_http_info(unit_create_dto, **kwargs)  # noqa: E501
            return data

    def create_unit_with_http_info(self, unit_create_dto, **kwargs):  # noqa: E501
        """Create a Unit  # noqa: E501

        A Spark Works Accounts authenticated user is able to create a Unit.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_unit_with_http_info(unit_create_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UnitCreateDTO unit_create_dto: Unit Creation API Model (required)
        :return: UnitDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['unit_create_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_unit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'unit_create_dto' is set
        if ('unit_create_dto' not in params or
                params['unit_create_dto'] is None):
            raise ValueError("Missing the required parameter `unit_create_dto` when calling `create_unit`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'unit_create_dto' in params:
            body_params = params['unit_create_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/unit', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UnitDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_unit(self, uuid, **kwargs):  # noqa: E501
        """Delete a Unit by its UUID  # noqa: E501

        A Spark Works Accounts authenticated user is able to delete a Unit by its UUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_unit(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Unit UUID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_unit_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_unit_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def delete_unit_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Delete a Unit by its UUID  # noqa: E501

        A Spark Works Accounts authenticated user is able to delete a Unit by its UUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_unit_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Unit UUID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_unit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `delete_unit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/unit/{uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_units(self, **kwargs):  # noqa: E501
        """Retrieve a collection of Units  # noqa: E501

        A Spark Works Accounts authenticated user is able to retrieve all of the Platform Units.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_units(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[UnitDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_units_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_units_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_units_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve a collection of Units  # noqa: E501

        A Spark Works Accounts authenticated user is able to retrieve all of the Platform Units.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_units_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[UnitDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_units" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/unit', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[UnitDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_unit_by_uuid(self, uuid, **kwargs):  # noqa: E501
        """Retrieve a Unit by its UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve a Unit that has permissions on by its UUID. An administrator is able to get any Unit by its UUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_unit_by_uuid(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Unit UUID (required)
        :return: UnitDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_unit_by_uuid_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_unit_by_uuid_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_unit_by_uuid_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Retrieve a Unit by its UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve a Unit that has permissions on by its UUID. An administrator is able to get any Unit by its UUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_unit_by_uuid_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Unit UUID (required)
        :return: UnitDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_unit_by_uuid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `get_unit_by_uuid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/unit/{uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UnitDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_units(self, unit_query_dto, **kwargs):  # noqa: E501
        """Retrieve a Unit by a query  # noqa: E501

        A Spark Works Accounts authenticated user is able to retrieve a Unit.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_units(unit_query_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UnitQueryDTO unit_query_dto: Unit Query API Model (required)
        :return: UnitDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.query_units_with_http_info(unit_query_dto, **kwargs)  # noqa: E501
        else:
            (data) = self.query_units_with_http_info(unit_query_dto, **kwargs)  # noqa: E501
            return data

    def query_units_with_http_info(self, unit_query_dto, **kwargs):  # noqa: E501
        """Retrieve a Unit by a query  # noqa: E501

        A Spark Works Accounts authenticated user is able to retrieve a Unit.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_units_with_http_info(unit_query_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UnitQueryDTO unit_query_dto: Unit Query API Model (required)
        :return: UnitDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['unit_query_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_units" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'unit_query_dto' is set
        if ('unit_query_dto' not in params or
                params['unit_query_dto'] is None):
            raise ValueError("Missing the required parameter `unit_query_dto` when calling `query_units`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'unit_query_dto' in params:
            body_params = params['unit_query_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/unit/query', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UnitDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_unit(self, uuid, update_dto, **kwargs):  # noqa: E501
        """Update Unit  # noqa: E501

        A Spark Works Accounts administrator is able to update a Unit by its UUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_unit(uuid, update_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Unit UUID (required)
        :param UnitUpdateDTO update_dto: updateDTO (required)
        :return: UnitDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_unit_with_http_info(uuid, update_dto, **kwargs)  # noqa: E501
        else:
            (data) = self.update_unit_with_http_info(uuid, update_dto, **kwargs)  # noqa: E501
            return data

    def update_unit_with_http_info(self, uuid, update_dto, **kwargs):  # noqa: E501
        """Update Unit  # noqa: E501

        A Spark Works Accounts administrator is able to update a Unit by its UUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_unit_with_http_info(uuid, update_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Unit UUID (required)
        :param UnitUpdateDTO update_dto: updateDTO (required)
        :return: UnitDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'update_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_unit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `update_unit`")  # noqa: E501
        # verify the required parameter 'update_dto' is set
        if ('update_dto' not in params or
                params['update_dto'] is None):
            raise ValueError("Missing the required parameter `update_dto` when calling `update_unit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_dto' in params:
            body_params = params['update_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/unit/{uuid}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UnitDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
