# coding: utf-8

"""
    SparkWorks Core API

    Management Service for the SparkWorks Processing Engine  # noqa: E501

    OpenAPI spec version: v2.0
    Contact: info@sparkworks.net
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from sparkworks_client.api_client import ApiClient


class ResourceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def count_resources(self, **kwargs):  # noqa: E501
        """Count Resources  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve the number of Resources that has permissions on. An administrator is able to retrieve the number of all Resources.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.count_resources(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.count_resources_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.count_resources_with_http_info(**kwargs)  # noqa: E501
            return data

    def count_resources_with_http_info(self, **kwargs):  # noqa: E501
        """Count Resources  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve the number of Resources that has permissions on. An administrator is able to retrieve the number of all Resources.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.count_resources_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method count_resources" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/resource/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='int',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_resource(self, resource_create_dto, **kwargs):  # noqa: E501
        """Create a new Resource  # noqa: E501

        A Spark Works authenticated user is able to request a new Resource creation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_resource(resource_create_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ResourceCreateDTO resource_create_dto: Resource Creation API Model (required)
        :return: ResourceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_resource_with_http_info(resource_create_dto, **kwargs)  # noqa: E501
        else:
            (data) = self.create_resource_with_http_info(resource_create_dto, **kwargs)  # noqa: E501
            return data

    def create_resource_with_http_info(self, resource_create_dto, **kwargs):  # noqa: E501
        """Create a new Resource  # noqa: E501

        A Spark Works authenticated user is able to request a new Resource creation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_resource_with_http_info(resource_create_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ResourceCreateDTO resource_create_dto: Resource Creation API Model (required)
        :return: ResourceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['resource_create_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_resource" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'resource_create_dto' is set
        if ('resource_create_dto' not in params or
                params['resource_create_dto'] is None):
            raise ValueError("Missing the required parameter `resource_create_dto` when calling `create_resource`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'resource_create_dto' in params:
            body_params = params['resource_create_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/resource', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_resource(self, uuid, **kwargs):  # noqa: E501
        """Delete Resource by its UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to remove a Spark Works Resource that has permissions on by its unique identifier. An administrator is able to remove any Resource of the platform  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_resource(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Resource UUID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_resource_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_resource_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def delete_resource_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Delete Resource by its UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to remove a Spark Works Resource that has permissions on by its unique identifier. An administrator is able to remove any Resource of the platform  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_resource_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Resource UUID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_resource" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `delete_resource`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/resource/{uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_resource_by_uuid(self, uuid, **kwargs):  # noqa: E501
        """Retrieve a Spark Works Resource by its UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve a Resource, that has permissions on, by its UUID. An administrator is able to retrieve any Resource of the platform  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_resource_by_uuid(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Resource UUID (required)
        :return: ResourceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_resource_by_uuid_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_resource_by_uuid_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_resource_by_uuid_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Retrieve a Spark Works Resource by its UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve a Resource, that has permissions on, by its UUID. An administrator is able to retrieve any Resource of the platform  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_resource_by_uuid_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Resource UUID (required)
        :return: ResourceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_resource_by_uuid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `get_resource_by_uuid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/resource/{uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_resources(self, **kwargs):  # noqa: E501
        """Retrieve a collection of Resources  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve all of the Platform resources that the user has permissions on. An administrator is able to query all of the platform resources  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_resources(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[ResourceDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_resources_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_resources_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_resources_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve a collection of Resources  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve all of the Platform resources that the user has permissions on. An administrator is able to query all of the platform resources  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_resources_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[ResourceDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_resources" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/resource', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ResourceDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def move_resource(self, uuid, target_uuid, **kwargs):  # noqa: E501
        """Move Resource by its UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to move a Spark Works Resource that has permissions on by its unique identifierto a Spark Works Group that has permissions on. An administrator is able to move any Resource of the platform  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_resource(uuid, target_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Resource UUID (required)
        :param str target_uuid: The Group UUID (required)
        :return: ResourceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.move_resource_with_http_info(uuid, target_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.move_resource_with_http_info(uuid, target_uuid, **kwargs)  # noqa: E501
            return data

    def move_resource_with_http_info(self, uuid, target_uuid, **kwargs):  # noqa: E501
        """Move Resource by its UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to move a Spark Works Resource that has permissions on by its unique identifierto a Spark Works Group that has permissions on. An administrator is able to move any Resource of the platform  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_resource_with_http_info(uuid, target_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Resource UUID (required)
        :param str target_uuid: The Group UUID (required)
        :return: ResourceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'target_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_resource" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `move_resource`")  # noqa: E501
        # verify the required parameter 'target_uuid' is set
        if ('target_uuid' not in params or
                params['target_uuid'] is None):
            raise ValueError("Missing the required parameter `target_uuid` when calling `move_resource`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501
        if 'target_uuid' in params:
            path_params['targetUUID'] = params['target_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/resource/{uuid}/move/{targetUUID}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_resources(self, resource_query_dto, **kwargs):  # noqa: E501
        """Retrieve a Resource by a query  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve a Resource that has permissions on by a query object. An administrator is able to get any Resource by a query object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_resources(resource_query_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ResourceQueryDTO resource_query_dto: The Resource Query (required)
        :return: ResourceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.query_resources_with_http_info(resource_query_dto, **kwargs)  # noqa: E501
        else:
            (data) = self.query_resources_with_http_info(resource_query_dto, **kwargs)  # noqa: E501
            return data

    def query_resources_with_http_info(self, resource_query_dto, **kwargs):  # noqa: E501
        """Retrieve a Resource by a query  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve a Resource that has permissions on by a query object. An administrator is able to get any Resource by a query object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_resources_with_http_info(resource_query_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ResourceQueryDTO resource_query_dto: The Resource Query (required)
        :return: ResourceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['resource_query_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_resources" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'resource_query_dto' is set
        if ('resource_query_dto' not in params or
                params['resource_query_dto'] is None):
            raise ValueError("Missing the required parameter `resource_query_dto` when calling `query_resources`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'resource_query_dto' in params:
            body_params = params['resource_query_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/resource/query', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_resource(self, uuid, resource_update_dto, **kwargs):  # noqa: E501
        """Update Resource  # noqa: E501

        A Spark Works Accounts authenticated common user is able to update a Resource's values that has permission on. An administrator is able to update the values of any Resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_resource(uuid, resource_update_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Group UUID (required)
        :param ResourceUpdateDTO resource_update_dto: resourceUpdateDTO (required)
        :return: ResourceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_resource_with_http_info(uuid, resource_update_dto, **kwargs)  # noqa: E501
        else:
            (data) = self.update_resource_with_http_info(uuid, resource_update_dto, **kwargs)  # noqa: E501
            return data

    def update_resource_with_http_info(self, uuid, resource_update_dto, **kwargs):  # noqa: E501
        """Update Resource  # noqa: E501

        A Spark Works Accounts authenticated common user is able to update a Resource's values that has permission on. An administrator is able to update the values of any Resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_resource_with_http_info(uuid, resource_update_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Group UUID (required)
        :param ResourceUpdateDTO resource_update_dto: resourceUpdateDTO (required)
        :return: ResourceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'resource_update_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_resource" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `update_resource`")  # noqa: E501
        # verify the required parameter 'resource_update_dto' is set
        if ('resource_update_dto' not in params or
                params['resource_update_dto'] is None):
            raise ValueError("Missing the required parameter `resource_update_dto` when calling `update_resource`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'resource_update_dto' in params:
            body_params = params['resource_update_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/resource/{uuid}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
