# coding: utf-8

"""
    SparkWorks Core API

    Management Service for the SparkWorks Processing Engine  # noqa: E501

    OpenAPI spec version: v2.0
    Contact: info@sparkworks.net
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from sparkworks_client.api_client import ApiClient


class RegistryApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def query_registry(self, uuids, **kwargs):  # noqa: E501
        """Query the Registry Service to retrieve a collection of Resources records with their last read value and timestamp by their UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve all of the Platform Resource info that has permissions on. An administrator is able to query all of the platform Resources  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_registry(uuids, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] uuids: uuids (required)
        :return: list[RegistryRecordDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.query_registry_with_http_info(uuids, **kwargs)  # noqa: E501
        else:
            (data) = self.query_registry_with_http_info(uuids, **kwargs)  # noqa: E501
            return data

    def query_registry_with_http_info(self, uuids, **kwargs):  # noqa: E501
        """Query the Registry Service to retrieve a collection of Resources records with their last read value and timestamp by their UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve all of the Platform Resource info that has permissions on. An administrator is able to query all of the platform Resources  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_registry_with_http_info(uuids, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] uuids: uuids (required)
        :return: list[RegistryRecordDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_registry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuids' is set
        if ('uuids' not in params or
                params['uuids'] is None):
            raise ValueError("Missing the required parameter `uuids` when calling `query_registry`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'uuids' in params:
            body_params = params['uuids']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/registry/query', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RegistryRecordDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
