# coding: utf-8

"""
    SparkWorks Core API

    Management Service for the SparkWorks Processing Engine  # noqa: E501

    OpenAPI spec version: v2.0
    Contact: info@sparkworks.net
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from sparkworks_client.api_client import ApiClient


class DataApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_latest_by_uuid(self, uuid, **kwargs):  # noqa: E501
        """Retrieve latest values and analytics for a single Resource  # noqa: E501

        Retrieve the latest values received for a single Resource. The response contains the latest value received for the Resource, the timestamp of the measurement as well as the analytics calculated for this measurement for the last 5minute, hour, day and month interval.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_by_uuid(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The UUID of the Resource (required)
        :return: ResourceLatestValuesResponseAPIModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_latest_by_uuid_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_latest_by_uuid_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_latest_by_uuid_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Retrieve latest values and analytics for a single Resource  # noqa: E501

        Retrieve the latest values received for a single Resource. The response contains the latest value received for the Resource, the timestamp of the measurement as well as the analytics calculated for this measurement for the last 5minute, hour, day and month interval.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_by_uuid_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The UUID of the Resource (required)
        :return: ResourceLatestValuesResponseAPIModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_latest_by_uuid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `get_latest_by_uuid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/resource/{uuid}/latest', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceLatestValuesResponseAPIModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_summary_by_uuid(self, uuid, **kwargs):  # noqa: E501
        """Retrieve the data summary for a single Resource  # noqa: E501

        Retrieve a summary of the latest analytics calculated for a single Resource. The summary contains the latest calculated analytics for the Resource for the past 48 5minute, hour, day and month intervals.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_summary_by_uuid(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The UUID of the Resource (required)
        :return: TheResourceSummaryDataAPIModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_summary_by_uuid_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_summary_by_uuid_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_summary_by_uuid_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Retrieve the data summary for a single Resource  # noqa: E501

        Retrieve a summary of the latest analytics calculated for a single Resource. The summary contains the latest calculated analytics for the Resource for the past 48 5minute, hour, day and month intervals.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_summary_by_uuid_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The UUID of the Resource (required)
        :return: TheResourceSummaryDataAPIModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_summary_by_uuid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `get_summary_by_uuid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/resource/{uuid}/summary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TheResourceSummaryDataAPIModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def publish_data(self, **kwargs):  # noqa: E501
        """Publish data to a single or multiple Resources  # noqa: E501

        Publish data to a single or multiple Resources. Send data for processing for one or more Resources that you have permission to update.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.publish_data(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PublishDataListDTOAPIModel publish_data_list_dto: Data to be published
        :return: PublishDataListDTOAPIModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.publish_data_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.publish_data_with_http_info(**kwargs)  # noqa: E501
            return data

    def publish_data_with_http_info(self, **kwargs):  # noqa: E501
        """Publish data to a single or multiple Resources  # noqa: E501

        Publish data to a single or multiple Resources. Send data for processing for one or more Resources that you have permission to update.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.publish_data_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PublishDataListDTOAPIModel publish_data_list_dto: Data to be published
        :return: PublishDataListDTOAPIModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['publish_data_list_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method publish_data" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'publish_data_list_dto' in params:
            body_params = params['publish_data_list_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/resource/data/publish', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PublishDataListDTOAPIModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_latest(self, query_latest_resource_data_dto, **kwargs):  # noqa: E501
        """Retrieve the latest values received for multiple Resources  # noqa: E501

        Retrieve the latest values received for multiple Resources. The response contains the latest value received for the Resource and the timestamp of the measurement. For more information on how to define the criteria check the method parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_latest(query_latest_resource_data_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QueryLatestResourceDataDTOAPIModel query_latest_resource_data_dto: Data query criteria (required)
        :return: QueryLatestResourceDataResultDTOAPIModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.query_latest_with_http_info(query_latest_resource_data_dto, **kwargs)  # noqa: E501
        else:
            (data) = self.query_latest_with_http_info(query_latest_resource_data_dto, **kwargs)  # noqa: E501
            return data

    def query_latest_with_http_info(self, query_latest_resource_data_dto, **kwargs):  # noqa: E501
        """Retrieve the latest values received for multiple Resources  # noqa: E501

        Retrieve the latest values received for multiple Resources. The response contains the latest value received for the Resource and the timestamp of the measurement. For more information on how to define the criteria check the method parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_latest_with_http_info(query_latest_resource_data_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QueryLatestResourceDataDTOAPIModel query_latest_resource_data_dto: Data query criteria (required)
        :return: QueryLatestResourceDataResultDTOAPIModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query_latest_resource_data_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_latest" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'query_latest_resource_data_dto' is set
        if ('query_latest_resource_data_dto' not in params or
                params['query_latest_resource_data_dto'] is None):
            raise ValueError("Missing the required parameter `query_latest_resource_data_dto` when calling `query_latest`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'query_latest_resource_data_dto' in params:
            body_params = params['query_latest_resource_data_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/resource/query/latest', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueryLatestResourceDataResultDTOAPIModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_summary(self, query_resource_data_criteria_dto, **kwargs):  # noqa: E501
        """Retrieve the data summaries of mutliple Resource  # noqa: E501

        Retrieve the data summaries received of multiple Resources. The response contains the summary with calculated analytics for each Resource for the past 48 5minute, hour, day and month intervals. A single summary is returned for each Resource  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_summary(query_resource_data_criteria_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QueryResourceDataCriteriaDTOAPIModel query_resource_data_criteria_dto: Data query criteria (required)
        :return: TheResourceSummaryDataAPIModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.query_summary_with_http_info(query_resource_data_criteria_dto, **kwargs)  # noqa: E501
        else:
            (data) = self.query_summary_with_http_info(query_resource_data_criteria_dto, **kwargs)  # noqa: E501
            return data

    def query_summary_with_http_info(self, query_resource_data_criteria_dto, **kwargs):  # noqa: E501
        """Retrieve the data summaries of mutliple Resource  # noqa: E501

        Retrieve the data summaries received of multiple Resources. The response contains the summary with calculated analytics for each Resource for the past 48 5minute, hour, day and month intervals. A single summary is returned for each Resource  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_summary_with_http_info(query_resource_data_criteria_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QueryResourceDataCriteriaDTOAPIModel query_resource_data_criteria_dto: Data query criteria (required)
        :return: TheResourceSummaryDataAPIModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query_resource_data_criteria_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_summary" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'query_resource_data_criteria_dto' is set
        if ('query_resource_data_criteria_dto' not in params or
                params['query_resource_data_criteria_dto'] is None):
            raise ValueError("Missing the required parameter `query_resource_data_criteria_dto` when calling `query_summary`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'query_resource_data_criteria_dto' in params:
            body_params = params['query_resource_data_criteria_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/resource/query/summary', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TheResourceSummaryDataAPIModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_time_range(self, query_time_range_resource_data_dto, **kwargs):  # noqa: E501
        """Retrieve analytics for a single Resource  # noqa: E501

        Retrieve analytics for a single Resource on multiple intervals and granularities. The response contains the latest calculated analytics for the Resource based on the query criteria provided with the request. For more information on how to define the criteria check the method parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_time_range(query_time_range_resource_data_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QueryTimeRangeResourceDataDTOAPIModel query_time_range_resource_data_dto: Timerange criteria (required)
        :return: QueryTimeRangeResourceDataResultDTOAPIModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.query_time_range_with_http_info(query_time_range_resource_data_dto, **kwargs)  # noqa: E501
        else:
            (data) = self.query_time_range_with_http_info(query_time_range_resource_data_dto, **kwargs)  # noqa: E501
            return data

    def query_time_range_with_http_info(self, query_time_range_resource_data_dto, **kwargs):  # noqa: E501
        """Retrieve analytics for a single Resource  # noqa: E501

        Retrieve analytics for a single Resource on multiple intervals and granularities. The response contains the latest calculated analytics for the Resource based on the query criteria provided with the request. For more information on how to define the criteria check the method parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_time_range_with_http_info(query_time_range_resource_data_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QueryTimeRangeResourceDataDTOAPIModel query_time_range_resource_data_dto: Timerange criteria (required)
        :return: QueryTimeRangeResourceDataResultDTOAPIModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query_time_range_resource_data_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_time_range" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'query_time_range_resource_data_dto' is set
        if ('query_time_range_resource_data_dto' not in params or
                params['query_time_range_resource_data_dto'] is None):
            raise ValueError("Missing the required parameter `query_time_range_resource_data_dto` when calling `query_time_range`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'query_time_range_resource_data_dto' in params:
            body_params = params['query_time_range_resource_data_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/resource/query/timerange', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueryTimeRangeResourceDataResultDTOAPIModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_time_range_raw(self, query_raw_data_time_range_dto, **kwargs):  # noqa: E501
        """Retrieve the raw data received for a single Resource  # noqa: E501

        Retrieve the raw data received for a single Resource over a specified time interval. This method retrieves from the raw data storage and depending on the amount of data that need to be accessed may take longer time to respond. If your get a response timeout you may need to limit the requested time range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_time_range_raw(query_raw_data_time_range_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QueryRawDataTimeRangeDTOAPIModel query_raw_data_time_range_dto: Raw Data Timerange Criteria (required)
        :return: QueryRawDataTimeRangeResultDTOAPIModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.query_time_range_raw_with_http_info(query_raw_data_time_range_dto, **kwargs)  # noqa: E501
        else:
            (data) = self.query_time_range_raw_with_http_info(query_raw_data_time_range_dto, **kwargs)  # noqa: E501
            return data

    def query_time_range_raw_with_http_info(self, query_raw_data_time_range_dto, **kwargs):  # noqa: E501
        """Retrieve the raw data received for a single Resource  # noqa: E501

        Retrieve the raw data received for a single Resource over a specified time interval. This method retrieves from the raw data storage and depending on the amount of data that need to be accessed may take longer time to respond. If your get a response timeout you may need to limit the requested time range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_time_range_raw_with_http_info(query_raw_data_time_range_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QueryRawDataTimeRangeDTOAPIModel query_raw_data_time_range_dto: Raw Data Timerange Criteria (required)
        :return: QueryRawDataTimeRangeResultDTOAPIModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query_raw_data_time_range_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_time_range_raw" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'query_raw_data_time_range_dto' is set
        if ('query_raw_data_time_range_dto' not in params or
                params['query_raw_data_time_range_dto'] is None):
            raise ValueError("Missing the required parameter `query_raw_data_time_range_dto` when calling `query_time_range_raw`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'query_raw_data_time_range_dto' in params:
            body_params = params['query_raw_data_time_range_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/resource/query/raw/timerange', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueryRawDataTimeRangeResultDTOAPIModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
