"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
// tslint:disable:no-var-requires
/**
 * Get my package JSON.
 *
 * In principle it's just '__dirname/../../package.json', but in the monocdk
 * it will live at a different location. So search upwards.
 */
function loadMyPackageJson() {
    let dir = path.resolve(__dirname, '..', '..');
    while (true) {
        try {
            // eslint-disable-next-line @typescript-eslint/no-require-imports
            return require(path.join(dir, 'package.json'));
        }
        catch (e) {
            if (e.code !== 'MODULE_NOT_FOUND') {
                throw e;
            }
            const newdir = path.dirname(dir);
            if (newdir === dir) {
                throw new Error(`No package.json found upward of ${__dirname}`);
            }
            dir = newdir;
        }
    }
}
exports.loadMyPackageJson = loadMyPackageJson;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibXktcGFja2FnZS1qc29uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibXktcGFja2FnZS1qc29uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsNkJBQTZCO0FBRTdCLGlDQUFpQztBQUVqQzs7Ozs7R0FLRztBQUNILFNBQWdCLGlCQUFpQjtJQUMvQixJQUFJLEdBQUcsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsRUFBRSxJQUFJLEVBQUUsSUFBSSxDQUFDLENBQUM7SUFDOUMsT0FBTyxJQUFJLEVBQUU7UUFDWCxJQUFJO1lBQ0YsaUVBQWlFO1lBQ2pFLE9BQU8sT0FBTyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxFQUFFLGNBQWMsQ0FBQyxDQUFDLENBQUM7U0FDaEQ7UUFBQyxPQUFPLENBQUMsRUFBRTtZQUNWLElBQUksQ0FBQyxDQUFDLElBQUksS0FBSyxrQkFBa0IsRUFBRTtnQkFBRSxNQUFNLENBQUMsQ0FBQzthQUFFO1lBRS9DLE1BQU0sTUFBTSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLENBQUM7WUFDakMsSUFBSSxNQUFNLEtBQUssR0FBRyxFQUFFO2dCQUFFLE1BQU0sSUFBSSxLQUFLLENBQUMsbUNBQW1DLFNBQVMsRUFBRSxDQUFDLENBQUM7YUFBRTtZQUN4RixHQUFHLEdBQUcsTUFBTSxDQUFDO1NBQ2Q7S0FDRjtBQUNILENBQUM7QUFkRCw4Q0FjQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5cbi8vIHRzbGludDpkaXNhYmxlOm5vLXZhci1yZXF1aXJlc1xuXG4vKipcbiAqIEdldCBteSBwYWNrYWdlIEpTT04uXG4gKlxuICogSW4gcHJpbmNpcGxlIGl0J3MganVzdCAnX19kaXJuYW1lLy4uLy4uL3BhY2thZ2UuanNvbicsIGJ1dCBpbiB0aGUgbW9ub2Nka1xuICogaXQgd2lsbCBsaXZlIGF0IGEgZGlmZmVyZW50IGxvY2F0aW9uLiBTbyBzZWFyY2ggdXB3YXJkcy5cbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIGxvYWRNeVBhY2thZ2VKc29uKCk6IGFueSB7XG4gIGxldCBkaXIgPSBwYXRoLnJlc29sdmUoX19kaXJuYW1lLCAnLi4nLCAnLi4nKTtcbiAgd2hpbGUgKHRydWUpIHtcbiAgICB0cnkge1xuICAgICAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIEB0eXBlc2NyaXB0LWVzbGludC9uby1yZXF1aXJlLWltcG9ydHNcbiAgICAgIHJldHVybiByZXF1aXJlKHBhdGguam9pbihkaXIsICdwYWNrYWdlLmpzb24nKSk7XG4gICAgfSBjYXRjaCAoZSkge1xuICAgICAgaWYgKGUuY29kZSAhPT0gJ01PRFVMRV9OT1RfRk9VTkQnKSB7IHRocm93IGU7IH1cblxuICAgICAgY29uc3QgbmV3ZGlyID0gcGF0aC5kaXJuYW1lKGRpcik7XG4gICAgICBpZiAobmV3ZGlyID09PSBkaXIpIHsgdGhyb3cgbmV3IEVycm9yKGBObyBwYWNrYWdlLmpzb24gZm91bmQgdXB3YXJkIG9mICR7X19kaXJuYW1lfWApOyB9XG4gICAgICBkaXIgPSBuZXdkaXI7XG4gICAgfVxuICB9XG59Il19