"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const sqs = require("@aws-cdk/aws-sqs");
const defaults = require("./sqs-defaults");
const utils_1 = require("./utils");
function buildQueue(scope, id, props) {
    // If props is undefined, define it
    props = (props === undefined) ? {} : props;
    // Setup the queue
    let queueProps;
    if (props.queueProps) {
        // If property overrides have been provided, incorporate them and deploy
        queueProps = utils_1.overrideProps(defaults.DefaultQueueProps(props.encryptionKey), props.queueProps);
    }
    else {
        // If no property overrides, deploy using the default configuration
        queueProps = defaults.DefaultQueueProps(props.encryptionKey);
    }
    // Determine whether a DLQ property should be added
    if (props.deadLetterQueue) {
        queueProps.deadLetterQueue = props.deadLetterQueue;
    }
    // Return the queue
    return new sqs.Queue(scope, id, queueProps);
}
exports.buildQueue = buildQueue;
function buildDeadLetterQueue(props) {
    // Setup the queue interface and return
    const dlq = {
        maxReceiveCount: props.maxReceiveCount,
        queue: props.deadLetterQueue
    };
    return dlq;
}
exports.buildDeadLetterQueue = buildDeadLetterQueue;
//# sourceMappingURL=data:application/json;base64,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