"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const sns = require("@aws-cdk/aws-sns");
const sns_defaults_1 = require("./sns-defaults");
const kms_helper_1 = require("./kms-helper");
const utils_1 = require("./utils");
function buildTopic(scope, props) {
    // If props is undefined, define it
    props = (props === undefined) ? {} : props;
    // Setup the topic properties
    let snsTopicProps;
    if (props.hasOwnProperty('topicProps')) {
        // If property overrides have been provided, incorporate them and deploy
        snsTopicProps = utils_1.overrideProps(sns_defaults_1.DefaultSnsTopicProps, props.topicProps);
    }
    else {
        // If no property overrides, deploy using the default configuration
        snsTopicProps = sns_defaults_1.DefaultSnsTopicProps;
    }
    // Set encryption properties
    if (!props.enableEncryption || props.enableEncryption === true) {
        if (props.encryptionKey) {
            snsTopicProps.masterKey = props.encryptionKey;
        }
        else {
            snsTopicProps.masterKey = kms_helper_1.buildEncryptionKey(scope);
        }
    }
    // Create the stream and return
    return new sns.Topic(scope, 'SnsTopic', snsTopicProps);
}
exports.buildTopic = buildTopic;
//# sourceMappingURL=data:application/json;base64,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