"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const s3 = require("@aws-cdk/aws-s3");
const s3_bucket_defaults_1 = require("./s3-bucket-defaults");
const utils_1 = require("./utils");
function buildS3Bucket(scope, props) {
    // Conditional s3 Bucket creation
    // If deployBucket == false
    if (props.hasOwnProperty('deployBucket') && props.deployBucket === false) {
        if (props.existingBucketObj) {
            return props.existingBucketObj;
        }
        else {
            throw Error('Missing existingBucketObj from props for deployBucket = false');
        }
        // If deploy == true
    }
    else {
        if (props.bucketProps) {
            return s3BucketWithLogging(scope, props.bucketProps);
        }
        else {
            return s3BucketWithLogging(scope, s3_bucket_defaults_1.DefaultS3Props());
        }
    }
}
exports.buildS3Bucket = buildS3Bucket;
function s3BucketWithLogging(scope, s3BucketProps) {
    var _a;
    // Create the Application Bucket
    let bucketprops;
    if ((_a = s3BucketProps) === null || _a === void 0 ? void 0 : _a.serverAccessLogsBucket) {
        bucketprops = s3_bucket_defaults_1.DefaultS3Props;
    }
    else {
        // Create the Logging Bucket
        const loggingBucket = new s3.Bucket(scope, 'S3LoggingBucket', s3_bucket_defaults_1.DefaultS3Props());
        // Extract the CfnBucket from the loggingBucket
        const loggingBucketResource = loggingBucket.node.findChild('Resource');
        // Override accessControl configuration and add metadata for the logging bucket
        loggingBucketResource.addPropertyOverride('AccessControl', 'LogDeliveryWrite');
        loggingBucketResource.cfnOptions.metadata = {
            cfn_nag: {
                rules_to_suppress: [{
                        id: 'W35',
                        reason: `This S3 bucket is used as the access logging bucket for another bucket`
                    }, {
                        id: 'W51',
                        reason: `This S3 bucket Bucket does not need a bucket policy`
                    }]
            }
        };
        bucketprops = s3_bucket_defaults_1.DefaultS3Props(loggingBucket);
    }
    if (s3BucketProps) {
        bucketprops = utils_1.overrideProps(bucketprops, s3BucketProps);
    }
    const s3Bucket = new s3.Bucket(scope, 'S3Bucket', bucketprops);
    return s3Bucket;
}
//# sourceMappingURL=data:application/json;base64,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