"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const lambda = require("@aws-cdk/aws-lambda");
const utils_1 = require("./utils");
const s3 = require("@aws-cdk/aws-s3");
function DefaultKinesisEventSourceProps(_eventSourceArn) {
    const defaultEventSourceProps = {
        eventSourceArn: _eventSourceArn
    };
    return defaultEventSourceProps;
}
exports.DefaultKinesisEventSourceProps = DefaultKinesisEventSourceProps;
function DynamoEventSourceProps(_dynamoEventSourceProps) {
    const defaultDynamoEventSourceProps = {
        startingPosition: lambda.StartingPosition.TRIM_HORIZON
    };
    if (_dynamoEventSourceProps) {
        return utils_1.overrideProps(defaultDynamoEventSourceProps, _dynamoEventSourceProps);
    }
    else {
        return defaultDynamoEventSourceProps;
    }
}
exports.DynamoEventSourceProps = DynamoEventSourceProps;
function S3EventSourceProps(_s3EventSourceProps) {
    const defaultS3EventSourceProps = {
        events: [s3.EventType.OBJECT_CREATED]
    };
    if (_s3EventSourceProps) {
        return utils_1.overrideProps(defaultS3EventSourceProps, _s3EventSourceProps, false);
    }
    else {
        return defaultS3EventSourceProps;
    }
}
exports.S3EventSourceProps = S3EventSourceProps;
//# sourceMappingURL=data:application/json;base64,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