"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const kms = require("@aws-cdk/aws-kms");
const kms_defaults_1 = require("./kms-defaults");
const utils_1 = require("./utils");
function buildEncryptionKey(scope, props) {
    // If props is undefined, define it
    props = (props === undefined) ? {} : props;
    // Setup the key properties
    let encryptionKeyProps;
    if (props.hasOwnProperty('encryptionKeyProps')) {
        // If property overrides have been provided, incorporate them and deploy
        encryptionKeyProps = utils_1.overrideProps(kms_defaults_1.DefaultEncryptionProps, props.encryptionKeyProps);
    }
    else {
        // If no property overrides, deploy using the default configuration
        encryptionKeyProps = kms_defaults_1.DefaultEncryptionProps;
    }
    // Create the encryption key and return
    return new kms.Key(scope, 'EncryptionKey', encryptionKeyProps);
}
exports.buildEncryptionKey = buildEncryptionKey;
//# sourceMappingURL=data:application/json;base64,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